# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['ServerlessCacheArgs', 'ServerlessCache']

@pulumi.input_type
class ServerlessCacheArgs:
    def __init__(__self__, *,
                 engine: pulumi.Input[str],
                 cache_usage_limits: Optional[pulumi.Input['ServerlessCacheCacheUsageLimitsArgs']] = None,
                 daily_snapshot_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input['ServerlessCacheEndpointArgs']] = None,
                 final_snapshot_name: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 major_engine_version: Optional[pulumi.Input[str]] = None,
                 reader_endpoint: Optional[pulumi.Input['ServerlessCacheEndpointArgs']] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 serverless_cache_name: Optional[pulumi.Input[str]] = None,
                 snapshot_arns_to_restore: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[int]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 user_group_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ServerlessCache resource.
        :param pulumi.Input[str] engine: The engine name of the Serverless Cache.
        :param pulumi.Input[str] daily_snapshot_time: The daily time range (in UTC) during which the service takes automatic snapshot of the Serverless Cache.
        :param pulumi.Input[str] description: The description of the Serverless Cache.
        :param pulumi.Input[str] final_snapshot_name: The final snapshot name which is taken before Serverless Cache is deleted.
        :param pulumi.Input[str] kms_key_id: The ID of the KMS key used to encrypt the cluster.
        :param pulumi.Input[str] major_engine_version: The major engine version of the Serverless Cache.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: One or more Amazon VPC security groups associated with this Serverless Cache.
        :param pulumi.Input[str] serverless_cache_name: The name of the Serverless Cache. This value must be unique.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] snapshot_arns_to_restore: The ARN's of snapshot to restore Serverless Cache.
        :param pulumi.Input[int] snapshot_retention_limit: The snapshot retention limit of the Serverless Cache.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: The subnet id's of the Serverless Cache.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this Serverless Cache.
        :param pulumi.Input[str] user_group_id: The ID of the user group.
        """
        pulumi.set(__self__, "engine", engine)
        if cache_usage_limits is not None:
            pulumi.set(__self__, "cache_usage_limits", cache_usage_limits)
        if daily_snapshot_time is not None:
            pulumi.set(__self__, "daily_snapshot_time", daily_snapshot_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if final_snapshot_name is not None:
            pulumi.set(__self__, "final_snapshot_name", final_snapshot_name)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if major_engine_version is not None:
            pulumi.set(__self__, "major_engine_version", major_engine_version)
        if reader_endpoint is not None:
            pulumi.set(__self__, "reader_endpoint", reader_endpoint)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if serverless_cache_name is not None:
            pulumi.set(__self__, "serverless_cache_name", serverless_cache_name)
        if snapshot_arns_to_restore is not None:
            pulumi.set(__self__, "snapshot_arns_to_restore", snapshot_arns_to_restore)
        if snapshot_retention_limit is not None:
            pulumi.set(__self__, "snapshot_retention_limit", snapshot_retention_limit)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_group_id is not None:
            pulumi.set(__self__, "user_group_id", user_group_id)

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Input[str]:
        """
        The engine name of the Serverless Cache.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: pulumi.Input[str]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="cacheUsageLimits")
    def cache_usage_limits(self) -> Optional[pulumi.Input['ServerlessCacheCacheUsageLimitsArgs']]:
        return pulumi.get(self, "cache_usage_limits")

    @cache_usage_limits.setter
    def cache_usage_limits(self, value: Optional[pulumi.Input['ServerlessCacheCacheUsageLimitsArgs']]):
        pulumi.set(self, "cache_usage_limits", value)

    @property
    @pulumi.getter(name="dailySnapshotTime")
    def daily_snapshot_time(self) -> Optional[pulumi.Input[str]]:
        """
        The daily time range (in UTC) during which the service takes automatic snapshot of the Serverless Cache.
        """
        return pulumi.get(self, "daily_snapshot_time")

    @daily_snapshot_time.setter
    def daily_snapshot_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "daily_snapshot_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Serverless Cache.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input['ServerlessCacheEndpointArgs']]:
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input['ServerlessCacheEndpointArgs']]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="finalSnapshotName")
    def final_snapshot_name(self) -> Optional[pulumi.Input[str]]:
        """
        The final snapshot name which is taken before Serverless Cache is deleted.
        """
        return pulumi.get(self, "final_snapshot_name")

    @final_snapshot_name.setter
    def final_snapshot_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "final_snapshot_name", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the KMS key used to encrypt the cluster.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="majorEngineVersion")
    def major_engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        The major engine version of the Serverless Cache.
        """
        return pulumi.get(self, "major_engine_version")

    @major_engine_version.setter
    def major_engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "major_engine_version", value)

    @property
    @pulumi.getter(name="readerEndpoint")
    def reader_endpoint(self) -> Optional[pulumi.Input['ServerlessCacheEndpointArgs']]:
        return pulumi.get(self, "reader_endpoint")

    @reader_endpoint.setter
    def reader_endpoint(self, value: Optional[pulumi.Input['ServerlessCacheEndpointArgs']]):
        pulumi.set(self, "reader_endpoint", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        One or more Amazon VPC security groups associated with this Serverless Cache.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="serverlessCacheName")
    def serverless_cache_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Serverless Cache. This value must be unique.
        """
        return pulumi.get(self, "serverless_cache_name")

    @serverless_cache_name.setter
    def serverless_cache_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serverless_cache_name", value)

    @property
    @pulumi.getter(name="snapshotArnsToRestore")
    def snapshot_arns_to_restore(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ARN's of snapshot to restore Serverless Cache.
        """
        return pulumi.get(self, "snapshot_arns_to_restore")

    @snapshot_arns_to_restore.setter
    def snapshot_arns_to_restore(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "snapshot_arns_to_restore", value)

    @property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The snapshot retention limit of the Serverless Cache.
        """
        return pulumi.get(self, "snapshot_retention_limit")

    @snapshot_retention_limit.setter
    def snapshot_retention_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "snapshot_retention_limit", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The subnet id's of the Serverless Cache.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this Serverless Cache.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userGroupId")
    def user_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the user group.
        """
        return pulumi.get(self, "user_group_id")

    @user_group_id.setter
    def user_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_group_id", value)


class ServerlessCache(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_usage_limits: Optional[pulumi.Input[pulumi.InputType['ServerlessCacheCacheUsageLimitsArgs']]] = None,
                 daily_snapshot_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[pulumi.InputType['ServerlessCacheEndpointArgs']]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 final_snapshot_name: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 major_engine_version: Optional[pulumi.Input[str]] = None,
                 reader_endpoint: Optional[pulumi.Input[pulumi.InputType['ServerlessCacheEndpointArgs']]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 serverless_cache_name: Optional[pulumi.Input[str]] = None,
                 snapshot_arns_to_restore: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[int]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 user_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The AWS::ElastiCache::ServerlessCache resource creates an Amazon ElastiCache Serverless Cache.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] daily_snapshot_time: The daily time range (in UTC) during which the service takes automatic snapshot of the Serverless Cache.
        :param pulumi.Input[str] description: The description of the Serverless Cache.
        :param pulumi.Input[str] engine: The engine name of the Serverless Cache.
        :param pulumi.Input[str] final_snapshot_name: The final snapshot name which is taken before Serverless Cache is deleted.
        :param pulumi.Input[str] kms_key_id: The ID of the KMS key used to encrypt the cluster.
        :param pulumi.Input[str] major_engine_version: The major engine version of the Serverless Cache.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: One or more Amazon VPC security groups associated with this Serverless Cache.
        :param pulumi.Input[str] serverless_cache_name: The name of the Serverless Cache. This value must be unique.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] snapshot_arns_to_restore: The ARN's of snapshot to restore Serverless Cache.
        :param pulumi.Input[int] snapshot_retention_limit: The snapshot retention limit of the Serverless Cache.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: The subnet id's of the Serverless Cache.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]] tags: An array of key-value pairs to apply to this Serverless Cache.
        :param pulumi.Input[str] user_group_id: The ID of the user group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerlessCacheArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::ElastiCache::ServerlessCache resource creates an Amazon ElastiCache Serverless Cache.

        :param str resource_name: The name of the resource.
        :param ServerlessCacheArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerlessCacheArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_usage_limits: Optional[pulumi.Input[pulumi.InputType['ServerlessCacheCacheUsageLimitsArgs']]] = None,
                 daily_snapshot_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[pulumi.InputType['ServerlessCacheEndpointArgs']]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 final_snapshot_name: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 major_engine_version: Optional[pulumi.Input[str]] = None,
                 reader_endpoint: Optional[pulumi.Input[pulumi.InputType['ServerlessCacheEndpointArgs']]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 serverless_cache_name: Optional[pulumi.Input[str]] = None,
                 snapshot_arns_to_restore: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[int]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 user_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerlessCacheArgs.__new__(ServerlessCacheArgs)

            __props__.__dict__["cache_usage_limits"] = cache_usage_limits
            __props__.__dict__["daily_snapshot_time"] = daily_snapshot_time
            __props__.__dict__["description"] = description
            __props__.__dict__["endpoint"] = endpoint
            if engine is None and not opts.urn:
                raise TypeError("Missing required property 'engine'")
            __props__.__dict__["engine"] = engine
            __props__.__dict__["final_snapshot_name"] = final_snapshot_name
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["major_engine_version"] = major_engine_version
            __props__.__dict__["reader_endpoint"] = reader_endpoint
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["serverless_cache_name"] = serverless_cache_name
            __props__.__dict__["snapshot_arns_to_restore"] = snapshot_arns_to_restore
            __props__.__dict__["snapshot_retention_limit"] = snapshot_retention_limit
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_group_id"] = user_group_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["full_engine_version"] = None
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["engine", "kmsKeyId", "majorEngineVersion", "serverlessCacheName", "snapshotArnsToRestore[*]", "subnetIds[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ServerlessCache, __self__).__init__(
            'aws-native:elasticache:ServerlessCache',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ServerlessCache':
        """
        Get an existing ServerlessCache resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ServerlessCacheArgs.__new__(ServerlessCacheArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["cache_usage_limits"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["daily_snapshot_time"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["endpoint"] = None
        __props__.__dict__["engine"] = None
        __props__.__dict__["final_snapshot_name"] = None
        __props__.__dict__["full_engine_version"] = None
        __props__.__dict__["kms_key_id"] = None
        __props__.__dict__["major_engine_version"] = None
        __props__.__dict__["reader_endpoint"] = None
        __props__.__dict__["security_group_ids"] = None
        __props__.__dict__["serverless_cache_name"] = None
        __props__.__dict__["snapshot_arns_to_restore"] = None
        __props__.__dict__["snapshot_retention_limit"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["subnet_ids"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["user_group_id"] = None
        return ServerlessCache(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the Serverless Cache.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="cacheUsageLimits")
    def cache_usage_limits(self) -> pulumi.Output[Optional['outputs.ServerlessCacheCacheUsageLimits']]:
        return pulumi.get(self, "cache_usage_limits")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The creation time of the Serverless Cache.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dailySnapshotTime")
    def daily_snapshot_time(self) -> pulumi.Output[Optional[str]]:
        """
        The daily time range (in UTC) during which the service takes automatic snapshot of the Serverless Cache.
        """
        return pulumi.get(self, "daily_snapshot_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Serverless Cache.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional['outputs.ServerlessCacheEndpoint']]:
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[str]:
        """
        The engine name of the Serverless Cache.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="finalSnapshotName")
    def final_snapshot_name(self) -> pulumi.Output[Optional[str]]:
        """
        The final snapshot name which is taken before Serverless Cache is deleted.
        """
        return pulumi.get(self, "final_snapshot_name")

    @property
    @pulumi.getter(name="fullEngineVersion")
    def full_engine_version(self) -> pulumi.Output[str]:
        """
        The full engine version of the Serverless Cache.
        """
        return pulumi.get(self, "full_engine_version")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the KMS key used to encrypt the cluster.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="majorEngineVersion")
    def major_engine_version(self) -> pulumi.Output[Optional[str]]:
        """
        The major engine version of the Serverless Cache.
        """
        return pulumi.get(self, "major_engine_version")

    @property
    @pulumi.getter(name="readerEndpoint")
    def reader_endpoint(self) -> pulumi.Output[Optional['outputs.ServerlessCacheEndpoint']]:
        return pulumi.get(self, "reader_endpoint")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        One or more Amazon VPC security groups associated with this Serverless Cache.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="serverlessCacheName")
    def serverless_cache_name(self) -> pulumi.Output[str]:
        """
        The name of the Serverless Cache. This value must be unique.
        """
        return pulumi.get(self, "serverless_cache_name")

    @property
    @pulumi.getter(name="snapshotArnsToRestore")
    def snapshot_arns_to_restore(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The ARN's of snapshot to restore Serverless Cache.
        """
        return pulumi.get(self, "snapshot_arns_to_restore")

    @property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> pulumi.Output[Optional[int]]:
        """
        The snapshot retention limit of the Serverless Cache.
        """
        return pulumi.get(self, "snapshot_retention_limit")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the Serverless Cache.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The subnet id's of the Serverless Cache.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this Serverless Cache.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userGroupId")
    def user_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the user group.
        """
        return pulumi.get(self, "user_group_id")

