# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetServerlessCacheResult',
    'AwaitableGetServerlessCacheResult',
    'get_serverless_cache',
    'get_serverless_cache_output',
]

@pulumi.output_type
class GetServerlessCacheResult:
    def __init__(__self__, arn=None, cache_usage_limits=None, create_time=None, daily_snapshot_time=None, description=None, endpoint=None, full_engine_version=None, reader_endpoint=None, security_group_ids=None, snapshot_retention_limit=None, status=None, tags=None, user_group_id=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if cache_usage_limits and not isinstance(cache_usage_limits, dict):
            raise TypeError("Expected argument 'cache_usage_limits' to be a dict")
        pulumi.set(__self__, "cache_usage_limits", cache_usage_limits)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if daily_snapshot_time and not isinstance(daily_snapshot_time, str):
            raise TypeError("Expected argument 'daily_snapshot_time' to be a str")
        pulumi.set(__self__, "daily_snapshot_time", daily_snapshot_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if endpoint and not isinstance(endpoint, dict):
            raise TypeError("Expected argument 'endpoint' to be a dict")
        pulumi.set(__self__, "endpoint", endpoint)
        if full_engine_version and not isinstance(full_engine_version, str):
            raise TypeError("Expected argument 'full_engine_version' to be a str")
        pulumi.set(__self__, "full_engine_version", full_engine_version)
        if reader_endpoint and not isinstance(reader_endpoint, dict):
            raise TypeError("Expected argument 'reader_endpoint' to be a dict")
        pulumi.set(__self__, "reader_endpoint", reader_endpoint)
        if security_group_ids and not isinstance(security_group_ids, list):
            raise TypeError("Expected argument 'security_group_ids' to be a list")
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        if snapshot_retention_limit and not isinstance(snapshot_retention_limit, int):
            raise TypeError("Expected argument 'snapshot_retention_limit' to be a int")
        pulumi.set(__self__, "snapshot_retention_limit", snapshot_retention_limit)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if user_group_id and not isinstance(user_group_id, str):
            raise TypeError("Expected argument 'user_group_id' to be a str")
        pulumi.set(__self__, "user_group_id", user_group_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The ARN of the Serverless Cache.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="cacheUsageLimits")
    def cache_usage_limits(self) -> Optional['outputs.ServerlessCacheCacheUsageLimits']:
        return pulumi.get(self, "cache_usage_limits")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[str]:
        """
        The creation time of the Serverless Cache.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dailySnapshotTime")
    def daily_snapshot_time(self) -> Optional[str]:
        """
        The daily time range (in UTC) during which the service takes automatic snapshot of the Serverless Cache.
        """
        return pulumi.get(self, "daily_snapshot_time")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Serverless Cache.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional['outputs.ServerlessCacheEndpoint']:
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="fullEngineVersion")
    def full_engine_version(self) -> Optional[str]:
        """
        The full engine version of the Serverless Cache.
        """
        return pulumi.get(self, "full_engine_version")

    @property
    @pulumi.getter(name="readerEndpoint")
    def reader_endpoint(self) -> Optional['outputs.ServerlessCacheEndpoint']:
        return pulumi.get(self, "reader_endpoint")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[str]]:
        """
        One or more Amazon VPC security groups associated with this Serverless Cache.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> Optional[int]:
        """
        The snapshot retention limit of the Serverless Cache.
        """
        return pulumi.get(self, "snapshot_retention_limit")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the Serverless Cache.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this Serverless Cache.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userGroupId")
    def user_group_id(self) -> Optional[str]:
        """
        The ID of the user group.
        """
        return pulumi.get(self, "user_group_id")


class AwaitableGetServerlessCacheResult(GetServerlessCacheResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerlessCacheResult(
            arn=self.arn,
            cache_usage_limits=self.cache_usage_limits,
            create_time=self.create_time,
            daily_snapshot_time=self.daily_snapshot_time,
            description=self.description,
            endpoint=self.endpoint,
            full_engine_version=self.full_engine_version,
            reader_endpoint=self.reader_endpoint,
            security_group_ids=self.security_group_ids,
            snapshot_retention_limit=self.snapshot_retention_limit,
            status=self.status,
            tags=self.tags,
            user_group_id=self.user_group_id)


def get_serverless_cache(serverless_cache_name: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerlessCacheResult:
    """
    The AWS::ElastiCache::ServerlessCache resource creates an Amazon ElastiCache Serverless Cache.


    :param str serverless_cache_name: The name of the Serverless Cache. This value must be unique.
    """
    __args__ = dict()
    __args__['serverlessCacheName'] = serverless_cache_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:elasticache:getServerlessCache', __args__, opts=opts, typ=GetServerlessCacheResult).value

    return AwaitableGetServerlessCacheResult(
        arn=pulumi.get(__ret__, 'arn'),
        cache_usage_limits=pulumi.get(__ret__, 'cache_usage_limits'),
        create_time=pulumi.get(__ret__, 'create_time'),
        daily_snapshot_time=pulumi.get(__ret__, 'daily_snapshot_time'),
        description=pulumi.get(__ret__, 'description'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        full_engine_version=pulumi.get(__ret__, 'full_engine_version'),
        reader_endpoint=pulumi.get(__ret__, 'reader_endpoint'),
        security_group_ids=pulumi.get(__ret__, 'security_group_ids'),
        snapshot_retention_limit=pulumi.get(__ret__, 'snapshot_retention_limit'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        user_group_id=pulumi.get(__ret__, 'user_group_id'))


@_utilities.lift_output_func(get_serverless_cache)
def get_serverless_cache_output(serverless_cache_name: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServerlessCacheResult]:
    """
    The AWS::ElastiCache::ServerlessCache resource creates an Amazon ElastiCache Serverless Cache.


    :param str serverless_cache_name: The name of the Serverless Cache. This value must be unique.
    """
    ...
