# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ReplicationConfiguration',
    'ReplicationConfigurationReplicationDestination',
    'ReplicationConfigurationReplicationRule',
    'ReplicationConfigurationRepositoryFilter',
    'RepositoryCreationTemplateEncryptionConfiguration',
    'RepositoryCreationTemplateTag',
    'RepositoryEncryptionConfiguration',
    'RepositoryImageScanningConfiguration',
    'RepositoryLifecyclePolicy',
]

@pulumi.output_type
class ReplicationConfiguration(dict):
    """
    An object representing the replication configuration for a registry.
    """
    def __init__(__self__, *,
                 rules: Sequence['outputs.ReplicationConfigurationReplicationRule']):
        """
        An object representing the replication configuration for a registry.
        :param Sequence['ReplicationConfigurationReplicationRule'] rules: An array of objects representing the replication rules for a replication configuration. A replication configuration may contain a maximum of 10 rules.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.ReplicationConfigurationReplicationRule']:
        """
        An array of objects representing the replication rules for a replication configuration. A replication configuration may contain a maximum of 10 rules.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class ReplicationConfigurationReplicationDestination(dict):
    """
    An array of objects representing the details of a replication destination.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registryId":
            suggest = "registry_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationConfigurationReplicationDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationConfigurationReplicationDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationConfigurationReplicationDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region: str,
                 registry_id: str):
        """
        An array of objects representing the details of a replication destination.
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "registry_id", registry_id)

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> str:
        return pulumi.get(self, "registry_id")


@pulumi.output_type
class ReplicationConfigurationReplicationRule(dict):
    """
    An array of objects representing the details of a replication destination.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryFilters":
            suggest = "repository_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationConfigurationReplicationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationConfigurationReplicationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationConfigurationReplicationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destinations: Sequence['outputs.ReplicationConfigurationReplicationDestination'],
                 repository_filters: Optional[Sequence['outputs.ReplicationConfigurationRepositoryFilter']] = None):
        """
        An array of objects representing the details of a replication destination.
        :param Sequence['ReplicationConfigurationReplicationDestination'] destinations: An array of objects representing the details of a replication destination.
        :param Sequence['ReplicationConfigurationRepositoryFilter'] repository_filters: An array of objects representing the details of a repository filter.
        """
        pulumi.set(__self__, "destinations", destinations)
        if repository_filters is not None:
            pulumi.set(__self__, "repository_filters", repository_filters)

    @property
    @pulumi.getter
    def destinations(self) -> Sequence['outputs.ReplicationConfigurationReplicationDestination']:
        """
        An array of objects representing the details of a replication destination.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter(name="repositoryFilters")
    def repository_filters(self) -> Optional[Sequence['outputs.ReplicationConfigurationRepositoryFilter']]:
        """
        An array of objects representing the details of a repository filter.
        """
        return pulumi.get(self, "repository_filters")


@pulumi.output_type
class ReplicationConfigurationRepositoryFilter(dict):
    """
    An array of objects representing the details of a repository filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterType":
            suggest = "filter_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationConfigurationRepositoryFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationConfigurationRepositoryFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationConfigurationRepositoryFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter: str,
                 filter_type: 'ReplicationConfigurationFilterType'):
        """
        An array of objects representing the details of a repository filter.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "filter_type", filter_type)

    @property
    @pulumi.getter
    def filter(self) -> str:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> 'ReplicationConfigurationFilterType':
        return pulumi.get(self, "filter_type")


@pulumi.output_type
class RepositoryCreationTemplateEncryptionConfiguration(dict):
    """
    The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest. By default, when no encryption configuration is set or the AES256 encryption type is used, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts your data at rest using an AES-256 encryption algorithm. This does not require any action on your part.

    For more information, see https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionType":
            suggest = "encryption_type"
        elif key == "kmsKey":
            suggest = "kms_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryCreationTemplateEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryCreationTemplateEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryCreationTemplateEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_type: 'RepositoryCreationTemplateEncryptionType',
                 kms_key: Optional[str] = None):
        """
        The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest. By default, when no encryption configuration is set or the AES256 encryption type is used, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts your data at rest using an AES-256 encryption algorithm. This does not require any action on your part.

        For more information, see https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html
        """
        pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> 'RepositoryCreationTemplateEncryptionType':
        return pulumi.get(self, "encryption_type")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[str]:
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class RepositoryCreationTemplateTag(dict):
    """
    An array of key-value pairs to apply to this resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        An array of key-value pairs to apply to this resource.
        :param str key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param str value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RepositoryEncryptionConfiguration(dict):
    """
    The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest.
     By default, when no encryption configuration is set or the ``AES256`` encryption type is used, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts your data at rest using an AES-256 encryption algorithm. This does not require any action on your part.
     For more control over the encryption of the contents of your repository, you can use server-side encryption with KMSlong key stored in KMSlong (KMS) to encrypt your images. For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionType":
            suggest = "encryption_type"
        elif key == "kmsKey":
            suggest = "kms_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_type: 'RepositoryEncryptionType',
                 kms_key: Optional[str] = None):
        """
        The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest.
         By default, when no encryption configuration is set or the ``AES256`` encryption type is used, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts your data at rest using an AES-256 encryption algorithm. This does not require any action on your part.
         For more control over the encryption of the contents of your repository, you can use server-side encryption with KMSlong key stored in KMSlong (KMS) to encrypt your images. For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide*.
        :param 'RepositoryEncryptionType' encryption_type: The encryption type to use.
                If you use the ``KMS`` encryption type, the contents of the repository will be encrypted using server-side encryption with KMSlong key stored in KMS. When you use KMS to encrypt your data, you can either use the default AWS managed KMS key for Amazon ECR, or specify your own KMS key, which you already created. For more information, see [Protecting data using server-side encryption with an key stored in (SSE-KMS)](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the *Amazon Simple Storage Service Console Developer Guide*.
                If you use the ``AES256`` encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts the images in the repository using an AES-256 encryption algorithm. For more information, see [Protecting data using server-side encryption with Amazon S3-managed encryption keys (SSE-S3)](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html) in the *Ama
        :param str kms_key: If you use the ``KMS`` encryption type, specify the KMS key to use for encryption. The alias, key ID, or full ARN of the KMS key can be specified. The key must exist in the same Region as the repository. If no key is specified, the default AWS managed KMS key for Amazon ECR will be used.
        """
        pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> 'RepositoryEncryptionType':
        """
        The encryption type to use.
         If you use the ``KMS`` encryption type, the contents of the repository will be encrypted using server-side encryption with KMSlong key stored in KMS. When you use KMS to encrypt your data, you can either use the default AWS managed KMS key for Amazon ECR, or specify your own KMS key, which you already created. For more information, see [Protecting data using server-side encryption with an key stored in (SSE-KMS)](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the *Amazon Simple Storage Service Console Developer Guide*.
         If you use the ``AES256`` encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts the images in the repository using an AES-256 encryption algorithm. For more information, see [Protecting data using server-side encryption with Amazon S3-managed encryption keys (SSE-S3)](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html) in the *Ama
        """
        return pulumi.get(self, "encryption_type")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[str]:
        """
        If you use the ``KMS`` encryption type, specify the KMS key to use for encryption. The alias, key ID, or full ARN of the KMS key can be specified. The key must exist in the same Region as the repository. If no key is specified, the default AWS managed KMS key for Amazon ECR will be used.
        """
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class RepositoryImageScanningConfiguration(dict):
    """
    The image scanning configuration for a repository.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scanOnPush":
            suggest = "scan_on_push"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryImageScanningConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryImageScanningConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryImageScanningConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scan_on_push: Optional[bool] = None):
        """
        The image scanning configuration for a repository.
        :param bool scan_on_push: The setting that determines whether images are scanned after being pushed to a repository. If set to ``true``, images will be scanned after being pushed. If this parameter is not specified, it will default to ``false`` and images will not be scanned unless a scan is manually started.
        """
        if scan_on_push is not None:
            pulumi.set(__self__, "scan_on_push", scan_on_push)

    @property
    @pulumi.getter(name="scanOnPush")
    def scan_on_push(self) -> Optional[bool]:
        """
        The setting that determines whether images are scanned after being pushed to a repository. If set to ``true``, images will be scanned after being pushed. If this parameter is not specified, it will default to ``false`` and images will not be scanned unless a scan is manually started.
        """
        return pulumi.get(self, "scan_on_push")


@pulumi.output_type
class RepositoryLifecyclePolicy(dict):
    """
    The ``LifecyclePolicy`` property type specifies a lifecycle policy. For information about lifecycle policy syntax, see [Lifecycle policy template](https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html) in the *Amazon ECR User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lifecyclePolicyText":
            suggest = "lifecycle_policy_text"
        elif key == "registryId":
            suggest = "registry_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryLifecyclePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryLifecyclePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryLifecyclePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lifecycle_policy_text: Optional[str] = None,
                 registry_id: Optional[str] = None):
        """
        The ``LifecyclePolicy`` property type specifies a lifecycle policy. For information about lifecycle policy syntax, see [Lifecycle policy template](https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html) in the *Amazon ECR User Guide*.
        :param str lifecycle_policy_text: The JSON repository policy text to apply to the repository.
        :param str registry_id: The AWS account ID associated with the registry that contains the repository. If you do
                not specify a registry, the default registry is assumed.
        """
        if lifecycle_policy_text is not None:
            pulumi.set(__self__, "lifecycle_policy_text", lifecycle_policy_text)
        if registry_id is not None:
            pulumi.set(__self__, "registry_id", registry_id)

    @property
    @pulumi.getter(name="lifecyclePolicyText")
    def lifecycle_policy_text(self) -> Optional[str]:
        """
        The JSON repository policy text to apply to the repository.
        """
        return pulumi.get(self, "lifecycle_policy_text")

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> Optional[str]:
        """
        The AWS account ID associated with the registry that contains the repository. If you do
         not specify a registry, the default registry is assumed.
        """
        return pulumi.get(self, "registry_id")


