# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetRepositoryCreationTemplateResult',
    'AwaitableGetRepositoryCreationTemplateResult',
    'get_repository_creation_template',
    'get_repository_creation_template_output',
]

@pulumi.output_type
class GetRepositoryCreationTemplateResult:
    def __init__(__self__, applied_for=None, created_at=None, description=None, encryption_configuration=None, image_tag_mutability=None, lifecycle_policy=None, repository_policy=None, resource_tags=None, updated_at=None):
        if applied_for and not isinstance(applied_for, list):
            raise TypeError("Expected argument 'applied_for' to be a list")
        pulumi.set(__self__, "applied_for", applied_for)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if encryption_configuration and not isinstance(encryption_configuration, dict):
            raise TypeError("Expected argument 'encryption_configuration' to be a dict")
        pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if image_tag_mutability and not isinstance(image_tag_mutability, str):
            raise TypeError("Expected argument 'image_tag_mutability' to be a str")
        pulumi.set(__self__, "image_tag_mutability", image_tag_mutability)
        if lifecycle_policy and not isinstance(lifecycle_policy, str):
            raise TypeError("Expected argument 'lifecycle_policy' to be a str")
        pulumi.set(__self__, "lifecycle_policy", lifecycle_policy)
        if repository_policy and not isinstance(repository_policy, str):
            raise TypeError("Expected argument 'repository_policy' to be a str")
        pulumi.set(__self__, "repository_policy", repository_policy)
        if resource_tags and not isinstance(resource_tags, list):
            raise TypeError("Expected argument 'resource_tags' to be a list")
        pulumi.set(__self__, "resource_tags", resource_tags)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="appliedFor")
    def applied_for(self) -> Optional[Sequence['RepositoryCreationTemplateAppliedForItem']]:
        """
        A list of enumerable Strings representing the repository creation scenarios that the template will apply towards.
        """
        return pulumi.get(self, "applied_for")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        Create timestamp of the template.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the template.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional['outputs.RepositoryCreationTemplateEncryptionConfiguration']:
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter(name="imageTagMutability")
    def image_tag_mutability(self) -> Optional['RepositoryCreationTemplateImageTagMutability']:
        """
        The image tag mutability setting for the repository.
        """
        return pulumi.get(self, "image_tag_mutability")

    @property
    @pulumi.getter(name="lifecyclePolicy")
    def lifecycle_policy(self) -> Optional[str]:
        """
        The JSON lifecycle policy text to apply to the repository. For information about lifecycle policy syntax, see https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html
        """
        return pulumi.get(self, "lifecycle_policy")

    @property
    @pulumi.getter(name="repositoryPolicy")
    def repository_policy(self) -> Optional[str]:
        """
        The JSON repository policy text to apply to the repository. For more information, see https://docs.aws.amazon.com/AmazonECR/latest/userguide/RepositoryPolicyExamples.html
        """
        return pulumi.get(self, "repository_policy")

    @property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[Sequence['outputs.RepositoryCreationTemplateTag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "resource_tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[str]:
        """
        Update timestamp of the template.
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetRepositoryCreationTemplateResult(GetRepositoryCreationTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryCreationTemplateResult(
            applied_for=self.applied_for,
            created_at=self.created_at,
            description=self.description,
            encryption_configuration=self.encryption_configuration,
            image_tag_mutability=self.image_tag_mutability,
            lifecycle_policy=self.lifecycle_policy,
            repository_policy=self.repository_policy,
            resource_tags=self.resource_tags,
            updated_at=self.updated_at)


def get_repository_creation_template(prefix: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryCreationTemplateResult:
    """
    AWS::ECR::RepositoryCreationTemplate is used to create repository with configuration from a pre-defined template.


    :param str prefix: The prefix use to match the repository name and apply the template.
    """
    __args__ = dict()
    __args__['prefix'] = prefix
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ecr:getRepositoryCreationTemplate', __args__, opts=opts, typ=GetRepositoryCreationTemplateResult).value

    return AwaitableGetRepositoryCreationTemplateResult(
        applied_for=pulumi.get(__ret__, 'applied_for'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        encryption_configuration=pulumi.get(__ret__, 'encryption_configuration'),
        image_tag_mutability=pulumi.get(__ret__, 'image_tag_mutability'),
        lifecycle_policy=pulumi.get(__ret__, 'lifecycle_policy'),
        repository_policy=pulumi.get(__ret__, 'repository_policy'),
        resource_tags=pulumi.get(__ret__, 'resource_tags'),
        updated_at=pulumi.get(__ret__, 'updated_at'))


@_utilities.lift_output_func(get_repository_creation_template)
def get_repository_creation_template_output(prefix: Optional[pulumi.Input[str]] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRepositoryCreationTemplateResult]:
    """
    AWS::ECR::RepositoryCreationTemplate is used to create repository with configuration from a pre-defined template.


    :param str prefix: The prefix use to match the repository name and apply the template.
    """
    ...
