# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = ['KeyPairArgs', 'KeyPair']

@pulumi.input_type
class KeyPairArgs:
    def __init__(__self__, *,
                 key_name: pulumi.Input[str],
                 key_format: Optional[pulumi.Input['KeyPairKeyFormat']] = None,
                 key_type: Optional[pulumi.Input['KeyPairKeyType']] = None,
                 public_key_material: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]] = None):
        """
        The set of arguments for constructing a KeyPair resource.
        :param pulumi.Input[str] key_name: A unique name for the key pair.
                Constraints: Up to 255 ASCII characters
        :param pulumi.Input['KeyPairKeyFormat'] key_format: The format of the key pair.
                Default: ``pem``
        :param pulumi.Input['KeyPairKeyType'] key_type: The type of key pair. Note that ED25519 keys are not supported for Windows instances.
                If the ``PublicKeyMaterial`` property is specified, the ``KeyType`` property is ignored, and the key type is inferred from the ``PublicKeyMaterial`` value.
                Default: ``rsa``
        :param pulumi.Input[str] public_key_material: The public key material. The ``PublicKeyMaterial`` property is used to import a key pair. If this property is not specified, then a new key pair will be created.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]] tags: The tags to apply to the key pair.
        """
        pulumi.set(__self__, "key_name", key_name)
        if key_format is not None:
            pulumi.set(__self__, "key_format", key_format)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if public_key_material is not None:
            pulumi.set(__self__, "public_key_material", public_key_material)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Input[str]:
        """
        A unique name for the key pair.
         Constraints: Up to 255 ASCII characters
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="keyFormat")
    def key_format(self) -> Optional[pulumi.Input['KeyPairKeyFormat']]:
        """
        The format of the key pair.
         Default: ``pem``
        """
        return pulumi.get(self, "key_format")

    @key_format.setter
    def key_format(self, value: Optional[pulumi.Input['KeyPairKeyFormat']]):
        pulumi.set(self, "key_format", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input['KeyPairKeyType']]:
        """
        The type of key pair. Note that ED25519 keys are not supported for Windows instances.
         If the ``PublicKeyMaterial`` property is specified, the ``KeyType`` property is ignored, and the key type is inferred from the ``PublicKeyMaterial`` value.
         Default: ``rsa``
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input['KeyPairKeyType']]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter(name="publicKeyMaterial")
    def public_key_material(self) -> Optional[pulumi.Input[str]]:
        """
        The public key material. The ``PublicKeyMaterial`` property is used to import a key pair. If this property is not specified, then a new key pair will be created.
        """
        return pulumi.get(self, "public_key_material")

    @public_key_material.setter
    def public_key_material(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key_material", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]]:
        """
        The tags to apply to the key pair.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]]):
        pulumi.set(self, "tags", value)


class KeyPair(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key_format: Optional[pulumi.Input['KeyPairKeyFormat']] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 key_type: Optional[pulumi.Input['KeyPairKeyType']] = None,
                 public_key_material: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.CreateOnlyTagArgs']]]]] = None,
                 __props__=None):
        """
        Specifies a key pair for use with an EC2long instance as follows:
          +  To import an existing key pair, include the ``PublicKeyMaterial`` property.
          +  To create a new key pair, omit the ``PublicKeyMaterial`` property.

         When you import an existing key pair, you specify the public key material for the key. We assume that you have the private key material for the key. CFNlong does not create or return the private key material when you import a key pair.
         When you create a new key pair, the private key is saved to SYSlong Parameter Store, using a parameter with the following name: ``/ec2/keypair/{key_pair_id}``. For more information about retrieving private key, and the required permissions, see [Create a key pair using](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-key-pairs.html#create-key-pair-cloudformation) in the *User Guide*.
         When CFN deletes a key pair that was created or imported by a stack, it also deletes the parameter that was used to store the private key material in Parameter Store.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        new_key_pair = aws_native.ec2.KeyPair("newKeyPair", key_name="MyKeyPair")
        ec2_instance = aws_native.ec2.Instance("ec2Instance",
            image_id="ami-02b92c281a4d3dc79",
            key_name=new_key_pair.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        new_key_pair = aws_native.ec2.KeyPair("newKeyPair", key_name="MyKeyPair")
        ec2_instance = aws_native.ec2.Instance("ec2Instance",
            image_id="ami-02b92c281a4d3dc79",
            key_name=new_key_pair.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        imported_key_pair = aws_native.ec2.KeyPair("importedKeyPair",
            key_name="NameForMyImportedKeyPair",
            public_key_material="ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAICfp1F7DhdWZdqkYAUGCzcBsLmJeu9izpIyGpmmg7eCz example")
        ec2_instance = aws_native.ec2.Instance("ec2Instance",
            image_id="ami-02b92c281a4d3dc79",
            key_name=imported_key_pair.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        imported_key_pair = aws_native.ec2.KeyPair("importedKeyPair",
            key_name="NameForMyImportedKeyPair",
            public_key_material="ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAICfp1F7DhdWZdqkYAUGCzcBsLmJeu9izpIyGpmmg7eCz example")
        ec2_instance = aws_native.ec2.Instance("ec2Instance",
            image_id="ami-02b92c281a4d3dc79",
            key_name=imported_key_pair.id)

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['KeyPairKeyFormat'] key_format: The format of the key pair.
                Default: ``pem``
        :param pulumi.Input[str] key_name: A unique name for the key pair.
                Constraints: Up to 255 ASCII characters
        :param pulumi.Input['KeyPairKeyType'] key_type: The type of key pair. Note that ED25519 keys are not supported for Windows instances.
                If the ``PublicKeyMaterial`` property is specified, the ``KeyType`` property is ignored, and the key type is inferred from the ``PublicKeyMaterial`` value.
                Default: ``rsa``
        :param pulumi.Input[str] public_key_material: The public key material. The ``PublicKeyMaterial`` property is used to import a key pair. If this property is not specified, then a new key pair will be created.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.CreateOnlyTagArgs']]]] tags: The tags to apply to the key pair.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KeyPairArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Specifies a key pair for use with an EC2long instance as follows:
          +  To import an existing key pair, include the ``PublicKeyMaterial`` property.
          +  To create a new key pair, omit the ``PublicKeyMaterial`` property.

         When you import an existing key pair, you specify the public key material for the key. We assume that you have the private key material for the key. CFNlong does not create or return the private key material when you import a key pair.
         When you create a new key pair, the private key is saved to SYSlong Parameter Store, using a parameter with the following name: ``/ec2/keypair/{key_pair_id}``. For more information about retrieving private key, and the required permissions, see [Create a key pair using](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-key-pairs.html#create-key-pair-cloudformation) in the *User Guide*.
         When CFN deletes a key pair that was created or imported by a stack, it also deletes the parameter that was used to store the private key material in Parameter Store.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        new_key_pair = aws_native.ec2.KeyPair("newKeyPair", key_name="MyKeyPair")
        ec2_instance = aws_native.ec2.Instance("ec2Instance",
            image_id="ami-02b92c281a4d3dc79",
            key_name=new_key_pair.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        new_key_pair = aws_native.ec2.KeyPair("newKeyPair", key_name="MyKeyPair")
        ec2_instance = aws_native.ec2.Instance("ec2Instance",
            image_id="ami-02b92c281a4d3dc79",
            key_name=new_key_pair.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        imported_key_pair = aws_native.ec2.KeyPair("importedKeyPair",
            key_name="NameForMyImportedKeyPair",
            public_key_material="ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAICfp1F7DhdWZdqkYAUGCzcBsLmJeu9izpIyGpmmg7eCz example")
        ec2_instance = aws_native.ec2.Instance("ec2Instance",
            image_id="ami-02b92c281a4d3dc79",
            key_name=imported_key_pair.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        imported_key_pair = aws_native.ec2.KeyPair("importedKeyPair",
            key_name="NameForMyImportedKeyPair",
            public_key_material="ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAICfp1F7DhdWZdqkYAUGCzcBsLmJeu9izpIyGpmmg7eCz example")
        ec2_instance = aws_native.ec2.Instance("ec2Instance",
            image_id="ami-02b92c281a4d3dc79",
            key_name=imported_key_pair.id)

        ```

        :param str resource_name: The name of the resource.
        :param KeyPairArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeyPairArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key_format: Optional[pulumi.Input['KeyPairKeyFormat']] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 key_type: Optional[pulumi.Input['KeyPairKeyType']] = None,
                 public_key_material: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.CreateOnlyTagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeyPairArgs.__new__(KeyPairArgs)

            __props__.__dict__["key_format"] = key_format
            if key_name is None and not opts.urn:
                raise TypeError("Missing required property 'key_name'")
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["key_type"] = key_type
            __props__.__dict__["public_key_material"] = public_key_material
            __props__.__dict__["tags"] = tags
            __props__.__dict__["key_fingerprint"] = None
            __props__.__dict__["key_pair_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["keyFormat", "keyName", "keyType", "publicKeyMaterial", "tags[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(KeyPair, __self__).__init__(
            'aws-native:ec2:KeyPair',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'KeyPair':
        """
        Get an existing KeyPair resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = KeyPairArgs.__new__(KeyPairArgs)

        __props__.__dict__["key_fingerprint"] = None
        __props__.__dict__["key_format"] = None
        __props__.__dict__["key_name"] = None
        __props__.__dict__["key_pair_id"] = None
        __props__.__dict__["key_type"] = None
        __props__.__dict__["public_key_material"] = None
        __props__.__dict__["tags"] = None
        return KeyPair(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="keyFingerprint")
    def key_fingerprint(self) -> pulumi.Output[str]:
        return pulumi.get(self, "key_fingerprint")

    @property
    @pulumi.getter(name="keyFormat")
    def key_format(self) -> pulumi.Output[Optional['KeyPairKeyFormat']]:
        """
        The format of the key pair.
         Default: ``pem``
        """
        return pulumi.get(self, "key_format")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[str]:
        """
        A unique name for the key pair.
         Constraints: Up to 255 ASCII characters
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="keyPairId")
    def key_pair_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "key_pair_id")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Output[Optional['KeyPairKeyType']]:
        """
        The type of key pair. Note that ED25519 keys are not supported for Windows instances.
         If the ``PublicKeyMaterial`` property is specified, the ``KeyType`` property is ignored, and the key type is inferred from the ``PublicKeyMaterial`` value.
         Default: ``rsa``
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter(name="publicKeyMaterial")
    def public_key_material(self) -> pulumi.Output[Optional[str]]:
        """
        The public key material. The ``PublicKeyMaterial`` property is used to import a key pair. If this property is not specified, then a new key pair will be created.
        """
        return pulumi.get(self, "public_key_material")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.CreateOnlyTag']]]:
        """
        The tags to apply to the key pair.
        """
        return pulumi.get(self, "tags")

