# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['IpamResourceDiscoveryAssociationArgs', 'IpamResourceDiscoveryAssociation']

@pulumi.input_type
class IpamResourceDiscoveryAssociationArgs:
    def __init__(__self__, *,
                 ipam_id: pulumi.Input[str],
                 ipam_resource_discovery_id: pulumi.Input[str],
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a IpamResourceDiscoveryAssociation resource.
        :param pulumi.Input[str] ipam_id: The Id of the IPAM this Resource Discovery is associated to.
        :param pulumi.Input[str] ipam_resource_discovery_id: The Amazon Resource Name (ARN) of the IPAM Resource Discovery Association.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "ipam_id", ipam_id)
        pulumi.set(__self__, "ipam_resource_discovery_id", ipam_resource_discovery_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="ipamId")
    def ipam_id(self) -> pulumi.Input[str]:
        """
        The Id of the IPAM this Resource Discovery is associated to.
        """
        return pulumi.get(self, "ipam_id")

    @ipam_id.setter
    def ipam_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "ipam_id", value)

    @property
    @pulumi.getter(name="ipamResourceDiscoveryId")
    def ipam_resource_discovery_id(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the IPAM Resource Discovery Association.
        """
        return pulumi.get(self, "ipam_resource_discovery_id")

    @ipam_resource_discovery_id.setter
    def ipam_resource_discovery_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "ipam_resource_discovery_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class IpamResourceDiscoveryAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ipam_id: Optional[pulumi.Input[str]] = None,
                 ipam_resource_discovery_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        """
        Resource Schema of AWS::EC2::IPAMResourceDiscoveryAssociation Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ipam_id: The Id of the IPAM this Resource Discovery is associated to.
        :param pulumi.Input[str] ipam_resource_discovery_id: The Amazon Resource Name (ARN) of the IPAM Resource Discovery Association.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpamResourceDiscoveryAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Schema of AWS::EC2::IPAMResourceDiscoveryAssociation Type

        :param str resource_name: The name of the resource.
        :param IpamResourceDiscoveryAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpamResourceDiscoveryAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ipam_id: Optional[pulumi.Input[str]] = None,
                 ipam_resource_discovery_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpamResourceDiscoveryAssociationArgs.__new__(IpamResourceDiscoveryAssociationArgs)

            if ipam_id is None and not opts.urn:
                raise TypeError("Missing required property 'ipam_id'")
            __props__.__dict__["ipam_id"] = ipam_id
            if ipam_resource_discovery_id is None and not opts.urn:
                raise TypeError("Missing required property 'ipam_resource_discovery_id'")
            __props__.__dict__["ipam_resource_discovery_id"] = ipam_resource_discovery_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["ipam_arn"] = None
            __props__.__dict__["ipam_region"] = None
            __props__.__dict__["ipam_resource_discovery_association_arn"] = None
            __props__.__dict__["ipam_resource_discovery_association_id"] = None
            __props__.__dict__["is_default"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["resource_discovery_status"] = None
            __props__.__dict__["state"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["ipamId", "ipamResourceDiscoveryId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(IpamResourceDiscoveryAssociation, __self__).__init__(
            'aws-native:ec2:IpamResourceDiscoveryAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'IpamResourceDiscoveryAssociation':
        """
        Get an existing IpamResourceDiscoveryAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = IpamResourceDiscoveryAssociationArgs.__new__(IpamResourceDiscoveryAssociationArgs)

        __props__.__dict__["ipam_arn"] = None
        __props__.__dict__["ipam_id"] = None
        __props__.__dict__["ipam_region"] = None
        __props__.__dict__["ipam_resource_discovery_association_arn"] = None
        __props__.__dict__["ipam_resource_discovery_association_id"] = None
        __props__.__dict__["ipam_resource_discovery_id"] = None
        __props__.__dict__["is_default"] = None
        __props__.__dict__["owner_id"] = None
        __props__.__dict__["resource_discovery_status"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["tags"] = None
        return IpamResourceDiscoveryAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="ipamArn")
    def ipam_arn(self) -> pulumi.Output[str]:
        """
        Arn of the IPAM.
        """
        return pulumi.get(self, "ipam_arn")

    @property
    @pulumi.getter(name="ipamId")
    def ipam_id(self) -> pulumi.Output[str]:
        """
        The Id of the IPAM this Resource Discovery is associated to.
        """
        return pulumi.get(self, "ipam_id")

    @property
    @pulumi.getter(name="ipamRegion")
    def ipam_region(self) -> pulumi.Output[str]:
        """
        The home region of the IPAM.
        """
        return pulumi.get(self, "ipam_region")

    @property
    @pulumi.getter(name="ipamResourceDiscoveryAssociationArn")
    def ipam_resource_discovery_association_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the resource discovery association is a part of.
        """
        return pulumi.get(self, "ipam_resource_discovery_association_arn")

    @property
    @pulumi.getter(name="ipamResourceDiscoveryAssociationId")
    def ipam_resource_discovery_association_id(self) -> pulumi.Output[str]:
        """
        Id of the IPAM Resource Discovery Association.
        """
        return pulumi.get(self, "ipam_resource_discovery_association_id")

    @property
    @pulumi.getter(name="ipamResourceDiscoveryId")
    def ipam_resource_discovery_id(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the IPAM Resource Discovery Association.
        """
        return pulumi.get(self, "ipam_resource_discovery_id")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[bool]:
        """
        If the Resource Discovery Association exists due as part of CreateIpam.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[str]:
        """
        The AWS Account ID for the account where the shared IPAM exists.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="resourceDiscoveryStatus")
    def resource_discovery_status(self) -> pulumi.Output[str]:
        """
        The status of the resource discovery.
        """
        return pulumi.get(self, "resource_discovery_status")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The operational state of the Resource Discovery Association. Related to Create/Delete activities.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

