# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetVerifiedAccessEndpointResult',
    'AwaitableGetVerifiedAccessEndpointResult',
    'get_verified_access_endpoint',
    'get_verified_access_endpoint_output',
]

@pulumi.output_type
class GetVerifiedAccessEndpointResult:
    def __init__(__self__, creation_time=None, description=None, device_validation_domain=None, endpoint_domain=None, last_updated_time=None, load_balancer_options=None, network_interface_options=None, policy_document=None, policy_enabled=None, sse_specification=None, status=None, tags=None, verified_access_endpoint_id=None, verified_access_group_id=None, verified_access_instance_id=None):
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device_validation_domain and not isinstance(device_validation_domain, str):
            raise TypeError("Expected argument 'device_validation_domain' to be a str")
        pulumi.set(__self__, "device_validation_domain", device_validation_domain)
        if endpoint_domain and not isinstance(endpoint_domain, str):
            raise TypeError("Expected argument 'endpoint_domain' to be a str")
        pulumi.set(__self__, "endpoint_domain", endpoint_domain)
        if last_updated_time and not isinstance(last_updated_time, str):
            raise TypeError("Expected argument 'last_updated_time' to be a str")
        pulumi.set(__self__, "last_updated_time", last_updated_time)
        if load_balancer_options and not isinstance(load_balancer_options, dict):
            raise TypeError("Expected argument 'load_balancer_options' to be a dict")
        pulumi.set(__self__, "load_balancer_options", load_balancer_options)
        if network_interface_options and not isinstance(network_interface_options, dict):
            raise TypeError("Expected argument 'network_interface_options' to be a dict")
        pulumi.set(__self__, "network_interface_options", network_interface_options)
        if policy_document and not isinstance(policy_document, str):
            raise TypeError("Expected argument 'policy_document' to be a str")
        pulumi.set(__self__, "policy_document", policy_document)
        if policy_enabled and not isinstance(policy_enabled, bool):
            raise TypeError("Expected argument 'policy_enabled' to be a bool")
        pulumi.set(__self__, "policy_enabled", policy_enabled)
        if sse_specification and not isinstance(sse_specification, dict):
            raise TypeError("Expected argument 'sse_specification' to be a dict")
        pulumi.set(__self__, "sse_specification", sse_specification)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if verified_access_endpoint_id and not isinstance(verified_access_endpoint_id, str):
            raise TypeError("Expected argument 'verified_access_endpoint_id' to be a str")
        pulumi.set(__self__, "verified_access_endpoint_id", verified_access_endpoint_id)
        if verified_access_group_id and not isinstance(verified_access_group_id, str):
            raise TypeError("Expected argument 'verified_access_group_id' to be a str")
        pulumi.set(__self__, "verified_access_group_id", verified_access_group_id)
        if verified_access_instance_id and not isinstance(verified_access_instance_id, str):
            raise TypeError("Expected argument 'verified_access_instance_id' to be a str")
        pulumi.set(__self__, "verified_access_instance_id", verified_access_instance_id)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[str]:
        """
        The creation time.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description for the AWS Verified Access endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceValidationDomain")
    def device_validation_domain(self) -> Optional[str]:
        """
        Returned if endpoint has a device trust provider attached.
        """
        return pulumi.get(self, "device_validation_domain")

    @property
    @pulumi.getter(name="endpointDomain")
    def endpoint_domain(self) -> Optional[str]:
        """
        A DNS name that is generated for the endpoint.
        """
        return pulumi.get(self, "endpoint_domain")

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[str]:
        """
        The last updated time.
        """
        return pulumi.get(self, "last_updated_time")

    @property
    @pulumi.getter(name="loadBalancerOptions")
    def load_balancer_options(self) -> Optional['outputs.VerifiedAccessEndpointLoadBalancerOptions']:
        """
        The load balancer details if creating the AWS Verified Access endpoint as load-balancer type.
        """
        return pulumi.get(self, "load_balancer_options")

    @property
    @pulumi.getter(name="networkInterfaceOptions")
    def network_interface_options(self) -> Optional['outputs.VerifiedAccessEndpointNetworkInterfaceOptions']:
        """
        The options for network-interface type endpoint.
        """
        return pulumi.get(self, "network_interface_options")

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Optional[str]:
        """
        The AWS Verified Access policy document.
        """
        return pulumi.get(self, "policy_document")

    @property
    @pulumi.getter(name="policyEnabled")
    def policy_enabled(self) -> Optional[bool]:
        """
        The status of the Verified Access policy.
        """
        return pulumi.get(self, "policy_enabled")

    @property
    @pulumi.getter(name="sseSpecification")
    def sse_specification(self) -> Optional['outputs.VerifiedAccessEndpointSseSpecification']:
        """
        The configuration options for customer provided KMS encryption.
        """
        return pulumi.get(self, "sse_specification")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The endpoint status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="verifiedAccessEndpointId")
    def verified_access_endpoint_id(self) -> Optional[str]:
        """
        The ID of the AWS Verified Access endpoint.
        """
        return pulumi.get(self, "verified_access_endpoint_id")

    @property
    @pulumi.getter(name="verifiedAccessGroupId")
    def verified_access_group_id(self) -> Optional[str]:
        """
        The ID of the AWS Verified Access group.
        """
        return pulumi.get(self, "verified_access_group_id")

    @property
    @pulumi.getter(name="verifiedAccessInstanceId")
    def verified_access_instance_id(self) -> Optional[str]:
        """
        The ID of the AWS Verified Access instance.
        """
        return pulumi.get(self, "verified_access_instance_id")


class AwaitableGetVerifiedAccessEndpointResult(GetVerifiedAccessEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVerifiedAccessEndpointResult(
            creation_time=self.creation_time,
            description=self.description,
            device_validation_domain=self.device_validation_domain,
            endpoint_domain=self.endpoint_domain,
            last_updated_time=self.last_updated_time,
            load_balancer_options=self.load_balancer_options,
            network_interface_options=self.network_interface_options,
            policy_document=self.policy_document,
            policy_enabled=self.policy_enabled,
            sse_specification=self.sse_specification,
            status=self.status,
            tags=self.tags,
            verified_access_endpoint_id=self.verified_access_endpoint_id,
            verified_access_group_id=self.verified_access_group_id,
            verified_access_instance_id=self.verified_access_instance_id)


def get_verified_access_endpoint(verified_access_endpoint_id: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVerifiedAccessEndpointResult:
    """
    The AWS::EC2::VerifiedAccessEndpoint resource creates an AWS EC2 Verified Access Endpoint.


    :param str verified_access_endpoint_id: The ID of the AWS Verified Access endpoint.
    """
    __args__ = dict()
    __args__['verifiedAccessEndpointId'] = verified_access_endpoint_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getVerifiedAccessEndpoint', __args__, opts=opts, typ=GetVerifiedAccessEndpointResult).value

    return AwaitableGetVerifiedAccessEndpointResult(
        creation_time=pulumi.get(__ret__, 'creation_time'),
        description=pulumi.get(__ret__, 'description'),
        device_validation_domain=pulumi.get(__ret__, 'device_validation_domain'),
        endpoint_domain=pulumi.get(__ret__, 'endpoint_domain'),
        last_updated_time=pulumi.get(__ret__, 'last_updated_time'),
        load_balancer_options=pulumi.get(__ret__, 'load_balancer_options'),
        network_interface_options=pulumi.get(__ret__, 'network_interface_options'),
        policy_document=pulumi.get(__ret__, 'policy_document'),
        policy_enabled=pulumi.get(__ret__, 'policy_enabled'),
        sse_specification=pulumi.get(__ret__, 'sse_specification'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        verified_access_endpoint_id=pulumi.get(__ret__, 'verified_access_endpoint_id'),
        verified_access_group_id=pulumi.get(__ret__, 'verified_access_group_id'),
        verified_access_instance_id=pulumi.get(__ret__, 'verified_access_instance_id'))


@_utilities.lift_output_func(get_verified_access_endpoint)
def get_verified_access_endpoint_output(verified_access_endpoint_id: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVerifiedAccessEndpointResult]:
    """
    The AWS::EC2::VerifiedAccessEndpoint resource creates an AWS EC2 Verified Access Endpoint.


    :param str verified_access_endpoint_id: The ID of the AWS Verified Access endpoint.
    """
    ...
