# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetKeyPairResult',
    'AwaitableGetKeyPairResult',
    'get_key_pair',
    'get_key_pair_output',
]

@pulumi.output_type
class GetKeyPairResult:
    def __init__(__self__, key_fingerprint=None, key_pair_id=None):
        if key_fingerprint and not isinstance(key_fingerprint, str):
            raise TypeError("Expected argument 'key_fingerprint' to be a str")
        pulumi.set(__self__, "key_fingerprint", key_fingerprint)
        if key_pair_id and not isinstance(key_pair_id, str):
            raise TypeError("Expected argument 'key_pair_id' to be a str")
        pulumi.set(__self__, "key_pair_id", key_pair_id)

    @property
    @pulumi.getter(name="keyFingerprint")
    def key_fingerprint(self) -> Optional[str]:
        return pulumi.get(self, "key_fingerprint")

    @property
    @pulumi.getter(name="keyPairId")
    def key_pair_id(self) -> Optional[str]:
        return pulumi.get(self, "key_pair_id")


class AwaitableGetKeyPairResult(GetKeyPairResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeyPairResult(
            key_fingerprint=self.key_fingerprint,
            key_pair_id=self.key_pair_id)


def get_key_pair(key_name: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeyPairResult:
    """
    Specifies a key pair for use with an EC2long instance as follows:
      +  To import an existing key pair, include the ``PublicKeyMaterial`` property.
      +  To create a new key pair, omit the ``PublicKeyMaterial`` property.

     When you import an existing key pair, you specify the public key material for the key. We assume that you have the private key material for the key. CFNlong does not create or return the private key material when you import a key pair.
     When you create a new key pair, the private key is saved to SYSlong Parameter Store, using a parameter with the following name: ``/ec2/keypair/{key_pair_id}``. For more information about retrieving private key, and the required permissions, see [Create a key pair using](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-key-pairs.html#create-key-pair-cloudformation) in the *User Guide*.
     When CFN deletes a key pair that was created or imported by a stack, it also deletes the parameter that was used to store the private key material in Parameter Store.


    :param str key_name: A unique name for the key pair.
            Constraints: Up to 255 ASCII characters
    """
    __args__ = dict()
    __args__['keyName'] = key_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getKeyPair', __args__, opts=opts, typ=GetKeyPairResult).value

    return AwaitableGetKeyPairResult(
        key_fingerprint=pulumi.get(__ret__, 'key_fingerprint'),
        key_pair_id=pulumi.get(__ret__, 'key_pair_id'))


@_utilities.lift_output_func(get_key_pair)
def get_key_pair_output(key_name: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetKeyPairResult]:
    """
    Specifies a key pair for use with an EC2long instance as follows:
      +  To import an existing key pair, include the ``PublicKeyMaterial`` property.
      +  To create a new key pair, omit the ``PublicKeyMaterial`` property.

     When you import an existing key pair, you specify the public key material for the key. We assume that you have the private key material for the key. CFNlong does not create or return the private key material when you import a key pair.
     When you create a new key pair, the private key is saved to SYSlong Parameter Store, using a parameter with the following name: ``/ec2/keypair/{key_pair_id}``. For more information about retrieving private key, and the required permissions, see [Create a key pair using](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-key-pairs.html#create-key-pair-cloudformation) in the *User Guide*.
     When CFN deletes a key pair that was created or imported by a stack, it also deletes the parameter that was used to store the private key material in Parameter Store.


    :param str key_name: A unique name for the key pair.
            Constraints: Up to 255 ASCII characters
    """
    ...
