# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetIpamScopeResult',
    'AwaitableGetIpamScopeResult',
    'get_ipam_scope',
    'get_ipam_scope_output',
]

@pulumi.output_type
class GetIpamScopeResult:
    def __init__(__self__, arn=None, description=None, ipam_arn=None, ipam_scope_id=None, ipam_scope_type=None, is_default=None, pool_count=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if ipam_arn and not isinstance(ipam_arn, str):
            raise TypeError("Expected argument 'ipam_arn' to be a str")
        pulumi.set(__self__, "ipam_arn", ipam_arn)
        if ipam_scope_id and not isinstance(ipam_scope_id, str):
            raise TypeError("Expected argument 'ipam_scope_id' to be a str")
        pulumi.set(__self__, "ipam_scope_id", ipam_scope_id)
        if ipam_scope_type and not isinstance(ipam_scope_type, str):
            raise TypeError("Expected argument 'ipam_scope_type' to be a str")
        pulumi.set(__self__, "ipam_scope_type", ipam_scope_type)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if pool_count and not isinstance(pool_count, int):
            raise TypeError("Expected argument 'pool_count' to be a int")
        pulumi.set(__self__, "pool_count", pool_count)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the IPAM scope.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ipamArn")
    def ipam_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the IPAM this scope is a part of.
        """
        return pulumi.get(self, "ipam_arn")

    @property
    @pulumi.getter(name="ipamScopeId")
    def ipam_scope_id(self) -> Optional[str]:
        """
        Id of the IPAM scope.
        """
        return pulumi.get(self, "ipam_scope_id")

    @property
    @pulumi.getter(name="ipamScopeType")
    def ipam_scope_type(self) -> Optional['IpamScopeType']:
        """
        Determines whether this scope contains publicly routable space or space for a private network
        """
        return pulumi.get(self, "ipam_scope_type")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[bool]:
        """
        Is this one of the default scopes created with the IPAM.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="poolCount")
    def pool_count(self) -> Optional[int]:
        """
        The number of pools that currently exist in this scope.
        """
        return pulumi.get(self, "pool_count")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetIpamScopeResult(GetIpamScopeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpamScopeResult(
            arn=self.arn,
            description=self.description,
            ipam_arn=self.ipam_arn,
            ipam_scope_id=self.ipam_scope_id,
            ipam_scope_type=self.ipam_scope_type,
            is_default=self.is_default,
            pool_count=self.pool_count,
            tags=self.tags)


def get_ipam_scope(ipam_scope_id: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpamScopeResult:
    """
    Resource Schema of AWS::EC2::IPAMScope Type


    :param str ipam_scope_id: Id of the IPAM scope.
    """
    __args__ = dict()
    __args__['ipamScopeId'] = ipam_scope_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getIpamScope', __args__, opts=opts, typ=GetIpamScopeResult).value

    return AwaitableGetIpamScopeResult(
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        ipam_arn=pulumi.get(__ret__, 'ipam_arn'),
        ipam_scope_id=pulumi.get(__ret__, 'ipam_scope_id'),
        ipam_scope_type=pulumi.get(__ret__, 'ipam_scope_type'),
        is_default=pulumi.get(__ret__, 'is_default'),
        pool_count=pulumi.get(__ret__, 'pool_count'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_ipam_scope)
def get_ipam_scope_output(ipam_scope_id: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIpamScopeResult]:
    """
    Resource Schema of AWS::EC2::IPAMScope Type


    :param str ipam_scope_id: Id of the IPAM scope.
    """
    ...
