# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetInstanceResult',
    'AwaitableGetInstanceResult',
    'get_instance',
    'get_instance_output',
]

@pulumi.output_type
class GetInstanceResult:
    def __init__(__self__, affinity=None, block_device_mappings=None, credit_specification=None, disable_api_termination=None, ebs_optimized=None, host_id=None, iam_instance_profile=None, instance_id=None, instance_initiated_shutdown_behavior=None, instance_type=None, kernel_id=None, monitoring=None, private_dns_name=None, private_dns_name_options=None, private_ip=None, public_dns_name=None, public_ip=None, ramdisk_id=None, security_group_ids=None, source_dest_check=None, ssm_associations=None, tags=None, tenancy=None, user_data=None, volumes=None, vpc_id=None):
        if affinity and not isinstance(affinity, str):
            raise TypeError("Expected argument 'affinity' to be a str")
        pulumi.set(__self__, "affinity", affinity)
        if block_device_mappings and not isinstance(block_device_mappings, list):
            raise TypeError("Expected argument 'block_device_mappings' to be a list")
        pulumi.set(__self__, "block_device_mappings", block_device_mappings)
        if credit_specification and not isinstance(credit_specification, dict):
            raise TypeError("Expected argument 'credit_specification' to be a dict")
        pulumi.set(__self__, "credit_specification", credit_specification)
        if disable_api_termination and not isinstance(disable_api_termination, bool):
            raise TypeError("Expected argument 'disable_api_termination' to be a bool")
        pulumi.set(__self__, "disable_api_termination", disable_api_termination)
        if ebs_optimized and not isinstance(ebs_optimized, bool):
            raise TypeError("Expected argument 'ebs_optimized' to be a bool")
        pulumi.set(__self__, "ebs_optimized", ebs_optimized)
        if host_id and not isinstance(host_id, str):
            raise TypeError("Expected argument 'host_id' to be a str")
        pulumi.set(__self__, "host_id", host_id)
        if iam_instance_profile and not isinstance(iam_instance_profile, str):
            raise TypeError("Expected argument 'iam_instance_profile' to be a str")
        pulumi.set(__self__, "iam_instance_profile", iam_instance_profile)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if instance_initiated_shutdown_behavior and not isinstance(instance_initiated_shutdown_behavior, str):
            raise TypeError("Expected argument 'instance_initiated_shutdown_behavior' to be a str")
        pulumi.set(__self__, "instance_initiated_shutdown_behavior", instance_initiated_shutdown_behavior)
        if instance_type and not isinstance(instance_type, str):
            raise TypeError("Expected argument 'instance_type' to be a str")
        pulumi.set(__self__, "instance_type", instance_type)
        if kernel_id and not isinstance(kernel_id, str):
            raise TypeError("Expected argument 'kernel_id' to be a str")
        pulumi.set(__self__, "kernel_id", kernel_id)
        if monitoring and not isinstance(monitoring, bool):
            raise TypeError("Expected argument 'monitoring' to be a bool")
        pulumi.set(__self__, "monitoring", monitoring)
        if private_dns_name and not isinstance(private_dns_name, str):
            raise TypeError("Expected argument 'private_dns_name' to be a str")
        pulumi.set(__self__, "private_dns_name", private_dns_name)
        if private_dns_name_options and not isinstance(private_dns_name_options, dict):
            raise TypeError("Expected argument 'private_dns_name_options' to be a dict")
        pulumi.set(__self__, "private_dns_name_options", private_dns_name_options)
        if private_ip and not isinstance(private_ip, str):
            raise TypeError("Expected argument 'private_ip' to be a str")
        pulumi.set(__self__, "private_ip", private_ip)
        if public_dns_name and not isinstance(public_dns_name, str):
            raise TypeError("Expected argument 'public_dns_name' to be a str")
        pulumi.set(__self__, "public_dns_name", public_dns_name)
        if public_ip and not isinstance(public_ip, str):
            raise TypeError("Expected argument 'public_ip' to be a str")
        pulumi.set(__self__, "public_ip", public_ip)
        if ramdisk_id and not isinstance(ramdisk_id, str):
            raise TypeError("Expected argument 'ramdisk_id' to be a str")
        pulumi.set(__self__, "ramdisk_id", ramdisk_id)
        if security_group_ids and not isinstance(security_group_ids, list):
            raise TypeError("Expected argument 'security_group_ids' to be a list")
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        if source_dest_check and not isinstance(source_dest_check, bool):
            raise TypeError("Expected argument 'source_dest_check' to be a bool")
        pulumi.set(__self__, "source_dest_check", source_dest_check)
        if ssm_associations and not isinstance(ssm_associations, list):
            raise TypeError("Expected argument 'ssm_associations' to be a list")
        pulumi.set(__self__, "ssm_associations", ssm_associations)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tenancy and not isinstance(tenancy, str):
            raise TypeError("Expected argument 'tenancy' to be a str")
        pulumi.set(__self__, "tenancy", tenancy)
        if user_data and not isinstance(user_data, str):
            raise TypeError("Expected argument 'user_data' to be a str")
        pulumi.set(__self__, "user_data", user_data)
        if volumes and not isinstance(volumes, list):
            raise TypeError("Expected argument 'volumes' to be a list")
        pulumi.set(__self__, "volumes", volumes)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def affinity(self) -> Optional['InstanceAffinity']:
        """
        Indicates whether the instance is associated with a dedicated host. If you want the instance to always restart on the same host on which it was launched, specify host. If you want the instance to restart on any available host, but try to launch onto the last host it ran on (on a best-effort basis), specify default.
        """
        return pulumi.get(self, "affinity")

    @property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> Optional[Sequence['outputs.InstanceBlockDeviceMapping']]:
        """
        The block device mapping entries that defines the block devices to attach to the instance at launch.
        """
        return pulumi.get(self, "block_device_mappings")

    @property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> Optional['outputs.CreditSpecificationProperties']:
        """
        The credit option for CPU usage of the burstable performance instance. Valid values are standard and unlimited.
        """
        return pulumi.get(self, "credit_specification")

    @property
    @pulumi.getter(name="disableApiTermination")
    def disable_api_termination(self) -> Optional[bool]:
        """
        If you set this parameter to true, you can't terminate the instance using the Amazon EC2 console, CLI, or API; otherwise, you can.
        """
        return pulumi.get(self, "disable_api_termination")

    @property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> Optional[bool]:
        """
        Indicates whether the instance is optimized for Amazon EBS I/O.
        """
        return pulumi.get(self, "ebs_optimized")

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[str]:
        """
        If you specify host for the Affinity property, the ID of a dedicated host that the instance is associated with. If you don't specify an ID, Amazon EC2 launches the instance onto any available, compatible dedicated host in your account.
        """
        return pulumi.get(self, "host_id")

    @property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> Optional[str]:
        """
        The IAM instance profile.
        """
        return pulumi.get(self, "iam_instance_profile")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        """
        The EC2 Instance ID.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceInitiatedShutdownBehavior")
    def instance_initiated_shutdown_behavior(self) -> Optional[str]:
        """
        Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
        """
        return pulumi.get(self, "instance_initiated_shutdown_behavior")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        """
        The instance type.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="kernelId")
    def kernel_id(self) -> Optional[str]:
        """
        The ID of the kernel.
        """
        return pulumi.get(self, "kernel_id")

    @property
    @pulumi.getter
    def monitoring(self) -> Optional[bool]:
        """
        Specifies whether detailed monitoring is enabled for the instance.
        """
        return pulumi.get(self, "monitoring")

    @property
    @pulumi.getter(name="privateDnsName")
    def private_dns_name(self) -> Optional[str]:
        """
        The private DNS name of the specified instance. For example: ip-10-24-34-0.ec2.internal.
        """
        return pulumi.get(self, "private_dns_name")

    @property
    @pulumi.getter(name="privateDnsNameOptions")
    def private_dns_name_options(self) -> Optional['outputs.InstancePrivateDnsNameOptions']:
        """
        The options for the instance hostname.
        """
        return pulumi.get(self, "private_dns_name_options")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[str]:
        """
        The private IP address of the specified instance. For example: 10.24.34.0.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicDnsName")
    def public_dns_name(self) -> Optional[str]:
        """
        The public DNS name of the specified instance. For example: ec2-107-20-50-45.compute-1.amazonaws.com.
        """
        return pulumi.get(self, "public_dns_name")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[str]:
        """
        The public IP address of the specified instance. For example: 192.0.2.0.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="ramdiskId")
    def ramdisk_id(self) -> Optional[str]:
        """
        The ID of the RAM disk to select.
        """
        return pulumi.get(self, "ramdisk_id")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[str]]:
        """
        The IDs of the security groups.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> Optional[bool]:
        """
        Specifies whether to enable an instance launched in a VPC to perform NAT.
        """
        return pulumi.get(self, "source_dest_check")

    @property
    @pulumi.getter(name="ssmAssociations")
    def ssm_associations(self) -> Optional[Sequence['outputs.InstanceSsmAssociation']]:
        """
        The SSM document and parameter values in AWS Systems Manager to associate with this instance.
        """
        return pulumi.get(self, "ssm_associations")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags to add to the instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def tenancy(self) -> Optional[str]:
        """
        The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of dedicated runs on single-tenant hardware.
        """
        return pulumi.get(self, "tenancy")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[str]:
        """
        The user data to make available to the instance.
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.InstanceVolume']]:
        """
        The volumes to attach to the instance.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        The ID of the VPC that the instance is running in.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetInstanceResult(GetInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceResult(
            affinity=self.affinity,
            block_device_mappings=self.block_device_mappings,
            credit_specification=self.credit_specification,
            disable_api_termination=self.disable_api_termination,
            ebs_optimized=self.ebs_optimized,
            host_id=self.host_id,
            iam_instance_profile=self.iam_instance_profile,
            instance_id=self.instance_id,
            instance_initiated_shutdown_behavior=self.instance_initiated_shutdown_behavior,
            instance_type=self.instance_type,
            kernel_id=self.kernel_id,
            monitoring=self.monitoring,
            private_dns_name=self.private_dns_name,
            private_dns_name_options=self.private_dns_name_options,
            private_ip=self.private_ip,
            public_dns_name=self.public_dns_name,
            public_ip=self.public_ip,
            ramdisk_id=self.ramdisk_id,
            security_group_ids=self.security_group_ids,
            source_dest_check=self.source_dest_check,
            ssm_associations=self.ssm_associations,
            tags=self.tags,
            tenancy=self.tenancy,
            user_data=self.user_data,
            volumes=self.volumes,
            vpc_id=self.vpc_id)


def get_instance(instance_id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceResult:
    """
    Resource Type definition for AWS::EC2::Instance


    :param str instance_id: The EC2 Instance ID.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getInstance', __args__, opts=opts, typ=GetInstanceResult).value

    return AwaitableGetInstanceResult(
        affinity=pulumi.get(__ret__, 'affinity'),
        block_device_mappings=pulumi.get(__ret__, 'block_device_mappings'),
        credit_specification=pulumi.get(__ret__, 'credit_specification'),
        disable_api_termination=pulumi.get(__ret__, 'disable_api_termination'),
        ebs_optimized=pulumi.get(__ret__, 'ebs_optimized'),
        host_id=pulumi.get(__ret__, 'host_id'),
        iam_instance_profile=pulumi.get(__ret__, 'iam_instance_profile'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        instance_initiated_shutdown_behavior=pulumi.get(__ret__, 'instance_initiated_shutdown_behavior'),
        instance_type=pulumi.get(__ret__, 'instance_type'),
        kernel_id=pulumi.get(__ret__, 'kernel_id'),
        monitoring=pulumi.get(__ret__, 'monitoring'),
        private_dns_name=pulumi.get(__ret__, 'private_dns_name'),
        private_dns_name_options=pulumi.get(__ret__, 'private_dns_name_options'),
        private_ip=pulumi.get(__ret__, 'private_ip'),
        public_dns_name=pulumi.get(__ret__, 'public_dns_name'),
        public_ip=pulumi.get(__ret__, 'public_ip'),
        ramdisk_id=pulumi.get(__ret__, 'ramdisk_id'),
        security_group_ids=pulumi.get(__ret__, 'security_group_ids'),
        source_dest_check=pulumi.get(__ret__, 'source_dest_check'),
        ssm_associations=pulumi.get(__ret__, 'ssm_associations'),
        tags=pulumi.get(__ret__, 'tags'),
        tenancy=pulumi.get(__ret__, 'tenancy'),
        user_data=pulumi.get(__ret__, 'user_data'),
        volumes=pulumi.get(__ret__, 'volumes'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))


@_utilities.lift_output_func(get_instance)
def get_instance_output(instance_id: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInstanceResult]:
    """
    Resource Type definition for AWS::EC2::Instance


    :param str instance_id: The EC2 Instance ID.
    """
    ...
