# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['MigrationProjectArgs', 'MigrationProject']

@pulumi.input_type
class MigrationProjectArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_profile_arn: Optional[pulumi.Input[str]] = None,
                 instance_profile_identifier: Optional[pulumi.Input[str]] = None,
                 instance_profile_name: Optional[pulumi.Input[str]] = None,
                 migration_project_creation_time: Optional[pulumi.Input[str]] = None,
                 migration_project_identifier: Optional[pulumi.Input[str]] = None,
                 migration_project_name: Optional[pulumi.Input[str]] = None,
                 schema_conversion_application_attributes: Optional[pulumi.Input['SchemaConversionApplicationAttributesPropertiesArgs']] = None,
                 source_data_provider_descriptors: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationProjectDataProviderDescriptorArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 target_data_provider_descriptors: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationProjectDataProviderDescriptorArgs']]]] = None,
                 transformation_rules: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MigrationProject resource.
        :param pulumi.Input[str] description: The optional description of the migration project.
        :param pulumi.Input[str] instance_profile_arn: The property describes an instance profile arn for the migration project. For read
        :param pulumi.Input[str] instance_profile_identifier: The property describes an instance profile identifier for the migration project. For create
        :param pulumi.Input[str] instance_profile_name: The property describes an instance profile name for the migration project. For read
        :param pulumi.Input[str] migration_project_creation_time: The property describes a creating time of the migration project.
        :param pulumi.Input[str] migration_project_identifier: The property describes an identifier for the migration project. It is used for describing/deleting/modifying can be name/arn
        :param pulumi.Input[str] migration_project_name: The property describes a name to identify the migration project.
        :param pulumi.Input['SchemaConversionApplicationAttributesPropertiesArgs'] schema_conversion_application_attributes: The property describes schema conversion application attributes for the migration project.
        :param pulumi.Input[Sequence[pulumi.Input['MigrationProjectDataProviderDescriptorArgs']]] source_data_provider_descriptors: The property describes source data provider descriptors for the migration project.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[Sequence[pulumi.Input['MigrationProjectDataProviderDescriptorArgs']]] target_data_provider_descriptors: The property describes target data provider descriptors for the migration project.
        :param pulumi.Input[str] transformation_rules: The property describes transformation rules for the migration project.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_profile_arn is not None:
            pulumi.set(__self__, "instance_profile_arn", instance_profile_arn)
        if instance_profile_identifier is not None:
            pulumi.set(__self__, "instance_profile_identifier", instance_profile_identifier)
        if instance_profile_name is not None:
            pulumi.set(__self__, "instance_profile_name", instance_profile_name)
        if migration_project_creation_time is not None:
            pulumi.set(__self__, "migration_project_creation_time", migration_project_creation_time)
        if migration_project_identifier is not None:
            pulumi.set(__self__, "migration_project_identifier", migration_project_identifier)
        if migration_project_name is not None:
            pulumi.set(__self__, "migration_project_name", migration_project_name)
        if schema_conversion_application_attributes is not None:
            pulumi.set(__self__, "schema_conversion_application_attributes", schema_conversion_application_attributes)
        if source_data_provider_descriptors is not None:
            pulumi.set(__self__, "source_data_provider_descriptors", source_data_provider_descriptors)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_data_provider_descriptors is not None:
            pulumi.set(__self__, "target_data_provider_descriptors", target_data_provider_descriptors)
        if transformation_rules is not None:
            pulumi.set(__self__, "transformation_rules", transformation_rules)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The optional description of the migration project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="instanceProfileArn")
    def instance_profile_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The property describes an instance profile arn for the migration project. For read
        """
        return pulumi.get(self, "instance_profile_arn")

    @instance_profile_arn.setter
    def instance_profile_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_profile_arn", value)

    @property
    @pulumi.getter(name="instanceProfileIdentifier")
    def instance_profile_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The property describes an instance profile identifier for the migration project. For create
        """
        return pulumi.get(self, "instance_profile_identifier")

    @instance_profile_identifier.setter
    def instance_profile_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_profile_identifier", value)

    @property
    @pulumi.getter(name="instanceProfileName")
    def instance_profile_name(self) -> Optional[pulumi.Input[str]]:
        """
        The property describes an instance profile name for the migration project. For read
        """
        return pulumi.get(self, "instance_profile_name")

    @instance_profile_name.setter
    def instance_profile_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_profile_name", value)

    @property
    @pulumi.getter(name="migrationProjectCreationTime")
    def migration_project_creation_time(self) -> Optional[pulumi.Input[str]]:
        """
        The property describes a creating time of the migration project.
        """
        return pulumi.get(self, "migration_project_creation_time")

    @migration_project_creation_time.setter
    def migration_project_creation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "migration_project_creation_time", value)

    @property
    @pulumi.getter(name="migrationProjectIdentifier")
    def migration_project_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The property describes an identifier for the migration project. It is used for describing/deleting/modifying can be name/arn
        """
        return pulumi.get(self, "migration_project_identifier")

    @migration_project_identifier.setter
    def migration_project_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "migration_project_identifier", value)

    @property
    @pulumi.getter(name="migrationProjectName")
    def migration_project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The property describes a name to identify the migration project.
        """
        return pulumi.get(self, "migration_project_name")

    @migration_project_name.setter
    def migration_project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "migration_project_name", value)

    @property
    @pulumi.getter(name="schemaConversionApplicationAttributes")
    def schema_conversion_application_attributes(self) -> Optional[pulumi.Input['SchemaConversionApplicationAttributesPropertiesArgs']]:
        """
        The property describes schema conversion application attributes for the migration project.
        """
        return pulumi.get(self, "schema_conversion_application_attributes")

    @schema_conversion_application_attributes.setter
    def schema_conversion_application_attributes(self, value: Optional[pulumi.Input['SchemaConversionApplicationAttributesPropertiesArgs']]):
        pulumi.set(self, "schema_conversion_application_attributes", value)

    @property
    @pulumi.getter(name="sourceDataProviderDescriptors")
    def source_data_provider_descriptors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationProjectDataProviderDescriptorArgs']]]]:
        """
        The property describes source data provider descriptors for the migration project.
        """
        return pulumi.get(self, "source_data_provider_descriptors")

    @source_data_provider_descriptors.setter
    def source_data_provider_descriptors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationProjectDataProviderDescriptorArgs']]]]):
        pulumi.set(self, "source_data_provider_descriptors", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetDataProviderDescriptors")
    def target_data_provider_descriptors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationProjectDataProviderDescriptorArgs']]]]:
        """
        The property describes target data provider descriptors for the migration project.
        """
        return pulumi.get(self, "target_data_provider_descriptors")

    @target_data_provider_descriptors.setter
    def target_data_provider_descriptors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationProjectDataProviderDescriptorArgs']]]]):
        pulumi.set(self, "target_data_provider_descriptors", value)

    @property
    @pulumi.getter(name="transformationRules")
    def transformation_rules(self) -> Optional[pulumi.Input[str]]:
        """
        The property describes transformation rules for the migration project.
        """
        return pulumi.get(self, "transformation_rules")

    @transformation_rules.setter
    def transformation_rules(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transformation_rules", value)


class MigrationProject(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_profile_arn: Optional[pulumi.Input[str]] = None,
                 instance_profile_identifier: Optional[pulumi.Input[str]] = None,
                 instance_profile_name: Optional[pulumi.Input[str]] = None,
                 migration_project_creation_time: Optional[pulumi.Input[str]] = None,
                 migration_project_identifier: Optional[pulumi.Input[str]] = None,
                 migration_project_name: Optional[pulumi.Input[str]] = None,
                 schema_conversion_application_attributes: Optional[pulumi.Input[pulumi.InputType['SchemaConversionApplicationAttributesPropertiesArgs']]] = None,
                 source_data_provider_descriptors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationProjectDataProviderDescriptorArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 target_data_provider_descriptors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationProjectDataProviderDescriptorArgs']]]]] = None,
                 transformation_rules: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource schema for AWS::DMS::MigrationProject

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The optional description of the migration project.
        :param pulumi.Input[str] instance_profile_arn: The property describes an instance profile arn for the migration project. For read
        :param pulumi.Input[str] instance_profile_identifier: The property describes an instance profile identifier for the migration project. For create
        :param pulumi.Input[str] instance_profile_name: The property describes an instance profile name for the migration project. For read
        :param pulumi.Input[str] migration_project_creation_time: The property describes a creating time of the migration project.
        :param pulumi.Input[str] migration_project_identifier: The property describes an identifier for the migration project. It is used for describing/deleting/modifying can be name/arn
        :param pulumi.Input[str] migration_project_name: The property describes a name to identify the migration project.
        :param pulumi.Input[pulumi.InputType['SchemaConversionApplicationAttributesPropertiesArgs']] schema_conversion_application_attributes: The property describes schema conversion application attributes for the migration project.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationProjectDataProviderDescriptorArgs']]]] source_data_provider_descriptors: The property describes source data provider descriptors for the migration project.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationProjectDataProviderDescriptorArgs']]]] target_data_provider_descriptors: The property describes target data provider descriptors for the migration project.
        :param pulumi.Input[str] transformation_rules: The property describes transformation rules for the migration project.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[MigrationProjectArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::DMS::MigrationProject

        :param str resource_name: The name of the resource.
        :param MigrationProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MigrationProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_profile_arn: Optional[pulumi.Input[str]] = None,
                 instance_profile_identifier: Optional[pulumi.Input[str]] = None,
                 instance_profile_name: Optional[pulumi.Input[str]] = None,
                 migration_project_creation_time: Optional[pulumi.Input[str]] = None,
                 migration_project_identifier: Optional[pulumi.Input[str]] = None,
                 migration_project_name: Optional[pulumi.Input[str]] = None,
                 schema_conversion_application_attributes: Optional[pulumi.Input[pulumi.InputType['SchemaConversionApplicationAttributesPropertiesArgs']]] = None,
                 source_data_provider_descriptors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationProjectDataProviderDescriptorArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 target_data_provider_descriptors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MigrationProjectDataProviderDescriptorArgs']]]]] = None,
                 transformation_rules: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MigrationProjectArgs.__new__(MigrationProjectArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["instance_profile_arn"] = instance_profile_arn
            __props__.__dict__["instance_profile_identifier"] = instance_profile_identifier
            __props__.__dict__["instance_profile_name"] = instance_profile_name
            __props__.__dict__["migration_project_creation_time"] = migration_project_creation_time
            __props__.__dict__["migration_project_identifier"] = migration_project_identifier
            __props__.__dict__["migration_project_name"] = migration_project_name
            __props__.__dict__["schema_conversion_application_attributes"] = schema_conversion_application_attributes
            __props__.__dict__["source_data_provider_descriptors"] = source_data_provider_descriptors
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_data_provider_descriptors"] = target_data_provider_descriptors
            __props__.__dict__["transformation_rules"] = transformation_rules
            __props__.__dict__["migration_project_arn"] = None
        super(MigrationProject, __self__).__init__(
            'aws-native:dms:MigrationProject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'MigrationProject':
        """
        Get an existing MigrationProject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = MigrationProjectArgs.__new__(MigrationProjectArgs)

        __props__.__dict__["description"] = None
        __props__.__dict__["instance_profile_arn"] = None
        __props__.__dict__["instance_profile_identifier"] = None
        __props__.__dict__["instance_profile_name"] = None
        __props__.__dict__["migration_project_arn"] = None
        __props__.__dict__["migration_project_creation_time"] = None
        __props__.__dict__["migration_project_identifier"] = None
        __props__.__dict__["migration_project_name"] = None
        __props__.__dict__["schema_conversion_application_attributes"] = None
        __props__.__dict__["source_data_provider_descriptors"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["target_data_provider_descriptors"] = None
        __props__.__dict__["transformation_rules"] = None
        return MigrationProject(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The optional description of the migration project.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="instanceProfileArn")
    def instance_profile_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The property describes an instance profile arn for the migration project. For read
        """
        return pulumi.get(self, "instance_profile_arn")

    @property
    @pulumi.getter(name="instanceProfileIdentifier")
    def instance_profile_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        The property describes an instance profile identifier for the migration project. For create
        """
        return pulumi.get(self, "instance_profile_identifier")

    @property
    @pulumi.getter(name="instanceProfileName")
    def instance_profile_name(self) -> pulumi.Output[Optional[str]]:
        """
        The property describes an instance profile name for the migration project. For read
        """
        return pulumi.get(self, "instance_profile_name")

    @property
    @pulumi.getter(name="migrationProjectArn")
    def migration_project_arn(self) -> pulumi.Output[str]:
        """
        The property describes an ARN of the migration project.
        """
        return pulumi.get(self, "migration_project_arn")

    @property
    @pulumi.getter(name="migrationProjectCreationTime")
    def migration_project_creation_time(self) -> pulumi.Output[Optional[str]]:
        """
        The property describes a creating time of the migration project.
        """
        return pulumi.get(self, "migration_project_creation_time")

    @property
    @pulumi.getter(name="migrationProjectIdentifier")
    def migration_project_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        The property describes an identifier for the migration project. It is used for describing/deleting/modifying can be name/arn
        """
        return pulumi.get(self, "migration_project_identifier")

    @property
    @pulumi.getter(name="migrationProjectName")
    def migration_project_name(self) -> pulumi.Output[Optional[str]]:
        """
        The property describes a name to identify the migration project.
        """
        return pulumi.get(self, "migration_project_name")

    @property
    @pulumi.getter(name="schemaConversionApplicationAttributes")
    def schema_conversion_application_attributes(self) -> pulumi.Output[Optional['outputs.SchemaConversionApplicationAttributesProperties']]:
        """
        The property describes schema conversion application attributes for the migration project.
        """
        return pulumi.get(self, "schema_conversion_application_attributes")

    @property
    @pulumi.getter(name="sourceDataProviderDescriptors")
    def source_data_provider_descriptors(self) -> pulumi.Output[Optional[Sequence['outputs.MigrationProjectDataProviderDescriptor']]]:
        """
        The property describes source data provider descriptors for the migration project.
        """
        return pulumi.get(self, "source_data_provider_descriptors")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetDataProviderDescriptors")
    def target_data_provider_descriptors(self) -> pulumi.Output[Optional[Sequence['outputs.MigrationProjectDataProviderDescriptor']]]:
        """
        The property describes target data provider descriptors for the migration project.
        """
        return pulumi.get(self, "target_data_provider_descriptors")

    @property
    @pulumi.getter(name="transformationRules")
    def transformation_rules(self) -> pulumi.Output[Optional[str]]:
        """
        The property describes transformation rules for the migration project.
        """
        return pulumi.get(self, "transformation_rules")

