# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SimpleAdArgs', 'SimpleAd']

@pulumi.input_type
class SimpleAdArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[str],
                 vpc_settings: pulumi.Input['SimpleAdVpcSettingsArgs'],
                 create_alias: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_sso: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 short_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SimpleAd resource.
        :param pulumi.Input[str] size: The size of the directory.
        :param pulumi.Input['SimpleAdVpcSettingsArgs'] vpc_settings: VPC settings of the Simple AD directory server in AWS.
        :param pulumi.Input[bool] create_alias: The name of the configuration set.
        :param pulumi.Input[str] description: Description for the directory.
        :param pulumi.Input[bool] enable_sso: Whether to enable single sign-on for a Simple Active Directory in AWS.
        :param pulumi.Input[str] name: The fully qualified domain name for the AWS Managed Simple AD directory.
        :param pulumi.Input[str] password: The password for the default administrative user named Admin.
        :param pulumi.Input[str] short_name: The NetBIOS name for your domain.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "vpc_settings", vpc_settings)
        if create_alias is not None:
            pulumi.set(__self__, "create_alias", create_alias)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_sso is not None:
            pulumi.set(__self__, "enable_sso", enable_sso)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if short_name is not None:
            pulumi.set(__self__, "short_name", short_name)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[str]:
        """
        The size of the directory.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[str]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="vpcSettings")
    def vpc_settings(self) -> pulumi.Input['SimpleAdVpcSettingsArgs']:
        """
        VPC settings of the Simple AD directory server in AWS.
        """
        return pulumi.get(self, "vpc_settings")

    @vpc_settings.setter
    def vpc_settings(self, value: pulumi.Input['SimpleAdVpcSettingsArgs']):
        pulumi.set(self, "vpc_settings", value)

    @property
    @pulumi.getter(name="createAlias")
    def create_alias(self) -> Optional[pulumi.Input[bool]]:
        """
        The name of the configuration set.
        """
        return pulumi.get(self, "create_alias")

    @create_alias.setter
    def create_alias(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_alias", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the directory.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableSso")
    def enable_sso(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable single sign-on for a Simple Active Directory in AWS.
        """
        return pulumi.get(self, "enable_sso")

    @enable_sso.setter
    def enable_sso(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_sso", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified domain name for the AWS Managed Simple AD directory.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for the default administrative user named Admin.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="shortName")
    def short_name(self) -> Optional[pulumi.Input[str]]:
        """
        The NetBIOS name for your domain.
        """
        return pulumi.get(self, "short_name")

    @short_name.setter
    def short_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "short_name", value)


class SimpleAd(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 create_alias: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_sso: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 short_name: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 vpc_settings: Optional[pulumi.Input[pulumi.InputType['SimpleAdVpcSettingsArgs']]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::DirectoryService::SimpleAD

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] create_alias: The name of the configuration set.
        :param pulumi.Input[str] description: Description for the directory.
        :param pulumi.Input[bool] enable_sso: Whether to enable single sign-on for a Simple Active Directory in AWS.
        :param pulumi.Input[str] name: The fully qualified domain name for the AWS Managed Simple AD directory.
        :param pulumi.Input[str] password: The password for the default administrative user named Admin.
        :param pulumi.Input[str] short_name: The NetBIOS name for your domain.
        :param pulumi.Input[str] size: The size of the directory.
        :param pulumi.Input[pulumi.InputType['SimpleAdVpcSettingsArgs']] vpc_settings: VPC settings of the Simple AD directory server in AWS.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SimpleAdArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::DirectoryService::SimpleAD

        :param str resource_name: The name of the resource.
        :param SimpleAdArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SimpleAdArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 create_alias: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_sso: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 short_name: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 vpc_settings: Optional[pulumi.Input[pulumi.InputType['SimpleAdVpcSettingsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SimpleAdArgs.__new__(SimpleAdArgs)

            __props__.__dict__["create_alias"] = create_alias
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_sso"] = enable_sso
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = password
            __props__.__dict__["short_name"] = short_name
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            if vpc_settings is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_settings'")
            __props__.__dict__["vpc_settings"] = vpc_settings
            __props__.__dict__["alias"] = None
            __props__.__dict__["directory_id"] = None
            __props__.__dict__["dns_ip_addresses"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["createAlias", "description", "name", "password", "shortName", "size", "vpcSettings"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(SimpleAd, __self__).__init__(
            'aws-native:directoryservice:SimpleAd',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SimpleAd':
        """
        Get an existing SimpleAd resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SimpleAdArgs.__new__(SimpleAdArgs)

        __props__.__dict__["alias"] = None
        __props__.__dict__["create_alias"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["directory_id"] = None
        __props__.__dict__["dns_ip_addresses"] = None
        __props__.__dict__["enable_sso"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["password"] = None
        __props__.__dict__["short_name"] = None
        __props__.__dict__["size"] = None
        __props__.__dict__["vpc_settings"] = None
        return SimpleAd(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def alias(self) -> pulumi.Output[str]:
        """
        The alias for a directory.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="createAlias")
    def create_alias(self) -> pulumi.Output[Optional[bool]]:
        """
        The name of the configuration set.
        """
        return pulumi.get(self, "create_alias")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description for the directory.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Output[str]:
        """
        The unique identifier for a directory.
        """
        return pulumi.get(self, "directory_id")

    @property
    @pulumi.getter(name="dnsIpAddresses")
    def dns_ip_addresses(self) -> pulumi.Output[Sequence[str]]:
        """
        The IP addresses of the DNS servers for the directory, such as [ "172.31.3.154", "172.31.63.203" ].
        """
        return pulumi.get(self, "dns_ip_addresses")

    @property
    @pulumi.getter(name="enableSso")
    def enable_sso(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable single sign-on for a Simple Active Directory in AWS.
        """
        return pulumi.get(self, "enable_sso")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The fully qualified domain name for the AWS Managed Simple AD directory.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        The password for the default administrative user named Admin.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="shortName")
    def short_name(self) -> pulumi.Output[Optional[str]]:
        """
        The NetBIOS name for your domain.
        """
        return pulumi.get(self, "short_name")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[str]:
        """
        The size of the directory.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="vpcSettings")
    def vpc_settings(self) -> pulumi.Output['outputs.SimpleAdVpcSettings']:
        """
        VPC settings of the Simple AD directory server in AWS.
        """
        return pulumi.get(self, "vpc_settings")

