# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['VpceConfigurationArgs', 'VpceConfiguration']

@pulumi.input_type
class VpceConfigurationArgs:
    def __init__(__self__, *,
                 service_dns_name: pulumi.Input[str],
                 vpce_service_name: pulumi.Input[str],
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 vpce_configuration_description: Optional[pulumi.Input[str]] = None,
                 vpce_configuration_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a VpceConfiguration resource.
        """
        pulumi.set(__self__, "service_dns_name", service_dns_name)
        pulumi.set(__self__, "vpce_service_name", vpce_service_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpce_configuration_description is not None:
            pulumi.set(__self__, "vpce_configuration_description", vpce_configuration_description)
        if vpce_configuration_name is not None:
            pulumi.set(__self__, "vpce_configuration_name", vpce_configuration_name)

    @property
    @pulumi.getter(name="serviceDnsName")
    def service_dns_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "service_dns_name")

    @service_dns_name.setter
    def service_dns_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_dns_name", value)

    @property
    @pulumi.getter(name="vpceServiceName")
    def vpce_service_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "vpce_service_name")

    @vpce_service_name.setter
    def vpce_service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpce_service_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpceConfigurationDescription")
    def vpce_configuration_description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "vpce_configuration_description")

    @vpce_configuration_description.setter
    def vpce_configuration_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpce_configuration_description", value)

    @property
    @pulumi.getter(name="vpceConfigurationName")
    def vpce_configuration_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "vpce_configuration_name")

    @vpce_configuration_name.setter
    def vpce_configuration_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpce_configuration_name", value)


class VpceConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 service_dns_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 vpce_configuration_description: Optional[pulumi.Input[str]] = None,
                 vpce_configuration_name: Optional[pulumi.Input[str]] = None,
                 vpce_service_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        AWS::DeviceFarm::VPCEConfiguration creates a new Device Farm VPCE Configuration

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpceConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        AWS::DeviceFarm::VPCEConfiguration creates a new Device Farm VPCE Configuration

        :param str resource_name: The name of the resource.
        :param VpceConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpceConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 service_dns_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 vpce_configuration_description: Optional[pulumi.Input[str]] = None,
                 vpce_configuration_name: Optional[pulumi.Input[str]] = None,
                 vpce_service_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpceConfigurationArgs.__new__(VpceConfigurationArgs)

            if service_dns_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_dns_name'")
            __props__.__dict__["service_dns_name"] = service_dns_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpce_configuration_description"] = vpce_configuration_description
            __props__.__dict__["vpce_configuration_name"] = vpce_configuration_name
            if vpce_service_name is None and not opts.urn:
                raise TypeError("Missing required property 'vpce_service_name'")
            __props__.__dict__["vpce_service_name"] = vpce_service_name
            __props__.__dict__["arn"] = None
        super(VpceConfiguration, __self__).__init__(
            'aws-native:devicefarm:VpceConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'VpceConfiguration':
        """
        Get an existing VpceConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = VpceConfigurationArgs.__new__(VpceConfigurationArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["service_dns_name"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["vpce_configuration_description"] = None
        __props__.__dict__["vpce_configuration_name"] = None
        __props__.__dict__["vpce_service_name"] = None
        return VpceConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="serviceDnsName")
    def service_dns_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "service_dns_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpceConfigurationDescription")
    def vpce_configuration_description(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "vpce_configuration_description")

    @property
    @pulumi.getter(name="vpceConfigurationName")
    def vpce_configuration_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "vpce_configuration_name")

    @property
    @pulumi.getter(name="vpceServiceName")
    def vpce_service_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "vpce_service_name")

