# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['FleetArgs', 'Fleet']

@pulumi.input_type
class FleetArgs:
    def __init__(__self__, *,
                 configuration: pulumi.Input[Union['FleetConfiguration0PropertiesArgs', 'FleetConfiguration1PropertiesArgs']],
                 display_name: pulumi.Input[str],
                 max_worker_count: pulumi.Input[int],
                 role_arn: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 farm_id: Optional[pulumi.Input[str]] = None,
                 min_worker_count: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Fleet resource.
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "max_worker_count", max_worker_count)
        pulumi.set(__self__, "role_arn", role_arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if farm_id is not None:
            pulumi.set(__self__, "farm_id", farm_id)
        if min_worker_count is not None:
            pulumi.set(__self__, "min_worker_count", min_worker_count)

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Input[Union['FleetConfiguration0PropertiesArgs', 'FleetConfiguration1PropertiesArgs']]:
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: pulumi.Input[Union['FleetConfiguration0PropertiesArgs', 'FleetConfiguration1PropertiesArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="maxWorkerCount")
    def max_worker_count(self) -> pulumi.Input[int]:
        return pulumi.get(self, "max_worker_count")

    @max_worker_count.setter
    def max_worker_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_worker_count", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="farmId")
    def farm_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "farm_id")

    @farm_id.setter
    def farm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "farm_id", value)

    @property
    @pulumi.getter(name="minWorkerCount")
    def min_worker_count(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "min_worker_count")

    @min_worker_count.setter
    def min_worker_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_worker_count", value)


class Fleet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union[pulumi.InputType['FleetConfiguration0PropertiesArgs'], pulumi.InputType['FleetConfiguration1PropertiesArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 farm_id: Optional[pulumi.Input[str]] = None,
                 max_worker_count: Optional[pulumi.Input[int]] = None,
                 min_worker_count: Optional[pulumi.Input[int]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Definition of AWS::Deadline::Fleet Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FleetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Deadline::Fleet Resource Type

        :param str resource_name: The name of the resource.
        :param FleetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FleetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union[pulumi.InputType['FleetConfiguration0PropertiesArgs'], pulumi.InputType['FleetConfiguration1PropertiesArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 farm_id: Optional[pulumi.Input[str]] = None,
                 max_worker_count: Optional[pulumi.Input[int]] = None,
                 min_worker_count: Optional[pulumi.Input[int]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FleetArgs.__new__(FleetArgs)

            if configuration is None and not opts.urn:
                raise TypeError("Missing required property 'configuration'")
            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["farm_id"] = farm_id
            if max_worker_count is None and not opts.urn:
                raise TypeError("Missing required property 'max_worker_count'")
            __props__.__dict__["max_worker_count"] = max_worker_count
            __props__.__dict__["min_worker_count"] = min_worker_count
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["arn"] = None
            __props__.__dict__["capabilities"] = None
            __props__.__dict__["fleet_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["worker_count"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["farmId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Fleet, __self__).__init__(
            'aws-native:deadline:Fleet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Fleet':
        """
        Get an existing Fleet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = FleetArgs.__new__(FleetArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["capabilities"] = None
        __props__.__dict__["configuration"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["farm_id"] = None
        __props__.__dict__["fleet_id"] = None
        __props__.__dict__["max_worker_count"] = None
        __props__.__dict__["min_worker_count"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["worker_count"] = None
        return Fleet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def capabilities(self) -> pulumi.Output['outputs.FleetCapabilities']:
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output[Any]:
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="farmId")
    def farm_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "farm_id")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter(name="maxWorkerCount")
    def max_worker_count(self) -> pulumi.Output[int]:
        return pulumi.get(self, "max_worker_count")

    @property
    @pulumi.getter(name="minWorkerCount")
    def min_worker_count(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "min_worker_count")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['FleetStatus']:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="workerCount")
    def worker_count(self) -> pulumi.Output[int]:
        return pulumi.get(self, "worker_count")

