# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DataSourceConfigurationInput0Properties',
    'DataSourceConfigurationInput1Properties',
    'DataSourceFilterExpression',
    'DataSourceFormInput',
    'DataSourceGlueRunConfigurationInput',
    'DataSourceRecommendationConfiguration',
    'DataSourceRedshiftClusterStorage',
    'DataSourceRedshiftCredentialConfiguration',
    'DataSourceRedshiftRunConfigurationInput',
    'DataSourceRedshiftServerlessStorage',
    'DataSourceRedshiftStorage0Properties',
    'DataSourceRedshiftStorage1Properties',
    'DataSourceRelationalFilterConfiguration',
    'DataSourceScheduleConfiguration',
    'DomainSingleSignOn',
    'EnvironmentBlueprintConfigurationRegionalParameter',
    'EnvironmentParameter',
    'EnvironmentProfileEnvironmentParameter',
    'SubscriptionTargetForm',
]

@pulumi.output_type
class DataSourceConfigurationInput0Properties(dict):
    """
    Specifies the configuration of the data source. It can be set to either glueRunConfiguration or redshiftRunConfiguration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "glueRunConfiguration":
            suggest = "glue_run_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceConfigurationInput0Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceConfigurationInput0Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceConfigurationInput0Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 glue_run_configuration: Optional['outputs.DataSourceGlueRunConfigurationInput'] = None):
        """
        Specifies the configuration of the data source. It can be set to either glueRunConfiguration or redshiftRunConfiguration.
        """
        if glue_run_configuration is not None:
            pulumi.set(__self__, "glue_run_configuration", glue_run_configuration)

    @property
    @pulumi.getter(name="glueRunConfiguration")
    def glue_run_configuration(self) -> Optional['outputs.DataSourceGlueRunConfigurationInput']:
        return pulumi.get(self, "glue_run_configuration")


@pulumi.output_type
class DataSourceConfigurationInput1Properties(dict):
    """
    Specifies the configuration of the data source. It can be set to either glueRunConfiguration or redshiftRunConfiguration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "redshiftRunConfiguration":
            suggest = "redshift_run_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceConfigurationInput1Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceConfigurationInput1Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceConfigurationInput1Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 redshift_run_configuration: Optional['outputs.DataSourceRedshiftRunConfigurationInput'] = None):
        """
        Specifies the configuration of the data source. It can be set to either glueRunConfiguration or redshiftRunConfiguration.
        """
        if redshift_run_configuration is not None:
            pulumi.set(__self__, "redshift_run_configuration", redshift_run_configuration)

    @property
    @pulumi.getter(name="redshiftRunConfiguration")
    def redshift_run_configuration(self) -> Optional['outputs.DataSourceRedshiftRunConfigurationInput']:
        return pulumi.get(self, "redshift_run_configuration")


@pulumi.output_type
class DataSourceFilterExpression(dict):
    """
    The search filter expression.
    """
    def __init__(__self__, *,
                 expression: str,
                 type: 'DataSourceFilterExpressionType'):
        """
        The search filter expression.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def type(self) -> 'DataSourceFilterExpressionType':
        return pulumi.get(self, "type")


@pulumi.output_type
class DataSourceFormInput(dict):
    """
    The details of a metadata form.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formName":
            suggest = "form_name"
        elif key == "typeIdentifier":
            suggest = "type_identifier"
        elif key == "typeRevision":
            suggest = "type_revision"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceFormInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceFormInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceFormInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 form_name: str,
                 content: Optional[str] = None,
                 type_identifier: Optional[str] = None,
                 type_revision: Optional[str] = None):
        """
        The details of a metadata form.
        :param str form_name: The name of the metadata form.
        :param str content: The content of the metadata form.
        :param str type_identifier: The ID of the metadata form type.
        :param str type_revision: The revision of the metadata form type.
        """
        pulumi.set(__self__, "form_name", form_name)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if type_identifier is not None:
            pulumi.set(__self__, "type_identifier", type_identifier)
        if type_revision is not None:
            pulumi.set(__self__, "type_revision", type_revision)

    @property
    @pulumi.getter(name="formName")
    def form_name(self) -> str:
        """
        The name of the metadata form.
        """
        return pulumi.get(self, "form_name")

    @property
    @pulumi.getter
    def content(self) -> Optional[str]:
        """
        The content of the metadata form.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="typeIdentifier")
    def type_identifier(self) -> Optional[str]:
        """
        The ID of the metadata form type.
        """
        return pulumi.get(self, "type_identifier")

    @property
    @pulumi.getter(name="typeRevision")
    def type_revision(self) -> Optional[str]:
        """
        The revision of the metadata form type.
        """
        return pulumi.get(self, "type_revision")


@pulumi.output_type
class DataSourceGlueRunConfigurationInput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relationalFilterConfigurations":
            suggest = "relational_filter_configurations"
        elif key == "autoImportDataQualityResult":
            suggest = "auto_import_data_quality_result"
        elif key == "dataAccessRole":
            suggest = "data_access_role"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceGlueRunConfigurationInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceGlueRunConfigurationInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceGlueRunConfigurationInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 relational_filter_configurations: Sequence['outputs.DataSourceRelationalFilterConfiguration'],
                 auto_import_data_quality_result: Optional[bool] = None,
                 data_access_role: Optional[str] = None):
        """
        :param Sequence['DataSourceRelationalFilterConfiguration'] relational_filter_configurations: The relational filter configurations included in the configuration details of the AWS Glue data source.
        :param bool auto_import_data_quality_result: Specifies whether to automatically import data quality metrics as part of the data source run.
        :param str data_access_role: The data access role included in the configuration details of the AWS Glue data source.
        """
        pulumi.set(__self__, "relational_filter_configurations", relational_filter_configurations)
        if auto_import_data_quality_result is not None:
            pulumi.set(__self__, "auto_import_data_quality_result", auto_import_data_quality_result)
        if data_access_role is not None:
            pulumi.set(__self__, "data_access_role", data_access_role)

    @property
    @pulumi.getter(name="relationalFilterConfigurations")
    def relational_filter_configurations(self) -> Sequence['outputs.DataSourceRelationalFilterConfiguration']:
        """
        The relational filter configurations included in the configuration details of the AWS Glue data source.
        """
        return pulumi.get(self, "relational_filter_configurations")

    @property
    @pulumi.getter(name="autoImportDataQualityResult")
    def auto_import_data_quality_result(self) -> Optional[bool]:
        """
        Specifies whether to automatically import data quality metrics as part of the data source run.
        """
        return pulumi.get(self, "auto_import_data_quality_result")

    @property
    @pulumi.getter(name="dataAccessRole")
    def data_access_role(self) -> Optional[str]:
        """
        The data access role included in the configuration details of the AWS Glue data source.
        """
        return pulumi.get(self, "data_access_role")


@pulumi.output_type
class DataSourceRecommendationConfiguration(dict):
    """
    The recommendation to be updated as part of the UpdateDataSource action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableBusinessNameGeneration":
            suggest = "enable_business_name_generation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceRecommendationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceRecommendationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceRecommendationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_business_name_generation: Optional[bool] = None):
        """
        The recommendation to be updated as part of the UpdateDataSource action.
        :param bool enable_business_name_generation: Specifies whether automatic business name generation is to be enabled or not as part of the recommendation configuration.
        """
        if enable_business_name_generation is not None:
            pulumi.set(__self__, "enable_business_name_generation", enable_business_name_generation)

    @property
    @pulumi.getter(name="enableBusinessNameGeneration")
    def enable_business_name_generation(self) -> Optional[bool]:
        """
        Specifies whether automatic business name generation is to be enabled or not as part of the recommendation configuration.
        """
        return pulumi.get(self, "enable_business_name_generation")


@pulumi.output_type
class DataSourceRedshiftClusterStorage(dict):
    """
    The name of an Amazon Redshift cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterName":
            suggest = "cluster_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceRedshiftClusterStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceRedshiftClusterStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceRedshiftClusterStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_name: str):
        """
        The name of an Amazon Redshift cluster.
        :param str cluster_name: The name of an Amazon Redshift cluster.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        """
        The name of an Amazon Redshift cluster.
        """
        return pulumi.get(self, "cluster_name")


@pulumi.output_type
class DataSourceRedshiftCredentialConfiguration(dict):
    """
    The ARN of a secret manager for an Amazon Redshift cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretManagerArn":
            suggest = "secret_manager_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceRedshiftCredentialConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceRedshiftCredentialConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceRedshiftCredentialConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_manager_arn: str):
        """
        The ARN of a secret manager for an Amazon Redshift cluster.
        :param str secret_manager_arn: The ARN of a secret manager for an Amazon Redshift cluster.
        """
        pulumi.set(__self__, "secret_manager_arn", secret_manager_arn)

    @property
    @pulumi.getter(name="secretManagerArn")
    def secret_manager_arn(self) -> str:
        """
        The ARN of a secret manager for an Amazon Redshift cluster.
        """
        return pulumi.get(self, "secret_manager_arn")


@pulumi.output_type
class DataSourceRedshiftRunConfigurationInput(dict):
    """
    The configuration details of the Amazon Redshift data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "redshiftCredentialConfiguration":
            suggest = "redshift_credential_configuration"
        elif key == "redshiftStorage":
            suggest = "redshift_storage"
        elif key == "relationalFilterConfigurations":
            suggest = "relational_filter_configurations"
        elif key == "dataAccessRole":
            suggest = "data_access_role"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceRedshiftRunConfigurationInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceRedshiftRunConfigurationInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceRedshiftRunConfigurationInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 redshift_credential_configuration: 'outputs.DataSourceRedshiftCredentialConfiguration',
                 redshift_storage: Any,
                 relational_filter_configurations: Sequence['outputs.DataSourceRelationalFilterConfiguration'],
                 data_access_role: Optional[str] = None):
        """
        The configuration details of the Amazon Redshift data source.
        :param 'DataSourceRedshiftCredentialConfiguration' redshift_credential_configuration: The details of the credentials required to access an Amazon Redshift cluster.
        :param Union['DataSourceRedshiftStorage0Properties', 'DataSourceRedshiftStorage1Properties'] redshift_storage: The details of the Amazon Redshift storage as part of the configuration of an Amazon Redshift data source run.
        :param str data_access_role: The data access role included in the configuration details of the Amazon Redshift data source.
        """
        pulumi.set(__self__, "redshift_credential_configuration", redshift_credential_configuration)
        pulumi.set(__self__, "redshift_storage", redshift_storage)
        pulumi.set(__self__, "relational_filter_configurations", relational_filter_configurations)
        if data_access_role is not None:
            pulumi.set(__self__, "data_access_role", data_access_role)

    @property
    @pulumi.getter(name="redshiftCredentialConfiguration")
    def redshift_credential_configuration(self) -> 'outputs.DataSourceRedshiftCredentialConfiguration':
        """
        The details of the credentials required to access an Amazon Redshift cluster.
        """
        return pulumi.get(self, "redshift_credential_configuration")

    @property
    @pulumi.getter(name="redshiftStorage")
    def redshift_storage(self) -> Any:
        """
        The details of the Amazon Redshift storage as part of the configuration of an Amazon Redshift data source run.
        """
        return pulumi.get(self, "redshift_storage")

    @property
    @pulumi.getter(name="relationalFilterConfigurations")
    def relational_filter_configurations(self) -> Sequence['outputs.DataSourceRelationalFilterConfiguration']:
        return pulumi.get(self, "relational_filter_configurations")

    @property
    @pulumi.getter(name="dataAccessRole")
    def data_access_role(self) -> Optional[str]:
        """
        The data access role included in the configuration details of the Amazon Redshift data source.
        """
        return pulumi.get(self, "data_access_role")


@pulumi.output_type
class DataSourceRedshiftServerlessStorage(dict):
    """
    The details of the Amazon Redshift Serverless workgroup storage.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workgroupName":
            suggest = "workgroup_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceRedshiftServerlessStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceRedshiftServerlessStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceRedshiftServerlessStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 workgroup_name: str):
        """
        The details of the Amazon Redshift Serverless workgroup storage.
        :param str workgroup_name: The name of the Amazon Redshift Serverless workgroup.
        """
        pulumi.set(__self__, "workgroup_name", workgroup_name)

    @property
    @pulumi.getter(name="workgroupName")
    def workgroup_name(self) -> str:
        """
        The name of the Amazon Redshift Serverless workgroup.
        """
        return pulumi.get(self, "workgroup_name")


@pulumi.output_type
class DataSourceRedshiftStorage0Properties(dict):
    """
    The details of the Amazon Redshift cluster source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "redshiftClusterSource":
            suggest = "redshift_cluster_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceRedshiftStorage0Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceRedshiftStorage0Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceRedshiftStorage0Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 redshift_cluster_source: 'outputs.DataSourceRedshiftClusterStorage'):
        """
        The details of the Amazon Redshift cluster source.
        """
        pulumi.set(__self__, "redshift_cluster_source", redshift_cluster_source)

    @property
    @pulumi.getter(name="redshiftClusterSource")
    def redshift_cluster_source(self) -> 'outputs.DataSourceRedshiftClusterStorage':
        return pulumi.get(self, "redshift_cluster_source")


@pulumi.output_type
class DataSourceRedshiftStorage1Properties(dict):
    """
    The details of the Amazon Redshift Serverless workgroup source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "redshiftServerlessSource":
            suggest = "redshift_serverless_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceRedshiftStorage1Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceRedshiftStorage1Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceRedshiftStorage1Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 redshift_serverless_source: 'outputs.DataSourceRedshiftServerlessStorage'):
        """
        The details of the Amazon Redshift Serverless workgroup source.
        """
        pulumi.set(__self__, "redshift_serverless_source", redshift_serverless_source)

    @property
    @pulumi.getter(name="redshiftServerlessSource")
    def redshift_serverless_source(self) -> 'outputs.DataSourceRedshiftServerlessStorage':
        return pulumi.get(self, "redshift_serverless_source")


@pulumi.output_type
class DataSourceRelationalFilterConfiguration(dict):
    """
    The relational filter configuration for the data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "filterExpressions":
            suggest = "filter_expressions"
        elif key == "schemaName":
            suggest = "schema_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceRelationalFilterConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceRelationalFilterConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceRelationalFilterConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: str,
                 filter_expressions: Optional[Sequence['outputs.DataSourceFilterExpression']] = None,
                 schema_name: Optional[str] = None):
        """
        The relational filter configuration for the data source.
        :param str database_name: The database name specified in the relational filter configuration for the data source.
        :param Sequence['DataSourceFilterExpression'] filter_expressions: The filter expressions specified in the relational filter configuration for the data source.
        :param str schema_name: The schema name specified in the relational filter configuration for the data source.
        """
        pulumi.set(__self__, "database_name", database_name)
        if filter_expressions is not None:
            pulumi.set(__self__, "filter_expressions", filter_expressions)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        The database name specified in the relational filter configuration for the data source.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="filterExpressions")
    def filter_expressions(self) -> Optional[Sequence['outputs.DataSourceFilterExpression']]:
        """
        The filter expressions specified in the relational filter configuration for the data source.
        """
        return pulumi.get(self, "filter_expressions")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[str]:
        """
        The schema name specified in the relational filter configuration for the data source.
        """
        return pulumi.get(self, "schema_name")


@pulumi.output_type
class DataSourceScheduleConfiguration(dict):
    """
    The schedule of the data source runs.
    """
    def __init__(__self__, *,
                 schedule: Optional[str] = None,
                 timezone: Optional[str] = None):
        """
        The schedule of the data source runs.
        :param str schedule: The schedule of the data source runs.
        :param str timezone: The timezone of the data source run.
        """
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[str]:
        """
        The schedule of the data source runs.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter
    def timezone(self) -> Optional[str]:
        """
        The timezone of the data source run.
        """
        return pulumi.get(self, "timezone")


@pulumi.output_type
class DomainSingleSignOn(dict):
    """
    The single-sign on configuration of the Amazon DataZone domain.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignment":
            suggest = "user_assignment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainSingleSignOn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainSingleSignOn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainSingleSignOn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: Optional['DomainAuthType'] = None,
                 user_assignment: Optional['DomainUserAssignment'] = None):
        """
        The single-sign on configuration of the Amazon DataZone domain.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assignment is not None:
            pulumi.set(__self__, "user_assignment", user_assignment)

    @property
    @pulumi.getter
    def type(self) -> Optional['DomainAuthType']:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignment")
    def user_assignment(self) -> Optional['DomainUserAssignment']:
        return pulumi.get(self, "user_assignment")


@pulumi.output_type
class EnvironmentBlueprintConfigurationRegionalParameter(dict):
    def __init__(__self__, *,
                 parameters: Optional[Mapping[str, str]] = None,
                 region: Optional[str] = None):
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")


@pulumi.output_type
class EnvironmentParameter(dict):
    """
    The parameter details of an environment.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        The parameter details of an environment.
        :param str name: The name of an environment parameter.
        :param str value: The value of an environment parameter.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of an environment parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of an environment parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EnvironmentProfileEnvironmentParameter(dict):
    """
    The parameter details of an environment profile.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        The parameter details of an environment profile.
        :param str name: The name of an environment profile parameter.
        :param str value: The value of an environment profile parameter.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of an environment profile parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of an environment profile parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SubscriptionTargetForm(dict):
    """
    The details of the subscription target configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formName":
            suggest = "form_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionTargetForm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionTargetForm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionTargetForm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: str,
                 form_name: str):
        """
        The details of the subscription target configuration.
        :param str content: The content of the subscription target configuration.
        :param str form_name: The form name included in the subscription target configuration.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "form_name", form_name)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The content of the subscription target configuration.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="formName")
    def form_name(self) -> str:
        """
        The form name included in the subscription target configuration.
        """
        return pulumi.get(self, "form_name")


