# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetDomainResult',
    'AwaitableGetDomainResult',
    'get_domain',
    'get_domain_output',
]

@pulumi.output_type
class GetDomainResult:
    def __init__(__self__, arn=None, created_at=None, description=None, domain_execution_role=None, id=None, last_updated_at=None, managed_account_id=None, name=None, portal_url=None, single_sign_on=None, status=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain_execution_role and not isinstance(domain_execution_role, str):
            raise TypeError("Expected argument 'domain_execution_role' to be a str")
        pulumi.set(__self__, "domain_execution_role", domain_execution_role)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated_at and not isinstance(last_updated_at, str):
            raise TypeError("Expected argument 'last_updated_at' to be a str")
        pulumi.set(__self__, "last_updated_at", last_updated_at)
        if managed_account_id and not isinstance(managed_account_id, str):
            raise TypeError("Expected argument 'managed_account_id' to be a str")
        pulumi.set(__self__, "managed_account_id", managed_account_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if portal_url and not isinstance(portal_url, str):
            raise TypeError("Expected argument 'portal_url' to be a str")
        pulumi.set(__self__, "portal_url", portal_url)
        if single_sign_on and not isinstance(single_sign_on, dict):
            raise TypeError("Expected argument 'single_sign_on' to be a dict")
        pulumi.set(__self__, "single_sign_on", single_sign_on)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The ARN of the Amazon DataZone domain.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of when the Amazon DataZone domain was last updated.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Amazon DataZone domain.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainExecutionRole")
    def domain_execution_role(self) -> Optional[str]:
        """
        The domain execution role that is created when an Amazon DataZone domain is created. The domain execution role is created in the AWS account that houses the Amazon DataZone domain.
        """
        return pulumi.get(self, "domain_execution_role")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The id of the Amazon DataZone domain.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastUpdatedAt")
    def last_updated_at(self) -> Optional[str]:
        """
        The timestamp of when the Amazon DataZone domain was last updated.
        """
        return pulumi.get(self, "last_updated_at")

    @property
    @pulumi.getter(name="managedAccountId")
    def managed_account_id(self) -> Optional[str]:
        """
        The identifier of the AWS account that manages the domain.
        """
        return pulumi.get(self, "managed_account_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the Amazon DataZone domain.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="portalUrl")
    def portal_url(self) -> Optional[str]:
        """
        The URL of the data portal for this Amazon DataZone domain.
        """
        return pulumi.get(self, "portal_url")

    @property
    @pulumi.getter(name="singleSignOn")
    def single_sign_on(self) -> Optional['outputs.DomainSingleSignOn']:
        """
        The single-sign on configuration of the Amazon DataZone domain.
        """
        return pulumi.get(self, "single_sign_on")

    @property
    @pulumi.getter
    def status(self) -> Optional['DomainStatus']:
        """
        The status of the Amazon DataZone domain.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags specified for the Amazon DataZone domain.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDomainResult(GetDomainResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainResult(
            arn=self.arn,
            created_at=self.created_at,
            description=self.description,
            domain_execution_role=self.domain_execution_role,
            id=self.id,
            last_updated_at=self.last_updated_at,
            managed_account_id=self.managed_account_id,
            name=self.name,
            portal_url=self.portal_url,
            single_sign_on=self.single_sign_on,
            status=self.status,
            tags=self.tags)


def get_domain(id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainResult:
    """
    A domain is an organizing entity for connecting together assets, users, and their projects


    :param str id: The id of the Amazon DataZone domain.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:datazone:getDomain', __args__, opts=opts, typ=GetDomainResult).value

    return AwaitableGetDomainResult(
        arn=pulumi.get(__ret__, 'arn'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        domain_execution_role=pulumi.get(__ret__, 'domain_execution_role'),
        id=pulumi.get(__ret__, 'id'),
        last_updated_at=pulumi.get(__ret__, 'last_updated_at'),
        managed_account_id=pulumi.get(__ret__, 'managed_account_id'),
        name=pulumi.get(__ret__, 'name'),
        portal_url=pulumi.get(__ret__, 'portal_url'),
        single_sign_on=pulumi.get(__ret__, 'single_sign_on'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_domain)
def get_domain_output(id: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDomainResult]:
    """
    A domain is an organizing entity for connecting together assets, users, and their projects


    :param str id: The id of the Amazon DataZone domain.
    """
    ...
