# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EnvironmentBlueprintConfigurationArgs', 'EnvironmentBlueprintConfiguration']

@pulumi.input_type
class EnvironmentBlueprintConfigurationArgs:
    def __init__(__self__, *,
                 domain_identifier: pulumi.Input[str],
                 enabled_regions: pulumi.Input[Sequence[pulumi.Input[str]]],
                 environment_blueprint_identifier: pulumi.Input[str],
                 manage_access_role_arn: Optional[pulumi.Input[str]] = None,
                 provisioning_role_arn: Optional[pulumi.Input[str]] = None,
                 regional_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentBlueprintConfigurationRegionalParameterArgs']]]] = None):
        """
        The set of arguments for constructing a EnvironmentBlueprintConfiguration resource.
        """
        pulumi.set(__self__, "domain_identifier", domain_identifier)
        pulumi.set(__self__, "enabled_regions", enabled_regions)
        pulumi.set(__self__, "environment_blueprint_identifier", environment_blueprint_identifier)
        if manage_access_role_arn is not None:
            pulumi.set(__self__, "manage_access_role_arn", manage_access_role_arn)
        if provisioning_role_arn is not None:
            pulumi.set(__self__, "provisioning_role_arn", provisioning_role_arn)
        if regional_parameters is not None:
            pulumi.set(__self__, "regional_parameters", regional_parameters)

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Input[str]:
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_identifier", value)

    @property
    @pulumi.getter(name="enabledRegions")
    def enabled_regions(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        return pulumi.get(self, "enabled_regions")

    @enabled_regions.setter
    def enabled_regions(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "enabled_regions", value)

    @property
    @pulumi.getter(name="environmentBlueprintIdentifier")
    def environment_blueprint_identifier(self) -> pulumi.Input[str]:
        return pulumi.get(self, "environment_blueprint_identifier")

    @environment_blueprint_identifier.setter
    def environment_blueprint_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "environment_blueprint_identifier", value)

    @property
    @pulumi.getter(name="manageAccessRoleArn")
    def manage_access_role_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "manage_access_role_arn")

    @manage_access_role_arn.setter
    def manage_access_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manage_access_role_arn", value)

    @property
    @pulumi.getter(name="provisioningRoleArn")
    def provisioning_role_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "provisioning_role_arn")

    @provisioning_role_arn.setter
    def provisioning_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioning_role_arn", value)

    @property
    @pulumi.getter(name="regionalParameters")
    def regional_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentBlueprintConfigurationRegionalParameterArgs']]]]:
        return pulumi.get(self, "regional_parameters")

    @regional_parameters.setter
    def regional_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentBlueprintConfigurationRegionalParameterArgs']]]]):
        pulumi.set(self, "regional_parameters", value)


class EnvironmentBlueprintConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_identifier: Optional[pulumi.Input[str]] = None,
                 enabled_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 environment_blueprint_identifier: Optional[pulumi.Input[str]] = None,
                 manage_access_role_arn: Optional[pulumi.Input[str]] = None,
                 provisioning_role_arn: Optional[pulumi.Input[str]] = None,
                 regional_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentBlueprintConfigurationRegionalParameterArgs']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::DataZone::EnvironmentBlueprintConfiguration Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentBlueprintConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::DataZone::EnvironmentBlueprintConfiguration Resource Type

        :param str resource_name: The name of the resource.
        :param EnvironmentBlueprintConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentBlueprintConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_identifier: Optional[pulumi.Input[str]] = None,
                 enabled_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 environment_blueprint_identifier: Optional[pulumi.Input[str]] = None,
                 manage_access_role_arn: Optional[pulumi.Input[str]] = None,
                 provisioning_role_arn: Optional[pulumi.Input[str]] = None,
                 regional_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentBlueprintConfigurationRegionalParameterArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentBlueprintConfigurationArgs.__new__(EnvironmentBlueprintConfigurationArgs)

            if domain_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'domain_identifier'")
            __props__.__dict__["domain_identifier"] = domain_identifier
            if enabled_regions is None and not opts.urn:
                raise TypeError("Missing required property 'enabled_regions'")
            __props__.__dict__["enabled_regions"] = enabled_regions
            if environment_blueprint_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'environment_blueprint_identifier'")
            __props__.__dict__["environment_blueprint_identifier"] = environment_blueprint_identifier
            __props__.__dict__["manage_access_role_arn"] = manage_access_role_arn
            __props__.__dict__["provisioning_role_arn"] = provisioning_role_arn
            __props__.__dict__["regional_parameters"] = regional_parameters
            __props__.__dict__["created_at"] = None
            __props__.__dict__["domain_id"] = None
            __props__.__dict__["environment_blueprint_id"] = None
            __props__.__dict__["updated_at"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["domainIdentifier", "environmentBlueprintIdentifier"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(EnvironmentBlueprintConfiguration, __self__).__init__(
            'aws-native:datazone:EnvironmentBlueprintConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'EnvironmentBlueprintConfiguration':
        """
        Get an existing EnvironmentBlueprintConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EnvironmentBlueprintConfigurationArgs.__new__(EnvironmentBlueprintConfigurationArgs)

        __props__.__dict__["created_at"] = None
        __props__.__dict__["domain_id"] = None
        __props__.__dict__["domain_identifier"] = None
        __props__.__dict__["enabled_regions"] = None
        __props__.__dict__["environment_blueprint_id"] = None
        __props__.__dict__["environment_blueprint_identifier"] = None
        __props__.__dict__["manage_access_role_arn"] = None
        __props__.__dict__["provisioning_role_arn"] = None
        __props__.__dict__["regional_parameters"] = None
        __props__.__dict__["updated_at"] = None
        return EnvironmentBlueprintConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Output[str]:
        return pulumi.get(self, "domain_identifier")

    @property
    @pulumi.getter(name="enabledRegions")
    def enabled_regions(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "enabled_regions")

    @property
    @pulumi.getter(name="environmentBlueprintId")
    def environment_blueprint_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "environment_blueprint_id")

    @property
    @pulumi.getter(name="environmentBlueprintIdentifier")
    def environment_blueprint_identifier(self) -> pulumi.Output[str]:
        return pulumi.get(self, "environment_blueprint_identifier")

    @property
    @pulumi.getter(name="manageAccessRoleArn")
    def manage_access_role_arn(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "manage_access_role_arn")

    @property
    @pulumi.getter(name="provisioningRoleArn")
    def provisioning_role_arn(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "provisioning_role_arn")

    @property
    @pulumi.getter(name="regionalParameters")
    def regional_parameters(self) -> pulumi.Output[Optional[Sequence['outputs.EnvironmentBlueprintConfigurationRegionalParameter']]]:
        return pulumi.get(self, "regional_parameters")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "updated_at")

