# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['LocationAzureBlobArgs', 'LocationAzureBlob']

@pulumi.input_type
class LocationAzureBlobArgs:
    def __init__(__self__, *,
                 agent_arns: pulumi.Input[Sequence[pulumi.Input[str]]],
                 azure_blob_authentication_type: pulumi.Input['LocationAzureBlobAzureBlobAuthenticationType'],
                 azure_access_tier: Optional[pulumi.Input['LocationAzureBlobAzureAccessTier']] = None,
                 azure_blob_container_url: Optional[pulumi.Input[str]] = None,
                 azure_blob_sas_configuration: Optional[pulumi.Input['LocationAzureBlobAzureBlobSasConfigurationArgs']] = None,
                 azure_blob_type: Optional[pulumi.Input['LocationAzureBlobAzureBlobType']] = None,
                 subdirectory: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a LocationAzureBlob resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] agent_arns: The Amazon Resource Names (ARNs) of agents to use for an Azure Blob Location.
        :param pulumi.Input['LocationAzureBlobAzureBlobAuthenticationType'] azure_blob_authentication_type: The specific authentication type that you want DataSync to use to access your Azure Blob Container.
        :param pulumi.Input['LocationAzureBlobAzureAccessTier'] azure_access_tier: Specifies an access tier for the objects you're transferring into your Azure Blob Storage container.
        :param pulumi.Input[str] azure_blob_container_url: The URL of the Azure Blob container that was described.
        :param pulumi.Input['LocationAzureBlobAzureBlobType'] azure_blob_type: Specifies a blob type for the objects you're transferring into your Azure Blob Storage container.
        :param pulumi.Input[str] subdirectory: The subdirectory in the Azure Blob Container that is used to read data from the Azure Blob Source Location.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "agent_arns", agent_arns)
        pulumi.set(__self__, "azure_blob_authentication_type", azure_blob_authentication_type)
        if azure_access_tier is not None:
            pulumi.set(__self__, "azure_access_tier", azure_access_tier)
        if azure_blob_container_url is not None:
            pulumi.set(__self__, "azure_blob_container_url", azure_blob_container_url)
        if azure_blob_sas_configuration is not None:
            pulumi.set(__self__, "azure_blob_sas_configuration", azure_blob_sas_configuration)
        if azure_blob_type is not None:
            pulumi.set(__self__, "azure_blob_type", azure_blob_type)
        if subdirectory is not None:
            pulumi.set(__self__, "subdirectory", subdirectory)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="agentArns")
    def agent_arns(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The Amazon Resource Names (ARNs) of agents to use for an Azure Blob Location.
        """
        return pulumi.get(self, "agent_arns")

    @agent_arns.setter
    def agent_arns(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "agent_arns", value)

    @property
    @pulumi.getter(name="azureBlobAuthenticationType")
    def azure_blob_authentication_type(self) -> pulumi.Input['LocationAzureBlobAzureBlobAuthenticationType']:
        """
        The specific authentication type that you want DataSync to use to access your Azure Blob Container.
        """
        return pulumi.get(self, "azure_blob_authentication_type")

    @azure_blob_authentication_type.setter
    def azure_blob_authentication_type(self, value: pulumi.Input['LocationAzureBlobAzureBlobAuthenticationType']):
        pulumi.set(self, "azure_blob_authentication_type", value)

    @property
    @pulumi.getter(name="azureAccessTier")
    def azure_access_tier(self) -> Optional[pulumi.Input['LocationAzureBlobAzureAccessTier']]:
        """
        Specifies an access tier for the objects you're transferring into your Azure Blob Storage container.
        """
        return pulumi.get(self, "azure_access_tier")

    @azure_access_tier.setter
    def azure_access_tier(self, value: Optional[pulumi.Input['LocationAzureBlobAzureAccessTier']]):
        pulumi.set(self, "azure_access_tier", value)

    @property
    @pulumi.getter(name="azureBlobContainerUrl")
    def azure_blob_container_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the Azure Blob container that was described.
        """
        return pulumi.get(self, "azure_blob_container_url")

    @azure_blob_container_url.setter
    def azure_blob_container_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_blob_container_url", value)

    @property
    @pulumi.getter(name="azureBlobSasConfiguration")
    def azure_blob_sas_configuration(self) -> Optional[pulumi.Input['LocationAzureBlobAzureBlobSasConfigurationArgs']]:
        return pulumi.get(self, "azure_blob_sas_configuration")

    @azure_blob_sas_configuration.setter
    def azure_blob_sas_configuration(self, value: Optional[pulumi.Input['LocationAzureBlobAzureBlobSasConfigurationArgs']]):
        pulumi.set(self, "azure_blob_sas_configuration", value)

    @property
    @pulumi.getter(name="azureBlobType")
    def azure_blob_type(self) -> Optional[pulumi.Input['LocationAzureBlobAzureBlobType']]:
        """
        Specifies a blob type for the objects you're transferring into your Azure Blob Storage container.
        """
        return pulumi.get(self, "azure_blob_type")

    @azure_blob_type.setter
    def azure_blob_type(self, value: Optional[pulumi.Input['LocationAzureBlobAzureBlobType']]):
        pulumi.set(self, "azure_blob_type", value)

    @property
    @pulumi.getter
    def subdirectory(self) -> Optional[pulumi.Input[str]]:
        """
        The subdirectory in the Azure Blob Container that is used to read data from the Azure Blob Source Location.
        """
        return pulumi.get(self, "subdirectory")

    @subdirectory.setter
    def subdirectory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subdirectory", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class LocationAzureBlob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 azure_access_tier: Optional[pulumi.Input['LocationAzureBlobAzureAccessTier']] = None,
                 azure_blob_authentication_type: Optional[pulumi.Input['LocationAzureBlobAzureBlobAuthenticationType']] = None,
                 azure_blob_container_url: Optional[pulumi.Input[str]] = None,
                 azure_blob_sas_configuration: Optional[pulumi.Input[pulumi.InputType['LocationAzureBlobAzureBlobSasConfigurationArgs']]] = None,
                 azure_blob_type: Optional[pulumi.Input['LocationAzureBlobAzureBlobType']] = None,
                 subdirectory: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        """
        Resource schema for AWS::DataSync::LocationAzureBlob.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] agent_arns: The Amazon Resource Names (ARNs) of agents to use for an Azure Blob Location.
        :param pulumi.Input['LocationAzureBlobAzureAccessTier'] azure_access_tier: Specifies an access tier for the objects you're transferring into your Azure Blob Storage container.
        :param pulumi.Input['LocationAzureBlobAzureBlobAuthenticationType'] azure_blob_authentication_type: The specific authentication type that you want DataSync to use to access your Azure Blob Container.
        :param pulumi.Input[str] azure_blob_container_url: The URL of the Azure Blob container that was described.
        :param pulumi.Input['LocationAzureBlobAzureBlobType'] azure_blob_type: Specifies a blob type for the objects you're transferring into your Azure Blob Storage container.
        :param pulumi.Input[str] subdirectory: The subdirectory in the Azure Blob Container that is used to read data from the Azure Blob Source Location.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LocationAzureBlobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::DataSync::LocationAzureBlob.

        :param str resource_name: The name of the resource.
        :param LocationAzureBlobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LocationAzureBlobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 azure_access_tier: Optional[pulumi.Input['LocationAzureBlobAzureAccessTier']] = None,
                 azure_blob_authentication_type: Optional[pulumi.Input['LocationAzureBlobAzureBlobAuthenticationType']] = None,
                 azure_blob_container_url: Optional[pulumi.Input[str]] = None,
                 azure_blob_sas_configuration: Optional[pulumi.Input[pulumi.InputType['LocationAzureBlobAzureBlobSasConfigurationArgs']]] = None,
                 azure_blob_type: Optional[pulumi.Input['LocationAzureBlobAzureBlobType']] = None,
                 subdirectory: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LocationAzureBlobArgs.__new__(LocationAzureBlobArgs)

            if agent_arns is None and not opts.urn:
                raise TypeError("Missing required property 'agent_arns'")
            __props__.__dict__["agent_arns"] = agent_arns
            __props__.__dict__["azure_access_tier"] = azure_access_tier
            if azure_blob_authentication_type is None and not opts.urn:
                raise TypeError("Missing required property 'azure_blob_authentication_type'")
            __props__.__dict__["azure_blob_authentication_type"] = azure_blob_authentication_type
            __props__.__dict__["azure_blob_container_url"] = azure_blob_container_url
            __props__.__dict__["azure_blob_sas_configuration"] = azure_blob_sas_configuration
            __props__.__dict__["azure_blob_type"] = azure_blob_type
            __props__.__dict__["subdirectory"] = subdirectory
            __props__.__dict__["tags"] = tags
            __props__.__dict__["location_arn"] = None
            __props__.__dict__["location_uri"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["azureBlobContainerUrl"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(LocationAzureBlob, __self__).__init__(
            'aws-native:datasync:LocationAzureBlob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'LocationAzureBlob':
        """
        Get an existing LocationAzureBlob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = LocationAzureBlobArgs.__new__(LocationAzureBlobArgs)

        __props__.__dict__["agent_arns"] = None
        __props__.__dict__["azure_access_tier"] = None
        __props__.__dict__["azure_blob_authentication_type"] = None
        __props__.__dict__["azure_blob_container_url"] = None
        __props__.__dict__["azure_blob_sas_configuration"] = None
        __props__.__dict__["azure_blob_type"] = None
        __props__.__dict__["location_arn"] = None
        __props__.__dict__["location_uri"] = None
        __props__.__dict__["subdirectory"] = None
        __props__.__dict__["tags"] = None
        return LocationAzureBlob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentArns")
    def agent_arns(self) -> pulumi.Output[Sequence[str]]:
        """
        The Amazon Resource Names (ARNs) of agents to use for an Azure Blob Location.
        """
        return pulumi.get(self, "agent_arns")

    @property
    @pulumi.getter(name="azureAccessTier")
    def azure_access_tier(self) -> pulumi.Output[Optional['LocationAzureBlobAzureAccessTier']]:
        """
        Specifies an access tier for the objects you're transferring into your Azure Blob Storage container.
        """
        return pulumi.get(self, "azure_access_tier")

    @property
    @pulumi.getter(name="azureBlobAuthenticationType")
    def azure_blob_authentication_type(self) -> pulumi.Output['LocationAzureBlobAzureBlobAuthenticationType']:
        """
        The specific authentication type that you want DataSync to use to access your Azure Blob Container.
        """
        return pulumi.get(self, "azure_blob_authentication_type")

    @property
    @pulumi.getter(name="azureBlobContainerUrl")
    def azure_blob_container_url(self) -> pulumi.Output[Optional[str]]:
        """
        The URL of the Azure Blob container that was described.
        """
        return pulumi.get(self, "azure_blob_container_url")

    @property
    @pulumi.getter(name="azureBlobSasConfiguration")
    def azure_blob_sas_configuration(self) -> pulumi.Output[Optional['outputs.LocationAzureBlobAzureBlobSasConfiguration']]:
        return pulumi.get(self, "azure_blob_sas_configuration")

    @property
    @pulumi.getter(name="azureBlobType")
    def azure_blob_type(self) -> pulumi.Output[Optional['LocationAzureBlobAzureBlobType']]:
        """
        Specifies a blob type for the objects you're transferring into your Azure Blob Storage container.
        """
        return pulumi.get(self, "azure_blob_type")

    @property
    @pulumi.getter(name="locationArn")
    def location_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the Azure Blob Location that is created.
        """
        return pulumi.get(self, "location_arn")

    @property
    @pulumi.getter(name="locationUri")
    def location_uri(self) -> pulumi.Output[str]:
        """
        The URL of the Azure Blob Location that was described.
        """
        return pulumi.get(self, "location_uri")

    @property
    @pulumi.getter
    def subdirectory(self) -> pulumi.Output[Optional[str]]:
        """
        The subdirectory in the Azure Blob Container that is used to read data from the Azure Blob Source Location.
        """
        return pulumi.get(self, "subdirectory")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

