# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'LocationAzureBlobAzureBlobSasConfigurationArgs',
    'LocationEfsEc2ConfigArgs',
    'LocationFSxOntapNfsMountOptionsArgs',
    'LocationFSxOntapNfsArgs',
    'LocationFSxOntapProtocolArgs',
    'LocationFSxOntapSmbMountOptionsArgs',
    'LocationFSxOntapSmbArgs',
    'LocationFSxOpenZfsMountOptionsArgs',
    'LocationFSxOpenZfsNfsArgs',
    'LocationFSxOpenZfsProtocolArgs',
    'LocationHdfsNameNodeArgs',
    'LocationHdfsQopConfigurationArgs',
    'LocationNfsMountOptionsArgs',
    'LocationNfsOnPremConfigArgs',
    'LocationS3s3ConfigArgs',
    'LocationSmbMountOptionsArgs',
    'StorageSystemServerConfigurationArgs',
    'StorageSystemServerCredentialsArgs',
    'TaskFilterRuleArgs',
    'TaskManifestConfigSourcePropertiesArgs',
    'TaskManifestConfigSourceS3Args',
    'TaskManifestConfigArgs',
    'TaskOptionsArgs',
    'TaskReportConfigDestinationPropertiesArgs',
    'TaskReportConfigDestinationS3Args',
    'TaskReportConfigOverridesPropertiesDeletedPropertiesArgs',
    'TaskReportConfigOverridesPropertiesSkippedPropertiesArgs',
    'TaskReportConfigOverridesPropertiesTransferredPropertiesArgs',
    'TaskReportConfigOverridesPropertiesVerifiedPropertiesArgs',
    'TaskReportConfigOverridesPropertiesArgs',
    'TaskReportConfigArgs',
    'TaskScheduleArgs',
]

@pulumi.input_type
class LocationAzureBlobAzureBlobSasConfigurationArgs:
    def __init__(__self__, *,
                 azure_blob_sas_token: pulumi.Input[str]):
        """
        Specifies the shared access signature (SAS) that DataSync uses to access your Azure Blob Storage container.
        :param pulumi.Input[str] azure_blob_sas_token: Specifies the shared access signature (SAS) token, which indicates the permissions DataSync needs to access your Azure Blob Storage container.
        """
        pulumi.set(__self__, "azure_blob_sas_token", azure_blob_sas_token)

    @property
    @pulumi.getter(name="azureBlobSasToken")
    def azure_blob_sas_token(self) -> pulumi.Input[str]:
        """
        Specifies the shared access signature (SAS) token, which indicates the permissions DataSync needs to access your Azure Blob Storage container.
        """
        return pulumi.get(self, "azure_blob_sas_token")

    @azure_blob_sas_token.setter
    def azure_blob_sas_token(self, value: pulumi.Input[str]):
        pulumi.set(self, "azure_blob_sas_token", value)


@pulumi.input_type
class LocationEfsEc2ConfigArgs:
    def __init__(__self__, *,
                 security_group_arns: pulumi.Input[Sequence[pulumi.Input[str]]],
                 subnet_arn: pulumi.Input[str]):
        """
        The subnet and security group that DataSync uses to access target EFS file system.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_arns: The Amazon Resource Names (ARNs) of the security groups that are configured for the Amazon EC2 resource.
        :param pulumi.Input[str] subnet_arn: The ARN of the subnet that DataSync uses to access the target EFS file system.
        """
        pulumi.set(__self__, "security_group_arns", security_group_arns)
        pulumi.set(__self__, "subnet_arn", subnet_arn)

    @property
    @pulumi.getter(name="securityGroupArns")
    def security_group_arns(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The Amazon Resource Names (ARNs) of the security groups that are configured for the Amazon EC2 resource.
        """
        return pulumi.get(self, "security_group_arns")

    @security_group_arns.setter
    def security_group_arns(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "security_group_arns", value)

    @property
    @pulumi.getter(name="subnetArn")
    def subnet_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the subnet that DataSync uses to access the target EFS file system.
        """
        return pulumi.get(self, "subnet_arn")

    @subnet_arn.setter
    def subnet_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_arn", value)


@pulumi.input_type
class LocationFSxOntapNfsMountOptionsArgs:
    def __init__(__self__, *,
                 version: Optional[pulumi.Input['LocationFSxOntapNfsMountOptionsVersion']] = None):
        """
        The NFS mount options that DataSync can use to mount your NFS share.
        :param pulumi.Input['LocationFSxOntapNfsMountOptionsVersion'] version: The specific NFS version that you want DataSync to use to mount your NFS share.
        """
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input['LocationFSxOntapNfsMountOptionsVersion']]:
        """
        The specific NFS version that you want DataSync to use to mount your NFS share.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input['LocationFSxOntapNfsMountOptionsVersion']]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class LocationFSxOntapNfsArgs:
    def __init__(__self__, *,
                 mount_options: pulumi.Input['LocationFSxOntapNfsMountOptionsArgs']):
        """
        NFS protocol configuration for FSx ONTAP file system.
        """
        pulumi.set(__self__, "mount_options", mount_options)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> pulumi.Input['LocationFSxOntapNfsMountOptionsArgs']:
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: pulumi.Input['LocationFSxOntapNfsMountOptionsArgs']):
        pulumi.set(self, "mount_options", value)


@pulumi.input_type
class LocationFSxOntapProtocolArgs:
    def __init__(__self__, *,
                 nfs: Optional[pulumi.Input['LocationFSxOntapNfsArgs']] = None,
                 smb: Optional[pulumi.Input['LocationFSxOntapSmbArgs']] = None):
        """
        Configuration settings for NFS or SMB protocol.
        """
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)
        if smb is not None:
            pulumi.set(__self__, "smb", smb)

    @property
    @pulumi.getter
    def nfs(self) -> Optional[pulumi.Input['LocationFSxOntapNfsArgs']]:
        return pulumi.get(self, "nfs")

    @nfs.setter
    def nfs(self, value: Optional[pulumi.Input['LocationFSxOntapNfsArgs']]):
        pulumi.set(self, "nfs", value)

    @property
    @pulumi.getter
    def smb(self) -> Optional[pulumi.Input['LocationFSxOntapSmbArgs']]:
        return pulumi.get(self, "smb")

    @smb.setter
    def smb(self, value: Optional[pulumi.Input['LocationFSxOntapSmbArgs']]):
        pulumi.set(self, "smb", value)


@pulumi.input_type
class LocationFSxOntapSmbMountOptionsArgs:
    def __init__(__self__, *,
                 version: Optional[pulumi.Input['LocationFSxOntapSmbMountOptionsVersion']] = None):
        """
        The mount options used by DataSync to access the SMB server.
        :param pulumi.Input['LocationFSxOntapSmbMountOptionsVersion'] version: The specific SMB version that you want DataSync to use to mount your SMB share.
        """
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input['LocationFSxOntapSmbMountOptionsVersion']]:
        """
        The specific SMB version that you want DataSync to use to mount your SMB share.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input['LocationFSxOntapSmbMountOptionsVersion']]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class LocationFSxOntapSmbArgs:
    def __init__(__self__, *,
                 mount_options: pulumi.Input['LocationFSxOntapSmbMountOptionsArgs'],
                 password: pulumi.Input[str],
                 user: pulumi.Input[str],
                 domain: Optional[pulumi.Input[str]] = None):
        """
        SMB protocol configuration for FSx ONTAP file system.
        :param pulumi.Input[str] password: The password of the user who can mount the share and has the permissions to access files and folders in the SMB share.
        :param pulumi.Input[str] user: The user who can mount the share, has the permissions to access files and folders in the SMB share.
        :param pulumi.Input[str] domain: The name of the Windows domain that the SMB server belongs to.
        """
        pulumi.set(__self__, "mount_options", mount_options)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user", user)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> pulumi.Input['LocationFSxOntapSmbMountOptionsArgs']:
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: pulumi.Input['LocationFSxOntapSmbMountOptionsArgs']):
        pulumi.set(self, "mount_options", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password of the user who can mount the share and has the permissions to access files and folders in the SMB share.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def user(self) -> pulumi.Input[str]:
        """
        The user who can mount the share, has the permissions to access files and folders in the SMB share.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[str]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Windows domain that the SMB server belongs to.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)


@pulumi.input_type
class LocationFSxOpenZfsMountOptionsArgs:
    def __init__(__self__, *,
                 version: Optional[pulumi.Input['LocationFSxOpenZfsMountOptionsVersion']] = None):
        """
        The NFS mount options that DataSync can use to mount your NFS share.
        :param pulumi.Input['LocationFSxOpenZfsMountOptionsVersion'] version: The specific NFS version that you want DataSync to use to mount your NFS share.
        """
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input['LocationFSxOpenZfsMountOptionsVersion']]:
        """
        The specific NFS version that you want DataSync to use to mount your NFS share.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input['LocationFSxOpenZfsMountOptionsVersion']]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class LocationFSxOpenZfsNfsArgs:
    def __init__(__self__, *,
                 mount_options: pulumi.Input['LocationFSxOpenZfsMountOptionsArgs']):
        """
        FSx OpenZFS file system NFS protocol information
        """
        pulumi.set(__self__, "mount_options", mount_options)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> pulumi.Input['LocationFSxOpenZfsMountOptionsArgs']:
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: pulumi.Input['LocationFSxOpenZfsMountOptionsArgs']):
        pulumi.set(self, "mount_options", value)


@pulumi.input_type
class LocationFSxOpenZfsProtocolArgs:
    def __init__(__self__, *,
                 nfs: Optional[pulumi.Input['LocationFSxOpenZfsNfsArgs']] = None):
        """
        Configuration settings for an NFS or SMB protocol, currently only support NFS
        """
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)

    @property
    @pulumi.getter
    def nfs(self) -> Optional[pulumi.Input['LocationFSxOpenZfsNfsArgs']]:
        return pulumi.get(self, "nfs")

    @nfs.setter
    def nfs(self, value: Optional[pulumi.Input['LocationFSxOpenZfsNfsArgs']]):
        pulumi.set(self, "nfs", value)


@pulumi.input_type
class LocationHdfsNameNodeArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[str],
                 port: pulumi.Input[int]):
        """
        HDFS Name Node IP and port information.
        :param pulumi.Input[str] hostname: The DNS name or IP address of the Name Node in the customer's on premises HDFS cluster.
        :param pulumi.Input[int] port: The port on which the Name Node is listening on for client requests.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[str]:
        """
        The DNS name or IP address of the Name Node in the customer's on premises HDFS cluster.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The port on which the Name Node is listening on for client requests.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class LocationHdfsQopConfigurationArgs:
    def __init__(__self__, *,
                 data_transfer_protection: Optional[pulumi.Input['LocationHdfsQopConfigurationDataTransferProtection']] = None,
                 rpc_protection: Optional[pulumi.Input['LocationHdfsQopConfigurationRpcProtection']] = None):
        """
        Configuration information for RPC Protection and Data Transfer Protection. These parameters can be set to AUTHENTICATION, INTEGRITY, or PRIVACY. The default value is PRIVACY.
        :param pulumi.Input['LocationHdfsQopConfigurationDataTransferProtection'] data_transfer_protection: Configuration for Data Transfer Protection.
        :param pulumi.Input['LocationHdfsQopConfigurationRpcProtection'] rpc_protection: Configuration for RPC Protection.
        """
        if data_transfer_protection is not None:
            pulumi.set(__self__, "data_transfer_protection", data_transfer_protection)
        if rpc_protection is not None:
            pulumi.set(__self__, "rpc_protection", rpc_protection)

    @property
    @pulumi.getter(name="dataTransferProtection")
    def data_transfer_protection(self) -> Optional[pulumi.Input['LocationHdfsQopConfigurationDataTransferProtection']]:
        """
        Configuration for Data Transfer Protection.
        """
        return pulumi.get(self, "data_transfer_protection")

    @data_transfer_protection.setter
    def data_transfer_protection(self, value: Optional[pulumi.Input['LocationHdfsQopConfigurationDataTransferProtection']]):
        pulumi.set(self, "data_transfer_protection", value)

    @property
    @pulumi.getter(name="rpcProtection")
    def rpc_protection(self) -> Optional[pulumi.Input['LocationHdfsQopConfigurationRpcProtection']]:
        """
        Configuration for RPC Protection.
        """
        return pulumi.get(self, "rpc_protection")

    @rpc_protection.setter
    def rpc_protection(self, value: Optional[pulumi.Input['LocationHdfsQopConfigurationRpcProtection']]):
        pulumi.set(self, "rpc_protection", value)


@pulumi.input_type
class LocationNfsMountOptionsArgs:
    def __init__(__self__, *,
                 version: Optional[pulumi.Input['LocationNfsMountOptionsVersion']] = None):
        """
        The NFS mount options that DataSync can use to mount your NFS share.
        :param pulumi.Input['LocationNfsMountOptionsVersion'] version: The specific NFS version that you want DataSync to use to mount your NFS share.
        """
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input['LocationNfsMountOptionsVersion']]:
        """
        The specific NFS version that you want DataSync to use to mount your NFS share.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input['LocationNfsMountOptionsVersion']]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class LocationNfsOnPremConfigArgs:
    def __init__(__self__, *,
                 agent_arns: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        Contains a list of Amazon Resource Names (ARNs) of agents that are used to connect an NFS server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] agent_arns: ARN(s) of the agent(s) to use for an NFS location.
        """
        pulumi.set(__self__, "agent_arns", agent_arns)

    @property
    @pulumi.getter(name="agentArns")
    def agent_arns(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        ARN(s) of the agent(s) to use for an NFS location.
        """
        return pulumi.get(self, "agent_arns")

    @agent_arns.setter
    def agent_arns(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "agent_arns", value)


@pulumi.input_type
class LocationS3s3ConfigArgs:
    def __init__(__self__, *,
                 bucket_access_role_arn: pulumi.Input[str]):
        """
        The Amazon Resource Name (ARN) of the AWS IAM role that is used to access an Amazon S3 bucket.
        :param pulumi.Input[str] bucket_access_role_arn: The ARN of the IAM role of the Amazon S3 bucket.
        """
        pulumi.set(__self__, "bucket_access_role_arn", bucket_access_role_arn)

    @property
    @pulumi.getter(name="bucketAccessRoleArn")
    def bucket_access_role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the IAM role of the Amazon S3 bucket.
        """
        return pulumi.get(self, "bucket_access_role_arn")

    @bucket_access_role_arn.setter
    def bucket_access_role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_access_role_arn", value)


@pulumi.input_type
class LocationSmbMountOptionsArgs:
    def __init__(__self__, *,
                 version: Optional[pulumi.Input['LocationSmbMountOptionsVersion']] = None):
        """
        The mount options used by DataSync to access the SMB server.
        :param pulumi.Input['LocationSmbMountOptionsVersion'] version: The specific SMB version that you want DataSync to use to mount your SMB share.
        """
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input['LocationSmbMountOptionsVersion']]:
        """
        The specific SMB version that you want DataSync to use to mount your SMB share.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input['LocationSmbMountOptionsVersion']]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class StorageSystemServerConfigurationArgs:
    def __init__(__self__, *,
                 server_hostname: pulumi.Input[str],
                 server_port: Optional[pulumi.Input[int]] = None):
        """
        The server name and network port required to connect with the management interface of the on-premises storage system.
        :param pulumi.Input[str] server_hostname: The domain name or IP address of the storage system's management interface.
        :param pulumi.Input[int] server_port: The network port needed to access the system's management interface
        """
        pulumi.set(__self__, "server_hostname", server_hostname)
        if server_port is not None:
            pulumi.set(__self__, "server_port", server_port)

    @property
    @pulumi.getter(name="serverHostname")
    def server_hostname(self) -> pulumi.Input[str]:
        """
        The domain name or IP address of the storage system's management interface.
        """
        return pulumi.get(self, "server_hostname")

    @server_hostname.setter
    def server_hostname(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_hostname", value)

    @property
    @pulumi.getter(name="serverPort")
    def server_port(self) -> Optional[pulumi.Input[int]]:
        """
        The network port needed to access the system's management interface
        """
        return pulumi.get(self, "server_port")

    @server_port.setter
    def server_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "server_port", value)


@pulumi.input_type
class StorageSystemServerCredentialsArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        The username and password for accessing your on-premises storage system's management interface.
        :param pulumi.Input[str] password: The password for your storage system's management interface
        :param pulumi.Input[str] username: The username for your storage system's management interface.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password for your storage system's management interface
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The username for your storage system's management interface.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class TaskFilterRuleArgs:
    def __init__(__self__, *,
                 filter_type: Optional[pulumi.Input['TaskFilterRuleFilterType']] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Specifies which files folders and objects to include or exclude when transferring files from source to destination.
        :param pulumi.Input['TaskFilterRuleFilterType'] filter_type: The type of filter rule to apply. AWS DataSync only supports the SIMPLE_PATTERN rule type.
        :param pulumi.Input[str] value: A single filter string that consists of the patterns to include or exclude. The patterns are delimited by "|".
        """
        if filter_type is not None:
            pulumi.set(__self__, "filter_type", filter_type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> Optional[pulumi.Input['TaskFilterRuleFilterType']]:
        """
        The type of filter rule to apply. AWS DataSync only supports the SIMPLE_PATTERN rule type.
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: Optional[pulumi.Input['TaskFilterRuleFilterType']]):
        pulumi.set(self, "filter_type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        A single filter string that consists of the patterns to include or exclude. The patterns are delimited by "|".
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class TaskManifestConfigSourcePropertiesArgs:
    def __init__(__self__, *,
                 s3: Optional[pulumi.Input['TaskManifestConfigSourceS3Args']] = None):
        """
        Specifies the manifest that you want DataSync to use and where it's hosted.
        """
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter
    def s3(self) -> Optional[pulumi.Input['TaskManifestConfigSourceS3Args']]:
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional[pulumi.Input['TaskManifestConfigSourceS3Args']]):
        pulumi.set(self, "s3", value)


@pulumi.input_type
class TaskManifestConfigSourceS3Args:
    def __init__(__self__, *,
                 bucket_access_role_arn: Optional[pulumi.Input[str]] = None,
                 manifest_object_path: Optional[pulumi.Input[str]] = None,
                 manifest_object_version_id: Optional[pulumi.Input[str]] = None,
                 s3_bucket_arn: Optional[pulumi.Input[str]] = None):
        """
        Specifies the S3 bucket where you're hosting the manifest that you want AWS DataSync to use.
        :param pulumi.Input[str] bucket_access_role_arn: Specifies the AWS Identity and Access Management (IAM) role that allows DataSync to access your manifest.
        :param pulumi.Input[str] manifest_object_path: Specifies the Amazon S3 object key of your manifest.
        :param pulumi.Input[str] manifest_object_version_id: Specifies the object version ID of the manifest that you want DataSync to use.
        :param pulumi.Input[str] s3_bucket_arn: Specifies the Amazon Resource Name (ARN) of the S3 bucket where you're hosting your manifest.
        """
        if bucket_access_role_arn is not None:
            pulumi.set(__self__, "bucket_access_role_arn", bucket_access_role_arn)
        if manifest_object_path is not None:
            pulumi.set(__self__, "manifest_object_path", manifest_object_path)
        if manifest_object_version_id is not None:
            pulumi.set(__self__, "manifest_object_version_id", manifest_object_version_id)
        if s3_bucket_arn is not None:
            pulumi.set(__self__, "s3_bucket_arn", s3_bucket_arn)

    @property
    @pulumi.getter(name="bucketAccessRoleArn")
    def bucket_access_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the AWS Identity and Access Management (IAM) role that allows DataSync to access your manifest.
        """
        return pulumi.get(self, "bucket_access_role_arn")

    @bucket_access_role_arn.setter
    def bucket_access_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_access_role_arn", value)

    @property
    @pulumi.getter(name="manifestObjectPath")
    def manifest_object_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Amazon S3 object key of your manifest.
        """
        return pulumi.get(self, "manifest_object_path")

    @manifest_object_path.setter
    def manifest_object_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manifest_object_path", value)

    @property
    @pulumi.getter(name="manifestObjectVersionId")
    def manifest_object_version_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the object version ID of the manifest that you want DataSync to use.
        """
        return pulumi.get(self, "manifest_object_version_id")

    @manifest_object_version_id.setter
    def manifest_object_version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manifest_object_version_id", value)

    @property
    @pulumi.getter(name="s3BucketArn")
    def s3_bucket_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Amazon Resource Name (ARN) of the S3 bucket where you're hosting your manifest.
        """
        return pulumi.get(self, "s3_bucket_arn")

    @s3_bucket_arn.setter
    def s3_bucket_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_bucket_arn", value)


@pulumi.input_type
class TaskManifestConfigArgs:
    def __init__(__self__, *,
                 source: pulumi.Input['TaskManifestConfigSourcePropertiesArgs'],
                 action: Optional[pulumi.Input['TaskManifestConfigAction']] = None,
                 format: Optional[pulumi.Input['TaskManifestConfigFormat']] = None):
        """
        Configures a manifest, which is a list of files or objects that you want DataSync to transfer.
        :param pulumi.Input['TaskManifestConfigSourcePropertiesArgs'] source: Specifies the manifest that you want DataSync to use and where it's hosted.
        :param pulumi.Input['TaskManifestConfigAction'] action: Specifies what DataSync uses the manifest for.
        :param pulumi.Input['TaskManifestConfigFormat'] format: Specifies the file format of your manifest.
        """
        pulumi.set(__self__, "source", source)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if format is not None:
            pulumi.set(__self__, "format", format)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input['TaskManifestConfigSourcePropertiesArgs']:
        """
        Specifies the manifest that you want DataSync to use and where it's hosted.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['TaskManifestConfigSourcePropertiesArgs']):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['TaskManifestConfigAction']]:
        """
        Specifies what DataSync uses the manifest for.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['TaskManifestConfigAction']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input['TaskManifestConfigFormat']]:
        """
        Specifies the file format of your manifest.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input['TaskManifestConfigFormat']]):
        pulumi.set(self, "format", value)


@pulumi.input_type
class TaskOptionsArgs:
    def __init__(__self__, *,
                 atime: Optional[pulumi.Input['TaskOptionsAtime']] = None,
                 bytes_per_second: Optional[pulumi.Input[int]] = None,
                 gid: Optional[pulumi.Input['TaskOptionsGid']] = None,
                 log_level: Optional[pulumi.Input['TaskOptionsLogLevel']] = None,
                 mtime: Optional[pulumi.Input['TaskOptionsMtime']] = None,
                 object_tags: Optional[pulumi.Input['TaskOptionsObjectTags']] = None,
                 overwrite_mode: Optional[pulumi.Input['TaskOptionsOverwriteMode']] = None,
                 posix_permissions: Optional[pulumi.Input['TaskOptionsPosixPermissions']] = None,
                 preserve_deleted_files: Optional[pulumi.Input['TaskOptionsPreserveDeletedFiles']] = None,
                 preserve_devices: Optional[pulumi.Input['TaskOptionsPreserveDevices']] = None,
                 security_descriptor_copy_flags: Optional[pulumi.Input['TaskOptionsSecurityDescriptorCopyFlags']] = None,
                 task_queueing: Optional[pulumi.Input['TaskOptionsTaskQueueing']] = None,
                 transfer_mode: Optional[pulumi.Input['TaskOptionsTransferMode']] = None,
                 uid: Optional[pulumi.Input['TaskOptionsUid']] = None,
                 verify_mode: Optional[pulumi.Input['TaskOptionsVerifyMode']] = None):
        """
        Represents the options that are available to control the behavior of a StartTaskExecution operation.
        :param pulumi.Input['TaskOptionsAtime'] atime: A file metadata value that shows the last time a file was accessed (that is, when the file was read or written to).
        :param pulumi.Input[int] bytes_per_second: A value that limits the bandwidth used by AWS DataSync.
        :param pulumi.Input['TaskOptionsGid'] gid: The group ID (GID) of the file's owners.
        :param pulumi.Input['TaskOptionsLogLevel'] log_level: A value that determines the types of logs that DataSync publishes to a log stream in the Amazon CloudWatch log group that you provide.
        :param pulumi.Input['TaskOptionsMtime'] mtime: A value that indicates the last time that a file was modified (that is, a file was written to) before the PREPARING phase.
        :param pulumi.Input['TaskOptionsObjectTags'] object_tags: A value that determines whether object tags should be read from the source object store and written to the destination object store.
        :param pulumi.Input['TaskOptionsOverwriteMode'] overwrite_mode: A value that determines whether files at the destination should be overwritten or preserved when copying files.
        :param pulumi.Input['TaskOptionsPosixPermissions'] posix_permissions: A value that determines which users or groups can access a file for a specific purpose such as reading, writing, or execution of the file.
        :param pulumi.Input['TaskOptionsPreserveDeletedFiles'] preserve_deleted_files: A value that specifies whether files in the destination that don't exist in the source file system should be preserved.
        :param pulumi.Input['TaskOptionsPreserveDevices'] preserve_devices: A value that determines whether AWS DataSync should preserve the metadata of block and character devices in the source file system, and recreate the files with that device name and metadata on the destination.
        :param pulumi.Input['TaskOptionsSecurityDescriptorCopyFlags'] security_descriptor_copy_flags: A value that determines which components of the SMB security descriptor are copied during transfer.
        :param pulumi.Input['TaskOptionsTaskQueueing'] task_queueing: A value that determines whether tasks should be queued before executing the tasks.
        :param pulumi.Input['TaskOptionsTransferMode'] transfer_mode: A value that determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing to the destination location.
        :param pulumi.Input['TaskOptionsUid'] uid: The user ID (UID) of the file's owner.
        :param pulumi.Input['TaskOptionsVerifyMode'] verify_mode: A value that determines whether a data integrity verification should be performed at the end of a task execution after all data and metadata have been transferred.
        """
        if atime is not None:
            pulumi.set(__self__, "atime", atime)
        if bytes_per_second is not None:
            pulumi.set(__self__, "bytes_per_second", bytes_per_second)
        if gid is not None:
            pulumi.set(__self__, "gid", gid)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if mtime is not None:
            pulumi.set(__self__, "mtime", mtime)
        if object_tags is not None:
            pulumi.set(__self__, "object_tags", object_tags)
        if overwrite_mode is not None:
            pulumi.set(__self__, "overwrite_mode", overwrite_mode)
        if posix_permissions is not None:
            pulumi.set(__self__, "posix_permissions", posix_permissions)
        if preserve_deleted_files is not None:
            pulumi.set(__self__, "preserve_deleted_files", preserve_deleted_files)
        if preserve_devices is not None:
            pulumi.set(__self__, "preserve_devices", preserve_devices)
        if security_descriptor_copy_flags is not None:
            pulumi.set(__self__, "security_descriptor_copy_flags", security_descriptor_copy_flags)
        if task_queueing is not None:
            pulumi.set(__self__, "task_queueing", task_queueing)
        if transfer_mode is not None:
            pulumi.set(__self__, "transfer_mode", transfer_mode)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if verify_mode is not None:
            pulumi.set(__self__, "verify_mode", verify_mode)

    @property
    @pulumi.getter
    def atime(self) -> Optional[pulumi.Input['TaskOptionsAtime']]:
        """
        A file metadata value that shows the last time a file was accessed (that is, when the file was read or written to).
        """
        return pulumi.get(self, "atime")

    @atime.setter
    def atime(self, value: Optional[pulumi.Input['TaskOptionsAtime']]):
        pulumi.set(self, "atime", value)

    @property
    @pulumi.getter(name="bytesPerSecond")
    def bytes_per_second(self) -> Optional[pulumi.Input[int]]:
        """
        A value that limits the bandwidth used by AWS DataSync.
        """
        return pulumi.get(self, "bytes_per_second")

    @bytes_per_second.setter
    def bytes_per_second(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bytes_per_second", value)

    @property
    @pulumi.getter
    def gid(self) -> Optional[pulumi.Input['TaskOptionsGid']]:
        """
        The group ID (GID) of the file's owners.
        """
        return pulumi.get(self, "gid")

    @gid.setter
    def gid(self, value: Optional[pulumi.Input['TaskOptionsGid']]):
        pulumi.set(self, "gid", value)

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input['TaskOptionsLogLevel']]:
        """
        A value that determines the types of logs that DataSync publishes to a log stream in the Amazon CloudWatch log group that you provide.
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input['TaskOptionsLogLevel']]):
        pulumi.set(self, "log_level", value)

    @property
    @pulumi.getter
    def mtime(self) -> Optional[pulumi.Input['TaskOptionsMtime']]:
        """
        A value that indicates the last time that a file was modified (that is, a file was written to) before the PREPARING phase.
        """
        return pulumi.get(self, "mtime")

    @mtime.setter
    def mtime(self, value: Optional[pulumi.Input['TaskOptionsMtime']]):
        pulumi.set(self, "mtime", value)

    @property
    @pulumi.getter(name="objectTags")
    def object_tags(self) -> Optional[pulumi.Input['TaskOptionsObjectTags']]:
        """
        A value that determines whether object tags should be read from the source object store and written to the destination object store.
        """
        return pulumi.get(self, "object_tags")

    @object_tags.setter
    def object_tags(self, value: Optional[pulumi.Input['TaskOptionsObjectTags']]):
        pulumi.set(self, "object_tags", value)

    @property
    @pulumi.getter(name="overwriteMode")
    def overwrite_mode(self) -> Optional[pulumi.Input['TaskOptionsOverwriteMode']]:
        """
        A value that determines whether files at the destination should be overwritten or preserved when copying files.
        """
        return pulumi.get(self, "overwrite_mode")

    @overwrite_mode.setter
    def overwrite_mode(self, value: Optional[pulumi.Input['TaskOptionsOverwriteMode']]):
        pulumi.set(self, "overwrite_mode", value)

    @property
    @pulumi.getter(name="posixPermissions")
    def posix_permissions(self) -> Optional[pulumi.Input['TaskOptionsPosixPermissions']]:
        """
        A value that determines which users or groups can access a file for a specific purpose such as reading, writing, or execution of the file.
        """
        return pulumi.get(self, "posix_permissions")

    @posix_permissions.setter
    def posix_permissions(self, value: Optional[pulumi.Input['TaskOptionsPosixPermissions']]):
        pulumi.set(self, "posix_permissions", value)

    @property
    @pulumi.getter(name="preserveDeletedFiles")
    def preserve_deleted_files(self) -> Optional[pulumi.Input['TaskOptionsPreserveDeletedFiles']]:
        """
        A value that specifies whether files in the destination that don't exist in the source file system should be preserved.
        """
        return pulumi.get(self, "preserve_deleted_files")

    @preserve_deleted_files.setter
    def preserve_deleted_files(self, value: Optional[pulumi.Input['TaskOptionsPreserveDeletedFiles']]):
        pulumi.set(self, "preserve_deleted_files", value)

    @property
    @pulumi.getter(name="preserveDevices")
    def preserve_devices(self) -> Optional[pulumi.Input['TaskOptionsPreserveDevices']]:
        """
        A value that determines whether AWS DataSync should preserve the metadata of block and character devices in the source file system, and recreate the files with that device name and metadata on the destination.
        """
        return pulumi.get(self, "preserve_devices")

    @preserve_devices.setter
    def preserve_devices(self, value: Optional[pulumi.Input['TaskOptionsPreserveDevices']]):
        pulumi.set(self, "preserve_devices", value)

    @property
    @pulumi.getter(name="securityDescriptorCopyFlags")
    def security_descriptor_copy_flags(self) -> Optional[pulumi.Input['TaskOptionsSecurityDescriptorCopyFlags']]:
        """
        A value that determines which components of the SMB security descriptor are copied during transfer.
        """
        return pulumi.get(self, "security_descriptor_copy_flags")

    @security_descriptor_copy_flags.setter
    def security_descriptor_copy_flags(self, value: Optional[pulumi.Input['TaskOptionsSecurityDescriptorCopyFlags']]):
        pulumi.set(self, "security_descriptor_copy_flags", value)

    @property
    @pulumi.getter(name="taskQueueing")
    def task_queueing(self) -> Optional[pulumi.Input['TaskOptionsTaskQueueing']]:
        """
        A value that determines whether tasks should be queued before executing the tasks.
        """
        return pulumi.get(self, "task_queueing")

    @task_queueing.setter
    def task_queueing(self, value: Optional[pulumi.Input['TaskOptionsTaskQueueing']]):
        pulumi.set(self, "task_queueing", value)

    @property
    @pulumi.getter(name="transferMode")
    def transfer_mode(self) -> Optional[pulumi.Input['TaskOptionsTransferMode']]:
        """
        A value that determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing to the destination location.
        """
        return pulumi.get(self, "transfer_mode")

    @transfer_mode.setter
    def transfer_mode(self, value: Optional[pulumi.Input['TaskOptionsTransferMode']]):
        pulumi.set(self, "transfer_mode", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input['TaskOptionsUid']]:
        """
        The user ID (UID) of the file's owner.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input['TaskOptionsUid']]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="verifyMode")
    def verify_mode(self) -> Optional[pulumi.Input['TaskOptionsVerifyMode']]:
        """
        A value that determines whether a data integrity verification should be performed at the end of a task execution after all data and metadata have been transferred.
        """
        return pulumi.get(self, "verify_mode")

    @verify_mode.setter
    def verify_mode(self, value: Optional[pulumi.Input['TaskOptionsVerifyMode']]):
        pulumi.set(self, "verify_mode", value)


@pulumi.input_type
class TaskReportConfigDestinationPropertiesArgs:
    def __init__(__self__, *,
                 s3: Optional[pulumi.Input['TaskReportConfigDestinationS3Args']] = None):
        """
        Specifies where DataSync uploads your task report.
        """
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter
    def s3(self) -> Optional[pulumi.Input['TaskReportConfigDestinationS3Args']]:
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional[pulumi.Input['TaskReportConfigDestinationS3Args']]):
        pulumi.set(self, "s3", value)


@pulumi.input_type
class TaskReportConfigDestinationS3Args:
    def __init__(__self__, *,
                 bucket_access_role_arn: Optional[pulumi.Input[str]] = None,
                 s3_bucket_arn: Optional[pulumi.Input[str]] = None,
                 subdirectory: Optional[pulumi.Input[str]] = None):
        """
        Specifies the Amazon S3 bucket where DataSync uploads your task report.
        :param pulumi.Input[str] bucket_access_role_arn: Specifies the Amazon Resource Name (ARN) of the IAM policy that allows Datasync to upload a task report to your S3 bucket.
        :param pulumi.Input[str] s3_bucket_arn: Specifies the ARN of the S3 bucket where Datasync uploads your report.
        :param pulumi.Input[str] subdirectory: Specifies a bucket prefix for your report.
        """
        if bucket_access_role_arn is not None:
            pulumi.set(__self__, "bucket_access_role_arn", bucket_access_role_arn)
        if s3_bucket_arn is not None:
            pulumi.set(__self__, "s3_bucket_arn", s3_bucket_arn)
        if subdirectory is not None:
            pulumi.set(__self__, "subdirectory", subdirectory)

    @property
    @pulumi.getter(name="bucketAccessRoleArn")
    def bucket_access_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Amazon Resource Name (ARN) of the IAM policy that allows Datasync to upload a task report to your S3 bucket.
        """
        return pulumi.get(self, "bucket_access_role_arn")

    @bucket_access_role_arn.setter
    def bucket_access_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_access_role_arn", value)

    @property
    @pulumi.getter(name="s3BucketArn")
    def s3_bucket_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ARN of the S3 bucket where Datasync uploads your report.
        """
        return pulumi.get(self, "s3_bucket_arn")

    @s3_bucket_arn.setter
    def s3_bucket_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_bucket_arn", value)

    @property
    @pulumi.getter
    def subdirectory(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a bucket prefix for your report.
        """
        return pulumi.get(self, "subdirectory")

    @subdirectory.setter
    def subdirectory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subdirectory", value)


@pulumi.input_type
class TaskReportConfigOverridesPropertiesDeletedPropertiesArgs:
    def __init__(__self__, *,
                 report_level: Optional[pulumi.Input['TaskReportConfigOverridesPropertiesDeletedPropertiesReportLevel']] = None):
        """
        Specifies the level of reporting for the files, objects, and directories that Datasync attempted to delete in your destination location. This only applies if you configure your task to delete data in the destination that isn't in the source.
        :param pulumi.Input['TaskReportConfigOverridesPropertiesDeletedPropertiesReportLevel'] report_level: Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
        """
        if report_level is not None:
            pulumi.set(__self__, "report_level", report_level)

    @property
    @pulumi.getter(name="reportLevel")
    def report_level(self) -> Optional[pulumi.Input['TaskReportConfigOverridesPropertiesDeletedPropertiesReportLevel']]:
        """
        Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
        """
        return pulumi.get(self, "report_level")

    @report_level.setter
    def report_level(self, value: Optional[pulumi.Input['TaskReportConfigOverridesPropertiesDeletedPropertiesReportLevel']]):
        pulumi.set(self, "report_level", value)


@pulumi.input_type
class TaskReportConfigOverridesPropertiesSkippedPropertiesArgs:
    def __init__(__self__, *,
                 report_level: Optional[pulumi.Input['TaskReportConfigOverridesPropertiesSkippedPropertiesReportLevel']] = None):
        """
        Specifies the level of reporting for the files, objects, and directories that Datasync attempted to skip during your transfer.
        :param pulumi.Input['TaskReportConfigOverridesPropertiesSkippedPropertiesReportLevel'] report_level: Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
        """
        if report_level is not None:
            pulumi.set(__self__, "report_level", report_level)

    @property
    @pulumi.getter(name="reportLevel")
    def report_level(self) -> Optional[pulumi.Input['TaskReportConfigOverridesPropertiesSkippedPropertiesReportLevel']]:
        """
        Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
        """
        return pulumi.get(self, "report_level")

    @report_level.setter
    def report_level(self, value: Optional[pulumi.Input['TaskReportConfigOverridesPropertiesSkippedPropertiesReportLevel']]):
        pulumi.set(self, "report_level", value)


@pulumi.input_type
class TaskReportConfigOverridesPropertiesTransferredPropertiesArgs:
    def __init__(__self__, *,
                 report_level: Optional[pulumi.Input['TaskReportConfigOverridesPropertiesTransferredPropertiesReportLevel']] = None):
        """
        Specifies the level of reporting for the files, objects, and directories that Datasync attempted to transfer.
        :param pulumi.Input['TaskReportConfigOverridesPropertiesTransferredPropertiesReportLevel'] report_level: Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
        """
        if report_level is not None:
            pulumi.set(__self__, "report_level", report_level)

    @property
    @pulumi.getter(name="reportLevel")
    def report_level(self) -> Optional[pulumi.Input['TaskReportConfigOverridesPropertiesTransferredPropertiesReportLevel']]:
        """
        Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
        """
        return pulumi.get(self, "report_level")

    @report_level.setter
    def report_level(self, value: Optional[pulumi.Input['TaskReportConfigOverridesPropertiesTransferredPropertiesReportLevel']]):
        pulumi.set(self, "report_level", value)


@pulumi.input_type
class TaskReportConfigOverridesPropertiesVerifiedPropertiesArgs:
    def __init__(__self__, *,
                 report_level: Optional[pulumi.Input['TaskReportConfigOverridesPropertiesVerifiedPropertiesReportLevel']] = None):
        """
        Specifies the level of reporting for the files, objects, and directories that Datasync attempted to verify at the end of your transfer. This only applies if you configure your task to verify data during and after the transfer (which Datasync does by default)
        :param pulumi.Input['TaskReportConfigOverridesPropertiesVerifiedPropertiesReportLevel'] report_level: Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
        """
        if report_level is not None:
            pulumi.set(__self__, "report_level", report_level)

    @property
    @pulumi.getter(name="reportLevel")
    def report_level(self) -> Optional[pulumi.Input['TaskReportConfigOverridesPropertiesVerifiedPropertiesReportLevel']]:
        """
        Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
        """
        return pulumi.get(self, "report_level")

    @report_level.setter
    def report_level(self, value: Optional[pulumi.Input['TaskReportConfigOverridesPropertiesVerifiedPropertiesReportLevel']]):
        pulumi.set(self, "report_level", value)


@pulumi.input_type
class TaskReportConfigOverridesPropertiesArgs:
    def __init__(__self__, *,
                 deleted: Optional[pulumi.Input['TaskReportConfigOverridesPropertiesDeletedPropertiesArgs']] = None,
                 skipped: Optional[pulumi.Input['TaskReportConfigOverridesPropertiesSkippedPropertiesArgs']] = None,
                 transferred: Optional[pulumi.Input['TaskReportConfigOverridesPropertiesTransferredPropertiesArgs']] = None,
                 verified: Optional[pulumi.Input['TaskReportConfigOverridesPropertiesVerifiedPropertiesArgs']] = None):
        """
        Customizes the reporting level for aspects of your task report. For example, your report might generally only include errors, but you could specify that you want a list of successes and errors just for the files that Datasync attempted to delete in your destination location.
        :param pulumi.Input['TaskReportConfigOverridesPropertiesDeletedPropertiesArgs'] deleted: Specifies the level of reporting for the files, objects, and directories that Datasync attempted to delete in your destination location. This only applies if you configure your task to delete data in the destination that isn't in the source.
        :param pulumi.Input['TaskReportConfigOverridesPropertiesSkippedPropertiesArgs'] skipped: Specifies the level of reporting for the files, objects, and directories that Datasync attempted to skip during your transfer.
        :param pulumi.Input['TaskReportConfigOverridesPropertiesTransferredPropertiesArgs'] transferred: Specifies the level of reporting for the files, objects, and directories that Datasync attempted to transfer.
        :param pulumi.Input['TaskReportConfigOverridesPropertiesVerifiedPropertiesArgs'] verified: Specifies the level of reporting for the files, objects, and directories that Datasync attempted to verify at the end of your transfer. This only applies if you configure your task to verify data during and after the transfer (which Datasync does by default)
        """
        if deleted is not None:
            pulumi.set(__self__, "deleted", deleted)
        if skipped is not None:
            pulumi.set(__self__, "skipped", skipped)
        if transferred is not None:
            pulumi.set(__self__, "transferred", transferred)
        if verified is not None:
            pulumi.set(__self__, "verified", verified)

    @property
    @pulumi.getter
    def deleted(self) -> Optional[pulumi.Input['TaskReportConfigOverridesPropertiesDeletedPropertiesArgs']]:
        """
        Specifies the level of reporting for the files, objects, and directories that Datasync attempted to delete in your destination location. This only applies if you configure your task to delete data in the destination that isn't in the source.
        """
        return pulumi.get(self, "deleted")

    @deleted.setter
    def deleted(self, value: Optional[pulumi.Input['TaskReportConfigOverridesPropertiesDeletedPropertiesArgs']]):
        pulumi.set(self, "deleted", value)

    @property
    @pulumi.getter
    def skipped(self) -> Optional[pulumi.Input['TaskReportConfigOverridesPropertiesSkippedPropertiesArgs']]:
        """
        Specifies the level of reporting for the files, objects, and directories that Datasync attempted to skip during your transfer.
        """
        return pulumi.get(self, "skipped")

    @skipped.setter
    def skipped(self, value: Optional[pulumi.Input['TaskReportConfigOverridesPropertiesSkippedPropertiesArgs']]):
        pulumi.set(self, "skipped", value)

    @property
    @pulumi.getter
    def transferred(self) -> Optional[pulumi.Input['TaskReportConfigOverridesPropertiesTransferredPropertiesArgs']]:
        """
        Specifies the level of reporting for the files, objects, and directories that Datasync attempted to transfer.
        """
        return pulumi.get(self, "transferred")

    @transferred.setter
    def transferred(self, value: Optional[pulumi.Input['TaskReportConfigOverridesPropertiesTransferredPropertiesArgs']]):
        pulumi.set(self, "transferred", value)

    @property
    @pulumi.getter
    def verified(self) -> Optional[pulumi.Input['TaskReportConfigOverridesPropertiesVerifiedPropertiesArgs']]:
        """
        Specifies the level of reporting for the files, objects, and directories that Datasync attempted to verify at the end of your transfer. This only applies if you configure your task to verify data during and after the transfer (which Datasync does by default)
        """
        return pulumi.get(self, "verified")

    @verified.setter
    def verified(self, value: Optional[pulumi.Input['TaskReportConfigOverridesPropertiesVerifiedPropertiesArgs']]):
        pulumi.set(self, "verified", value)


@pulumi.input_type
class TaskReportConfigArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input['TaskReportConfigDestinationPropertiesArgs'],
                 output_type: pulumi.Input['TaskReportConfigOutputType'],
                 object_version_ids: Optional[pulumi.Input['TaskReportConfigObjectVersionIds']] = None,
                 overrides: Optional[pulumi.Input['TaskReportConfigOverridesPropertiesArgs']] = None,
                 report_level: Optional[pulumi.Input['TaskReportConfigReportLevel']] = None):
        """
        Specifies how you want to configure a task report, which provides detailed information about for your Datasync transfer.
        :param pulumi.Input['TaskReportConfigDestinationPropertiesArgs'] destination: Specifies where DataSync uploads your task report.
        :param pulumi.Input['TaskReportConfigOutputType'] output_type: Specifies the type of task report that you want.
        :param pulumi.Input['TaskReportConfigObjectVersionIds'] object_version_ids: Specifies whether your task report includes the new version of each object transferred into an S3 bucket, this only applies if you enable versioning on your bucket.
        :param pulumi.Input['TaskReportConfigOverridesPropertiesArgs'] overrides: Customizes the reporting level for aspects of your task report. For example, your report might generally only include errors, but you could specify that you want a list of successes and errors just for the files that Datasync attempted to delete in your destination location.
        :param pulumi.Input['TaskReportConfigReportLevel'] report_level: Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "output_type", output_type)
        if object_version_ids is not None:
            pulumi.set(__self__, "object_version_ids", object_version_ids)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)
        if report_level is not None:
            pulumi.set(__self__, "report_level", report_level)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input['TaskReportConfigDestinationPropertiesArgs']:
        """
        Specifies where DataSync uploads your task report.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['TaskReportConfigDestinationPropertiesArgs']):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="outputType")
    def output_type(self) -> pulumi.Input['TaskReportConfigOutputType']:
        """
        Specifies the type of task report that you want.
        """
        return pulumi.get(self, "output_type")

    @output_type.setter
    def output_type(self, value: pulumi.Input['TaskReportConfigOutputType']):
        pulumi.set(self, "output_type", value)

    @property
    @pulumi.getter(name="objectVersionIds")
    def object_version_ids(self) -> Optional[pulumi.Input['TaskReportConfigObjectVersionIds']]:
        """
        Specifies whether your task report includes the new version of each object transferred into an S3 bucket, this only applies if you enable versioning on your bucket.
        """
        return pulumi.get(self, "object_version_ids")

    @object_version_ids.setter
    def object_version_ids(self, value: Optional[pulumi.Input['TaskReportConfigObjectVersionIds']]):
        pulumi.set(self, "object_version_ids", value)

    @property
    @pulumi.getter
    def overrides(self) -> Optional[pulumi.Input['TaskReportConfigOverridesPropertiesArgs']]:
        """
        Customizes the reporting level for aspects of your task report. For example, your report might generally only include errors, but you could specify that you want a list of successes and errors just for the files that Datasync attempted to delete in your destination location.
        """
        return pulumi.get(self, "overrides")

    @overrides.setter
    def overrides(self, value: Optional[pulumi.Input['TaskReportConfigOverridesPropertiesArgs']]):
        pulumi.set(self, "overrides", value)

    @property
    @pulumi.getter(name="reportLevel")
    def report_level(self) -> Optional[pulumi.Input['TaskReportConfigReportLevel']]:
        """
        Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
        """
        return pulumi.get(self, "report_level")

    @report_level.setter
    def report_level(self, value: Optional[pulumi.Input['TaskReportConfigReportLevel']]):
        pulumi.set(self, "report_level", value)


@pulumi.input_type
class TaskScheduleArgs:
    def __init__(__self__, *,
                 schedule_expression: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input['TaskScheduleStatus']] = None):
        """
        Specifies the schedule you want your task to use for repeated executions.
        :param pulumi.Input[str] schedule_expression: A cron expression that specifies when AWS DataSync initiates a scheduled transfer from a source to a destination location
        :param pulumi.Input['TaskScheduleStatus'] status: Specifies status of a schedule.
        """
        if schedule_expression is not None:
            pulumi.set(__self__, "schedule_expression", schedule_expression)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> Optional[pulumi.Input[str]]:
        """
        A cron expression that specifies when AWS DataSync initiates a scheduled transfer from a source to a destination location
        """
        return pulumi.get(self, "schedule_expression")

    @schedule_expression.setter
    def schedule_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_expression", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['TaskScheduleStatus']]:
        """
        Specifies status of a schedule.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['TaskScheduleStatus']]):
        pulumi.set(self, "status", value)


