# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetEnabledControlResult',
    'AwaitableGetEnabledControlResult',
    'get_enabled_control',
    'get_enabled_control_output',
]

@pulumi.output_type
class GetEnabledControlResult:
    def __init__(__self__, parameters=None, tags=None):
        if parameters and not isinstance(parameters, list):
            raise TypeError("Expected argument 'parameters' to be a list")
        pulumi.set(__self__, "parameters", parameters)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.EnabledControlParameter']]:
        """
        Parameters to configure the enabled control behavior.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A set of tags to assign to the enabled control.
        """
        return pulumi.get(self, "tags")


class AwaitableGetEnabledControlResult(GetEnabledControlResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnabledControlResult(
            parameters=self.parameters,
            tags=self.tags)


def get_enabled_control(control_identifier: Optional[str] = None,
                        target_identifier: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnabledControlResult:
    """
    Enables a control on a specified target.


    :param str control_identifier: Arn of the control.
    :param str target_identifier: Arn for Organizational unit to which the control needs to be applied
    """
    __args__ = dict()
    __args__['controlIdentifier'] = control_identifier
    __args__['targetIdentifier'] = target_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:controltower:getEnabledControl', __args__, opts=opts, typ=GetEnabledControlResult).value

    return AwaitableGetEnabledControlResult(
        parameters=pulumi.get(__ret__, 'parameters'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_enabled_control)
def get_enabled_control_output(control_identifier: Optional[pulumi.Input[str]] = None,
                               target_identifier: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEnabledControlResult]:
    """
    Enables a control on a specified target.


    :param str control_identifier: Arn of the control.
    :param str target_identifier: Arn for Organizational unit to which the control needs to be applied
    """
    ...
