# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['EnabledControlArgs', 'EnabledControl']

@pulumi.input_type
class EnabledControlArgs:
    def __init__(__self__, *,
                 control_identifier: pulumi.Input[str],
                 target_identifier: pulumi.Input[str],
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['EnabledControlParameterArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a EnabledControl resource.
        :param pulumi.Input[str] control_identifier: Arn of the control.
        :param pulumi.Input[str] target_identifier: Arn for Organizational unit to which the control needs to be applied
        :param pulumi.Input[Sequence[pulumi.Input['EnabledControlParameterArgs']]] parameters: Parameters to configure the enabled control behavior.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A set of tags to assign to the enabled control.
        """
        pulumi.set(__self__, "control_identifier", control_identifier)
        pulumi.set(__self__, "target_identifier", target_identifier)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="controlIdentifier")
    def control_identifier(self) -> pulumi.Input[str]:
        """
        Arn of the control.
        """
        return pulumi.get(self, "control_identifier")

    @control_identifier.setter
    def control_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "control_identifier", value)

    @property
    @pulumi.getter(name="targetIdentifier")
    def target_identifier(self) -> pulumi.Input[str]:
        """
        Arn for Organizational unit to which the control needs to be applied
        """
        return pulumi.get(self, "target_identifier")

    @target_identifier.setter
    def target_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_identifier", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnabledControlParameterArgs']]]]:
        """
        Parameters to configure the enabled control behavior.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnabledControlParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A set of tags to assign to the enabled control.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class EnabledControl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 control_identifier: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnabledControlParameterArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 target_identifier: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Enables a control on a specified target.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_example_control = aws_native.controltower.EnabledControl("myExampleControl",
            control_identifier="arn:aws:controltower:us-east-2::control/EXAMPLE_NAME",
            target_identifier="arn:aws:organizations::01234567890:ou/o-EXAMPLE/ou-zzxx-zzx0zzz2")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_example_control = aws_native.controltower.EnabledControl("myExampleControl",
            control_identifier="arn:aws:controltower:us-east-2::control/EXAMPLE_NAME",
            target_identifier="arn:aws:organizations::01234567890:ou/o-EXAMPLE/ou-zzxx-zzx0zzz2")

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] control_identifier: Arn of the control.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnabledControlParameterArgs']]]] parameters: Parameters to configure the enabled control behavior.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]] tags: A set of tags to assign to the enabled control.
        :param pulumi.Input[str] target_identifier: Arn for Organizational unit to which the control needs to be applied
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnabledControlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Enables a control on a specified target.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_example_control = aws_native.controltower.EnabledControl("myExampleControl",
            control_identifier="arn:aws:controltower:us-east-2::control/EXAMPLE_NAME",
            target_identifier="arn:aws:organizations::01234567890:ou/o-EXAMPLE/ou-zzxx-zzx0zzz2")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_example_control = aws_native.controltower.EnabledControl("myExampleControl",
            control_identifier="arn:aws:controltower:us-east-2::control/EXAMPLE_NAME",
            target_identifier="arn:aws:organizations::01234567890:ou/o-EXAMPLE/ou-zzxx-zzx0zzz2")

        ```

        :param str resource_name: The name of the resource.
        :param EnabledControlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnabledControlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 control_identifier: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnabledControlParameterArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 target_identifier: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnabledControlArgs.__new__(EnabledControlArgs)

            if control_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'control_identifier'")
            __props__.__dict__["control_identifier"] = control_identifier
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["tags"] = tags
            if target_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'target_identifier'")
            __props__.__dict__["target_identifier"] = target_identifier
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["controlIdentifier", "targetIdentifier"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(EnabledControl, __self__).__init__(
            'aws-native:controltower:EnabledControl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'EnabledControl':
        """
        Get an existing EnabledControl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EnabledControlArgs.__new__(EnabledControlArgs)

        __props__.__dict__["control_identifier"] = None
        __props__.__dict__["parameters"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["target_identifier"] = None
        return EnabledControl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="controlIdentifier")
    def control_identifier(self) -> pulumi.Output[str]:
        """
        Arn of the control.
        """
        return pulumi.get(self, "control_identifier")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Sequence['outputs.EnabledControlParameter']]]:
        """
        Parameters to configure the enabled control behavior.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A set of tags to assign to the enabled control.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetIdentifier")
    def target_identifier(self) -> pulumi.Output[str]:
        """
        Arn for Organizational unit to which the control needs to be applied
        """
        return pulumi.get(self, "target_identifier")

