# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['RoutingProfileArgs', 'RoutingProfile']

@pulumi.input_type
class RoutingProfileArgs:
    def __init__(__self__, *,
                 default_outbound_queue_arn: pulumi.Input[str],
                 description: pulumi.Input[str],
                 instance_arn: pulumi.Input[str],
                 media_concurrencies: pulumi.Input[Sequence[pulumi.Input['RoutingProfileMediaConcurrencyArgs']]],
                 agent_availability_timer: Optional[pulumi.Input['RoutingProfileAgentAvailabilityTimer']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 queue_configs: Optional[pulumi.Input[Sequence[pulumi.Input['RoutingProfileQueueConfigArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a RoutingProfile resource.
        :param pulumi.Input[str] default_outbound_queue_arn: The identifier of the default outbound queue for this routing profile.
        :param pulumi.Input[str] description: The description of the routing profile.
        :param pulumi.Input[str] instance_arn: The identifier of the Amazon Connect instance.
        :param pulumi.Input[Sequence[pulumi.Input['RoutingProfileMediaConcurrencyArgs']]] media_concurrencies: The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
        :param pulumi.Input['RoutingProfileAgentAvailabilityTimer'] agent_availability_timer: Whether agents with this routing profile will have their routing order calculated based on longest idle time or time since their last inbound contact.
        :param pulumi.Input[str] name: The name of the routing profile.
        :param pulumi.Input[Sequence[pulumi.Input['RoutingProfileQueueConfigArgs']]] queue_configs: The queues to associate with this routing profile.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "default_outbound_queue_arn", default_outbound_queue_arn)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "instance_arn", instance_arn)
        pulumi.set(__self__, "media_concurrencies", media_concurrencies)
        if agent_availability_timer is not None:
            pulumi.set(__self__, "agent_availability_timer", agent_availability_timer)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if queue_configs is not None:
            pulumi.set(__self__, "queue_configs", queue_configs)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="defaultOutboundQueueArn")
    def default_outbound_queue_arn(self) -> pulumi.Input[str]:
        """
        The identifier of the default outbound queue for this routing profile.
        """
        return pulumi.get(self, "default_outbound_queue_arn")

    @default_outbound_queue_arn.setter
    def default_outbound_queue_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "default_outbound_queue_arn", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the routing profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> pulumi.Input[str]:
        """
        The identifier of the Amazon Connect instance.
        """
        return pulumi.get(self, "instance_arn")

    @instance_arn.setter
    def instance_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_arn", value)

    @property
    @pulumi.getter(name="mediaConcurrencies")
    def media_concurrencies(self) -> pulumi.Input[Sequence[pulumi.Input['RoutingProfileMediaConcurrencyArgs']]]:
        """
        The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
        """
        return pulumi.get(self, "media_concurrencies")

    @media_concurrencies.setter
    def media_concurrencies(self, value: pulumi.Input[Sequence[pulumi.Input['RoutingProfileMediaConcurrencyArgs']]]):
        pulumi.set(self, "media_concurrencies", value)

    @property
    @pulumi.getter(name="agentAvailabilityTimer")
    def agent_availability_timer(self) -> Optional[pulumi.Input['RoutingProfileAgentAvailabilityTimer']]:
        """
        Whether agents with this routing profile will have their routing order calculated based on longest idle time or time since their last inbound contact.
        """
        return pulumi.get(self, "agent_availability_timer")

    @agent_availability_timer.setter
    def agent_availability_timer(self, value: Optional[pulumi.Input['RoutingProfileAgentAvailabilityTimer']]):
        pulumi.set(self, "agent_availability_timer", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the routing profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="queueConfigs")
    def queue_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RoutingProfileQueueConfigArgs']]]]:
        """
        The queues to associate with this routing profile.
        """
        return pulumi.get(self, "queue_configs")

    @queue_configs.setter
    def queue_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RoutingProfileQueueConfigArgs']]]]):
        pulumi.set(self, "queue_configs", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class RoutingProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_availability_timer: Optional[pulumi.Input['RoutingProfileAgentAvailabilityTimer']] = None,
                 default_outbound_queue_arn: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_arn: Optional[pulumi.Input[str]] = None,
                 media_concurrencies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoutingProfileMediaConcurrencyArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 queue_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoutingProfileQueueConfigArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Connect::RoutingProfile

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['RoutingProfileAgentAvailabilityTimer'] agent_availability_timer: Whether agents with this routing profile will have their routing order calculated based on longest idle time or time since their last inbound contact.
        :param pulumi.Input[str] default_outbound_queue_arn: The identifier of the default outbound queue for this routing profile.
        :param pulumi.Input[str] description: The description of the routing profile.
        :param pulumi.Input[str] instance_arn: The identifier of the Amazon Connect instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoutingProfileMediaConcurrencyArgs']]]] media_concurrencies: The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
        :param pulumi.Input[str] name: The name of the routing profile.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoutingProfileQueueConfigArgs']]]] queue_configs: The queues to associate with this routing profile.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RoutingProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Connect::RoutingProfile

        :param str resource_name: The name of the resource.
        :param RoutingProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoutingProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_availability_timer: Optional[pulumi.Input['RoutingProfileAgentAvailabilityTimer']] = None,
                 default_outbound_queue_arn: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_arn: Optional[pulumi.Input[str]] = None,
                 media_concurrencies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoutingProfileMediaConcurrencyArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 queue_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RoutingProfileQueueConfigArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoutingProfileArgs.__new__(RoutingProfileArgs)

            __props__.__dict__["agent_availability_timer"] = agent_availability_timer
            if default_outbound_queue_arn is None and not opts.urn:
                raise TypeError("Missing required property 'default_outbound_queue_arn'")
            __props__.__dict__["default_outbound_queue_arn"] = default_outbound_queue_arn
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if instance_arn is None and not opts.urn:
                raise TypeError("Missing required property 'instance_arn'")
            __props__.__dict__["instance_arn"] = instance_arn
            if media_concurrencies is None and not opts.urn:
                raise TypeError("Missing required property 'media_concurrencies'")
            __props__.__dict__["media_concurrencies"] = media_concurrencies
            __props__.__dict__["name"] = name
            __props__.__dict__["queue_configs"] = queue_configs
            __props__.__dict__["tags"] = tags
            __props__.__dict__["routing_profile_arn"] = None
        super(RoutingProfile, __self__).__init__(
            'aws-native:connect:RoutingProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'RoutingProfile':
        """
        Get an existing RoutingProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RoutingProfileArgs.__new__(RoutingProfileArgs)

        __props__.__dict__["agent_availability_timer"] = None
        __props__.__dict__["default_outbound_queue_arn"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["instance_arn"] = None
        __props__.__dict__["media_concurrencies"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["queue_configs"] = None
        __props__.__dict__["routing_profile_arn"] = None
        __props__.__dict__["tags"] = None
        return RoutingProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentAvailabilityTimer")
    def agent_availability_timer(self) -> pulumi.Output[Optional['RoutingProfileAgentAvailabilityTimer']]:
        """
        Whether agents with this routing profile will have their routing order calculated based on longest idle time or time since their last inbound contact.
        """
        return pulumi.get(self, "agent_availability_timer")

    @property
    @pulumi.getter(name="defaultOutboundQueueArn")
    def default_outbound_queue_arn(self) -> pulumi.Output[str]:
        """
        The identifier of the default outbound queue for this routing profile.
        """
        return pulumi.get(self, "default_outbound_queue_arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the routing profile.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> pulumi.Output[str]:
        """
        The identifier of the Amazon Connect instance.
        """
        return pulumi.get(self, "instance_arn")

    @property
    @pulumi.getter(name="mediaConcurrencies")
    def media_concurrencies(self) -> pulumi.Output[Sequence['outputs.RoutingProfileMediaConcurrency']]:
        """
        The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
        """
        return pulumi.get(self, "media_concurrencies")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the routing profile.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="queueConfigs")
    def queue_configs(self) -> pulumi.Output[Optional[Sequence['outputs.RoutingProfileQueueConfig']]]:
        """
        The queues to associate with this routing profile.
        """
        return pulumi.get(self, "queue_configs")

    @property
    @pulumi.getter(name="routingProfileArn")
    def routing_profile_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the routing profile.
        """
        return pulumi.get(self, "routing_profile_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

