# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    def __init__(__self__, directory_user_id=None, hierarchy_group_arn=None, identity_info=None, instance_arn=None, phone_config=None, routing_profile_arn=None, security_profile_arns=None, tags=None, user_arn=None, user_proficiencies=None, username=None):
        if directory_user_id and not isinstance(directory_user_id, str):
            raise TypeError("Expected argument 'directory_user_id' to be a str")
        pulumi.set(__self__, "directory_user_id", directory_user_id)
        if hierarchy_group_arn and not isinstance(hierarchy_group_arn, str):
            raise TypeError("Expected argument 'hierarchy_group_arn' to be a str")
        pulumi.set(__self__, "hierarchy_group_arn", hierarchy_group_arn)
        if identity_info and not isinstance(identity_info, dict):
            raise TypeError("Expected argument 'identity_info' to be a dict")
        pulumi.set(__self__, "identity_info", identity_info)
        if instance_arn and not isinstance(instance_arn, str):
            raise TypeError("Expected argument 'instance_arn' to be a str")
        pulumi.set(__self__, "instance_arn", instance_arn)
        if phone_config and not isinstance(phone_config, dict):
            raise TypeError("Expected argument 'phone_config' to be a dict")
        pulumi.set(__self__, "phone_config", phone_config)
        if routing_profile_arn and not isinstance(routing_profile_arn, str):
            raise TypeError("Expected argument 'routing_profile_arn' to be a str")
        pulumi.set(__self__, "routing_profile_arn", routing_profile_arn)
        if security_profile_arns and not isinstance(security_profile_arns, list):
            raise TypeError("Expected argument 'security_profile_arns' to be a list")
        pulumi.set(__self__, "security_profile_arns", security_profile_arns)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if user_arn and not isinstance(user_arn, str):
            raise TypeError("Expected argument 'user_arn' to be a str")
        pulumi.set(__self__, "user_arn", user_arn)
        if user_proficiencies and not isinstance(user_proficiencies, list):
            raise TypeError("Expected argument 'user_proficiencies' to be a list")
        pulumi.set(__self__, "user_proficiencies", user_proficiencies)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="directoryUserId")
    def directory_user_id(self) -> Optional[str]:
        """
        The identifier of the user account in the directory used for identity management.
        """
        return pulumi.get(self, "directory_user_id")

    @property
    @pulumi.getter(name="hierarchyGroupArn")
    def hierarchy_group_arn(self) -> Optional[str]:
        """
        The identifier of the hierarchy group for the user.
        """
        return pulumi.get(self, "hierarchy_group_arn")

    @property
    @pulumi.getter(name="identityInfo")
    def identity_info(self) -> Optional['outputs.UserIdentityInfo']:
        """
        The information about the identity of the user.
        """
        return pulumi.get(self, "identity_info")

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> Optional[str]:
        """
        The identifier of the Amazon Connect instance.
        """
        return pulumi.get(self, "instance_arn")

    @property
    @pulumi.getter(name="phoneConfig")
    def phone_config(self) -> Optional['outputs.UserPhoneConfig']:
        """
        The phone settings for the user.
        """
        return pulumi.get(self, "phone_config")

    @property
    @pulumi.getter(name="routingProfileArn")
    def routing_profile_arn(self) -> Optional[str]:
        """
        The identifier of the routing profile for the user.
        """
        return pulumi.get(self, "routing_profile_arn")

    @property
    @pulumi.getter(name="securityProfileArns")
    def security_profile_arns(self) -> Optional[Sequence[str]]:
        """
        One or more security profile arns for the user
        """
        return pulumi.get(self, "security_profile_arns")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        One or more tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userArn")
    def user_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the user.
        """
        return pulumi.get(self, "user_arn")

    @property
    @pulumi.getter(name="userProficiencies")
    def user_proficiencies(self) -> Optional[Sequence['outputs.UserProficiency']]:
        """
        One or more predefined attributes assigned to a user, with a level that indicates how skilled they are.
        """
        return pulumi.get(self, "user_proficiencies")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The user name for the account.
        """
        return pulumi.get(self, "username")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            directory_user_id=self.directory_user_id,
            hierarchy_group_arn=self.hierarchy_group_arn,
            identity_info=self.identity_info,
            instance_arn=self.instance_arn,
            phone_config=self.phone_config,
            routing_profile_arn=self.routing_profile_arn,
            security_profile_arns=self.security_profile_arns,
            tags=self.tags,
            user_arn=self.user_arn,
            user_proficiencies=self.user_proficiencies,
            username=self.username)


def get_user(user_arn: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    Resource Type definition for AWS::Connect::User


    :param str user_arn: The Amazon Resource Name (ARN) for the user.
    """
    __args__ = dict()
    __args__['userArn'] = user_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:connect:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        directory_user_id=pulumi.get(__ret__, 'directory_user_id'),
        hierarchy_group_arn=pulumi.get(__ret__, 'hierarchy_group_arn'),
        identity_info=pulumi.get(__ret__, 'identity_info'),
        instance_arn=pulumi.get(__ret__, 'instance_arn'),
        phone_config=pulumi.get(__ret__, 'phone_config'),
        routing_profile_arn=pulumi.get(__ret__, 'routing_profile_arn'),
        security_profile_arns=pulumi.get(__ret__, 'security_profile_arns'),
        tags=pulumi.get(__ret__, 'tags'),
        user_arn=pulumi.get(__ret__, 'user_arn'),
        user_proficiencies=pulumi.get(__ret__, 'user_proficiencies'),
        username=pulumi.get(__ret__, 'username'))


@_utilities.lift_output_func(get_user)
def get_user_output(user_arn: Optional[pulumi.Input[str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUserResult]:
    """
    Resource Type definition for AWS::Connect::User


    :param str user_arn: The Amazon Resource Name (ARN) for the user.
    """
    ...
