# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetPromptResult',
    'AwaitableGetPromptResult',
    'get_prompt',
    'get_prompt_output',
]

@pulumi.output_type
class GetPromptResult:
    def __init__(__self__, description=None, instance_arn=None, name=None, prompt_arn=None, tags=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if instance_arn and not isinstance(instance_arn, str):
            raise TypeError("Expected argument 'instance_arn' to be a str")
        pulumi.set(__self__, "instance_arn", instance_arn)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if prompt_arn and not isinstance(prompt_arn, str):
            raise TypeError("Expected argument 'prompt_arn' to be a str")
        pulumi.set(__self__, "prompt_arn", prompt_arn)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the prompt.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> Optional[str]:
        """
        The identifier of the Amazon Connect instance.
        """
        return pulumi.get(self, "instance_arn")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the prompt.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="promptArn")
    def prompt_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the prompt.
        """
        return pulumi.get(self, "prompt_arn")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetPromptResult(GetPromptResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPromptResult(
            description=self.description,
            instance_arn=self.instance_arn,
            name=self.name,
            prompt_arn=self.prompt_arn,
            tags=self.tags)


def get_prompt(prompt_arn: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPromptResult:
    """
    Resource Type definition for AWS::Connect::Prompt


    :param str prompt_arn: The Amazon Resource Name (ARN) for the prompt.
    """
    __args__ = dict()
    __args__['promptArn'] = prompt_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:connect:getPrompt', __args__, opts=opts, typ=GetPromptResult).value

    return AwaitableGetPromptResult(
        description=pulumi.get(__ret__, 'description'),
        instance_arn=pulumi.get(__ret__, 'instance_arn'),
        name=pulumi.get(__ret__, 'name'),
        prompt_arn=pulumi.get(__ret__, 'prompt_arn'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_prompt)
def get_prompt_output(prompt_arn: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPromptResult]:
    """
    Resource Type definition for AWS::Connect::Prompt


    :param str prompt_arn: The Amazon Resource Name (ARN) for the prompt.
    """
    ...
