# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'GetSyncConfigurationResult',
    'AwaitableGetSyncConfigurationResult',
    'get_sync_configuration',
    'get_sync_configuration_output',
]

@pulumi.output_type
class GetSyncConfigurationResult:
    def __init__(__self__, branch=None, config_file=None, owner_id=None, provider_type=None, publish_deployment_status=None, repository_link_id=None, repository_name=None, role_arn=None, trigger_resource_update_on=None):
        if branch and not isinstance(branch, str):
            raise TypeError("Expected argument 'branch' to be a str")
        pulumi.set(__self__, "branch", branch)
        if config_file and not isinstance(config_file, str):
            raise TypeError("Expected argument 'config_file' to be a str")
        pulumi.set(__self__, "config_file", config_file)
        if owner_id and not isinstance(owner_id, str):
            raise TypeError("Expected argument 'owner_id' to be a str")
        pulumi.set(__self__, "owner_id", owner_id)
        if provider_type and not isinstance(provider_type, str):
            raise TypeError("Expected argument 'provider_type' to be a str")
        pulumi.set(__self__, "provider_type", provider_type)
        if publish_deployment_status and not isinstance(publish_deployment_status, str):
            raise TypeError("Expected argument 'publish_deployment_status' to be a str")
        pulumi.set(__self__, "publish_deployment_status", publish_deployment_status)
        if repository_link_id and not isinstance(repository_link_id, str):
            raise TypeError("Expected argument 'repository_link_id' to be a str")
        pulumi.set(__self__, "repository_link_id", repository_link_id)
        if repository_name and not isinstance(repository_name, str):
            raise TypeError("Expected argument 'repository_name' to be a str")
        pulumi.set(__self__, "repository_name", repository_name)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if trigger_resource_update_on and not isinstance(trigger_resource_update_on, str):
            raise TypeError("Expected argument 'trigger_resource_update_on' to be a str")
        pulumi.set(__self__, "trigger_resource_update_on", trigger_resource_update_on)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch of the repository from which resources are to be synchronized,
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="configFile")
    def config_file(self) -> Optional[str]:
        """
        The source provider repository path of the sync configuration file of the respective SyncType.
        """
        return pulumi.get(self, "config_file")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[str]:
        """
        the ID of the entity that owns the repository.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> Optional['SyncConfigurationProviderType']:
        """
        The name of the external provider where your third-party code repository is configured.
        """
        return pulumi.get(self, "provider_type")

    @property
    @pulumi.getter(name="publishDeploymentStatus")
    def publish_deployment_status(self) -> Optional['SyncConfigurationPublishDeploymentStatus']:
        """
        Whether to enable or disable publishing of deployment status to source providers.
        """
        return pulumi.get(self, "publish_deployment_status")

    @property
    @pulumi.getter(name="repositoryLinkId")
    def repository_link_id(self) -> Optional[str]:
        """
        A UUID that uniquely identifies the RepositoryLink that the SyncConfig is associated with.
        """
        return pulumi.get(self, "repository_link_id")

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> Optional[str]:
        """
        The name of the repository that is being synced to.
        """
        return pulumi.get(self, "repository_name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        The IAM Role that allows AWS to update CloudFormation stacks based on content in the specified repository.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="triggerResourceUpdateOn")
    def trigger_resource_update_on(self) -> Optional['SyncConfigurationTriggerResourceUpdateOn']:
        """
        When to trigger Git sync to begin the stack update.
        """
        return pulumi.get(self, "trigger_resource_update_on")


class AwaitableGetSyncConfigurationResult(GetSyncConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSyncConfigurationResult(
            branch=self.branch,
            config_file=self.config_file,
            owner_id=self.owner_id,
            provider_type=self.provider_type,
            publish_deployment_status=self.publish_deployment_status,
            repository_link_id=self.repository_link_id,
            repository_name=self.repository_name,
            role_arn=self.role_arn,
            trigger_resource_update_on=self.trigger_resource_update_on)


def get_sync_configuration(resource_name: Optional[str] = None,
                           sync_type: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSyncConfigurationResult:
    """
    Schema for AWS::CodeStarConnections::SyncConfiguration resource which is used to enables an AWS resource to be synchronized from a source-provider.


    :param str resource_name: The name of the resource that is being synchronized to the repository.
    :param str sync_type: The type of resource synchronization service that is to be configured, for example, CFN_STACK_SYNC.
    """
    __args__ = dict()
    __args__['resourceName'] = resource_name
    __args__['syncType'] = sync_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:codestarconnections:getSyncConfiguration', __args__, opts=opts, typ=GetSyncConfigurationResult).value

    return AwaitableGetSyncConfigurationResult(
        branch=pulumi.get(__ret__, 'branch'),
        config_file=pulumi.get(__ret__, 'config_file'),
        owner_id=pulumi.get(__ret__, 'owner_id'),
        provider_type=pulumi.get(__ret__, 'provider_type'),
        publish_deployment_status=pulumi.get(__ret__, 'publish_deployment_status'),
        repository_link_id=pulumi.get(__ret__, 'repository_link_id'),
        repository_name=pulumi.get(__ret__, 'repository_name'),
        role_arn=pulumi.get(__ret__, 'role_arn'),
        trigger_resource_update_on=pulumi.get(__ret__, 'trigger_resource_update_on'))


@_utilities.lift_output_func(get_sync_configuration)
def get_sync_configuration_output(resource_name: Optional[pulumi.Input[str]] = None,
                                  sync_type: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSyncConfigurationResult]:
    """
    Schema for AWS::CodeStarConnections::SyncConfiguration resource which is used to enables an AWS resource to be synchronized from a source-provider.


    :param str resource_name: The name of the resource that is being synchronized to the repository.
    :param str sync_type: The type of resource synchronization service that is to be configured, for example, CFN_STACK_SYNC.
    """
    ...
