# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeploymentConfigArgs', 'DeploymentConfig']

@pulumi.input_type
class DeploymentConfigArgs:
    def __init__(__self__, *,
                 compute_platform: Optional[pulumi.Input[str]] = None,
                 deployment_config_name: Optional[pulumi.Input[str]] = None,
                 minimum_healthy_hosts: Optional[pulumi.Input['DeploymentConfigMinimumHealthyHostsArgs']] = None,
                 traffic_routing_config: Optional[pulumi.Input['DeploymentConfigTrafficRoutingConfigArgs']] = None,
                 zonal_config: Optional[pulumi.Input['DeploymentConfigZonalConfigArgs']] = None):
        """
        The set of arguments for constructing a DeploymentConfig resource.
        :param pulumi.Input[str] compute_platform: The destination platform type for the deployment (Lambda, Server, or ECS).
        :param pulumi.Input[str] deployment_config_name: A name for the deployment configuration. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the deployment configuration name. For more information, see Name Type.
        :param pulumi.Input['DeploymentConfigMinimumHealthyHostsArgs'] minimum_healthy_hosts: The minimum number of healthy instances that should be available at any time during the deployment. There are two parameters expected in the input: type and value.
        :param pulumi.Input['DeploymentConfigTrafficRoutingConfigArgs'] traffic_routing_config: The configuration that specifies how the deployment traffic is routed.
        :param pulumi.Input['DeploymentConfigZonalConfigArgs'] zonal_config: The zonal deployment config that specifies how the zonal deployment behaves
        """
        if compute_platform is not None:
            pulumi.set(__self__, "compute_platform", compute_platform)
        if deployment_config_name is not None:
            pulumi.set(__self__, "deployment_config_name", deployment_config_name)
        if minimum_healthy_hosts is not None:
            pulumi.set(__self__, "minimum_healthy_hosts", minimum_healthy_hosts)
        if traffic_routing_config is not None:
            pulumi.set(__self__, "traffic_routing_config", traffic_routing_config)
        if zonal_config is not None:
            pulumi.set(__self__, "zonal_config", zonal_config)

    @property
    @pulumi.getter(name="computePlatform")
    def compute_platform(self) -> Optional[pulumi.Input[str]]:
        """
        The destination platform type for the deployment (Lambda, Server, or ECS).
        """
        return pulumi.get(self, "compute_platform")

    @compute_platform.setter
    def compute_platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_platform", value)

    @property
    @pulumi.getter(name="deploymentConfigName")
    def deployment_config_name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the deployment configuration. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the deployment configuration name. For more information, see Name Type.
        """
        return pulumi.get(self, "deployment_config_name")

    @deployment_config_name.setter
    def deployment_config_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_config_name", value)

    @property
    @pulumi.getter(name="minimumHealthyHosts")
    def minimum_healthy_hosts(self) -> Optional[pulumi.Input['DeploymentConfigMinimumHealthyHostsArgs']]:
        """
        The minimum number of healthy instances that should be available at any time during the deployment. There are two parameters expected in the input: type and value.
        """
        return pulumi.get(self, "minimum_healthy_hosts")

    @minimum_healthy_hosts.setter
    def minimum_healthy_hosts(self, value: Optional[pulumi.Input['DeploymentConfigMinimumHealthyHostsArgs']]):
        pulumi.set(self, "minimum_healthy_hosts", value)

    @property
    @pulumi.getter(name="trafficRoutingConfig")
    def traffic_routing_config(self) -> Optional[pulumi.Input['DeploymentConfigTrafficRoutingConfigArgs']]:
        """
        The configuration that specifies how the deployment traffic is routed.
        """
        return pulumi.get(self, "traffic_routing_config")

    @traffic_routing_config.setter
    def traffic_routing_config(self, value: Optional[pulumi.Input['DeploymentConfigTrafficRoutingConfigArgs']]):
        pulumi.set(self, "traffic_routing_config", value)

    @property
    @pulumi.getter(name="zonalConfig")
    def zonal_config(self) -> Optional[pulumi.Input['DeploymentConfigZonalConfigArgs']]:
        """
        The zonal deployment config that specifies how the zonal deployment behaves
        """
        return pulumi.get(self, "zonal_config")

    @zonal_config.setter
    def zonal_config(self, value: Optional[pulumi.Input['DeploymentConfigZonalConfigArgs']]):
        pulumi.set(self, "zonal_config", value)


class DeploymentConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_platform: Optional[pulumi.Input[str]] = None,
                 deployment_config_name: Optional[pulumi.Input[str]] = None,
                 minimum_healthy_hosts: Optional[pulumi.Input[pulumi.InputType['DeploymentConfigMinimumHealthyHostsArgs']]] = None,
                 traffic_routing_config: Optional[pulumi.Input[pulumi.InputType['DeploymentConfigTrafficRoutingConfigArgs']]] = None,
                 zonal_config: Optional[pulumi.Input[pulumi.InputType['DeploymentConfigZonalConfigArgs']]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::CodeDeploy::DeploymentConfig

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compute_platform: The destination platform type for the deployment (Lambda, Server, or ECS).
        :param pulumi.Input[str] deployment_config_name: A name for the deployment configuration. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the deployment configuration name. For more information, see Name Type.
        :param pulumi.Input[pulumi.InputType['DeploymentConfigMinimumHealthyHostsArgs']] minimum_healthy_hosts: The minimum number of healthy instances that should be available at any time during the deployment. There are two parameters expected in the input: type and value.
        :param pulumi.Input[pulumi.InputType['DeploymentConfigTrafficRoutingConfigArgs']] traffic_routing_config: The configuration that specifies how the deployment traffic is routed.
        :param pulumi.Input[pulumi.InputType['DeploymentConfigZonalConfigArgs']] zonal_config: The zonal deployment config that specifies how the zonal deployment behaves
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DeploymentConfigArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::CodeDeploy::DeploymentConfig

        :param str resource_name: The name of the resource.
        :param DeploymentConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeploymentConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_platform: Optional[pulumi.Input[str]] = None,
                 deployment_config_name: Optional[pulumi.Input[str]] = None,
                 minimum_healthy_hosts: Optional[pulumi.Input[pulumi.InputType['DeploymentConfigMinimumHealthyHostsArgs']]] = None,
                 traffic_routing_config: Optional[pulumi.Input[pulumi.InputType['DeploymentConfigTrafficRoutingConfigArgs']]] = None,
                 zonal_config: Optional[pulumi.Input[pulumi.InputType['DeploymentConfigZonalConfigArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeploymentConfigArgs.__new__(DeploymentConfigArgs)

            __props__.__dict__["compute_platform"] = compute_platform
            __props__.__dict__["deployment_config_name"] = deployment_config_name
            __props__.__dict__["minimum_healthy_hosts"] = minimum_healthy_hosts
            __props__.__dict__["traffic_routing_config"] = traffic_routing_config
            __props__.__dict__["zonal_config"] = zonal_config
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["computePlatform", "deploymentConfigName", "minimumHealthyHosts", "trafficRoutingConfig", "zonalConfig"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DeploymentConfig, __self__).__init__(
            'aws-native:codedeploy:DeploymentConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DeploymentConfig':
        """
        Get an existing DeploymentConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DeploymentConfigArgs.__new__(DeploymentConfigArgs)

        __props__.__dict__["compute_platform"] = None
        __props__.__dict__["deployment_config_name"] = None
        __props__.__dict__["minimum_healthy_hosts"] = None
        __props__.__dict__["traffic_routing_config"] = None
        __props__.__dict__["zonal_config"] = None
        return DeploymentConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="computePlatform")
    def compute_platform(self) -> pulumi.Output[Optional[str]]:
        """
        The destination platform type for the deployment (Lambda, Server, or ECS).
        """
        return pulumi.get(self, "compute_platform")

    @property
    @pulumi.getter(name="deploymentConfigName")
    def deployment_config_name(self) -> pulumi.Output[Optional[str]]:
        """
        A name for the deployment configuration. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the deployment configuration name. For more information, see Name Type.
        """
        return pulumi.get(self, "deployment_config_name")

    @property
    @pulumi.getter(name="minimumHealthyHosts")
    def minimum_healthy_hosts(self) -> pulumi.Output[Optional['outputs.DeploymentConfigMinimumHealthyHosts']]:
        """
        The minimum number of healthy instances that should be available at any time during the deployment. There are two parameters expected in the input: type and value.
        """
        return pulumi.get(self, "minimum_healthy_hosts")

    @property
    @pulumi.getter(name="trafficRoutingConfig")
    def traffic_routing_config(self) -> pulumi.Output[Optional['outputs.DeploymentConfigTrafficRoutingConfig']]:
        """
        The configuration that specifies how the deployment traffic is routed.
        """
        return pulumi.get(self, "traffic_routing_config")

    @property
    @pulumi.getter(name="zonalConfig")
    def zonal_config(self) -> pulumi.Output[Optional['outputs.DeploymentConfigZonalConfig']]:
        """
        The zonal deployment config that specifies how the zonal deployment behaves
        """
        return pulumi.get(self, "zonal_config")

