# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetPackageGroupResult',
    'AwaitableGetPackageGroupResult',
    'get_package_group',
    'get_package_group_output',
]

@pulumi.output_type
class GetPackageGroupResult:
    def __init__(__self__, arn=None, contact_info=None, description=None, domain_owner=None, origin_configuration=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if contact_info and not isinstance(contact_info, str):
            raise TypeError("Expected argument 'contact_info' to be a str")
        pulumi.set(__self__, "contact_info", contact_info)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain_owner and not isinstance(domain_owner, str):
            raise TypeError("Expected argument 'domain_owner' to be a str")
        pulumi.set(__self__, "domain_owner", domain_owner)
        if origin_configuration and not isinstance(origin_configuration, dict):
            raise TypeError("Expected argument 'origin_configuration' to be a dict")
        pulumi.set(__self__, "origin_configuration", origin_configuration)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The ARN of the package group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="contactInfo")
    def contact_info(self) -> Optional[str]:
        """
        The contact info of the package group.
        """
        return pulumi.get(self, "contact_info")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The text description of the package group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainOwner")
    def domain_owner(self) -> Optional[str]:
        """
        The 12-digit account ID of the AWS account that owns the domain.
        """
        return pulumi.get(self, "domain_owner")

    @property
    @pulumi.getter(name="originConfiguration")
    def origin_configuration(self) -> Optional['outputs.PackageGroupOriginConfiguration']:
        """
        The package origin configuration of the package group.
        """
        return pulumi.get(self, "origin_configuration")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to the package group.
        """
        return pulumi.get(self, "tags")


class AwaitableGetPackageGroupResult(GetPackageGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPackageGroupResult(
            arn=self.arn,
            contact_info=self.contact_info,
            description=self.description,
            domain_owner=self.domain_owner,
            origin_configuration=self.origin_configuration,
            tags=self.tags)


def get_package_group(arn: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPackageGroupResult:
    """
    The resource schema to create a CodeArtifact package group.


    :param str arn: The ARN of the package group.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:codeartifact:getPackageGroup', __args__, opts=opts, typ=GetPackageGroupResult).value

    return AwaitableGetPackageGroupResult(
        arn=pulumi.get(__ret__, 'arn'),
        contact_info=pulumi.get(__ret__, 'contact_info'),
        description=pulumi.get(__ret__, 'description'),
        domain_owner=pulumi.get(__ret__, 'domain_owner'),
        origin_configuration=pulumi.get(__ret__, 'origin_configuration'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_package_group)
def get_package_group_output(arn: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPackageGroupResult]:
    """
    The resource schema to create a CodeArtifact package group.


    :param str arn: The ARN of the package group.
    """
    ...
