# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'PackageGroupOriginConfigurationArgs',
    'PackageGroupRestrictionTypeArgs',
    'PackageGroupRestrictionsArgs',
]

@pulumi.input_type
class PackageGroupOriginConfigurationArgs:
    def __init__(__self__, *,
                 restrictions: pulumi.Input['PackageGroupRestrictionsArgs']):
        """
        :param pulumi.Input['PackageGroupRestrictionsArgs'] restrictions: The origin configuration that is applied to the package group.
        """
        pulumi.set(__self__, "restrictions", restrictions)

    @property
    @pulumi.getter
    def restrictions(self) -> pulumi.Input['PackageGroupRestrictionsArgs']:
        """
        The origin configuration that is applied to the package group.
        """
        return pulumi.get(self, "restrictions")

    @restrictions.setter
    def restrictions(self, value: pulumi.Input['PackageGroupRestrictionsArgs']):
        pulumi.set(self, "restrictions", value)


@pulumi.input_type
class PackageGroupRestrictionTypeArgs:
    def __init__(__self__, *,
                 restriction_mode: pulumi.Input['PackageGroupRestrictionTypeRestrictionMode'],
                 repositories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        pulumi.set(__self__, "restriction_mode", restriction_mode)
        if repositories is not None:
            pulumi.set(__self__, "repositories", repositories)

    @property
    @pulumi.getter(name="restrictionMode")
    def restriction_mode(self) -> pulumi.Input['PackageGroupRestrictionTypeRestrictionMode']:
        return pulumi.get(self, "restriction_mode")

    @restriction_mode.setter
    def restriction_mode(self, value: pulumi.Input['PackageGroupRestrictionTypeRestrictionMode']):
        pulumi.set(self, "restriction_mode", value)

    @property
    @pulumi.getter
    def repositories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "repositories")

    @repositories.setter
    def repositories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "repositories", value)


@pulumi.input_type
class PackageGroupRestrictionsArgs:
    def __init__(__self__, *,
                 external_upstream: Optional[pulumi.Input['PackageGroupRestrictionTypeArgs']] = None,
                 internal_upstream: Optional[pulumi.Input['PackageGroupRestrictionTypeArgs']] = None,
                 publish: Optional[pulumi.Input['PackageGroupRestrictionTypeArgs']] = None):
        """
        :param pulumi.Input['PackageGroupRestrictionTypeArgs'] external_upstream: The external upstream restriction determines if new package versions can be ingested or retained from external connections.
        :param pulumi.Input['PackageGroupRestrictionTypeArgs'] internal_upstream: The internal upstream restriction determines if new package versions can be ingested or retained from upstream repositories.
        :param pulumi.Input['PackageGroupRestrictionTypeArgs'] publish: The publish restriction determines if new package versions can be published.
        """
        if external_upstream is not None:
            pulumi.set(__self__, "external_upstream", external_upstream)
        if internal_upstream is not None:
            pulumi.set(__self__, "internal_upstream", internal_upstream)
        if publish is not None:
            pulumi.set(__self__, "publish", publish)

    @property
    @pulumi.getter(name="externalUpstream")
    def external_upstream(self) -> Optional[pulumi.Input['PackageGroupRestrictionTypeArgs']]:
        """
        The external upstream restriction determines if new package versions can be ingested or retained from external connections.
        """
        return pulumi.get(self, "external_upstream")

    @external_upstream.setter
    def external_upstream(self, value: Optional[pulumi.Input['PackageGroupRestrictionTypeArgs']]):
        pulumi.set(self, "external_upstream", value)

    @property
    @pulumi.getter(name="internalUpstream")
    def internal_upstream(self) -> Optional[pulumi.Input['PackageGroupRestrictionTypeArgs']]:
        """
        The internal upstream restriction determines if new package versions can be ingested or retained from upstream repositories.
        """
        return pulumi.get(self, "internal_upstream")

    @internal_upstream.setter
    def internal_upstream(self, value: Optional[pulumi.Input['PackageGroupRestrictionTypeArgs']]):
        pulumi.set(self, "internal_upstream", value)

    @property
    @pulumi.getter
    def publish(self) -> Optional[pulumi.Input['PackageGroupRestrictionTypeArgs']]:
        """
        The publish restriction determines if new package versions can be published.
        """
        return pulumi.get(self, "publish")

    @publish.setter
    def publish(self, value: Optional[pulumi.Input['PackageGroupRestrictionTypeArgs']]):
        pulumi.set(self, "publish", value)


