# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CachePolicyConfig',
    'CachePolicyCookiesConfig',
    'CachePolicyHeadersConfig',
    'CachePolicyParametersInCacheKeyAndForwardedToOrigin',
    'CachePolicyQueryStringsConfig',
    'CloudFrontOriginAccessIdentityConfig',
    'ContinuousDeploymentPolicyConfig',
    'ContinuousDeploymentPolicyConfigSingleHeaderPolicyConfigProperties',
    'ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigProperties',
    'ContinuousDeploymentPolicySessionStickinessConfig',
    'ContinuousDeploymentPolicySingleHeaderConfig',
    'ContinuousDeploymentPolicySingleWeightConfig',
    'ContinuousDeploymentPolicyTrafficConfig',
    'DistributionCacheBehavior',
    'DistributionConfig',
    'DistributionCookies',
    'DistributionCustomErrorResponse',
    'DistributionCustomOriginConfig',
    'DistributionDefaultCacheBehavior',
    'DistributionForwardedValues',
    'DistributionFunctionAssociation',
    'DistributionGeoRestriction',
    'DistributionLambdaFunctionAssociation',
    'DistributionLegacyCustomOrigin',
    'DistributionLegacyS3Origin',
    'DistributionLogging',
    'DistributionOrigin',
    'DistributionOriginCustomHeader',
    'DistributionOriginGroup',
    'DistributionOriginGroupFailoverCriteria',
    'DistributionOriginGroupMember',
    'DistributionOriginGroupMembers',
    'DistributionOriginGroups',
    'DistributionOriginShield',
    'DistributionRestrictions',
    'DistributionS3OriginConfig',
    'DistributionStatusCodes',
    'DistributionViewerCertificate',
    'FunctionConfig',
    'FunctionKeyValueStoreAssociation',
    'FunctionMetadata',
    'KeyGroupConfig',
    'KeyValueStoreImportSource',
    'MonitoringSubscription',
    'MonitoringSubscriptionRealtimeMetricsSubscriptionConfig',
    'OriginAccessControlConfig',
    'OriginRequestPolicyConfig',
    'OriginRequestPolicyCookiesConfig',
    'OriginRequestPolicyHeadersConfig',
    'OriginRequestPolicyQueryStringsConfig',
    'PublicKeyConfig',
    'RealtimeLogConfigEndPoint',
    'RealtimeLogConfigKinesisStreamConfig',
    'ResponseHeadersPolicyAccessControlAllowHeaders',
    'ResponseHeadersPolicyAccessControlAllowMethods',
    'ResponseHeadersPolicyAccessControlAllowOrigins',
    'ResponseHeadersPolicyAccessControlExposeHeaders',
    'ResponseHeadersPolicyConfig',
    'ResponseHeadersPolicyContentSecurityPolicy',
    'ResponseHeadersPolicyContentTypeOptions',
    'ResponseHeadersPolicyCorsConfig',
    'ResponseHeadersPolicyCustomHeader',
    'ResponseHeadersPolicyCustomHeadersConfig',
    'ResponseHeadersPolicyFrameOptions',
    'ResponseHeadersPolicyReferrerPolicy',
    'ResponseHeadersPolicyRemoveHeader',
    'ResponseHeadersPolicyRemoveHeadersConfig',
    'ResponseHeadersPolicySecurityHeadersConfig',
    'ResponseHeadersPolicyServerTimingHeadersConfig',
    'ResponseHeadersPolicyStrictTransportSecurity',
    'ResponseHeadersPolicyXssProtection',
]

@pulumi.output_type
class CachePolicyConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultTtl":
            suggest = "default_ttl"
        elif key == "maxTtl":
            suggest = "max_ttl"
        elif key == "minTtl":
            suggest = "min_ttl"
        elif key == "parametersInCacheKeyAndForwardedToOrigin":
            suggest = "parameters_in_cache_key_and_forwarded_to_origin"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CachePolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CachePolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CachePolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_ttl: float,
                 max_ttl: float,
                 min_ttl: float,
                 name: str,
                 parameters_in_cache_key_and_forwarded_to_origin: 'outputs.CachePolicyParametersInCacheKeyAndForwardedToOrigin',
                 comment: Optional[str] = None):
        pulumi.set(__self__, "default_ttl", default_ttl)
        pulumi.set(__self__, "max_ttl", max_ttl)
        pulumi.set(__self__, "min_ttl", min_ttl)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameters_in_cache_key_and_forwarded_to_origin", parameters_in_cache_key_and_forwarded_to_origin)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> float:
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> float:
        return pulumi.get(self, "max_ttl")

    @property
    @pulumi.getter(name="minTtl")
    def min_ttl(self) -> float:
        return pulumi.get(self, "min_ttl")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parametersInCacheKeyAndForwardedToOrigin")
    def parameters_in_cache_key_and_forwarded_to_origin(self) -> 'outputs.CachePolicyParametersInCacheKeyAndForwardedToOrigin':
        return pulumi.get(self, "parameters_in_cache_key_and_forwarded_to_origin")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        return pulumi.get(self, "comment")


@pulumi.output_type
class CachePolicyCookiesConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieBehavior":
            suggest = "cookie_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CachePolicyCookiesConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CachePolicyCookiesConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CachePolicyCookiesConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookie_behavior: str,
                 cookies: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "cookie_behavior", cookie_behavior)
        if cookies is not None:
            pulumi.set(__self__, "cookies", cookies)

    @property
    @pulumi.getter(name="cookieBehavior")
    def cookie_behavior(self) -> str:
        return pulumi.get(self, "cookie_behavior")

    @property
    @pulumi.getter
    def cookies(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "cookies")


@pulumi.output_type
class CachePolicyHeadersConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerBehavior":
            suggest = "header_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CachePolicyHeadersConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CachePolicyHeadersConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CachePolicyHeadersConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_behavior: str,
                 headers: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "header_behavior", header_behavior)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)

    @property
    @pulumi.getter(name="headerBehavior")
    def header_behavior(self) -> str:
        return pulumi.get(self, "header_behavior")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "headers")


@pulumi.output_type
class CachePolicyParametersInCacheKeyAndForwardedToOrigin(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookiesConfig":
            suggest = "cookies_config"
        elif key == "enableAcceptEncodingGzip":
            suggest = "enable_accept_encoding_gzip"
        elif key == "headersConfig":
            suggest = "headers_config"
        elif key == "queryStringsConfig":
            suggest = "query_strings_config"
        elif key == "enableAcceptEncodingBrotli":
            suggest = "enable_accept_encoding_brotli"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CachePolicyParametersInCacheKeyAndForwardedToOrigin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CachePolicyParametersInCacheKeyAndForwardedToOrigin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CachePolicyParametersInCacheKeyAndForwardedToOrigin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookies_config: 'outputs.CachePolicyCookiesConfig',
                 enable_accept_encoding_gzip: bool,
                 headers_config: 'outputs.CachePolicyHeadersConfig',
                 query_strings_config: 'outputs.CachePolicyQueryStringsConfig',
                 enable_accept_encoding_brotli: Optional[bool] = None):
        pulumi.set(__self__, "cookies_config", cookies_config)
        pulumi.set(__self__, "enable_accept_encoding_gzip", enable_accept_encoding_gzip)
        pulumi.set(__self__, "headers_config", headers_config)
        pulumi.set(__self__, "query_strings_config", query_strings_config)
        if enable_accept_encoding_brotli is not None:
            pulumi.set(__self__, "enable_accept_encoding_brotli", enable_accept_encoding_brotli)

    @property
    @pulumi.getter(name="cookiesConfig")
    def cookies_config(self) -> 'outputs.CachePolicyCookiesConfig':
        return pulumi.get(self, "cookies_config")

    @property
    @pulumi.getter(name="enableAcceptEncodingGzip")
    def enable_accept_encoding_gzip(self) -> bool:
        return pulumi.get(self, "enable_accept_encoding_gzip")

    @property
    @pulumi.getter(name="headersConfig")
    def headers_config(self) -> 'outputs.CachePolicyHeadersConfig':
        return pulumi.get(self, "headers_config")

    @property
    @pulumi.getter(name="queryStringsConfig")
    def query_strings_config(self) -> 'outputs.CachePolicyQueryStringsConfig':
        return pulumi.get(self, "query_strings_config")

    @property
    @pulumi.getter(name="enableAcceptEncodingBrotli")
    def enable_accept_encoding_brotli(self) -> Optional[bool]:
        return pulumi.get(self, "enable_accept_encoding_brotli")


@pulumi.output_type
class CachePolicyQueryStringsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryStringBehavior":
            suggest = "query_string_behavior"
        elif key == "queryStrings":
            suggest = "query_strings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CachePolicyQueryStringsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CachePolicyQueryStringsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CachePolicyQueryStringsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_string_behavior: str,
                 query_strings: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "query_string_behavior", query_string_behavior)
        if query_strings is not None:
            pulumi.set(__self__, "query_strings", query_strings)

    @property
    @pulumi.getter(name="queryStringBehavior")
    def query_string_behavior(self) -> str:
        return pulumi.get(self, "query_string_behavior")

    @property
    @pulumi.getter(name="queryStrings")
    def query_strings(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "query_strings")


@pulumi.output_type
class CloudFrontOriginAccessIdentityConfig(dict):
    def __init__(__self__, *,
                 comment: str):
        pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")


@pulumi.output_type
class ContinuousDeploymentPolicyConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stagingDistributionDnsNames":
            suggest = "staging_distribution_dns_names"
        elif key == "singleHeaderPolicyConfig":
            suggest = "single_header_policy_config"
        elif key == "singleWeightPolicyConfig":
            suggest = "single_weight_policy_config"
        elif key == "trafficConfig":
            suggest = "traffic_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContinuousDeploymentPolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContinuousDeploymentPolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContinuousDeploymentPolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 staging_distribution_dns_names: Sequence[str],
                 single_header_policy_config: Optional['outputs.ContinuousDeploymentPolicyConfigSingleHeaderPolicyConfigProperties'] = None,
                 single_weight_policy_config: Optional['outputs.ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigProperties'] = None,
                 traffic_config: Optional['outputs.ContinuousDeploymentPolicyTrafficConfig'] = None,
                 type: Optional['ContinuousDeploymentPolicyConfigType'] = None):
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "staging_distribution_dns_names", staging_distribution_dns_names)
        if single_header_policy_config is not None:
            pulumi.set(__self__, "single_header_policy_config", single_header_policy_config)
        if single_weight_policy_config is not None:
            pulumi.set(__self__, "single_weight_policy_config", single_weight_policy_config)
        if traffic_config is not None:
            pulumi.set(__self__, "traffic_config", traffic_config)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="stagingDistributionDnsNames")
    def staging_distribution_dns_names(self) -> Sequence[str]:
        return pulumi.get(self, "staging_distribution_dns_names")

    @property
    @pulumi.getter(name="singleHeaderPolicyConfig")
    def single_header_policy_config(self) -> Optional['outputs.ContinuousDeploymentPolicyConfigSingleHeaderPolicyConfigProperties']:
        return pulumi.get(self, "single_header_policy_config")

    @property
    @pulumi.getter(name="singleWeightPolicyConfig")
    def single_weight_policy_config(self) -> Optional['outputs.ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigProperties']:
        return pulumi.get(self, "single_weight_policy_config")

    @property
    @pulumi.getter(name="trafficConfig")
    def traffic_config(self) -> Optional['outputs.ContinuousDeploymentPolicyTrafficConfig']:
        return pulumi.get(self, "traffic_config")

    @property
    @pulumi.getter
    def type(self) -> Optional['ContinuousDeploymentPolicyConfigType']:
        return pulumi.get(self, "type")


@pulumi.output_type
class ContinuousDeploymentPolicyConfigSingleHeaderPolicyConfigProperties(dict):
    def __init__(__self__, *,
                 header: str,
                 value: str):
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def header(self) -> str:
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sessionStickinessConfig":
            suggest = "session_stickiness_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContinuousDeploymentPolicyConfigSingleWeightPolicyConfigProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 weight: float,
                 session_stickiness_config: Optional['outputs.ContinuousDeploymentPolicySessionStickinessConfig'] = None):
        pulumi.set(__self__, "weight", weight)
        if session_stickiness_config is not None:
            pulumi.set(__self__, "session_stickiness_config", session_stickiness_config)

    @property
    @pulumi.getter
    def weight(self) -> float:
        return pulumi.get(self, "weight")

    @property
    @pulumi.getter(name="sessionStickinessConfig")
    def session_stickiness_config(self) -> Optional['outputs.ContinuousDeploymentPolicySessionStickinessConfig']:
        return pulumi.get(self, "session_stickiness_config")


@pulumi.output_type
class ContinuousDeploymentPolicySessionStickinessConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idleTtl":
            suggest = "idle_ttl"
        elif key == "maximumTtl":
            suggest = "maximum_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContinuousDeploymentPolicySessionStickinessConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContinuousDeploymentPolicySessionStickinessConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContinuousDeploymentPolicySessionStickinessConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idle_ttl: int,
                 maximum_ttl: int):
        pulumi.set(__self__, "idle_ttl", idle_ttl)
        pulumi.set(__self__, "maximum_ttl", maximum_ttl)

    @property
    @pulumi.getter(name="idleTtl")
    def idle_ttl(self) -> int:
        return pulumi.get(self, "idle_ttl")

    @property
    @pulumi.getter(name="maximumTtl")
    def maximum_ttl(self) -> int:
        return pulumi.get(self, "maximum_ttl")


@pulumi.output_type
class ContinuousDeploymentPolicySingleHeaderConfig(dict):
    def __init__(__self__, *,
                 header: str,
                 value: str):
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def header(self) -> str:
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class ContinuousDeploymentPolicySingleWeightConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sessionStickinessConfig":
            suggest = "session_stickiness_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContinuousDeploymentPolicySingleWeightConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContinuousDeploymentPolicySingleWeightConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContinuousDeploymentPolicySingleWeightConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 weight: float,
                 session_stickiness_config: Optional['outputs.ContinuousDeploymentPolicySessionStickinessConfig'] = None):
        pulumi.set(__self__, "weight", weight)
        if session_stickiness_config is not None:
            pulumi.set(__self__, "session_stickiness_config", session_stickiness_config)

    @property
    @pulumi.getter
    def weight(self) -> float:
        return pulumi.get(self, "weight")

    @property
    @pulumi.getter(name="sessionStickinessConfig")
    def session_stickiness_config(self) -> Optional['outputs.ContinuousDeploymentPolicySessionStickinessConfig']:
        return pulumi.get(self, "session_stickiness_config")


@pulumi.output_type
class ContinuousDeploymentPolicyTrafficConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "singleHeaderConfig":
            suggest = "single_header_config"
        elif key == "singleWeightConfig":
            suggest = "single_weight_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContinuousDeploymentPolicyTrafficConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContinuousDeploymentPolicyTrafficConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContinuousDeploymentPolicyTrafficConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: 'ContinuousDeploymentPolicyTrafficConfigType',
                 single_header_config: Optional['outputs.ContinuousDeploymentPolicySingleHeaderConfig'] = None,
                 single_weight_config: Optional['outputs.ContinuousDeploymentPolicySingleWeightConfig'] = None):
        pulumi.set(__self__, "type", type)
        if single_header_config is not None:
            pulumi.set(__self__, "single_header_config", single_header_config)
        if single_weight_config is not None:
            pulumi.set(__self__, "single_weight_config", single_weight_config)

    @property
    @pulumi.getter
    def type(self) -> 'ContinuousDeploymentPolicyTrafficConfigType':
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="singleHeaderConfig")
    def single_header_config(self) -> Optional['outputs.ContinuousDeploymentPolicySingleHeaderConfig']:
        return pulumi.get(self, "single_header_config")

    @property
    @pulumi.getter(name="singleWeightConfig")
    def single_weight_config(self) -> Optional['outputs.ContinuousDeploymentPolicySingleWeightConfig']:
        return pulumi.get(self, "single_weight_config")


@pulumi.output_type
class DistributionCacheBehavior(dict):
    """
    A complex type that describes how CloudFront processes requests.
     You must create at least as many cache behaviors (including the default cache behavior) as you have origins if you want CloudFront to serve objects from all of the origins. Each cache behavior specifies the one origin from which you want CloudFront to get objects. If you have two origins and only the default cache behavior, the default cache behavior will cause CloudFront to get objects from one of the origins, but the other origin is never used.
     For the current quota (formerly known as limit) on the number of cache behaviors that you can add to a distribution, see [Quotas](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html) in the *Amazon CloudFront Developer Guide*.
     If you don't want to specify any cache behaviors, include only an empty ``CacheBehaviors`` element. Don't include an empty ``CacheBehavior`` element because this is invalid.
     To delete all cache behaviors in an existing distribution, update the distribution configuration and include only an empty ``CacheBehaviors`` element.
     To add, change, or remove one or more cache behaviors, update the distribution configuration and specify all of the cache behaviors that you want to include in the updated distribution.
     For more information about cache behaviors, see [Cache Behavior Settings](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesCacheBehavior) in the *Amazon CloudFront Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pathPattern":
            suggest = "path_pattern"
        elif key == "targetOriginId":
            suggest = "target_origin_id"
        elif key == "viewerProtocolPolicy":
            suggest = "viewer_protocol_policy"
        elif key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "cachePolicyId":
            suggest = "cache_policy_id"
        elif key == "cachedMethods":
            suggest = "cached_methods"
        elif key == "defaultTtl":
            suggest = "default_ttl"
        elif key == "fieldLevelEncryptionId":
            suggest = "field_level_encryption_id"
        elif key == "forwardedValues":
            suggest = "forwarded_values"
        elif key == "functionAssociations":
            suggest = "function_associations"
        elif key == "lambdaFunctionAssociations":
            suggest = "lambda_function_associations"
        elif key == "maxTtl":
            suggest = "max_ttl"
        elif key == "minTtl":
            suggest = "min_ttl"
        elif key == "originRequestPolicyId":
            suggest = "origin_request_policy_id"
        elif key == "realtimeLogConfigArn":
            suggest = "realtime_log_config_arn"
        elif key == "responseHeadersPolicyId":
            suggest = "response_headers_policy_id"
        elif key == "smoothStreaming":
            suggest = "smooth_streaming"
        elif key == "trustedKeyGroups":
            suggest = "trusted_key_groups"
        elif key == "trustedSigners":
            suggest = "trusted_signers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCacheBehavior. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCacheBehavior.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCacheBehavior.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path_pattern: str,
                 target_origin_id: str,
                 viewer_protocol_policy: str,
                 allowed_methods: Optional[Sequence[str]] = None,
                 cache_policy_id: Optional[str] = None,
                 cached_methods: Optional[Sequence[str]] = None,
                 compress: Optional[bool] = None,
                 default_ttl: Optional[float] = None,
                 field_level_encryption_id: Optional[str] = None,
                 forwarded_values: Optional['outputs.DistributionForwardedValues'] = None,
                 function_associations: Optional[Sequence['outputs.DistributionFunctionAssociation']] = None,
                 lambda_function_associations: Optional[Sequence['outputs.DistributionLambdaFunctionAssociation']] = None,
                 max_ttl: Optional[float] = None,
                 min_ttl: Optional[float] = None,
                 origin_request_policy_id: Optional[str] = None,
                 realtime_log_config_arn: Optional[str] = None,
                 response_headers_policy_id: Optional[str] = None,
                 smooth_streaming: Optional[bool] = None,
                 trusted_key_groups: Optional[Sequence[str]] = None,
                 trusted_signers: Optional[Sequence[str]] = None):
        """
        A complex type that describes how CloudFront processes requests.
         You must create at least as many cache behaviors (including the default cache behavior) as you have origins if you want CloudFront to serve objects from all of the origins. Each cache behavior specifies the one origin from which you want CloudFront to get objects. If you have two origins and only the default cache behavior, the default cache behavior will cause CloudFront to get objects from one of the origins, but the other origin is never used.
         For the current quota (formerly known as limit) on the number of cache behaviors that you can add to a distribution, see [Quotas](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html) in the *Amazon CloudFront Developer Guide*.
         If you don't want to specify any cache behaviors, include only an empty ``CacheBehaviors`` element. Don't include an empty ``CacheBehavior`` element because this is invalid.
         To delete all cache behaviors in an existing distribution, update the distribution configuration and include only an empty ``CacheBehaviors`` element.
         To add, change, or remove one or more cache behaviors, update the distribution configuration and specify all of the cache behaviors that you want to include in the updated distribution.
         For more information about cache behaviors, see [Cache Behavior Settings](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesCacheBehavior) in the *Amazon CloudFront Developer Guide*.
        :param str path_pattern: The pattern (for example, ``images/*.jpg``) that specifies which requests to apply the behavior to. When CloudFront receives a viewer request, the requested path is compared with path patterns in the order in which cache behaviors are listed in the distribution.
                 You can optionally include a slash (``/``) at the beginning of the path pattern. For example, ``/images/*.jpg``. CloudFront behavior is the same with or without the leading ``/``.
                 The path pattern for the default cache behavior is ``*`` and cannot be changed. If the request for an object does not match the path pattern for any cache behaviors, CloudFront applies the behavior in the default cache behavior.
                For more information, see [Path Pattern](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesPathPattern) in the *Amazon CloudFront Developer Guide*.
        :param str target_origin_id: The value of ``ID`` for the origin that you want CloudFront to route requests to when they match this cache behavior.
        :param str viewer_protocol_policy: The protocol that viewers can use to access the files in the origin specified by ``TargetOriginId`` when a request matches the path pattern in ``PathPattern``. You can specify the following options:
                 +   ``allow-all``: Viewers can use HTTP or HTTPS.
                 +   ``redirect-to-https``: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the new URL.
                 +   ``https-only``: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403 (Forbidden).
                 
                For more information about requiring the HTTPS protocol, see [Requiring HTTPS Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html) in the *Amazon CloudFront Developer Guide*.
                 The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will return an object from the cache regardless of whether the current request protocol matches the protocol used previously. For more information, see [Managing Cache Expiration](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        :param Sequence[str] allowed_methods: A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin. There are three choices:
                 +  CloudFront forwards only ``GET`` and ``HEAD`` requests.
                 +  CloudFront forwards only ``GET``, ``HEAD``, and ``OPTIONS`` requests.
                 +  CloudFront forwards ``GET, HEAD, OPTIONS, PUT, PATCH, POST``, and ``DELETE`` requests.
                 
                If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so users can't perform operations that you don't want them to. For example, you might not want users to have permissions to delete objects from your origin.
        :param str cache_policy_id: The unique identifier of the cache policy that is attached to this cache behavior. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                A ``CacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
        :param Sequence[str] cached_methods: A complex type that controls whether CloudFront caches the response to requests using the specified HTTP methods. There are two choices:
                 +  CloudFront caches responses to ``GET`` and ``HEAD`` requests.
                 +  CloudFront caches responses to ``GET``, ``HEAD``, and ``OPTIONS`` requests.
                 
                If you pick the second choice for your Amazon S3 Origin, you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the responses to be cached correctly.
        :param bool compress: Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify true; if not, specify false. For more information, see [Serving Compressed Files](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html) in the *Amazon CloudFront Developer Guide*.
        :param float default_ttl: This field is deprecated. We recommend that you use the ``DefaultTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin does not add HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        :param str field_level_encryption_id: The value of ``ID`` for the field-level encryption configuration that you want CloudFront to use for encrypting specific fields of data for this cache behavior.
        :param 'DistributionForwardedValues' forwarded_values: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see [Working with policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html) in the *Amazon CloudFront Developer Guide*.
                If you want to include values in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
                A ``CacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
                A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
        :param Sequence['DistributionFunctionAssociation'] function_associations: A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must be published to the ``LIVE`` stage to associate them with a cache behavior.
        :param Sequence['DistributionLambdaFunctionAssociation'] lambda_function_associations: A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.
        :param float max_ttl: This field is deprecated. We recommend that you use the ``MaxTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin adds HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        :param float min_ttl: This field is deprecated. We recommend that you use the ``MinTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
                You must specify ``0`` for ``MinTTL`` if you configure CloudFront to forward all headers to your origin (under ``Headers``, if you specify ``1`` for ``Quantity`` and ``*`` for ``Name``).
        :param str origin_request_policy_id: The unique identifier of the origin request policy that is attached to this cache behavior. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
        :param str realtime_log_config_arn: The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior. For more information, see [Real-time logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html) in the *Amazon CloudFront Developer Guide*.
        :param str response_headers_policy_id: The identifier for a response headers policy.
        :param bool smooth_streaming: Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior. If so, specify ``true``; if not, specify ``false``. If you specify ``true`` for ``SmoothStreaming``, you can still distribute other content using this cache behavior if the content matches the value of ``PathPattern``.
        :param Sequence[str] trusted_key_groups: A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
                When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        :param Sequence[str] trusted_signers: We recommend using ``TrustedKeyGroups`` instead of ``TrustedSigners``.
                 A list of AWS-account IDs whose public keys CloudFront can use to validate signed URLs or signed cookies.
                When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront key pair in the trusted signer's AWS-account. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        pulumi.set(__self__, "path_pattern", path_pattern)
        pulumi.set(__self__, "target_origin_id", target_origin_id)
        pulumi.set(__self__, "viewer_protocol_policy", viewer_protocol_policy)
        if allowed_methods is not None:
            pulumi.set(__self__, "allowed_methods", allowed_methods)
        if cache_policy_id is not None:
            pulumi.set(__self__, "cache_policy_id", cache_policy_id)
        if cached_methods is not None:
            pulumi.set(__self__, "cached_methods", cached_methods)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if field_level_encryption_id is not None:
            pulumi.set(__self__, "field_level_encryption_id", field_level_encryption_id)
        if forwarded_values is not None:
            pulumi.set(__self__, "forwarded_values", forwarded_values)
        if function_associations is not None:
            pulumi.set(__self__, "function_associations", function_associations)
        if lambda_function_associations is not None:
            pulumi.set(__self__, "lambda_function_associations", lambda_function_associations)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if min_ttl is not None:
            pulumi.set(__self__, "min_ttl", min_ttl)
        if origin_request_policy_id is not None:
            pulumi.set(__self__, "origin_request_policy_id", origin_request_policy_id)
        if realtime_log_config_arn is not None:
            pulumi.set(__self__, "realtime_log_config_arn", realtime_log_config_arn)
        if response_headers_policy_id is not None:
            pulumi.set(__self__, "response_headers_policy_id", response_headers_policy_id)
        if smooth_streaming is not None:
            pulumi.set(__self__, "smooth_streaming", smooth_streaming)
        if trusted_key_groups is not None:
            pulumi.set(__self__, "trusted_key_groups", trusted_key_groups)
        if trusted_signers is not None:
            pulumi.set(__self__, "trusted_signers", trusted_signers)

    @property
    @pulumi.getter(name="pathPattern")
    def path_pattern(self) -> str:
        """
        The pattern (for example, ``images/*.jpg``) that specifies which requests to apply the behavior to. When CloudFront receives a viewer request, the requested path is compared with path patterns in the order in which cache behaviors are listed in the distribution.
          You can optionally include a slash (``/``) at the beginning of the path pattern. For example, ``/images/*.jpg``. CloudFront behavior is the same with or without the leading ``/``.
          The path pattern for the default cache behavior is ``*`` and cannot be changed. If the request for an object does not match the path pattern for any cache behaviors, CloudFront applies the behavior in the default cache behavior.
         For more information, see [Path Pattern](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesPathPattern) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "path_pattern")

    @property
    @pulumi.getter(name="targetOriginId")
    def target_origin_id(self) -> str:
        """
        The value of ``ID`` for the origin that you want CloudFront to route requests to when they match this cache behavior.
        """
        return pulumi.get(self, "target_origin_id")

    @property
    @pulumi.getter(name="viewerProtocolPolicy")
    def viewer_protocol_policy(self) -> str:
        """
        The protocol that viewers can use to access the files in the origin specified by ``TargetOriginId`` when a request matches the path pattern in ``PathPattern``. You can specify the following options:
          +   ``allow-all``: Viewers can use HTTP or HTTPS.
          +   ``redirect-to-https``: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the new URL.
          +   ``https-only``: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403 (Forbidden).
          
         For more information about requiring the HTTPS protocol, see [Requiring HTTPS Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html) in the *Amazon CloudFront Developer Guide*.
          The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will return an object from the cache regardless of whether the current request protocol matches the protocol used previously. For more information, see [Managing Cache Expiration](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "viewer_protocol_policy")

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Optional[Sequence[str]]:
        """
        A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin. There are three choices:
          +  CloudFront forwards only ``GET`` and ``HEAD`` requests.
          +  CloudFront forwards only ``GET``, ``HEAD``, and ``OPTIONS`` requests.
          +  CloudFront forwards ``GET, HEAD, OPTIONS, PUT, PATCH, POST``, and ``DELETE`` requests.
          
         If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so users can't perform operations that you don't want them to. For example, you might not want users to have permissions to delete objects from your origin.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="cachePolicyId")
    def cache_policy_id(self) -> Optional[str]:
        """
        The unique identifier of the cache policy that is attached to this cache behavior. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         A ``CacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
        """
        return pulumi.get(self, "cache_policy_id")

    @property
    @pulumi.getter(name="cachedMethods")
    def cached_methods(self) -> Optional[Sequence[str]]:
        """
        A complex type that controls whether CloudFront caches the response to requests using the specified HTTP methods. There are two choices:
          +  CloudFront caches responses to ``GET`` and ``HEAD`` requests.
          +  CloudFront caches responses to ``GET``, ``HEAD``, and ``OPTIONS`` requests.
          
         If you pick the second choice for your Amazon S3 Origin, you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the responses to be cached correctly.
        """
        return pulumi.get(self, "cached_methods")

    @property
    @pulumi.getter
    def compress(self) -> Optional[bool]:
        """
        Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify true; if not, specify false. For more information, see [Serving Compressed Files](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "compress")

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[float]:
        """
        This field is deprecated. We recommend that you use the ``DefaultTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin does not add HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter(name="fieldLevelEncryptionId")
    def field_level_encryption_id(self) -> Optional[str]:
        """
        The value of ``ID`` for the field-level encryption configuration that you want CloudFront to use for encrypting specific fields of data for this cache behavior.
        """
        return pulumi.get(self, "field_level_encryption_id")

    @property
    @pulumi.getter(name="forwardedValues")
    def forwarded_values(self) -> Optional['outputs.DistributionForwardedValues']:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see [Working with policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html) in the *Amazon CloudFront Developer Guide*.
         If you want to include values in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
         A ``CacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
         A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
        """
        return pulumi.get(self, "forwarded_values")

    @property
    @pulumi.getter(name="functionAssociations")
    def function_associations(self) -> Optional[Sequence['outputs.DistributionFunctionAssociation']]:
        """
        A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must be published to the ``LIVE`` stage to associate them with a cache behavior.
        """
        return pulumi.get(self, "function_associations")

    @property
    @pulumi.getter(name="lambdaFunctionAssociations")
    def lambda_function_associations(self) -> Optional[Sequence['outputs.DistributionLambdaFunctionAssociation']]:
        """
        A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.
        """
        return pulumi.get(self, "lambda_function_associations")

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[float]:
        """
        This field is deprecated. We recommend that you use the ``MaxTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin adds HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "max_ttl")

    @property
    @pulumi.getter(name="minTtl")
    def min_ttl(self) -> Optional[float]:
        """
        This field is deprecated. We recommend that you use the ``MinTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
         You must specify ``0`` for ``MinTTL`` if you configure CloudFront to forward all headers to your origin (under ``Headers``, if you specify ``1`` for ``Quantity`` and ``*`` for ``Name``).
        """
        return pulumi.get(self, "min_ttl")

    @property
    @pulumi.getter(name="originRequestPolicyId")
    def origin_request_policy_id(self) -> Optional[str]:
        """
        The unique identifier of the origin request policy that is attached to this cache behavior. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_request_policy_id")

    @property
    @pulumi.getter(name="realtimeLogConfigArn")
    def realtime_log_config_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior. For more information, see [Real-time logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "realtime_log_config_arn")

    @property
    @pulumi.getter(name="responseHeadersPolicyId")
    def response_headers_policy_id(self) -> Optional[str]:
        """
        The identifier for a response headers policy.
        """
        return pulumi.get(self, "response_headers_policy_id")

    @property
    @pulumi.getter(name="smoothStreaming")
    def smooth_streaming(self) -> Optional[bool]:
        """
        Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior. If so, specify ``true``; if not, specify ``false``. If you specify ``true`` for ``SmoothStreaming``, you can still distribute other content using this cache behavior if the content matches the value of ``PathPattern``.
        """
        return pulumi.get(self, "smooth_streaming")

    @property
    @pulumi.getter(name="trustedKeyGroups")
    def trusted_key_groups(self) -> Optional[Sequence[str]]:
        """
        A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
         When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "trusted_key_groups")

    @property
    @pulumi.getter(name="trustedSigners")
    def trusted_signers(self) -> Optional[Sequence[str]]:
        """
        We recommend using ``TrustedKeyGroups`` instead of ``TrustedSigners``.
          A list of AWS-account IDs whose public keys CloudFront can use to validate signed URLs or signed cookies.
         When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront key pair in the trusted signer's AWS-account. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "trusted_signers")


@pulumi.output_type
class DistributionConfig(dict):
    """
    A distribution configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultCacheBehavior":
            suggest = "default_cache_behavior"
        elif key == "cacheBehaviors":
            suggest = "cache_behaviors"
        elif key == "continuousDeploymentPolicyId":
            suggest = "continuous_deployment_policy_id"
        elif key == "customErrorResponses":
            suggest = "custom_error_responses"
        elif key == "customOrigin":
            suggest = "custom_origin"
        elif key == "defaultRootObject":
            suggest = "default_root_object"
        elif key == "httpVersion":
            suggest = "http_version"
        elif key == "ipv6Enabled":
            suggest = "ipv6_enabled"
        elif key == "originGroups":
            suggest = "origin_groups"
        elif key == "priceClass":
            suggest = "price_class"
        elif key == "s3Origin":
            suggest = "s3_origin"
        elif key == "viewerCertificate":
            suggest = "viewer_certificate"
        elif key == "webAclId":
            suggest = "web_acl_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_cache_behavior: 'outputs.DistributionDefaultCacheBehavior',
                 enabled: bool,
                 aliases: Optional[Sequence[str]] = None,
                 cache_behaviors: Optional[Sequence['outputs.DistributionCacheBehavior']] = None,
                 cnames: Optional[Sequence[str]] = None,
                 comment: Optional[str] = None,
                 continuous_deployment_policy_id: Optional[str] = None,
                 custom_error_responses: Optional[Sequence['outputs.DistributionCustomErrorResponse']] = None,
                 custom_origin: Optional['outputs.DistributionLegacyCustomOrigin'] = None,
                 default_root_object: Optional[str] = None,
                 http_version: Optional[str] = None,
                 ipv6_enabled: Optional[bool] = None,
                 logging: Optional['outputs.DistributionLogging'] = None,
                 origin_groups: Optional['outputs.DistributionOriginGroups'] = None,
                 origins: Optional[Sequence['outputs.DistributionOrigin']] = None,
                 price_class: Optional[str] = None,
                 restrictions: Optional['outputs.DistributionRestrictions'] = None,
                 s3_origin: Optional['outputs.DistributionLegacyS3Origin'] = None,
                 staging: Optional[bool] = None,
                 viewer_certificate: Optional['outputs.DistributionViewerCertificate'] = None,
                 web_acl_id: Optional[str] = None):
        """
        A distribution configuration.
        :param 'DistributionDefaultCacheBehavior' default_cache_behavior: A complex type that describes the default cache behavior if you don't specify a ``CacheBehavior`` element or if files don't match any of the values of ``PathPattern`` in ``CacheBehavior`` elements. You must create exactly one default cache behavior.
        :param bool enabled: From this field, you can enable or disable the selected distribution.
        :param Sequence[str] aliases: A complex type that contains information about CNAMEs (alternate domain names), if any, for this distribution.
        :param Sequence['DistributionCacheBehavior'] cache_behaviors: A complex type that contains zero or more ``CacheBehavior`` elements.
        :param str comment: A comment to describe the distribution. The comment cannot be longer than 128 characters.
        :param str continuous_deployment_policy_id: The identifier of a continuous deployment policy. For more information, see ``CreateContinuousDeploymentPolicy``.
        :param Sequence['DistributionCustomErrorResponse'] custom_error_responses: A complex type that controls the following:
                 +  Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer.
                 +  How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
                 
                For more information about custom error pages, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
        :param str default_root_object: The object that you want CloudFront to request from your origin (for example, ``index.html``) when a viewer requests the root URL for your distribution (``https://www.example.com``) instead of an object in your distribution (``https://www.example.com/product-description.html``). Specifying a default root object avoids exposing the contents of your distribution.
                Specify only the object name, for example, ``index.html``. Don't add a ``/`` before the object name.
                If you don't want to specify a default root object when you create a distribution, include an empty ``DefaultRootObject`` element.
                To delete the default root object from an existing distribution, update the distribution configuration and include an empty ``DefaultRootObject`` element.
                To replace the default root object, update the distribution configuration and specify the new object.
                For more information about the default root object, see [Creating a Default Root Object](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html) in the *Amazon CloudFront Developer Guide*.
        :param str http_version: (Optional) Specify the maximum HTTP version(s) that you want viewers to use to communicate with CF. The default value for new distributions is ``http1.1``.
                For viewers and CF to use HTTP/2, viewers must support TLSv1.2 or later, and must support Server Name Indication (SNI).
                For viewers and CF to use HTTP/3, viewers must support TLSv1.3 and Server Name Indication (SNI). CF supports HTTP/3 connection migration to allow the viewer to switch networks without losing connection. For more information about connection migration, see [Connection Migration](https://docs.aws.amazon.com/https://www.rfc-editor.org/rfc/rfc9000.html#name-connection-migration) at RFC 9000. For more information about supported TLSv1.3 ciphers, see [Supported protocols and ciphers between viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html).
        :param bool ipv6_enabled: If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your distribution, specify ``true``. If you specify ``false``, CloudFront responds to IPv6 DNS requests with the DNS response code ``NOERROR`` and with no IP addresses. This allows viewers to submit a second request, for an IPv4 address for your distribution.
                In general, you should enable IPv6 if you have users on IPv6 networks who want to access your content. However, if you're using signed URLs or signed cookies to restrict access to your content, and if you're using a custom policy that includes the ``IpAddress`` parameter to restrict the IP addresses that can access your content, don't enable IPv6. If you want to restrict access to some content by IP address and not restrict access to other content (or restrict access but not by IP address), you can create two distributions. For more information, see [Creating a Signed URL Using a Custom Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html) in the *Amazon CloudFront Developer Guide*.
                If you're using an R53AWSIntlong alias resource record set to route traffic to your CloudFront distribution, you need to create a second alias resource record set when both of the following are true:
                 +  You enable IPv6 for the distribution
                 +  You're using alternate domain names in the URLs for your objects
                 
                For more information, see [Routing Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html) in the *Developer Guide*.
                If you created a CNAME resource record set, either with R53AWSIntlong or with another DNS service, you don't need to make any changes. A CNAME record will route traffic to your distribution regardless of the IP address format of the viewer request.
        :param 'DistributionLogging' logging: A complex type that controls whether access logs are written for the distribution.
                For more information about logging, see [Access Logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html) in the *Amazon CloudFront Developer Guide*.
        :param 'DistributionOriginGroups' origin_groups: A complex type that contains information about origin groups for this distribution.
        :param Sequence['DistributionOrigin'] origins: A complex type that contains information about origins for this distribution.
        :param str price_class: The price class that corresponds with the maximum price that you want to pay for CloudFront service. If you specify ``PriceClass_All``, CloudFront responds to requests for your objects from all CloudFront edge locations.
                If you specify a price class other than ``PriceClass_All``, CloudFront serves your objects from the CloudFront edge location that has the lowest latency among the edge locations in your price class. Viewers who are in or near regions that are excluded from your specified price class may encounter slower performance.
                For more information about price classes, see [Choosing the Price Class for a CloudFront Distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html) in the *Amazon CloudFront Developer Guide*. For information about CloudFront pricing, including how price classes (such as Price Class 100) map to CloudFront regions, see [Amazon CloudFront Pricing](https://docs.aws.amazon.com/cloudfront/pricing/).
        :param 'DistributionRestrictions' restrictions: A complex type that identifies ways in which you want to restrict distribution of your content.
        :param bool staging: A Boolean that indicates whether this is a staging distribution. When this value is ``true``, this is a staging distribution. When this value is ``false``, this is not a staging distribution.
        :param 'DistributionViewerCertificate' viewer_certificate: A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
        :param str web_acl_id: A unique identifier that specifies the WAF web ACL, if any, to associate with this distribution. To specify a web ACL created using the latest version of WAF, use the ACL ARN, for example ``arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a``. To specify a web ACL created using WAF Classic, use the ACL ID, for example ``473e64fd-f30b-4765-81a0-62ad96dd167a``.
                 WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to CloudFront, and lets you control access to your content. Based on conditions that you specify, such as the IP addresses that requests originate from or the values of query strings, CloudFront responds to requests either with the requested content or with an HTTP 403 status code (Forbidden). You can also configure CloudFront to return a custom error page when a request is blocked. For more information about WAF, see the [Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html).
        """
        pulumi.set(__self__, "default_cache_behavior", default_cache_behavior)
        pulumi.set(__self__, "enabled", enabled)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if cache_behaviors is not None:
            pulumi.set(__self__, "cache_behaviors", cache_behaviors)
        if cnames is not None:
            pulumi.set(__self__, "cnames", cnames)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if continuous_deployment_policy_id is not None:
            pulumi.set(__self__, "continuous_deployment_policy_id", continuous_deployment_policy_id)
        if custom_error_responses is not None:
            pulumi.set(__self__, "custom_error_responses", custom_error_responses)
        if custom_origin is not None:
            pulumi.set(__self__, "custom_origin", custom_origin)
        if default_root_object is not None:
            pulumi.set(__self__, "default_root_object", default_root_object)
        if http_version is not None:
            pulumi.set(__self__, "http_version", http_version)
        if ipv6_enabled is not None:
            pulumi.set(__self__, "ipv6_enabled", ipv6_enabled)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if origin_groups is not None:
            pulumi.set(__self__, "origin_groups", origin_groups)
        if origins is not None:
            pulumi.set(__self__, "origins", origins)
        if price_class is not None:
            pulumi.set(__self__, "price_class", price_class)
        if restrictions is not None:
            pulumi.set(__self__, "restrictions", restrictions)
        if s3_origin is not None:
            pulumi.set(__self__, "s3_origin", s3_origin)
        if staging is not None:
            pulumi.set(__self__, "staging", staging)
        if viewer_certificate is not None:
            pulumi.set(__self__, "viewer_certificate", viewer_certificate)
        if web_acl_id is not None:
            pulumi.set(__self__, "web_acl_id", web_acl_id)

    @property
    @pulumi.getter(name="defaultCacheBehavior")
    def default_cache_behavior(self) -> 'outputs.DistributionDefaultCacheBehavior':
        """
        A complex type that describes the default cache behavior if you don't specify a ``CacheBehavior`` element or if files don't match any of the values of ``PathPattern`` in ``CacheBehavior`` elements. You must create exactly one default cache behavior.
        """
        return pulumi.get(self, "default_cache_behavior")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        From this field, you can enable or disable the selected distribution.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def aliases(self) -> Optional[Sequence[str]]:
        """
        A complex type that contains information about CNAMEs (alternate domain names), if any, for this distribution.
        """
        return pulumi.get(self, "aliases")

    @property
    @pulumi.getter(name="cacheBehaviors")
    def cache_behaviors(self) -> Optional[Sequence['outputs.DistributionCacheBehavior']]:
        """
        A complex type that contains zero or more ``CacheBehavior`` elements.
        """
        return pulumi.get(self, "cache_behaviors")

    @property
    @pulumi.getter
    def cnames(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "cnames")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        A comment to describe the distribution. The comment cannot be longer than 128 characters.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="continuousDeploymentPolicyId")
    def continuous_deployment_policy_id(self) -> Optional[str]:
        """
        The identifier of a continuous deployment policy. For more information, see ``CreateContinuousDeploymentPolicy``.
        """
        return pulumi.get(self, "continuous_deployment_policy_id")

    @property
    @pulumi.getter(name="customErrorResponses")
    def custom_error_responses(self) -> Optional[Sequence['outputs.DistributionCustomErrorResponse']]:
        """
        A complex type that controls the following:
          +  Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer.
          +  How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
          
         For more information about custom error pages, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "custom_error_responses")

    @property
    @pulumi.getter(name="customOrigin")
    def custom_origin(self) -> Optional['outputs.DistributionLegacyCustomOrigin']:
        return pulumi.get(self, "custom_origin")

    @property
    @pulumi.getter(name="defaultRootObject")
    def default_root_object(self) -> Optional[str]:
        """
        The object that you want CloudFront to request from your origin (for example, ``index.html``) when a viewer requests the root URL for your distribution (``https://www.example.com``) instead of an object in your distribution (``https://www.example.com/product-description.html``). Specifying a default root object avoids exposing the contents of your distribution.
         Specify only the object name, for example, ``index.html``. Don't add a ``/`` before the object name.
         If you don't want to specify a default root object when you create a distribution, include an empty ``DefaultRootObject`` element.
         To delete the default root object from an existing distribution, update the distribution configuration and include an empty ``DefaultRootObject`` element.
         To replace the default root object, update the distribution configuration and specify the new object.
         For more information about the default root object, see [Creating a Default Root Object](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "default_root_object")

    @property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> Optional[str]:
        """
        (Optional) Specify the maximum HTTP version(s) that you want viewers to use to communicate with CF. The default value for new distributions is ``http1.1``.
         For viewers and CF to use HTTP/2, viewers must support TLSv1.2 or later, and must support Server Name Indication (SNI).
         For viewers and CF to use HTTP/3, viewers must support TLSv1.3 and Server Name Indication (SNI). CF supports HTTP/3 connection migration to allow the viewer to switch networks without losing connection. For more information about connection migration, see [Connection Migration](https://docs.aws.amazon.com/https://www.rfc-editor.org/rfc/rfc9000.html#name-connection-migration) at RFC 9000. For more information about supported TLSv1.3 ciphers, see [Supported protocols and ciphers between viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html).
        """
        return pulumi.get(self, "http_version")

    @property
    @pulumi.getter(name="ipv6Enabled")
    def ipv6_enabled(self) -> Optional[bool]:
        """
        If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your distribution, specify ``true``. If you specify ``false``, CloudFront responds to IPv6 DNS requests with the DNS response code ``NOERROR`` and with no IP addresses. This allows viewers to submit a second request, for an IPv4 address for your distribution.
         In general, you should enable IPv6 if you have users on IPv6 networks who want to access your content. However, if you're using signed URLs or signed cookies to restrict access to your content, and if you're using a custom policy that includes the ``IpAddress`` parameter to restrict the IP addresses that can access your content, don't enable IPv6. If you want to restrict access to some content by IP address and not restrict access to other content (or restrict access but not by IP address), you can create two distributions. For more information, see [Creating a Signed URL Using a Custom Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html) in the *Amazon CloudFront Developer Guide*.
         If you're using an R53AWSIntlong alias resource record set to route traffic to your CloudFront distribution, you need to create a second alias resource record set when both of the following are true:
          +  You enable IPv6 for the distribution
          +  You're using alternate domain names in the URLs for your objects
          
         For more information, see [Routing Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html) in the *Developer Guide*.
         If you created a CNAME resource record set, either with R53AWSIntlong or with another DNS service, you don't need to make any changes. A CNAME record will route traffic to your distribution regardless of the IP address format of the viewer request.
        """
        return pulumi.get(self, "ipv6_enabled")

    @property
    @pulumi.getter
    def logging(self) -> Optional['outputs.DistributionLogging']:
        """
        A complex type that controls whether access logs are written for the distribution.
         For more information about logging, see [Access Logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "logging")

    @property
    @pulumi.getter(name="originGroups")
    def origin_groups(self) -> Optional['outputs.DistributionOriginGroups']:
        """
        A complex type that contains information about origin groups for this distribution.
        """
        return pulumi.get(self, "origin_groups")

    @property
    @pulumi.getter
    def origins(self) -> Optional[Sequence['outputs.DistributionOrigin']]:
        """
        A complex type that contains information about origins for this distribution.
        """
        return pulumi.get(self, "origins")

    @property
    @pulumi.getter(name="priceClass")
    def price_class(self) -> Optional[str]:
        """
        The price class that corresponds with the maximum price that you want to pay for CloudFront service. If you specify ``PriceClass_All``, CloudFront responds to requests for your objects from all CloudFront edge locations.
         If you specify a price class other than ``PriceClass_All``, CloudFront serves your objects from the CloudFront edge location that has the lowest latency among the edge locations in your price class. Viewers who are in or near regions that are excluded from your specified price class may encounter slower performance.
         For more information about price classes, see [Choosing the Price Class for a CloudFront Distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html) in the *Amazon CloudFront Developer Guide*. For information about CloudFront pricing, including how price classes (such as Price Class 100) map to CloudFront regions, see [Amazon CloudFront Pricing](https://docs.aws.amazon.com/cloudfront/pricing/).
        """
        return pulumi.get(self, "price_class")

    @property
    @pulumi.getter
    def restrictions(self) -> Optional['outputs.DistributionRestrictions']:
        """
        A complex type that identifies ways in which you want to restrict distribution of your content.
        """
        return pulumi.get(self, "restrictions")

    @property
    @pulumi.getter(name="s3Origin")
    def s3_origin(self) -> Optional['outputs.DistributionLegacyS3Origin']:
        return pulumi.get(self, "s3_origin")

    @property
    @pulumi.getter
    def staging(self) -> Optional[bool]:
        """
        A Boolean that indicates whether this is a staging distribution. When this value is ``true``, this is a staging distribution. When this value is ``false``, this is not a staging distribution.
        """
        return pulumi.get(self, "staging")

    @property
    @pulumi.getter(name="viewerCertificate")
    def viewer_certificate(self) -> Optional['outputs.DistributionViewerCertificate']:
        """
        A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
        """
        return pulumi.get(self, "viewer_certificate")

    @property
    @pulumi.getter(name="webAclId")
    def web_acl_id(self) -> Optional[str]:
        """
        A unique identifier that specifies the WAF web ACL, if any, to associate with this distribution. To specify a web ACL created using the latest version of WAF, use the ACL ARN, for example ``arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a``. To specify a web ACL created using WAF Classic, use the ACL ID, for example ``473e64fd-f30b-4765-81a0-62ad96dd167a``.
          WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to CloudFront, and lets you control access to your content. Based on conditions that you specify, such as the IP addresses that requests originate from or the values of query strings, CloudFront responds to requests either with the requested content or with an HTTP 403 status code (Forbidden). You can also configure CloudFront to return a custom error page when a request is blocked. For more information about WAF, see the [Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html).
        """
        return pulumi.get(self, "web_acl_id")


@pulumi.output_type
class DistributionCookies(dict):
    """
    This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
     If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
     If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
     A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which ones. For more information about forwarding cookies to the origin, see [How CloudFront Forwards, Caches, and Logs Cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html) in the *Amazon CloudFront Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "whitelistedNames":
            suggest = "whitelisted_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCookies. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCookies.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCookies.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 forward: str,
                 whitelisted_names: Optional[Sequence[str]] = None):
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which ones. For more information about forwarding cookies to the origin, see [How CloudFront Forwards, Caches, and Logs Cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html) in the *Amazon CloudFront Developer Guide*.
        :param str forward: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
                If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
                If you want to send cookies to the origin but not include them in the cache key, use origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
                Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of cookies specified in the ``WhitelistedNames`` complex type.
                Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3 origin, specify none for the ``Forward`` element.
        :param Sequence[str] whitelisted_names: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
                If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
                If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
                Required if you specify ``whitelist`` for the value of ``Forward``. A complex type that specifies how many different cookies you want CloudFront to forward to the origin for this cache behavior and, if you want to forward selected cookies, the names of those cookies.
                If you specify ``all`` or ``none`` for the value of ``Forward``, omit ``WhitelistedNames``. If you change the value of ``Forward`` from ``whitelist`` to ``all`` or ``none`` and you don't delete the ``WhitelistedNames`` element and its child elements, CloudFront deletes them automatically.
                For the current limit on the number of cookie names that you can whitelist for each cache behavior, see [CloudFront Limits](https://docs.aws.amazon.com/general/latest/gr/xrefaws_service_limits.html#limits_cloudfront) in the *General Reference*.
        """
        pulumi.set(__self__, "forward", forward)
        if whitelisted_names is not None:
            pulumi.set(__self__, "whitelisted_names", whitelisted_names)

    @property
    @pulumi.getter
    def forward(self) -> str:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send cookies to the origin but not include them in the cache key, use origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of cookies specified in the ``WhitelistedNames`` complex type.
         Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3 origin, specify none for the ``Forward`` element.
        """
        return pulumi.get(self, "forward")

    @property
    @pulumi.getter(name="whitelistedNames")
    def whitelisted_names(self) -> Optional[Sequence[str]]:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         Required if you specify ``whitelist`` for the value of ``Forward``. A complex type that specifies how many different cookies you want CloudFront to forward to the origin for this cache behavior and, if you want to forward selected cookies, the names of those cookies.
         If you specify ``all`` or ``none`` for the value of ``Forward``, omit ``WhitelistedNames``. If you change the value of ``Forward`` from ``whitelist`` to ``all`` or ``none`` and you don't delete the ``WhitelistedNames`` element and its child elements, CloudFront deletes them automatically.
         For the current limit on the number of cookie names that you can whitelist for each cache behavior, see [CloudFront Limits](https://docs.aws.amazon.com/general/latest/gr/xrefaws_service_limits.html#limits_cloudfront) in the *General Reference*.
        """
        return pulumi.get(self, "whitelisted_names")


@pulumi.output_type
class DistributionCustomErrorResponse(dict):
    """
    A complex type that controls:
      +  Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer.
      +  How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
      
     For more information about custom error pages, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "errorCachingMinTtl":
            suggest = "error_caching_min_ttl"
        elif key == "responseCode":
            suggest = "response_code"
        elif key == "responsePagePath":
            suggest = "response_page_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCustomErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCustomErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCustomErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: int,
                 error_caching_min_ttl: Optional[float] = None,
                 response_code: Optional[int] = None,
                 response_page_path: Optional[str] = None):
        """
        A complex type that controls:
          +  Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer.
          +  How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
          
         For more information about custom error pages, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
        :param int error_code: The HTTP status code for which you want to specify a custom error page and/or a caching duration.
        :param float error_caching_min_ttl: The minimum amount of time, in seconds, that you want CloudFront to cache the HTTP status code specified in ``ErrorCode``. When this time period has elapsed, CloudFront queries your origin to see whether the problem that caused the error has been resolved and the requested object is now available.
                For more information, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
        :param int response_code: The HTTP status code that you want CloudFront to return to the viewer along with the custom error page. There are a variety of reasons that you might want CloudFront to return a status code different from the status code that your origin returned to CloudFront, for example:
                 +  Some Internet devices (some firewalls and corporate proxies, for example) intercept HTTP 4xx and 5xx and prevent the response from being returned to the viewer. If you substitute ``200``, the response typically won't be intercepted.
                 +  If you don't care about distinguishing among different client errors or server errors, you can specify ``400`` or ``500`` as the ``ResponseCode`` for all 4xx or 5xx errors.
                 +  You might want to return a ``200`` status code (OK) and static website so your customers don't know that your website is down.
                 
                If you specify a value for ``ResponseCode``, you must also specify a value for ``ResponsePagePath``.
        :param str response_page_path: The path to the custom error page that you want CloudFront to return to a viewer when your origin returns the HTTP status code specified by ``ErrorCode``, for example, ``/4xx-errors/403-forbidden.html``. If you want to store your objects and your custom error pages in different locations, your distribution must include a cache behavior for which the following is true:
                 +  The value of ``PathPattern`` matches the path to your custom error messages. For example, suppose you saved custom error pages for 4xx errors in an Amazon S3 bucket in a directory named ``/4xx-errors``. Your distribution must include a cache behavior for which the path pattern routes requests for your custom error pages to that location, for example, ``/4xx-errors/*``.
                 +  The value of ``TargetOriginId`` specifies the value of the ``ID`` element for the origin that contains your custom error pages.
                 
                If you specify a value for ``ResponsePagePath``, you must also specify a value for ``ResponseCode``.
                We recommend that you store custom error pages in an Amazon S3 bucket. If you store custom error pages on an HTTP server and the server starts to return 5xx errors, CloudFront can't get the files that you want to return to viewers because the origin server is unavailable.
        """
        pulumi.set(__self__, "error_code", error_code)
        if error_caching_min_ttl is not None:
            pulumi.set(__self__, "error_caching_min_ttl", error_caching_min_ttl)
        if response_code is not None:
            pulumi.set(__self__, "response_code", response_code)
        if response_page_path is not None:
            pulumi.set(__self__, "response_page_path", response_page_path)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> int:
        """
        The HTTP status code for which you want to specify a custom error page and/or a caching duration.
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorCachingMinTtl")
    def error_caching_min_ttl(self) -> Optional[float]:
        """
        The minimum amount of time, in seconds, that you want CloudFront to cache the HTTP status code specified in ``ErrorCode``. When this time period has elapsed, CloudFront queries your origin to see whether the problem that caused the error has been resolved and the requested object is now available.
         For more information, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "error_caching_min_ttl")

    @property
    @pulumi.getter(name="responseCode")
    def response_code(self) -> Optional[int]:
        """
        The HTTP status code that you want CloudFront to return to the viewer along with the custom error page. There are a variety of reasons that you might want CloudFront to return a status code different from the status code that your origin returned to CloudFront, for example:
          +  Some Internet devices (some firewalls and corporate proxies, for example) intercept HTTP 4xx and 5xx and prevent the response from being returned to the viewer. If you substitute ``200``, the response typically won't be intercepted.
          +  If you don't care about distinguishing among different client errors or server errors, you can specify ``400`` or ``500`` as the ``ResponseCode`` for all 4xx or 5xx errors.
          +  You might want to return a ``200`` status code (OK) and static website so your customers don't know that your website is down.
          
         If you specify a value for ``ResponseCode``, you must also specify a value for ``ResponsePagePath``.
        """
        return pulumi.get(self, "response_code")

    @property
    @pulumi.getter(name="responsePagePath")
    def response_page_path(self) -> Optional[str]:
        """
        The path to the custom error page that you want CloudFront to return to a viewer when your origin returns the HTTP status code specified by ``ErrorCode``, for example, ``/4xx-errors/403-forbidden.html``. If you want to store your objects and your custom error pages in different locations, your distribution must include a cache behavior for which the following is true:
          +  The value of ``PathPattern`` matches the path to your custom error messages. For example, suppose you saved custom error pages for 4xx errors in an Amazon S3 bucket in a directory named ``/4xx-errors``. Your distribution must include a cache behavior for which the path pattern routes requests for your custom error pages to that location, for example, ``/4xx-errors/*``.
          +  The value of ``TargetOriginId`` specifies the value of the ``ID`` element for the origin that contains your custom error pages.
          
         If you specify a value for ``ResponsePagePath``, you must also specify a value for ``ResponseCode``.
         We recommend that you store custom error pages in an Amazon S3 bucket. If you store custom error pages on an HTTP server and the server starts to return 5xx errors, CloudFront can't get the files that you want to return to viewers because the origin server is unavailable.
        """
        return pulumi.get(self, "response_page_path")


@pulumi.output_type
class DistributionCustomOriginConfig(dict):
    """
    A custom origin. A custom origin is any origin that is *not* an Amazon S3 bucket, with one exception. An Amazon S3 bucket that is [configured with static website hosting](https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html) *is* a custom origin.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "originProtocolPolicy":
            suggest = "origin_protocol_policy"
        elif key == "httpPort":
            suggest = "http_port"
        elif key == "httpsPort":
            suggest = "https_port"
        elif key == "originKeepaliveTimeout":
            suggest = "origin_keepalive_timeout"
        elif key == "originReadTimeout":
            suggest = "origin_read_timeout"
        elif key == "originSslProtocols":
            suggest = "origin_ssl_protocols"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCustomOriginConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCustomOriginConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCustomOriginConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 origin_protocol_policy: str,
                 http_port: Optional[int] = None,
                 https_port: Optional[int] = None,
                 origin_keepalive_timeout: Optional[int] = None,
                 origin_read_timeout: Optional[int] = None,
                 origin_ssl_protocols: Optional[Sequence[str]] = None):
        """
        A custom origin. A custom origin is any origin that is *not* an Amazon S3 bucket, with one exception. An Amazon S3 bucket that is [configured with static website hosting](https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html) *is* a custom origin.
        :param str origin_protocol_policy: Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. Valid values are:
                 +   ``http-only`` – CloudFront always uses HTTP to connect to the origin.
                 +   ``match-viewer`` – CloudFront connects to the origin using the same protocol that the viewer used to connect to CloudFront.
                 +   ``https-only`` – CloudFront always uses HTTPS to connect to the origin.
        :param int http_port: The HTTP port that CloudFront uses to connect to the origin. Specify the HTTP port that the origin listens on.
        :param int https_port: The HTTPS port that CloudFront uses to connect to the origin. Specify the HTTPS port that the origin listens on.
        :param int origin_keepalive_timeout: Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 5 seconds.
                For more information, see [Origin Keep-alive Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout) in the *Amazon CloudFront Developer Guide*.
        :param int origin_read_timeout: Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as the *origin response timeout*. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 30 seconds.
                For more information, see [Origin Response Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout) in the *Amazon CloudFront Developer Guide*.
        :param Sequence[str] origin_ssl_protocols: Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS. Valid values include ``SSLv3``, ``TLSv1``, ``TLSv1.1``, and ``TLSv1.2``.
                For more information, see [Minimum Origin SSL Protocol](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols) in the *Amazon CloudFront Developer Guide*.
        """
        pulumi.set(__self__, "origin_protocol_policy", origin_protocol_policy)
        if http_port is not None:
            pulumi.set(__self__, "http_port", http_port)
        if https_port is not None:
            pulumi.set(__self__, "https_port", https_port)
        if origin_keepalive_timeout is not None:
            pulumi.set(__self__, "origin_keepalive_timeout", origin_keepalive_timeout)
        if origin_read_timeout is not None:
            pulumi.set(__self__, "origin_read_timeout", origin_read_timeout)
        if origin_ssl_protocols is not None:
            pulumi.set(__self__, "origin_ssl_protocols", origin_ssl_protocols)

    @property
    @pulumi.getter(name="originProtocolPolicy")
    def origin_protocol_policy(self) -> str:
        """
        Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. Valid values are:
          +   ``http-only`` – CloudFront always uses HTTP to connect to the origin.
          +   ``match-viewer`` – CloudFront connects to the origin using the same protocol that the viewer used to connect to CloudFront.
          +   ``https-only`` – CloudFront always uses HTTPS to connect to the origin.
        """
        return pulumi.get(self, "origin_protocol_policy")

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> Optional[int]:
        """
        The HTTP port that CloudFront uses to connect to the origin. Specify the HTTP port that the origin listens on.
        """
        return pulumi.get(self, "http_port")

    @property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> Optional[int]:
        """
        The HTTPS port that CloudFront uses to connect to the origin. Specify the HTTPS port that the origin listens on.
        """
        return pulumi.get(self, "https_port")

    @property
    @pulumi.getter(name="originKeepaliveTimeout")
    def origin_keepalive_timeout(self) -> Optional[int]:
        """
        Specifies how long, in seconds, CloudFront persists its connection to the origin. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 5 seconds.
         For more information, see [Origin Keep-alive Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_keepalive_timeout")

    @property
    @pulumi.getter(name="originReadTimeout")
    def origin_read_timeout(self) -> Optional[int]:
        """
        Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as the *origin response timeout*. The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 30 seconds.
         For more information, see [Origin Response Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_read_timeout")

    @property
    @pulumi.getter(name="originSslProtocols")
    def origin_ssl_protocols(self) -> Optional[Sequence[str]]:
        """
        Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS. Valid values include ``SSLv3``, ``TLSv1``, ``TLSv1.1``, and ``TLSv1.2``.
         For more information, see [Minimum Origin SSL Protocol](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_ssl_protocols")


@pulumi.output_type
class DistributionDefaultCacheBehavior(dict):
    """
    A complex type that describes the default cache behavior if you don't specify a ``CacheBehavior`` element or if request URLs don't match any of the values of ``PathPattern`` in ``CacheBehavior`` elements. You must create exactly one default cache behavior.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetOriginId":
            suggest = "target_origin_id"
        elif key == "viewerProtocolPolicy":
            suggest = "viewer_protocol_policy"
        elif key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "cachePolicyId":
            suggest = "cache_policy_id"
        elif key == "cachedMethods":
            suggest = "cached_methods"
        elif key == "defaultTtl":
            suggest = "default_ttl"
        elif key == "fieldLevelEncryptionId":
            suggest = "field_level_encryption_id"
        elif key == "forwardedValues":
            suggest = "forwarded_values"
        elif key == "functionAssociations":
            suggest = "function_associations"
        elif key == "lambdaFunctionAssociations":
            suggest = "lambda_function_associations"
        elif key == "maxTtl":
            suggest = "max_ttl"
        elif key == "minTtl":
            suggest = "min_ttl"
        elif key == "originRequestPolicyId":
            suggest = "origin_request_policy_id"
        elif key == "realtimeLogConfigArn":
            suggest = "realtime_log_config_arn"
        elif key == "responseHeadersPolicyId":
            suggest = "response_headers_policy_id"
        elif key == "smoothStreaming":
            suggest = "smooth_streaming"
        elif key == "trustedKeyGroups":
            suggest = "trusted_key_groups"
        elif key == "trustedSigners":
            suggest = "trusted_signers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionDefaultCacheBehavior. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionDefaultCacheBehavior.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionDefaultCacheBehavior.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_origin_id: str,
                 viewer_protocol_policy: str,
                 allowed_methods: Optional[Sequence[str]] = None,
                 cache_policy_id: Optional[str] = None,
                 cached_methods: Optional[Sequence[str]] = None,
                 compress: Optional[bool] = None,
                 default_ttl: Optional[float] = None,
                 field_level_encryption_id: Optional[str] = None,
                 forwarded_values: Optional['outputs.DistributionForwardedValues'] = None,
                 function_associations: Optional[Sequence['outputs.DistributionFunctionAssociation']] = None,
                 lambda_function_associations: Optional[Sequence['outputs.DistributionLambdaFunctionAssociation']] = None,
                 max_ttl: Optional[float] = None,
                 min_ttl: Optional[float] = None,
                 origin_request_policy_id: Optional[str] = None,
                 realtime_log_config_arn: Optional[str] = None,
                 response_headers_policy_id: Optional[str] = None,
                 smooth_streaming: Optional[bool] = None,
                 trusted_key_groups: Optional[Sequence[str]] = None,
                 trusted_signers: Optional[Sequence[str]] = None):
        """
        A complex type that describes the default cache behavior if you don't specify a ``CacheBehavior`` element or if request URLs don't match any of the values of ``PathPattern`` in ``CacheBehavior`` elements. You must create exactly one default cache behavior.
        :param str target_origin_id: The value of ``ID`` for the origin that you want CloudFront to route requests to when they use the default cache behavior.
        :param str viewer_protocol_policy: The protocol that viewers can use to access the files in the origin specified by ``TargetOriginId`` when a request matches the path pattern in ``PathPattern``. You can specify the following options:
                 +   ``allow-all``: Viewers can use HTTP or HTTPS.
                 +   ``redirect-to-https``: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the new URL.
                 +   ``https-only``: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403 (Forbidden).
                 
                For more information about requiring the HTTPS protocol, see [Requiring HTTPS Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html) in the *Amazon CloudFront Developer Guide*.
                 The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will return an object from the cache regardless of whether the current request protocol matches the protocol used previously. For more information, see [Managing Cache Expiration](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        :param Sequence[str] allowed_methods: A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin. There are three choices:
                 +  CloudFront forwards only ``GET`` and ``HEAD`` requests.
                 +  CloudFront forwards only ``GET``, ``HEAD``, and ``OPTIONS`` requests.
                 +  CloudFront forwards ``GET, HEAD, OPTIONS, PUT, PATCH, POST``, and ``DELETE`` requests.
                 
                If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so users can't perform operations that you don't want them to. For example, you might not want users to have permissions to delete objects from your origin.
        :param str cache_policy_id: The unique identifier of the cache policy that is attached to the default cache behavior. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                A ``DefaultCacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
        :param Sequence[str] cached_methods: A complex type that controls whether CloudFront caches the response to requests using the specified HTTP methods. There are two choices:
                 +  CloudFront caches responses to ``GET`` and ``HEAD`` requests.
                 +  CloudFront caches responses to ``GET``, ``HEAD``, and ``OPTIONS`` requests.
                 
                If you pick the second choice for your Amazon S3 Origin, you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the responses to be cached correctly.
        :param bool compress: Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify ``true``; if not, specify ``false``. For more information, see [Serving Compressed Files](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html) in the *Amazon CloudFront Developer Guide*.
        :param float default_ttl: This field is deprecated. We recommend that you use the ``DefaultTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin does not add HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        :param str field_level_encryption_id: The value of ``ID`` for the field-level encryption configuration that you want CloudFront to use for encrypting specific fields of data for the default cache behavior.
        :param 'DistributionForwardedValues' forwarded_values: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see [Working with policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html) in the *Amazon CloudFront Developer Guide*.
                If you want to include values in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
                A ``DefaultCacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
                A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
        :param Sequence['DistributionFunctionAssociation'] function_associations: A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must be published to the ``LIVE`` stage to associate them with a cache behavior.
        :param Sequence['DistributionLambdaFunctionAssociation'] lambda_function_associations: A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.
        :param float max_ttl: This field is deprecated. We recommend that you use the ``MaxTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin adds HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        :param float min_ttl: This field is deprecated. We recommend that you use the ``MinTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
                The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
                You must specify ``0`` for ``MinTTL`` if you configure CloudFront to forward all headers to your origin (under ``Headers``, if you specify ``1`` for ``Quantity`` and ``*`` for ``Name``).
        :param str origin_request_policy_id: The unique identifier of the origin request policy that is attached to the default cache behavior. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
        :param str realtime_log_config_arn: The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior. For more information, see [Real-time logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html) in the *Amazon CloudFront Developer Guide*.
        :param str response_headers_policy_id: The identifier for a response headers policy.
        :param bool smooth_streaming: Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior. If so, specify ``true``; if not, specify ``false``. If you specify ``true`` for ``SmoothStreaming``, you can still distribute other content using this cache behavior if the content matches the value of ``PathPattern``.
        :param Sequence[str] trusted_key_groups: A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
                When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        :param Sequence[str] trusted_signers: We recommend using ``TrustedKeyGroups`` instead of ``TrustedSigners``.
                 A list of AWS-account IDs whose public keys CloudFront can use to validate signed URLs or signed cookies.
                When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront key pair in a trusted signer's AWS-account. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        pulumi.set(__self__, "target_origin_id", target_origin_id)
        pulumi.set(__self__, "viewer_protocol_policy", viewer_protocol_policy)
        if allowed_methods is not None:
            pulumi.set(__self__, "allowed_methods", allowed_methods)
        if cache_policy_id is not None:
            pulumi.set(__self__, "cache_policy_id", cache_policy_id)
        if cached_methods is not None:
            pulumi.set(__self__, "cached_methods", cached_methods)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if field_level_encryption_id is not None:
            pulumi.set(__self__, "field_level_encryption_id", field_level_encryption_id)
        if forwarded_values is not None:
            pulumi.set(__self__, "forwarded_values", forwarded_values)
        if function_associations is not None:
            pulumi.set(__self__, "function_associations", function_associations)
        if lambda_function_associations is not None:
            pulumi.set(__self__, "lambda_function_associations", lambda_function_associations)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if min_ttl is not None:
            pulumi.set(__self__, "min_ttl", min_ttl)
        if origin_request_policy_id is not None:
            pulumi.set(__self__, "origin_request_policy_id", origin_request_policy_id)
        if realtime_log_config_arn is not None:
            pulumi.set(__self__, "realtime_log_config_arn", realtime_log_config_arn)
        if response_headers_policy_id is not None:
            pulumi.set(__self__, "response_headers_policy_id", response_headers_policy_id)
        if smooth_streaming is not None:
            pulumi.set(__self__, "smooth_streaming", smooth_streaming)
        if trusted_key_groups is not None:
            pulumi.set(__self__, "trusted_key_groups", trusted_key_groups)
        if trusted_signers is not None:
            pulumi.set(__self__, "trusted_signers", trusted_signers)

    @property
    @pulumi.getter(name="targetOriginId")
    def target_origin_id(self) -> str:
        """
        The value of ``ID`` for the origin that you want CloudFront to route requests to when they use the default cache behavior.
        """
        return pulumi.get(self, "target_origin_id")

    @property
    @pulumi.getter(name="viewerProtocolPolicy")
    def viewer_protocol_policy(self) -> str:
        """
        The protocol that viewers can use to access the files in the origin specified by ``TargetOriginId`` when a request matches the path pattern in ``PathPattern``. You can specify the following options:
          +   ``allow-all``: Viewers can use HTTP or HTTPS.
          +   ``redirect-to-https``: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the new URL.
          +   ``https-only``: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403 (Forbidden).
          
         For more information about requiring the HTTPS protocol, see [Requiring HTTPS Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html) in the *Amazon CloudFront Developer Guide*.
          The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will return an object from the cache regardless of whether the current request protocol matches the protocol used previously. For more information, see [Managing Cache Expiration](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "viewer_protocol_policy")

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Optional[Sequence[str]]:
        """
        A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin. There are three choices:
          +  CloudFront forwards only ``GET`` and ``HEAD`` requests.
          +  CloudFront forwards only ``GET``, ``HEAD``, and ``OPTIONS`` requests.
          +  CloudFront forwards ``GET, HEAD, OPTIONS, PUT, PATCH, POST``, and ``DELETE`` requests.
          
         If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so users can't perform operations that you don't want them to. For example, you might not want users to have permissions to delete objects from your origin.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="cachePolicyId")
    def cache_policy_id(self) -> Optional[str]:
        """
        The unique identifier of the cache policy that is attached to the default cache behavior. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         A ``DefaultCacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
        """
        return pulumi.get(self, "cache_policy_id")

    @property
    @pulumi.getter(name="cachedMethods")
    def cached_methods(self) -> Optional[Sequence[str]]:
        """
        A complex type that controls whether CloudFront caches the response to requests using the specified HTTP methods. There are two choices:
          +  CloudFront caches responses to ``GET`` and ``HEAD`` requests.
          +  CloudFront caches responses to ``GET``, ``HEAD``, and ``OPTIONS`` requests.
          
         If you pick the second choice for your Amazon S3 Origin, you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the responses to be cached correctly.
        """
        return pulumi.get(self, "cached_methods")

    @property
    @pulumi.getter
    def compress(self) -> Optional[bool]:
        """
        Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify ``true``; if not, specify ``false``. For more information, see [Serving Compressed Files](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "compress")

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[float]:
        """
        This field is deprecated. We recommend that you use the ``DefaultTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin does not add HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter(name="fieldLevelEncryptionId")
    def field_level_encryption_id(self) -> Optional[str]:
        """
        The value of ``ID`` for the field-level encryption configuration that you want CloudFront to use for encrypting specific fields of data for the default cache behavior.
        """
        return pulumi.get(self, "field_level_encryption_id")

    @property
    @pulumi.getter(name="forwardedValues")
    def forwarded_values(self) -> Optional['outputs.DistributionForwardedValues']:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see [Working with policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html) in the *Amazon CloudFront Developer Guide*.
         If you want to include values in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
         A ``DefaultCacheBehavior`` must include either a ``CachePolicyId`` or ``ForwardedValues``. We recommend that you use a ``CachePolicyId``.
         A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
        """
        return pulumi.get(self, "forwarded_values")

    @property
    @pulumi.getter(name="functionAssociations")
    def function_associations(self) -> Optional[Sequence['outputs.DistributionFunctionAssociation']]:
        """
        A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must be published to the ``LIVE`` stage to associate them with a cache behavior.
        """
        return pulumi.get(self, "function_associations")

    @property
    @pulumi.getter(name="lambdaFunctionAssociations")
    def lambda_function_associations(self) -> Optional[Sequence['outputs.DistributionLambdaFunctionAssociation']]:
        """
        A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.
        """
        return pulumi.get(self, "lambda_function_associations")

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[float]:
        """
        This field is deprecated. We recommend that you use the ``MaxTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin adds HTTP headers such as ``Cache-Control max-age``, ``Cache-Control s-maxage``, and ``Expires`` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "max_ttl")

    @property
    @pulumi.getter(name="minTtl")
    def min_ttl(self) -> Optional[float]:
        """
        This field is deprecated. We recommend that you use the ``MinTTL`` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
         You must specify ``0`` for ``MinTTL`` if you configure CloudFront to forward all headers to your origin (under ``Headers``, if you specify ``1`` for ``Quantity`` and ``*`` for ``Name``).
        """
        return pulumi.get(self, "min_ttl")

    @property
    @pulumi.getter(name="originRequestPolicyId")
    def origin_request_policy_id(self) -> Optional[str]:
        """
        The unique identifier of the origin request policy that is attached to the default cache behavior. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_request_policy_id")

    @property
    @pulumi.getter(name="realtimeLogConfigArn")
    def realtime_log_config_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior. For more information, see [Real-time logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "realtime_log_config_arn")

    @property
    @pulumi.getter(name="responseHeadersPolicyId")
    def response_headers_policy_id(self) -> Optional[str]:
        """
        The identifier for a response headers policy.
        """
        return pulumi.get(self, "response_headers_policy_id")

    @property
    @pulumi.getter(name="smoothStreaming")
    def smooth_streaming(self) -> Optional[bool]:
        """
        Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior. If so, specify ``true``; if not, specify ``false``. If you specify ``true`` for ``SmoothStreaming``, you can still distribute other content using this cache behavior if the content matches the value of ``PathPattern``.
        """
        return pulumi.get(self, "smooth_streaming")

    @property
    @pulumi.getter(name="trustedKeyGroups")
    def trusted_key_groups(self) -> Optional[Sequence[str]]:
        """
        A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
         When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "trusted_key_groups")

    @property
    @pulumi.getter(name="trustedSigners")
    def trusted_signers(self) -> Optional[Sequence[str]]:
        """
        We recommend using ``TrustedKeyGroups`` instead of ``TrustedSigners``.
          A list of AWS-account IDs whose public keys CloudFront can use to validate signed URLs or signed cookies.
         When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront key pair in a trusted signer's AWS-account. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "trusted_signers")


@pulumi.output_type
class DistributionForwardedValues(dict):
    """
    This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
     If you want to include values in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
     If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
     A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryString":
            suggest = "query_string"
        elif key == "queryStringCacheKeys":
            suggest = "query_string_cache_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionForwardedValues. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionForwardedValues.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionForwardedValues.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_string: bool,
                 cookies: Optional['outputs.DistributionCookies'] = None,
                 headers: Optional[Sequence[str]] = None,
                 query_string_cache_keys: Optional[Sequence[str]] = None):
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include values in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
        :param bool query_string: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
                If you want to include query strings in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
                If you want to send query strings to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
                Indicates whether you want CloudFront to forward query strings to the origin that is associated with this cache behavior and cache based on the query string parameters. CloudFront behavior depends on the value of ``QueryString`` and on the values that you specify for ``QueryStringCacheKeys``, if any:
                If you specify true for ``QueryString`` and you don't specify any values for ``QueryStringCacheKeys``, CloudFront forwards all query string parameters to the origin and caches based on all query string parameters. Depending on how many query string parameters and values you have, this can adversely affect performance because CloudFront must forward more requests to the origin.
                If you specify true for ``QueryString`` and you specify one or more values for ``QueryStringCacheKeys``, CloudFront forwards all query string parameters to the origin, but it only caches based on the query string parameters that you specify.
                If you specify false for ``QueryString``, CloudFront doesn't forward any query string parameters to the origin, and doesn't cache based on query string parameters.
                For more information, see [Configuring CloudFront to Cache Based on Query String Parameters](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html) in the *Amazon CloudFront Developer Guide*.
        :param 'DistributionCookies' cookies: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
                If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
                If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
                A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which ones. For more information about forwarding cookies to the origin, see [How CloudFront Forwards, Caches, and Logs Cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html) in the *Amazon CloudFront Developer Guide*.
        :param Sequence[str] headers: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
                If you want to include headers in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
                If you want to send headers to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
                A complex type that specifies the ``Headers``, if any, that you want CloudFront to forward to the origin for this cache behavior (whitelisted headers). For the headers that you specify, CloudFront also caches separate versions of a specified object that is based on the header values in viewer requests.
                For more information, see [Caching Content Based on Request Headers](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html) in the *Amazon CloudFront Developer Guide*.
        :param Sequence[str] query_string_cache_keys: This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
                If you want to include query strings in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
                If you want to send query strings to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
                A complex type that contains information about the query string parameters that you want CloudFront to use for caching for this cache behavior.
        """
        pulumi.set(__self__, "query_string", query_string)
        if cookies is not None:
            pulumi.set(__self__, "cookies", cookies)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_string_cache_keys is not None:
            pulumi.set(__self__, "query_string_cache_keys", query_string_cache_keys)

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> bool:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include query strings in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send query strings to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         Indicates whether you want CloudFront to forward query strings to the origin that is associated with this cache behavior and cache based on the query string parameters. CloudFront behavior depends on the value of ``QueryString`` and on the values that you specify for ``QueryStringCacheKeys``, if any:
         If you specify true for ``QueryString`` and you don't specify any values for ``QueryStringCacheKeys``, CloudFront forwards all query string parameters to the origin and caches based on all query string parameters. Depending on how many query string parameters and values you have, this can adversely affect performance because CloudFront must forward more requests to the origin.
         If you specify true for ``QueryString`` and you specify one or more values for ``QueryStringCacheKeys``, CloudFront forwards all query string parameters to the origin, but it only caches based on the query string parameters that you specify.
         If you specify false for ``QueryString``, CloudFront doesn't forward any query string parameters to the origin, and doesn't cache based on query string parameters.
         For more information, see [Configuring CloudFront to Cache Based on Query String Parameters](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "query_string")

    @property
    @pulumi.getter
    def cookies(self) -> Optional['outputs.DistributionCookies']:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include cookies in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which ones. For more information about forwarding cookies to the origin, see [How CloudFront Forwards, Caches, and Logs Cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "cookies")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence[str]]:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include headers in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send headers to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         A complex type that specifies the ``Headers``, if any, that you want CloudFront to forward to the origin for this cache behavior (whitelisted headers). For the headers that you specify, CloudFront also caches separate versions of a specified object that is based on the header values in viewer requests.
         For more information, see [Caching Content Based on Request Headers](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="queryStringCacheKeys")
    def query_string_cache_keys(self) -> Optional[Sequence[str]]:
        """
        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
         If you want to include query strings in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) in the *Amazon CloudFront Developer Guide*.
         If you want to send query strings to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) in the *Amazon CloudFront Developer Guide*.
         A complex type that contains information about the query string parameters that you want CloudFront to use for caching for this cache behavior.
        """
        return pulumi.get(self, "query_string_cache_keys")


@pulumi.output_type
class DistributionFunctionAssociation(dict):
    """
    A CloudFront function that is associated with a cache behavior in a CloudFront distribution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventType":
            suggest = "event_type"
        elif key == "functionArn":
            suggest = "function_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionFunctionAssociation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionFunctionAssociation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionFunctionAssociation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_type: Optional[str] = None,
                 function_arn: Optional[str] = None):
        """
        A CloudFront function that is associated with a cache behavior in a CloudFront distribution.
        :param str event_type: The event type of the function, either ``viewer-request`` or ``viewer-response``. You cannot use origin-facing event types (``origin-request`` and ``origin-response``) with a CloudFront function.
        :param str function_arn: The Amazon Resource Name (ARN) of the function.
        """
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if function_arn is not None:
            pulumi.set(__self__, "function_arn", function_arn)

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[str]:
        """
        The event type of the function, either ``viewer-request`` or ``viewer-response``. You cannot use origin-facing event types (``origin-request`` and ``origin-response``) with a CloudFront function.
        """
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the function.
        """
        return pulumi.get(self, "function_arn")


@pulumi.output_type
class DistributionGeoRestriction(dict):
    """
    A complex type that controls the countries in which your content is distributed. CF determines the location of your users using ``MaxMind`` GeoIP databases. To disable geo restriction, remove the [Restrictions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-restrictions) property from your stack template.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restrictionType":
            suggest = "restriction_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionGeoRestriction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionGeoRestriction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionGeoRestriction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 restriction_type: str,
                 locations: Optional[Sequence[str]] = None):
        """
        A complex type that controls the countries in which your content is distributed. CF determines the location of your users using ``MaxMind`` GeoIP databases. To disable geo restriction, remove the [Restrictions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-restrictions) property from your stack template.
        :param str restriction_type: The method that you want to use to restrict distribution of your content by country:
                 +   ``none``: No geo restriction is enabled, meaning access to content is not restricted by client geo location.
                 +   ``blacklist``: The ``Location`` elements specify the countries in which you don't want CloudFront to distribute your content.
                 +   ``whitelist``: The ``Location`` elements specify the countries in which you want CloudFront to distribute your content.
        :param Sequence[str] locations: A complex type that contains a ``Location`` element for each country in which you want CloudFront either to distribute your content (``whitelist``) or not distribute your content (``blacklist``).
                The ``Location`` element is a two-letter, uppercase country code for a country that you want to include in your ``blacklist`` or ``whitelist``. Include one ``Location`` element for each country.
                CloudFront and ``MaxMind`` both use ``ISO 3166`` country codes. For the current list of countries and the corresponding codes, see ``ISO 3166-1-alpha-2`` code on the *International Organization for Standardization* website. You can also refer to the country list on the CloudFront console, which includes both country names and codes.
        """
        pulumi.set(__self__, "restriction_type", restriction_type)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)

    @property
    @pulumi.getter(name="restrictionType")
    def restriction_type(self) -> str:
        """
        The method that you want to use to restrict distribution of your content by country:
          +   ``none``: No geo restriction is enabled, meaning access to content is not restricted by client geo location.
          +   ``blacklist``: The ``Location`` elements specify the countries in which you don't want CloudFront to distribute your content.
          +   ``whitelist``: The ``Location`` elements specify the countries in which you want CloudFront to distribute your content.
        """
        return pulumi.get(self, "restriction_type")

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence[str]]:
        """
        A complex type that contains a ``Location`` element for each country in which you want CloudFront either to distribute your content (``whitelist``) or not distribute your content (``blacklist``).
         The ``Location`` element is a two-letter, uppercase country code for a country that you want to include in your ``blacklist`` or ``whitelist``. Include one ``Location`` element for each country.
         CloudFront and ``MaxMind`` both use ``ISO 3166`` country codes. For the current list of countries and the corresponding codes, see ``ISO 3166-1-alpha-2`` code on the *International Organization for Standardization* website. You can also refer to the country list on the CloudFront console, which includes both country names and codes.
        """
        return pulumi.get(self, "locations")


@pulumi.output_type
class DistributionLambdaFunctionAssociation(dict):
    """
    A complex type that contains a Lambda@Edge function association.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventType":
            suggest = "event_type"
        elif key == "includeBody":
            suggest = "include_body"
        elif key == "lambdaFunctionArn":
            suggest = "lambda_function_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionLambdaFunctionAssociation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionLambdaFunctionAssociation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionLambdaFunctionAssociation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_type: Optional[str] = None,
                 include_body: Optional[bool] = None,
                 lambda_function_arn: Optional[str] = None):
        """
        A complex type that contains a Lambda@Edge function association.
        :param str event_type: Specifies the event type that triggers a Lambda@Edge function invocation. You can specify the following values:
                 +   ``viewer-request``: The function executes when CloudFront receives a request from a viewer and before it checks to see whether the requested object is in the edge cache.
                 +   ``origin-request``: The function executes only when CloudFront sends a request to your origin. When the requested object is in the edge cache, the function doesn't execute.
                 +   ``origin-response``: The function executes after CloudFront receives a response from the origin and before it caches the object in the response. When the requested object is in the edge cache, the function doesn't execute.
                 +   ``viewer-response``: The function executes before CloudFront returns the requested object to the viewer. The function executes regardless of whether the object was already in the edge cache.
                If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
        :param bool include_body: A flag that allows a Lambda@Edge function to have read access to the body content. For more information, see [Accessing the Request Body by Choosing the Include Body Option](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html) in the Amazon CloudFront Developer Guide.
        :param str lambda_function_arn: The ARN of the Lambda@Edge function. You must specify the ARN of a function version; you can't specify an alias or $LATEST.
        """
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if include_body is not None:
            pulumi.set(__self__, "include_body", include_body)
        if lambda_function_arn is not None:
            pulumi.set(__self__, "lambda_function_arn", lambda_function_arn)

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[str]:
        """
        Specifies the event type that triggers a Lambda@Edge function invocation. You can specify the following values:
          +   ``viewer-request``: The function executes when CloudFront receives a request from a viewer and before it checks to see whether the requested object is in the edge cache.
          +   ``origin-request``: The function executes only when CloudFront sends a request to your origin. When the requested object is in the edge cache, the function doesn't execute.
          +   ``origin-response``: The function executes after CloudFront receives a response from the origin and before it caches the object in the response. When the requested object is in the edge cache, the function doesn't execute.
          +   ``viewer-response``: The function executes before CloudFront returns the requested object to the viewer. The function executes regardless of whether the object was already in the edge cache.
         If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
        """
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter(name="includeBody")
    def include_body(self) -> Optional[bool]:
        """
        A flag that allows a Lambda@Edge function to have read access to the body content. For more information, see [Accessing the Request Body by Choosing the Include Body Option](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html) in the Amazon CloudFront Developer Guide.
        """
        return pulumi.get(self, "include_body")

    @property
    @pulumi.getter(name="lambdaFunctionArn")
    def lambda_function_arn(self) -> Optional[str]:
        """
        The ARN of the Lambda@Edge function. You must specify the ARN of a function version; you can't specify an alias or $LATEST.
        """
        return pulumi.get(self, "lambda_function_arn")


@pulumi.output_type
class DistributionLegacyCustomOrigin(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsName":
            suggest = "dns_name"
        elif key == "originProtocolPolicy":
            suggest = "origin_protocol_policy"
        elif key == "originSslProtocols":
            suggest = "origin_ssl_protocols"
        elif key == "httpPort":
            suggest = "http_port"
        elif key == "httpsPort":
            suggest = "https_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionLegacyCustomOrigin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionLegacyCustomOrigin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionLegacyCustomOrigin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_name: str,
                 origin_protocol_policy: str,
                 origin_ssl_protocols: Sequence[str],
                 http_port: Optional[int] = None,
                 https_port: Optional[int] = None):
        pulumi.set(__self__, "dns_name", dns_name)
        pulumi.set(__self__, "origin_protocol_policy", origin_protocol_policy)
        pulumi.set(__self__, "origin_ssl_protocols", origin_ssl_protocols)
        if http_port is not None:
            pulumi.set(__self__, "http_port", http_port)
        if https_port is not None:
            pulumi.set(__self__, "https_port", https_port)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> str:
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="originProtocolPolicy")
    def origin_protocol_policy(self) -> str:
        return pulumi.get(self, "origin_protocol_policy")

    @property
    @pulumi.getter(name="originSslProtocols")
    def origin_ssl_protocols(self) -> Sequence[str]:
        return pulumi.get(self, "origin_ssl_protocols")

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> Optional[int]:
        return pulumi.get(self, "http_port")

    @property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> Optional[int]:
        return pulumi.get(self, "https_port")


@pulumi.output_type
class DistributionLegacyS3Origin(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsName":
            suggest = "dns_name"
        elif key == "originAccessIdentity":
            suggest = "origin_access_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionLegacyS3Origin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionLegacyS3Origin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionLegacyS3Origin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_name: str,
                 origin_access_identity: Optional[str] = None):
        pulumi.set(__self__, "dns_name", dns_name)
        if origin_access_identity is not None:
            pulumi.set(__self__, "origin_access_identity", origin_access_identity)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> str:
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="originAccessIdentity")
    def origin_access_identity(self) -> Optional[str]:
        return pulumi.get(self, "origin_access_identity")


@pulumi.output_type
class DistributionLogging(dict):
    """
    A complex type that controls whether access logs are written for the distribution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeCookies":
            suggest = "include_cookies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionLogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionLogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionLogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 include_cookies: Optional[bool] = None,
                 prefix: Optional[str] = None):
        """
        A complex type that controls whether access logs are written for the distribution.
        :param str bucket: The Amazon S3 bucket to store the access logs in, for example, ``myawslogbucket.s3.amazonaws.com``.
        :param bool include_cookies: Specifies whether you want CloudFront to include cookies in access logs, specify ``true`` for ``IncludeCookies``. If you choose to include cookies in logs, CloudFront logs all cookies regardless of how you configure the cache behaviors for this distribution. If you don't want to include cookies when you create a distribution or if you want to disable include cookies for an existing distribution, specify ``false`` for ``IncludeCookies``.
        :param str prefix: An optional string that you want CloudFront to prefix to the access log ``filenames`` for this distribution, for example, ``myprefix/``. If you want to enable logging, but you don't want to specify a prefix, you still must include an empty ``Prefix`` element in the ``Logging`` element.
        """
        pulumi.set(__self__, "bucket", bucket)
        if include_cookies is not None:
            pulumi.set(__self__, "include_cookies", include_cookies)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The Amazon S3 bucket to store the access logs in, for example, ``myawslogbucket.s3.amazonaws.com``.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="includeCookies")
    def include_cookies(self) -> Optional[bool]:
        """
        Specifies whether you want CloudFront to include cookies in access logs, specify ``true`` for ``IncludeCookies``. If you choose to include cookies in logs, CloudFront logs all cookies regardless of how you configure the cache behaviors for this distribution. If you don't want to include cookies when you create a distribution or if you want to disable include cookies for an existing distribution, specify ``false`` for ``IncludeCookies``.
        """
        return pulumi.get(self, "include_cookies")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        An optional string that you want CloudFront to prefix to the access log ``filenames`` for this distribution, for example, ``myprefix/``. If you want to enable logging, but you don't want to specify a prefix, you still must include an empty ``Prefix`` element in the ``Logging`` element.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class DistributionOrigin(dict):
    """
    An origin.
     An origin is the location where content is stored, and from which CloudFront gets content to serve to viewers. To specify an origin:
      +  Use ``S3OriginConfig`` to specify an Amazon S3 bucket that is not configured with static website hosting.
      +  Use ``CustomOriginConfig`` to specify all other kinds of origins, including:
      +  An Amazon S3 bucket that is configured with static website hosting
      +  An Elastic Load Balancing load balancer
      +  An EMPlong endpoint
      +  An EMSlong container
      +  Any other HTTP server, running on an Amazon EC2 instance or any other kind of host
      
      
     For the current maximum number of origins that you can specify per distribution, see [General Quotas on Web Distributions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html#limits-web-distributions) in the *Amazon CloudFront Developer Guide* (quotas were formerly referred to as limits).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "connectionAttempts":
            suggest = "connection_attempts"
        elif key == "connectionTimeout":
            suggest = "connection_timeout"
        elif key == "customOriginConfig":
            suggest = "custom_origin_config"
        elif key == "originAccessControlId":
            suggest = "origin_access_control_id"
        elif key == "originCustomHeaders":
            suggest = "origin_custom_headers"
        elif key == "originPath":
            suggest = "origin_path"
        elif key == "originShield":
            suggest = "origin_shield"
        elif key == "s3OriginConfig":
            suggest = "s3_origin_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionOrigin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionOrigin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionOrigin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: str,
                 id: str,
                 connection_attempts: Optional[int] = None,
                 connection_timeout: Optional[int] = None,
                 custom_origin_config: Optional['outputs.DistributionCustomOriginConfig'] = None,
                 origin_access_control_id: Optional[str] = None,
                 origin_custom_headers: Optional[Sequence['outputs.DistributionOriginCustomHeader']] = None,
                 origin_path: Optional[str] = None,
                 origin_shield: Optional['outputs.DistributionOriginShield'] = None,
                 s3_origin_config: Optional['outputs.DistributionS3OriginConfig'] = None):
        """
        An origin.
         An origin is the location where content is stored, and from which CloudFront gets content to serve to viewers. To specify an origin:
          +  Use ``S3OriginConfig`` to specify an Amazon S3 bucket that is not configured with static website hosting.
          +  Use ``CustomOriginConfig`` to specify all other kinds of origins, including:
          +  An Amazon S3 bucket that is configured with static website hosting
          +  An Elastic Load Balancing load balancer
          +  An EMPlong endpoint
          +  An EMSlong container
          +  Any other HTTP server, running on an Amazon EC2 instance or any other kind of host
          
          
         For the current maximum number of origins that you can specify per distribution, see [General Quotas on Web Distributions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html#limits-web-distributions) in the *Amazon CloudFront Developer Guide* (quotas were formerly referred to as limits).
        :param str domain_name: The domain name for the origin.
                For more information, see [Origin Domain Name](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName) in the *Amazon CloudFront Developer Guide*.
        :param str id: A unique identifier for the origin. This value must be unique within the distribution.
                Use this value to specify the ``TargetOriginId`` in a ``CacheBehavior`` or ``DefaultCacheBehavior``.
        :param int connection_attempts: The number of times that CloudFront attempts to connect to the origin. The minimum number is 1, the maximum is 3, and the default (if you don't specify otherwise) is 3.
                For a custom origin (including an Amazon S3 bucket that's configured with static website hosting), this value also specifies the number of times that CloudFront attempts to get a response from the origin, in the case of an [Origin Response Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout).
                For more information, see [Origin Connection Attempts](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts) in the *Amazon CloudFront Developer Guide*.
        :param int connection_timeout: The number of seconds that CloudFront waits when trying to establish a connection to the origin. The minimum timeout is 1 second, the maximum is 10 seconds, and the default (if you don't specify otherwise) is 10 seconds.
                For more information, see [Origin Connection Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout) in the *Amazon CloudFront Developer Guide*.
        :param 'DistributionCustomOriginConfig' custom_origin_config: Use this type to specify an origin that is not an Amazon S3 bucket, with one exception. If the Amazon S3 bucket is configured with static website hosting, use this type. If the Amazon S3 bucket is not configured with static website hosting, use the ``S3OriginConfig`` type instead.
        :param str origin_access_control_id: The unique identifier of an origin access control for this origin.
                For more information, see [Restricting access to an Amazon S3 origin](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html) in the *Amazon CloudFront Developer Guide*.
        :param Sequence['DistributionOriginCustomHeader'] origin_custom_headers: A list of HTTP header names and values that CloudFront adds to the requests that it sends to the origin.
                For more information, see [Adding Custom Headers to Origin Requests](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html) in the *Amazon CloudFront Developer Guide*.
        :param str origin_path: An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
                For more information, see [Origin Path](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath) in the *Amazon CloudFront Developer Guide*.
        :param 'DistributionOriginShield' origin_shield: CloudFront Origin Shield. Using Origin Shield can help reduce the load on your origin.
                For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the *Amazon CloudFront Developer Guide*.
        :param 'DistributionS3OriginConfig' s3_origin_config: Use this type to specify an origin that is an Amazon S3 bucket that is not configured with static website hosting. To specify any other type of origin, including an Amazon S3 bucket that is configured with static website hosting, use the ``CustomOriginConfig`` type instead.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "id", id)
        if connection_attempts is not None:
            pulumi.set(__self__, "connection_attempts", connection_attempts)
        if connection_timeout is not None:
            pulumi.set(__self__, "connection_timeout", connection_timeout)
        if custom_origin_config is not None:
            pulumi.set(__self__, "custom_origin_config", custom_origin_config)
        if origin_access_control_id is not None:
            pulumi.set(__self__, "origin_access_control_id", origin_access_control_id)
        if origin_custom_headers is not None:
            pulumi.set(__self__, "origin_custom_headers", origin_custom_headers)
        if origin_path is not None:
            pulumi.set(__self__, "origin_path", origin_path)
        if origin_shield is not None:
            pulumi.set(__self__, "origin_shield", origin_shield)
        if s3_origin_config is not None:
            pulumi.set(__self__, "s3_origin_config", s3_origin_config)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        The domain name for the origin.
         For more information, see [Origin Domain Name](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A unique identifier for the origin. This value must be unique within the distribution.
         Use this value to specify the ``TargetOriginId`` in a ``CacheBehavior`` or ``DefaultCacheBehavior``.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="connectionAttempts")
    def connection_attempts(self) -> Optional[int]:
        """
        The number of times that CloudFront attempts to connect to the origin. The minimum number is 1, the maximum is 3, and the default (if you don't specify otherwise) is 3.
         For a custom origin (including an Amazon S3 bucket that's configured with static website hosting), this value also specifies the number of times that CloudFront attempts to get a response from the origin, in the case of an [Origin Response Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout).
         For more information, see [Origin Connection Attempts](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "connection_attempts")

    @property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> Optional[int]:
        """
        The number of seconds that CloudFront waits when trying to establish a connection to the origin. The minimum timeout is 1 second, the maximum is 10 seconds, and the default (if you don't specify otherwise) is 10 seconds.
         For more information, see [Origin Connection Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "connection_timeout")

    @property
    @pulumi.getter(name="customOriginConfig")
    def custom_origin_config(self) -> Optional['outputs.DistributionCustomOriginConfig']:
        """
        Use this type to specify an origin that is not an Amazon S3 bucket, with one exception. If the Amazon S3 bucket is configured with static website hosting, use this type. If the Amazon S3 bucket is not configured with static website hosting, use the ``S3OriginConfig`` type instead.
        """
        return pulumi.get(self, "custom_origin_config")

    @property
    @pulumi.getter(name="originAccessControlId")
    def origin_access_control_id(self) -> Optional[str]:
        """
        The unique identifier of an origin access control for this origin.
         For more information, see [Restricting access to an Amazon S3 origin](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_access_control_id")

    @property
    @pulumi.getter(name="originCustomHeaders")
    def origin_custom_headers(self) -> Optional[Sequence['outputs.DistributionOriginCustomHeader']]:
        """
        A list of HTTP header names and values that CloudFront adds to the requests that it sends to the origin.
         For more information, see [Adding Custom Headers to Origin Requests](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_custom_headers")

    @property
    @pulumi.getter(name="originPath")
    def origin_path(self) -> Optional[str]:
        """
        An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
         For more information, see [Origin Path](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_path")

    @property
    @pulumi.getter(name="originShield")
    def origin_shield(self) -> Optional['outputs.DistributionOriginShield']:
        """
        CloudFront Origin Shield. Using Origin Shield can help reduce the load on your origin.
         For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_shield")

    @property
    @pulumi.getter(name="s3OriginConfig")
    def s3_origin_config(self) -> Optional['outputs.DistributionS3OriginConfig']:
        """
        Use this type to specify an origin that is an Amazon S3 bucket that is not configured with static website hosting. To specify any other type of origin, including an Amazon S3 bucket that is configured with static website hosting, use the ``CustomOriginConfig`` type instead.
        """
        return pulumi.get(self, "s3_origin_config")


@pulumi.output_type
class DistributionOriginCustomHeader(dict):
    """
    A complex type that contains ``HeaderName`` and ``HeaderValue`` elements, if any, for this distribution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"
        elif key == "headerValue":
            suggest = "header_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionOriginCustomHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionOriginCustomHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionOriginCustomHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: str,
                 header_value: str):
        """
        A complex type that contains ``HeaderName`` and ``HeaderValue`` elements, if any, for this distribution.
        :param str header_name: The name of a header that you want CloudFront to send to your origin. For more information, see [Adding Custom Headers to Origin Requests](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html) in the *Amazon CloudFront Developer Guide*.
        :param str header_value: The value for the header that you specified in the ``HeaderName`` field.
        """
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "header_value", header_value)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> str:
        """
        The name of a header that you want CloudFront to send to your origin. For more information, see [Adding Custom Headers to Origin Requests](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> str:
        """
        The value for the header that you specified in the ``HeaderName`` field.
        """
        return pulumi.get(self, "header_value")


@pulumi.output_type
class DistributionOriginGroup(dict):
    """
    An origin group includes two origins (a primary origin and a second origin to failover to) and a failover criteria that you specify. You create an origin group to support origin failover in CloudFront. When you create or update a distribution, you can specify the origin group instead of a single origin, and CloudFront will failover from the primary origin to the second origin under the failover conditions that you've chosen.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverCriteria":
            suggest = "failover_criteria"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionOriginGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionOriginGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionOriginGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failover_criteria: 'outputs.DistributionOriginGroupFailoverCriteria',
                 id: str,
                 members: 'outputs.DistributionOriginGroupMembers'):
        """
        An origin group includes two origins (a primary origin and a second origin to failover to) and a failover criteria that you specify. You create an origin group to support origin failover in CloudFront. When you create or update a distribution, you can specify the origin group instead of a single origin, and CloudFront will failover from the primary origin to the second origin under the failover conditions that you've chosen.
        :param 'DistributionOriginGroupFailoverCriteria' failover_criteria: A complex type that contains information about the failover criteria for an origin group.
        :param str id: The origin group's ID.
        :param 'DistributionOriginGroupMembers' members: A complex type that contains information about the origins in an origin group.
        """
        pulumi.set(__self__, "failover_criteria", failover_criteria)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "members", members)

    @property
    @pulumi.getter(name="failoverCriteria")
    def failover_criteria(self) -> 'outputs.DistributionOriginGroupFailoverCriteria':
        """
        A complex type that contains information about the failover criteria for an origin group.
        """
        return pulumi.get(self, "failover_criteria")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The origin group's ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def members(self) -> 'outputs.DistributionOriginGroupMembers':
        """
        A complex type that contains information about the origins in an origin group.
        """
        return pulumi.get(self, "members")


@pulumi.output_type
class DistributionOriginGroupFailoverCriteria(dict):
    """
    A complex data type that includes information about the failover criteria for an origin group, including the status codes for which CloudFront will failover from the primary origin to the second origin.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCodes":
            suggest = "status_codes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionOriginGroupFailoverCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionOriginGroupFailoverCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionOriginGroupFailoverCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status_codes: 'outputs.DistributionStatusCodes'):
        """
        A complex data type that includes information about the failover criteria for an origin group, including the status codes for which CloudFront will failover from the primary origin to the second origin.
        :param 'DistributionStatusCodes' status_codes: The status codes that, when returned from the primary origin, will trigger CloudFront to failover to the second origin.
        """
        pulumi.set(__self__, "status_codes", status_codes)

    @property
    @pulumi.getter(name="statusCodes")
    def status_codes(self) -> 'outputs.DistributionStatusCodes':
        """
        The status codes that, when returned from the primary origin, will trigger CloudFront to failover to the second origin.
        """
        return pulumi.get(self, "status_codes")


@pulumi.output_type
class DistributionOriginGroupMember(dict):
    """
    An origin in an origin group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "originId":
            suggest = "origin_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionOriginGroupMember. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionOriginGroupMember.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionOriginGroupMember.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 origin_id: str):
        """
        An origin in an origin group.
        :param str origin_id: The ID for an origin in an origin group.
        """
        pulumi.set(__self__, "origin_id", origin_id)

    @property
    @pulumi.getter(name="originId")
    def origin_id(self) -> str:
        """
        The ID for an origin in an origin group.
        """
        return pulumi.get(self, "origin_id")


@pulumi.output_type
class DistributionOriginGroupMembers(dict):
    """
    A complex data type for the origins included in an origin group.
    """
    def __init__(__self__, *,
                 items: Sequence['outputs.DistributionOriginGroupMember'],
                 quantity: int):
        """
        A complex data type for the origins included in an origin group.
        :param Sequence['DistributionOriginGroupMember'] items: Items (origins) in an origin group.
        :param int quantity: The number of origins in an origin group.
        """
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.DistributionOriginGroupMember']:
        """
        Items (origins) in an origin group.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def quantity(self) -> int:
        """
        The number of origins in an origin group.
        """
        return pulumi.get(self, "quantity")


@pulumi.output_type
class DistributionOriginGroups(dict):
    """
    A complex data type for the origin groups specified for a distribution.
    """
    def __init__(__self__, *,
                 quantity: int,
                 items: Optional[Sequence['outputs.DistributionOriginGroup']] = None):
        """
        A complex data type for the origin groups specified for a distribution.
        :param int quantity: The number of origin groups.
        :param Sequence['DistributionOriginGroup'] items: The items (origin groups) in a distribution.
        """
        pulumi.set(__self__, "quantity", quantity)
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def quantity(self) -> int:
        """
        The number of origin groups.
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.DistributionOriginGroup']]:
        """
        The items (origin groups) in a distribution.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class DistributionOriginShield(dict):
    """
    CloudFront Origin Shield.
     Using Origin Shield can help reduce the load on your origin. For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the *Amazon CloudFront Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "originShieldRegion":
            suggest = "origin_shield_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionOriginShield. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionOriginShield.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionOriginShield.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 origin_shield_region: Optional[str] = None):
        """
        CloudFront Origin Shield.
         Using Origin Shield can help reduce the load on your origin. For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the *Amazon CloudFront Developer Guide*.
        :param bool enabled: A flag that specifies whether Origin Shield is enabled.
                When it's enabled, CloudFront routes all requests through Origin Shield, which can help protect your origin. When it's disabled, CloudFront might send requests directly to your origin from multiple edge locations or regional edge caches.
        :param str origin_shield_region: The AWS-Region for Origin Shield.
                Specify the AWS-Region that has the lowest latency to your origin. To specify a region, use the region code, not the region name. For example, specify the US East (Ohio) region as ``us-east-2``.
                When you enable CloudFront Origin Shield, you must specify the AWS-Region for Origin Shield. For the list of AWS-Regions that you can specify, and for help choosing the best Region for your origin, see [Choosing the for Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region) in the *Amazon CloudFront Developer Guide*.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if origin_shield_region is not None:
            pulumi.set(__self__, "origin_shield_region", origin_shield_region)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        A flag that specifies whether Origin Shield is enabled.
         When it's enabled, CloudFront routes all requests through Origin Shield, which can help protect your origin. When it's disabled, CloudFront might send requests directly to your origin from multiple edge locations or regional edge caches.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="originShieldRegion")
    def origin_shield_region(self) -> Optional[str]:
        """
        The AWS-Region for Origin Shield.
         Specify the AWS-Region that has the lowest latency to your origin. To specify a region, use the region code, not the region name. For example, specify the US East (Ohio) region as ``us-east-2``.
         When you enable CloudFront Origin Shield, you must specify the AWS-Region for Origin Shield. For the list of AWS-Regions that you can specify, and for help choosing the best Region for your origin, see [Choosing the for Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_shield_region")


@pulumi.output_type
class DistributionRestrictions(dict):
    """
    A complex type that identifies ways in which you want to restrict distribution of your content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "geoRestriction":
            suggest = "geo_restriction"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionRestrictions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionRestrictions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionRestrictions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 geo_restriction: 'outputs.DistributionGeoRestriction'):
        """
        A complex type that identifies ways in which you want to restrict distribution of your content.
        :param 'DistributionGeoRestriction' geo_restriction: A complex type that controls the countries in which your content is distributed. CF determines the location of your users using ``MaxMind`` GeoIP databases. To disable geo restriction, remove the [Restrictions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-restrictions) property from your stack template.
        """
        pulumi.set(__self__, "geo_restriction", geo_restriction)

    @property
    @pulumi.getter(name="geoRestriction")
    def geo_restriction(self) -> 'outputs.DistributionGeoRestriction':
        """
        A complex type that controls the countries in which your content is distributed. CF determines the location of your users using ``MaxMind`` GeoIP databases. To disable geo restriction, remove the [Restrictions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-restrictions) property from your stack template.
        """
        return pulumi.get(self, "geo_restriction")


@pulumi.output_type
class DistributionS3OriginConfig(dict):
    """
    A complex type that contains information about the Amazon S3 origin. If the origin is a custom origin or an S3 bucket that is configured as a website endpoint, use the ``CustomOriginConfig`` element instead.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "originAccessIdentity":
            suggest = "origin_access_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionS3OriginConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionS3OriginConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionS3OriginConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 origin_access_identity: Optional[str] = None):
        """
        A complex type that contains information about the Amazon S3 origin. If the origin is a custom origin or an S3 bucket that is configured as a website endpoint, use the ``CustomOriginConfig`` element instead.
        :param str origin_access_identity: The CloudFront origin access identity to associate with the origin. Use an origin access identity to configure the origin so that viewers can *only* access objects in an Amazon S3 bucket through CloudFront. The format of the value is:
                origin-access-identity/cloudfront/*ID-of-origin-access-identity* 
                where ``ID-of-origin-access-identity`` is the value that CloudFront returned in the ``ID`` element when you created the origin access identity.
                If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify an empty ``OriginAccessIdentity`` element.
                To delete the origin access identity from an existing distribution, update the distribution configuration and include an empty ``OriginAccessIdentity`` element.
                To replace the origin access identity, update the distribution configuration and specify the new origin access identity.
                For more information about the origin access identity, see [Serving Private Content through CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        if origin_access_identity is not None:
            pulumi.set(__self__, "origin_access_identity", origin_access_identity)

    @property
    @pulumi.getter(name="originAccessIdentity")
    def origin_access_identity(self) -> Optional[str]:
        """
        The CloudFront origin access identity to associate with the origin. Use an origin access identity to configure the origin so that viewers can *only* access objects in an Amazon S3 bucket through CloudFront. The format of the value is:
         origin-access-identity/cloudfront/*ID-of-origin-access-identity* 
         where ``ID-of-origin-access-identity`` is the value that CloudFront returned in the ``ID`` element when you created the origin access identity.
         If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify an empty ``OriginAccessIdentity`` element.
         To delete the origin access identity from an existing distribution, update the distribution configuration and include an empty ``OriginAccessIdentity`` element.
         To replace the origin access identity, update the distribution configuration and specify the new origin access identity.
         For more information about the origin access identity, see [Serving Private Content through CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
        """
        return pulumi.get(self, "origin_access_identity")


@pulumi.output_type
class DistributionStatusCodes(dict):
    """
    A complex data type for the status codes that you specify that, when returned by a primary origin, trigger CloudFront to failover to a second origin.
    """
    def __init__(__self__, *,
                 items: Sequence[int],
                 quantity: int):
        """
        A complex data type for the status codes that you specify that, when returned by a primary origin, trigger CloudFront to failover to a second origin.
        :param Sequence[int] items: The items (status codes) for an origin group.
        :param int quantity: The number of status codes.
        """
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def items(self) -> Sequence[int]:
        """
        The items (status codes) for an origin group.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def quantity(self) -> int:
        """
        The number of status codes.
        """
        return pulumi.get(self, "quantity")


@pulumi.output_type
class DistributionViewerCertificate(dict):
    """
    A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
     If the distribution doesn't use ``Aliases`` (also known as alternate domain names or CNAMEs)—that is, if the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net``—set ``CloudFrontDefaultCertificate`` to ``true`` and leave all other fields empty.
     If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), use the fields in this type to specify the following settings:
      +  Which viewers the distribution accepts HTTPS connections from: only viewers that support [server name indication (SNI)](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Server_Name_Indication) (recommended), or all viewers including those that don't support SNI.
      +  To accept HTTPS connections from only viewers that support SNI, set ``SSLSupportMethod`` to ``sni-only``. This is recommended. Most browsers and clients support SNI. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
      +  To accept HTTPS connections from all viewers, including those that don't support SNI, set ``SSLSupportMethod`` to ``vip``. This is not recommended, and results in additional monthly charges from CloudFront. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
      
      +  The minimum SSL/TLS protocol version that the distribution can use to communicate with viewers. To specify a minimum version, choose a value for ``MinimumProtocolVersion``. For more information, see [Security Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy) in the *Amazon CloudFront Developer Guide*.
      +  The location of the SSL/TLS certificate, [(ACM)](https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html) (recommended) or [(IAM)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html). You specify the location by setting a value in one of the following fields (not both):
      +   ``ACMCertificateArn`` (In CloudFormation, this field name is ``AcmCertificateArn``. Note the different capitalization.)
      +   ``IAMCertificateId`` (In CloudFormation, this field name is ``IamCertificateId``. Note the different capitalization.)
      
      
     All distributions support HTTPS connections from viewers. To require viewers to use HTTPS only, or to redirect them from HTTP to HTTPS, use ``ViewerProtocolPolicy`` in the ``CacheBehavior`` or ``DefaultCacheBehavior``. To specify how CloudFront should use SSL/TLS to communicate with your custom origin, use ``CustomOriginConfig``.
     For more information, see [Using HTTPS with CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https.html) and [Using Alternate Domain Names and HTTPS](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-alternate-domain-names.html) in the *Amazon CloudFront Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acmCertificateArn":
            suggest = "acm_certificate_arn"
        elif key == "cloudFrontDefaultCertificate":
            suggest = "cloud_front_default_certificate"
        elif key == "iamCertificateId":
            suggest = "iam_certificate_id"
        elif key == "minimumProtocolVersion":
            suggest = "minimum_protocol_version"
        elif key == "sslSupportMethod":
            suggest = "ssl_support_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionViewerCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionViewerCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionViewerCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acm_certificate_arn: Optional[str] = None,
                 cloud_front_default_certificate: Optional[bool] = None,
                 iam_certificate_id: Optional[str] = None,
                 minimum_protocol_version: Optional[str] = None,
                 ssl_support_method: Optional[str] = None):
        """
        A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
         If the distribution doesn't use ``Aliases`` (also known as alternate domain names or CNAMEs)—that is, if the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net``—set ``CloudFrontDefaultCertificate`` to ``true`` and leave all other fields empty.
         If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), use the fields in this type to specify the following settings:
          +  Which viewers the distribution accepts HTTPS connections from: only viewers that support [server name indication (SNI)](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Server_Name_Indication) (recommended), or all viewers including those that don't support SNI.
          +  To accept HTTPS connections from only viewers that support SNI, set ``SSLSupportMethod`` to ``sni-only``. This is recommended. Most browsers and clients support SNI. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
          +  To accept HTTPS connections from all viewers, including those that don't support SNI, set ``SSLSupportMethod`` to ``vip``. This is not recommended, and results in additional monthly charges from CloudFront. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
          
          +  The minimum SSL/TLS protocol version that the distribution can use to communicate with viewers. To specify a minimum version, choose a value for ``MinimumProtocolVersion``. For more information, see [Security Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy) in the *Amazon CloudFront Developer Guide*.
          +  The location of the SSL/TLS certificate, [(ACM)](https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html) (recommended) or [(IAM)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html). You specify the location by setting a value in one of the following fields (not both):
          +   ``ACMCertificateArn`` (In CloudFormation, this field name is ``AcmCertificateArn``. Note the different capitalization.)
          +   ``IAMCertificateId`` (In CloudFormation, this field name is ``IamCertificateId``. Note the different capitalization.)
          
          
         All distributions support HTTPS connections from viewers. To require viewers to use HTTPS only, or to redirect them from HTTP to HTTPS, use ``ViewerProtocolPolicy`` in the ``CacheBehavior`` or ``DefaultCacheBehavior``. To specify how CloudFront should use SSL/TLS to communicate with your custom origin, use ``CustomOriginConfig``.
         For more information, see [Using HTTPS with CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https.html) and [Using Alternate Domain Names and HTTPS](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-alternate-domain-names.html) in the *Amazon CloudFront Developer Guide*.
        :param str acm_certificate_arn: In CloudFormation, this field name is ``AcmCertificateArn``. Note the different capitalization.
                 If the distribution uses ``Aliases`` (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in [(ACM)](https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html), provide the Amazon Resource Name (ARN) of the ACM certificate. CloudFront only supports ACM certificates in the US East (N. Virginia) Region (``us-east-1``).
                If you specify an ACM certificate ARN, you must also specify values for ``MinimumProtocolVersion`` and ``SSLSupportMethod``. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
        :param bool cloud_front_default_certificate: If the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net``, set this field to ``true``.
                If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), omit this field and specify values for the following fields:
                 +   ``AcmCertificateArn`` or ``IamCertificateId`` (specify a value for one, not both) 
                 +   ``MinimumProtocolVersion`` 
                 +   ``SslSupportMethod``
        :param str iam_certificate_id: In CloudFormation, this field name is ``IamCertificateId``. Note the different capitalization.
                 If the distribution uses ``Aliases`` (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in [(IAM)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html), provide the ID of the IAM certificate.
                If you specify an IAM certificate ID, you must also specify values for ``MinimumProtocolVersion`` and ``SSLSupportMethod``. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
        :param str minimum_protocol_version: If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), specify the security policy that you want CloudFront to use for HTTPS connections with viewers. The security policy determines two settings:
                 +  The minimum SSL/TLS protocol that CloudFront can use to communicate with viewers.
                 +  The ciphers that CloudFront can use to encrypt the content that it returns to viewers.
                 
                For more information, see [Security Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy) and [Supported Protocols and Ciphers Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html#secure-connections-supported-ciphers) in the *Amazon CloudFront Developer Guide*.
                 On the CloudFront console, this setting is called *Security Policy*.
                 When you're using SNI only (you set ``SSLSupportMethod`` to ``sni-only``), you must specify ``TLSv1`` or higher. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
                If the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net`` (you set ``CloudFrontDefaultCertificate`` to ``true``), CloudFront automatically sets the security policy to ``TLSv1`` regardless of the value that you set here.
        :param str ssl_support_method: In CloudFormation, this field name is ``SslSupportMethod``. Note the different capitalization.
                 If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), specify which viewers the distribution accepts HTTPS connections from.
                 +   ``sni-only`` – The distribution accepts HTTPS connections from only viewers that support [server name indication (SNI)](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Server_Name_Indication). This is recommended. Most browsers and clients support SNI.
                 +   ``vip`` – The distribution accepts HTTPS connections from all viewers including those that don't support SNI. This is not recommended, and results in additional monthly charges from CloudFront.
                 +   ``static-ip`` - Do not specify this value unless your distribution has been enabled for this feature by the CloudFront team. If you have a use case that requires static IP addresses for a distribution, contact CloudFront through the [Center](https://docs.aws.amazon.com/support/home).
                 
                If the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net``, don't set a value for this field.
        """
        if acm_certificate_arn is not None:
            pulumi.set(__self__, "acm_certificate_arn", acm_certificate_arn)
        if cloud_front_default_certificate is not None:
            pulumi.set(__self__, "cloud_front_default_certificate", cloud_front_default_certificate)
        if iam_certificate_id is not None:
            pulumi.set(__self__, "iam_certificate_id", iam_certificate_id)
        if minimum_protocol_version is not None:
            pulumi.set(__self__, "minimum_protocol_version", minimum_protocol_version)
        if ssl_support_method is not None:
            pulumi.set(__self__, "ssl_support_method", ssl_support_method)

    @property
    @pulumi.getter(name="acmCertificateArn")
    def acm_certificate_arn(self) -> Optional[str]:
        """
        In CloudFormation, this field name is ``AcmCertificateArn``. Note the different capitalization.
          If the distribution uses ``Aliases`` (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in [(ACM)](https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html), provide the Amazon Resource Name (ARN) of the ACM certificate. CloudFront only supports ACM certificates in the US East (N. Virginia) Region (``us-east-1``).
         If you specify an ACM certificate ARN, you must also specify values for ``MinimumProtocolVersion`` and ``SSLSupportMethod``. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
        """
        return pulumi.get(self, "acm_certificate_arn")

    @property
    @pulumi.getter(name="cloudFrontDefaultCertificate")
    def cloud_front_default_certificate(self) -> Optional[bool]:
        """
        If the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net``, set this field to ``true``.
         If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), omit this field and specify values for the following fields:
          +   ``AcmCertificateArn`` or ``IamCertificateId`` (specify a value for one, not both) 
          +   ``MinimumProtocolVersion`` 
          +   ``SslSupportMethod``
        """
        return pulumi.get(self, "cloud_front_default_certificate")

    @property
    @pulumi.getter(name="iamCertificateId")
    def iam_certificate_id(self) -> Optional[str]:
        """
        In CloudFormation, this field name is ``IamCertificateId``. Note the different capitalization.
          If the distribution uses ``Aliases`` (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in [(IAM)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html), provide the ID of the IAM certificate.
         If you specify an IAM certificate ID, you must also specify values for ``MinimumProtocolVersion`` and ``SSLSupportMethod``. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
        """
        return pulumi.get(self, "iam_certificate_id")

    @property
    @pulumi.getter(name="minimumProtocolVersion")
    def minimum_protocol_version(self) -> Optional[str]:
        """
        If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), specify the security policy that you want CloudFront to use for HTTPS connections with viewers. The security policy determines two settings:
          +  The minimum SSL/TLS protocol that CloudFront can use to communicate with viewers.
          +  The ciphers that CloudFront can use to encrypt the content that it returns to viewers.
          
         For more information, see [Security Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy) and [Supported Protocols and Ciphers Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html#secure-connections-supported-ciphers) in the *Amazon CloudFront Developer Guide*.
          On the CloudFront console, this setting is called *Security Policy*.
          When you're using SNI only (you set ``SSLSupportMethod`` to ``sni-only``), you must specify ``TLSv1`` or higher. (In CloudFormation, the field name is ``SslSupportMethod``. Note the different capitalization.)
         If the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net`` (you set ``CloudFrontDefaultCertificate`` to ``true``), CloudFront automatically sets the security policy to ``TLSv1`` regardless of the value that you set here.
        """
        return pulumi.get(self, "minimum_protocol_version")

    @property
    @pulumi.getter(name="sslSupportMethod")
    def ssl_support_method(self) -> Optional[str]:
        """
        In CloudFormation, this field name is ``SslSupportMethod``. Note the different capitalization.
          If the distribution uses ``Aliases`` (alternate domain names or CNAMEs), specify which viewers the distribution accepts HTTPS connections from.
          +   ``sni-only`` – The distribution accepts HTTPS connections from only viewers that support [server name indication (SNI)](https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Server_Name_Indication). This is recommended. Most browsers and clients support SNI.
          +   ``vip`` – The distribution accepts HTTPS connections from all viewers including those that don't support SNI. This is not recommended, and results in additional monthly charges from CloudFront.
          +   ``static-ip`` - Do not specify this value unless your distribution has been enabled for this feature by the CloudFront team. If you have a use case that requires static IP addresses for a distribution, contact CloudFront through the [Center](https://docs.aws.amazon.com/support/home).
          
         If the distribution uses the CloudFront domain name such as ``d111111abcdef8.cloudfront.net``, don't set a value for this field.
        """
        return pulumi.get(self, "ssl_support_method")


@pulumi.output_type
class FunctionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyValueStoreAssociations":
            suggest = "key_value_store_associations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 comment: str,
                 runtime: str,
                 key_value_store_associations: Optional[Sequence['outputs.FunctionKeyValueStoreAssociation']] = None):
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "runtime", runtime)
        if key_value_store_associations is not None:
            pulumi.set(__self__, "key_value_store_associations", key_value_store_associations)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def runtime(self) -> str:
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="keyValueStoreAssociations")
    def key_value_store_associations(self) -> Optional[Sequence['outputs.FunctionKeyValueStoreAssociation']]:
        return pulumi.get(self, "key_value_store_associations")


@pulumi.output_type
class FunctionKeyValueStoreAssociation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyValueStoreArn":
            suggest = "key_value_store_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionKeyValueStoreAssociation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionKeyValueStoreAssociation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionKeyValueStoreAssociation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_value_store_arn: str):
        pulumi.set(__self__, "key_value_store_arn", key_value_store_arn)

    @property
    @pulumi.getter(name="keyValueStoreArn")
    def key_value_store_arn(self) -> str:
        return pulumi.get(self, "key_value_store_arn")


@pulumi.output_type
class FunctionMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionArn":
            suggest = "function_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_arn: Optional[str] = None):
        if function_arn is not None:
            pulumi.set(__self__, "function_arn", function_arn)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> Optional[str]:
        return pulumi.get(self, "function_arn")


@pulumi.output_type
class KeyGroupConfig(dict):
    def __init__(__self__, *,
                 items: Sequence[str],
                 name: str,
                 comment: Optional[str] = None):
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter
    def items(self) -> Sequence[str]:
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        return pulumi.get(self, "comment")


@pulumi.output_type
class KeyValueStoreImportSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceArn":
            suggest = "source_arn"
        elif key == "sourceType":
            suggest = "source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyValueStoreImportSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyValueStoreImportSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyValueStoreImportSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_arn: str,
                 source_type: str):
        pulumi.set(__self__, "source_arn", source_arn)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> str:
        return pulumi.get(self, "source_arn")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        return pulumi.get(self, "source_type")


@pulumi.output_type
class MonitoringSubscription(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "realtimeMetricsSubscriptionConfig":
            suggest = "realtime_metrics_subscription_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringSubscription. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringSubscription.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringSubscription.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 realtime_metrics_subscription_config: Optional['outputs.MonitoringSubscriptionRealtimeMetricsSubscriptionConfig'] = None):
        if realtime_metrics_subscription_config is not None:
            pulumi.set(__self__, "realtime_metrics_subscription_config", realtime_metrics_subscription_config)

    @property
    @pulumi.getter(name="realtimeMetricsSubscriptionConfig")
    def realtime_metrics_subscription_config(self) -> Optional['outputs.MonitoringSubscriptionRealtimeMetricsSubscriptionConfig']:
        return pulumi.get(self, "realtime_metrics_subscription_config")


@pulumi.output_type
class MonitoringSubscriptionRealtimeMetricsSubscriptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "realtimeMetricsSubscriptionStatus":
            suggest = "realtime_metrics_subscription_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringSubscriptionRealtimeMetricsSubscriptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringSubscriptionRealtimeMetricsSubscriptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringSubscriptionRealtimeMetricsSubscriptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 realtime_metrics_subscription_status: 'MonitoringSubscriptionRealtimeMetricsSubscriptionConfigRealtimeMetricsSubscriptionStatus'):
        pulumi.set(__self__, "realtime_metrics_subscription_status", realtime_metrics_subscription_status)

    @property
    @pulumi.getter(name="realtimeMetricsSubscriptionStatus")
    def realtime_metrics_subscription_status(self) -> 'MonitoringSubscriptionRealtimeMetricsSubscriptionConfigRealtimeMetricsSubscriptionStatus':
        return pulumi.get(self, "realtime_metrics_subscription_status")


@pulumi.output_type
class OriginAccessControlConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "originAccessControlOriginType":
            suggest = "origin_access_control_origin_type"
        elif key == "signingBehavior":
            suggest = "signing_behavior"
        elif key == "signingProtocol":
            suggest = "signing_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginAccessControlConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginAccessControlConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginAccessControlConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 origin_access_control_origin_type: str,
                 signing_behavior: str,
                 signing_protocol: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "origin_access_control_origin_type", origin_access_control_origin_type)
        pulumi.set(__self__, "signing_behavior", signing_behavior)
        pulumi.set(__self__, "signing_protocol", signing_protocol)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="originAccessControlOriginType")
    def origin_access_control_origin_type(self) -> str:
        return pulumi.get(self, "origin_access_control_origin_type")

    @property
    @pulumi.getter(name="signingBehavior")
    def signing_behavior(self) -> str:
        return pulumi.get(self, "signing_behavior")

    @property
    @pulumi.getter(name="signingProtocol")
    def signing_protocol(self) -> str:
        return pulumi.get(self, "signing_protocol")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class OriginRequestPolicyConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookiesConfig":
            suggest = "cookies_config"
        elif key == "headersConfig":
            suggest = "headers_config"
        elif key == "queryStringsConfig":
            suggest = "query_strings_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginRequestPolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginRequestPolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginRequestPolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookies_config: 'outputs.OriginRequestPolicyCookiesConfig',
                 headers_config: 'outputs.OriginRequestPolicyHeadersConfig',
                 name: str,
                 query_strings_config: 'outputs.OriginRequestPolicyQueryStringsConfig',
                 comment: Optional[str] = None):
        pulumi.set(__self__, "cookies_config", cookies_config)
        pulumi.set(__self__, "headers_config", headers_config)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "query_strings_config", query_strings_config)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter(name="cookiesConfig")
    def cookies_config(self) -> 'outputs.OriginRequestPolicyCookiesConfig':
        return pulumi.get(self, "cookies_config")

    @property
    @pulumi.getter(name="headersConfig")
    def headers_config(self) -> 'outputs.OriginRequestPolicyHeadersConfig':
        return pulumi.get(self, "headers_config")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="queryStringsConfig")
    def query_strings_config(self) -> 'outputs.OriginRequestPolicyQueryStringsConfig':
        return pulumi.get(self, "query_strings_config")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        return pulumi.get(self, "comment")


@pulumi.output_type
class OriginRequestPolicyCookiesConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieBehavior":
            suggest = "cookie_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginRequestPolicyCookiesConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginRequestPolicyCookiesConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginRequestPolicyCookiesConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookie_behavior: str,
                 cookies: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "cookie_behavior", cookie_behavior)
        if cookies is not None:
            pulumi.set(__self__, "cookies", cookies)

    @property
    @pulumi.getter(name="cookieBehavior")
    def cookie_behavior(self) -> str:
        return pulumi.get(self, "cookie_behavior")

    @property
    @pulumi.getter
    def cookies(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "cookies")


@pulumi.output_type
class OriginRequestPolicyHeadersConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerBehavior":
            suggest = "header_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginRequestPolicyHeadersConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginRequestPolicyHeadersConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginRequestPolicyHeadersConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_behavior: str,
                 headers: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "header_behavior", header_behavior)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)

    @property
    @pulumi.getter(name="headerBehavior")
    def header_behavior(self) -> str:
        return pulumi.get(self, "header_behavior")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "headers")


@pulumi.output_type
class OriginRequestPolicyQueryStringsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryStringBehavior":
            suggest = "query_string_behavior"
        elif key == "queryStrings":
            suggest = "query_strings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginRequestPolicyQueryStringsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginRequestPolicyQueryStringsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginRequestPolicyQueryStringsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_string_behavior: str,
                 query_strings: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "query_string_behavior", query_string_behavior)
        if query_strings is not None:
            pulumi.set(__self__, "query_strings", query_strings)

    @property
    @pulumi.getter(name="queryStringBehavior")
    def query_string_behavior(self) -> str:
        return pulumi.get(self, "query_string_behavior")

    @property
    @pulumi.getter(name="queryStrings")
    def query_strings(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "query_strings")


@pulumi.output_type
class PublicKeyConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callerReference":
            suggest = "caller_reference"
        elif key == "encodedKey":
            suggest = "encoded_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublicKeyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublicKeyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublicKeyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 caller_reference: str,
                 encoded_key: str,
                 name: str,
                 comment: Optional[str] = None):
        pulumi.set(__self__, "caller_reference", caller_reference)
        pulumi.set(__self__, "encoded_key", encoded_key)
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter(name="callerReference")
    def caller_reference(self) -> str:
        return pulumi.get(self, "caller_reference")

    @property
    @pulumi.getter(name="encodedKey")
    def encoded_key(self) -> str:
        return pulumi.get(self, "encoded_key")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        return pulumi.get(self, "comment")


@pulumi.output_type
class RealtimeLogConfigEndPoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kinesisStreamConfig":
            suggest = "kinesis_stream_config"
        elif key == "streamType":
            suggest = "stream_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RealtimeLogConfigEndPoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RealtimeLogConfigEndPoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RealtimeLogConfigEndPoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kinesis_stream_config: 'outputs.RealtimeLogConfigKinesisStreamConfig',
                 stream_type: str):
        pulumi.set(__self__, "kinesis_stream_config", kinesis_stream_config)
        pulumi.set(__self__, "stream_type", stream_type)

    @property
    @pulumi.getter(name="kinesisStreamConfig")
    def kinesis_stream_config(self) -> 'outputs.RealtimeLogConfigKinesisStreamConfig':
        return pulumi.get(self, "kinesis_stream_config")

    @property
    @pulumi.getter(name="streamType")
    def stream_type(self) -> str:
        return pulumi.get(self, "stream_type")


@pulumi.output_type
class RealtimeLogConfigKinesisStreamConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "streamArn":
            suggest = "stream_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RealtimeLogConfigKinesisStreamConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RealtimeLogConfigKinesisStreamConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RealtimeLogConfigKinesisStreamConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: str,
                 stream_arn: str):
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "stream_arn", stream_arn)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> str:
        return pulumi.get(self, "stream_arn")


@pulumi.output_type
class ResponseHeadersPolicyAccessControlAllowHeaders(dict):
    def __init__(__self__, *,
                 items: Sequence[str]):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence[str]:
        return pulumi.get(self, "items")


@pulumi.output_type
class ResponseHeadersPolicyAccessControlAllowMethods(dict):
    def __init__(__self__, *,
                 items: Sequence[str]):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence[str]:
        return pulumi.get(self, "items")


@pulumi.output_type
class ResponseHeadersPolicyAccessControlAllowOrigins(dict):
    def __init__(__self__, *,
                 items: Sequence[str]):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence[str]:
        return pulumi.get(self, "items")


@pulumi.output_type
class ResponseHeadersPolicyAccessControlExposeHeaders(dict):
    def __init__(__self__, *,
                 items: Sequence[str]):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence[str]:
        return pulumi.get(self, "items")


@pulumi.output_type
class ResponseHeadersPolicyConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "corsConfig":
            suggest = "cors_config"
        elif key == "customHeadersConfig":
            suggest = "custom_headers_config"
        elif key == "removeHeadersConfig":
            suggest = "remove_headers_config"
        elif key == "securityHeadersConfig":
            suggest = "security_headers_config"
        elif key == "serverTimingHeadersConfig":
            suggest = "server_timing_headers_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 comment: Optional[str] = None,
                 cors_config: Optional['outputs.ResponseHeadersPolicyCorsConfig'] = None,
                 custom_headers_config: Optional['outputs.ResponseHeadersPolicyCustomHeadersConfig'] = None,
                 remove_headers_config: Optional['outputs.ResponseHeadersPolicyRemoveHeadersConfig'] = None,
                 security_headers_config: Optional['outputs.ResponseHeadersPolicySecurityHeadersConfig'] = None,
                 server_timing_headers_config: Optional['outputs.ResponseHeadersPolicyServerTimingHeadersConfig'] = None):
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if cors_config is not None:
            pulumi.set(__self__, "cors_config", cors_config)
        if custom_headers_config is not None:
            pulumi.set(__self__, "custom_headers_config", custom_headers_config)
        if remove_headers_config is not None:
            pulumi.set(__self__, "remove_headers_config", remove_headers_config)
        if security_headers_config is not None:
            pulumi.set(__self__, "security_headers_config", security_headers_config)
        if server_timing_headers_config is not None:
            pulumi.set(__self__, "server_timing_headers_config", server_timing_headers_config)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="corsConfig")
    def cors_config(self) -> Optional['outputs.ResponseHeadersPolicyCorsConfig']:
        return pulumi.get(self, "cors_config")

    @property
    @pulumi.getter(name="customHeadersConfig")
    def custom_headers_config(self) -> Optional['outputs.ResponseHeadersPolicyCustomHeadersConfig']:
        return pulumi.get(self, "custom_headers_config")

    @property
    @pulumi.getter(name="removeHeadersConfig")
    def remove_headers_config(self) -> Optional['outputs.ResponseHeadersPolicyRemoveHeadersConfig']:
        return pulumi.get(self, "remove_headers_config")

    @property
    @pulumi.getter(name="securityHeadersConfig")
    def security_headers_config(self) -> Optional['outputs.ResponseHeadersPolicySecurityHeadersConfig']:
        return pulumi.get(self, "security_headers_config")

    @property
    @pulumi.getter(name="serverTimingHeadersConfig")
    def server_timing_headers_config(self) -> Optional['outputs.ResponseHeadersPolicyServerTimingHeadersConfig']:
        return pulumi.get(self, "server_timing_headers_config")


@pulumi.output_type
class ResponseHeadersPolicyContentSecurityPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentSecurityPolicy":
            suggest = "content_security_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyContentSecurityPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyContentSecurityPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyContentSecurityPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_security_policy: str,
                 override: bool):
        pulumi.set(__self__, "content_security_policy", content_security_policy)
        pulumi.set(__self__, "override", override)

    @property
    @pulumi.getter(name="contentSecurityPolicy")
    def content_security_policy(self) -> str:
        return pulumi.get(self, "content_security_policy")

    @property
    @pulumi.getter
    def override(self) -> bool:
        return pulumi.get(self, "override")


@pulumi.output_type
class ResponseHeadersPolicyContentTypeOptions(dict):
    def __init__(__self__, *,
                 override: bool):
        pulumi.set(__self__, "override", override)

    @property
    @pulumi.getter
    def override(self) -> bool:
        return pulumi.get(self, "override")


@pulumi.output_type
class ResponseHeadersPolicyCorsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessControlAllowCredentials":
            suggest = "access_control_allow_credentials"
        elif key == "accessControlAllowHeaders":
            suggest = "access_control_allow_headers"
        elif key == "accessControlAllowMethods":
            suggest = "access_control_allow_methods"
        elif key == "accessControlAllowOrigins":
            suggest = "access_control_allow_origins"
        elif key == "originOverride":
            suggest = "origin_override"
        elif key == "accessControlExposeHeaders":
            suggest = "access_control_expose_headers"
        elif key == "accessControlMaxAgeSec":
            suggest = "access_control_max_age_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyCorsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyCorsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyCorsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_control_allow_credentials: bool,
                 access_control_allow_headers: 'outputs.ResponseHeadersPolicyAccessControlAllowHeaders',
                 access_control_allow_methods: 'outputs.ResponseHeadersPolicyAccessControlAllowMethods',
                 access_control_allow_origins: 'outputs.ResponseHeadersPolicyAccessControlAllowOrigins',
                 origin_override: bool,
                 access_control_expose_headers: Optional['outputs.ResponseHeadersPolicyAccessControlExposeHeaders'] = None,
                 access_control_max_age_sec: Optional[int] = None):
        pulumi.set(__self__, "access_control_allow_credentials", access_control_allow_credentials)
        pulumi.set(__self__, "access_control_allow_headers", access_control_allow_headers)
        pulumi.set(__self__, "access_control_allow_methods", access_control_allow_methods)
        pulumi.set(__self__, "access_control_allow_origins", access_control_allow_origins)
        pulumi.set(__self__, "origin_override", origin_override)
        if access_control_expose_headers is not None:
            pulumi.set(__self__, "access_control_expose_headers", access_control_expose_headers)
        if access_control_max_age_sec is not None:
            pulumi.set(__self__, "access_control_max_age_sec", access_control_max_age_sec)

    @property
    @pulumi.getter(name="accessControlAllowCredentials")
    def access_control_allow_credentials(self) -> bool:
        return pulumi.get(self, "access_control_allow_credentials")

    @property
    @pulumi.getter(name="accessControlAllowHeaders")
    def access_control_allow_headers(self) -> 'outputs.ResponseHeadersPolicyAccessControlAllowHeaders':
        return pulumi.get(self, "access_control_allow_headers")

    @property
    @pulumi.getter(name="accessControlAllowMethods")
    def access_control_allow_methods(self) -> 'outputs.ResponseHeadersPolicyAccessControlAllowMethods':
        return pulumi.get(self, "access_control_allow_methods")

    @property
    @pulumi.getter(name="accessControlAllowOrigins")
    def access_control_allow_origins(self) -> 'outputs.ResponseHeadersPolicyAccessControlAllowOrigins':
        return pulumi.get(self, "access_control_allow_origins")

    @property
    @pulumi.getter(name="originOverride")
    def origin_override(self) -> bool:
        return pulumi.get(self, "origin_override")

    @property
    @pulumi.getter(name="accessControlExposeHeaders")
    def access_control_expose_headers(self) -> Optional['outputs.ResponseHeadersPolicyAccessControlExposeHeaders']:
        return pulumi.get(self, "access_control_expose_headers")

    @property
    @pulumi.getter(name="accessControlMaxAgeSec")
    def access_control_max_age_sec(self) -> Optional[int]:
        return pulumi.get(self, "access_control_max_age_sec")


@pulumi.output_type
class ResponseHeadersPolicyCustomHeader(dict):
    def __init__(__self__, *,
                 header: str,
                 override: bool,
                 value: str):
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "override", override)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def header(self) -> str:
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def override(self) -> bool:
        return pulumi.get(self, "override")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class ResponseHeadersPolicyCustomHeadersConfig(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.ResponseHeadersPolicyCustomHeader']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.ResponseHeadersPolicyCustomHeader']:
        return pulumi.get(self, "items")


@pulumi.output_type
class ResponseHeadersPolicyFrameOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "frameOption":
            suggest = "frame_option"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyFrameOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyFrameOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyFrameOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 frame_option: str,
                 override: bool):
        pulumi.set(__self__, "frame_option", frame_option)
        pulumi.set(__self__, "override", override)

    @property
    @pulumi.getter(name="frameOption")
    def frame_option(self) -> str:
        return pulumi.get(self, "frame_option")

    @property
    @pulumi.getter
    def override(self) -> bool:
        return pulumi.get(self, "override")


@pulumi.output_type
class ResponseHeadersPolicyReferrerPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "referrerPolicy":
            suggest = "referrer_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyReferrerPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyReferrerPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyReferrerPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 override: bool,
                 referrer_policy: str):
        pulumi.set(__self__, "override", override)
        pulumi.set(__self__, "referrer_policy", referrer_policy)

    @property
    @pulumi.getter
    def override(self) -> bool:
        return pulumi.get(self, "override")

    @property
    @pulumi.getter(name="referrerPolicy")
    def referrer_policy(self) -> str:
        return pulumi.get(self, "referrer_policy")


@pulumi.output_type
class ResponseHeadersPolicyRemoveHeader(dict):
    def __init__(__self__, *,
                 header: str):
        pulumi.set(__self__, "header", header)

    @property
    @pulumi.getter
    def header(self) -> str:
        return pulumi.get(self, "header")


@pulumi.output_type
class ResponseHeadersPolicyRemoveHeadersConfig(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.ResponseHeadersPolicyRemoveHeader']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.ResponseHeadersPolicyRemoveHeader']:
        return pulumi.get(self, "items")


@pulumi.output_type
class ResponseHeadersPolicySecurityHeadersConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentSecurityPolicy":
            suggest = "content_security_policy"
        elif key == "contentTypeOptions":
            suggest = "content_type_options"
        elif key == "frameOptions":
            suggest = "frame_options"
        elif key == "referrerPolicy":
            suggest = "referrer_policy"
        elif key == "strictTransportSecurity":
            suggest = "strict_transport_security"
        elif key == "xssProtection":
            suggest = "xss_protection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicySecurityHeadersConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicySecurityHeadersConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicySecurityHeadersConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_security_policy: Optional['outputs.ResponseHeadersPolicyContentSecurityPolicy'] = None,
                 content_type_options: Optional['outputs.ResponseHeadersPolicyContentTypeOptions'] = None,
                 frame_options: Optional['outputs.ResponseHeadersPolicyFrameOptions'] = None,
                 referrer_policy: Optional['outputs.ResponseHeadersPolicyReferrerPolicy'] = None,
                 strict_transport_security: Optional['outputs.ResponseHeadersPolicyStrictTransportSecurity'] = None,
                 xss_protection: Optional['outputs.ResponseHeadersPolicyXssProtection'] = None):
        if content_security_policy is not None:
            pulumi.set(__self__, "content_security_policy", content_security_policy)
        if content_type_options is not None:
            pulumi.set(__self__, "content_type_options", content_type_options)
        if frame_options is not None:
            pulumi.set(__self__, "frame_options", frame_options)
        if referrer_policy is not None:
            pulumi.set(__self__, "referrer_policy", referrer_policy)
        if strict_transport_security is not None:
            pulumi.set(__self__, "strict_transport_security", strict_transport_security)
        if xss_protection is not None:
            pulumi.set(__self__, "xss_protection", xss_protection)

    @property
    @pulumi.getter(name="contentSecurityPolicy")
    def content_security_policy(self) -> Optional['outputs.ResponseHeadersPolicyContentSecurityPolicy']:
        return pulumi.get(self, "content_security_policy")

    @property
    @pulumi.getter(name="contentTypeOptions")
    def content_type_options(self) -> Optional['outputs.ResponseHeadersPolicyContentTypeOptions']:
        return pulumi.get(self, "content_type_options")

    @property
    @pulumi.getter(name="frameOptions")
    def frame_options(self) -> Optional['outputs.ResponseHeadersPolicyFrameOptions']:
        return pulumi.get(self, "frame_options")

    @property
    @pulumi.getter(name="referrerPolicy")
    def referrer_policy(self) -> Optional['outputs.ResponseHeadersPolicyReferrerPolicy']:
        return pulumi.get(self, "referrer_policy")

    @property
    @pulumi.getter(name="strictTransportSecurity")
    def strict_transport_security(self) -> Optional['outputs.ResponseHeadersPolicyStrictTransportSecurity']:
        return pulumi.get(self, "strict_transport_security")

    @property
    @pulumi.getter(name="xssProtection")
    def xss_protection(self) -> Optional['outputs.ResponseHeadersPolicyXssProtection']:
        return pulumi.get(self, "xss_protection")


@pulumi.output_type
class ResponseHeadersPolicyServerTimingHeadersConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "samplingRate":
            suggest = "sampling_rate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyServerTimingHeadersConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyServerTimingHeadersConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyServerTimingHeadersConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 sampling_rate: Optional[float] = None):
        pulumi.set(__self__, "enabled", enabled)
        if sampling_rate is not None:
            pulumi.set(__self__, "sampling_rate", sampling_rate)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="samplingRate")
    def sampling_rate(self) -> Optional[float]:
        return pulumi.get(self, "sampling_rate")


@pulumi.output_type
class ResponseHeadersPolicyStrictTransportSecurity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessControlMaxAgeSec":
            suggest = "access_control_max_age_sec"
        elif key == "includeSubdomains":
            suggest = "include_subdomains"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyStrictTransportSecurity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyStrictTransportSecurity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyStrictTransportSecurity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_control_max_age_sec: int,
                 override: bool,
                 include_subdomains: Optional[bool] = None,
                 preload: Optional[bool] = None):
        pulumi.set(__self__, "access_control_max_age_sec", access_control_max_age_sec)
        pulumi.set(__self__, "override", override)
        if include_subdomains is not None:
            pulumi.set(__self__, "include_subdomains", include_subdomains)
        if preload is not None:
            pulumi.set(__self__, "preload", preload)

    @property
    @pulumi.getter(name="accessControlMaxAgeSec")
    def access_control_max_age_sec(self) -> int:
        return pulumi.get(self, "access_control_max_age_sec")

    @property
    @pulumi.getter
    def override(self) -> bool:
        return pulumi.get(self, "override")

    @property
    @pulumi.getter(name="includeSubdomains")
    def include_subdomains(self) -> Optional[bool]:
        return pulumi.get(self, "include_subdomains")

    @property
    @pulumi.getter
    def preload(self) -> Optional[bool]:
        return pulumi.get(self, "preload")


@pulumi.output_type
class ResponseHeadersPolicyXssProtection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "modeBlock":
            suggest = "mode_block"
        elif key == "reportUri":
            suggest = "report_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseHeadersPolicyXssProtection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseHeadersPolicyXssProtection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseHeadersPolicyXssProtection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 override: bool,
                 protection: bool,
                 mode_block: Optional[bool] = None,
                 report_uri: Optional[str] = None):
        pulumi.set(__self__, "override", override)
        pulumi.set(__self__, "protection", protection)
        if mode_block is not None:
            pulumi.set(__self__, "mode_block", mode_block)
        if report_uri is not None:
            pulumi.set(__self__, "report_uri", report_uri)

    @property
    @pulumi.getter
    def override(self) -> bool:
        return pulumi.get(self, "override")

    @property
    @pulumi.getter
    def protection(self) -> bool:
        return pulumi.get(self, "protection")

    @property
    @pulumi.getter(name="modeBlock")
    def mode_block(self) -> Optional[bool]:
        return pulumi.get(self, "mode_block")

    @property
    @pulumi.getter(name="reportUri")
    def report_uri(self) -> Optional[str]:
        return pulumi.get(self, "report_uri")


