# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = ['StackArgs', 'Stack']

@pulumi.input_type
class StackArgs:
    def __init__(__self__, *,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input['StackCapabilitiesItem']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_rollback: Optional[pulumi.Input[bool]] = None,
                 enable_termination_protection: Optional[pulumi.Input[bool]] = None,
                 notification_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 stack_name: Optional[pulumi.Input[str]] = None,
                 stack_policy_body: Optional[Any] = None,
                 stack_policy_url: Optional[pulumi.Input[str]] = None,
                 stack_status_reason: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 template_body: Optional[Any] = None,
                 template_url: Optional[pulumi.Input[str]] = None,
                 timeout_in_minutes: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Stack resource.
        :param Any stack_policy_body: Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::CloudFormation::Stack` for more information about the expected schema for this property.
        :param Any template_body: Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::CloudFormation::Stack` for more information about the expected schema for this property.
        """
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_rollback is not None:
            pulumi.set(__self__, "disable_rollback", disable_rollback)
        if enable_termination_protection is not None:
            pulumi.set(__self__, "enable_termination_protection", enable_termination_protection)
        if notification_arns is not None:
            pulumi.set(__self__, "notification_arns", notification_arns)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if stack_name is not None:
            pulumi.set(__self__, "stack_name", stack_name)
        if stack_policy_body is not None:
            pulumi.set(__self__, "stack_policy_body", stack_policy_body)
        if stack_policy_url is not None:
            pulumi.set(__self__, "stack_policy_url", stack_policy_url)
        if stack_status_reason is not None:
            pulumi.set(__self__, "stack_status_reason", stack_status_reason)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_body is not None:
            pulumi.set(__self__, "template_body", template_body)
        if template_url is not None:
            pulumi.set(__self__, "template_url", template_url)
        if timeout_in_minutes is not None:
            pulumi.set(__self__, "timeout_in_minutes", timeout_in_minutes)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackCapabilitiesItem']]]]:
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackCapabilitiesItem']]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableRollback")
    def disable_rollback(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "disable_rollback")

    @disable_rollback.setter
    def disable_rollback(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_rollback", value)

    @property
    @pulumi.getter(name="enableTerminationProtection")
    def enable_termination_protection(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enable_termination_protection")

    @enable_termination_protection.setter
    def enable_termination_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_termination_protection", value)

    @property
    @pulumi.getter(name="notificationArns")
    def notification_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "notification_arns")

    @notification_arns.setter
    def notification_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "notification_arns", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="stackName")
    def stack_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "stack_name")

    @stack_name.setter
    def stack_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stack_name", value)

    @property
    @pulumi.getter(name="stackPolicyBody")
    def stack_policy_body(self) -> Optional[Any]:
        """
        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::CloudFormation::Stack` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "stack_policy_body")

    @stack_policy_body.setter
    def stack_policy_body(self, value: Optional[Any]):
        pulumi.set(self, "stack_policy_body", value)

    @property
    @pulumi.getter(name="stackPolicyUrl")
    def stack_policy_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "stack_policy_url")

    @stack_policy_url.setter
    def stack_policy_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stack_policy_url", value)

    @property
    @pulumi.getter(name="stackStatusReason")
    def stack_status_reason(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "stack_status_reason")

    @stack_status_reason.setter
    def stack_status_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stack_status_reason", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateBody")
    def template_body(self) -> Optional[Any]:
        """
        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::CloudFormation::Stack` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "template_body")

    @template_body.setter
    def template_body(self, value: Optional[Any]):
        pulumi.set(self, "template_body", value)

    @property
    @pulumi.getter(name="templateUrl")
    def template_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "template_url")

    @template_url.setter
    def template_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_url", value)

    @property
    @pulumi.getter(name="timeoutInMinutes")
    def timeout_in_minutes(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "timeout_in_minutes")

    @timeout_in_minutes.setter
    def timeout_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_in_minutes", value)


class Stack(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input['StackCapabilitiesItem']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_rollback: Optional[pulumi.Input[bool]] = None,
                 enable_termination_protection: Optional[pulumi.Input[bool]] = None,
                 notification_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 stack_name: Optional[pulumi.Input[str]] = None,
                 stack_policy_body: Optional[Any] = None,
                 stack_policy_url: Optional[pulumi.Input[str]] = None,
                 stack_status_reason: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 template_body: Optional[Any] = None,
                 template_url: Optional[pulumi.Input[str]] = None,
                 timeout_in_minutes: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        The AWS::CloudFormation::Stack resource nests a stack as a resource in a top-level template.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param Any stack_policy_body: Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::CloudFormation::Stack` for more information about the expected schema for this property.
        :param Any template_body: Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::CloudFormation::Stack` for more information about the expected schema for this property.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[StackArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::CloudFormation::Stack resource nests a stack as a resource in a top-level template.

        :param str resource_name: The name of the resource.
        :param StackArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StackArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input['StackCapabilitiesItem']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_rollback: Optional[pulumi.Input[bool]] = None,
                 enable_termination_protection: Optional[pulumi.Input[bool]] = None,
                 notification_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 stack_name: Optional[pulumi.Input[str]] = None,
                 stack_policy_body: Optional[Any] = None,
                 stack_policy_url: Optional[pulumi.Input[str]] = None,
                 stack_status_reason: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 template_body: Optional[Any] = None,
                 template_url: Optional[pulumi.Input[str]] = None,
                 timeout_in_minutes: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StackArgs.__new__(StackArgs)

            __props__.__dict__["capabilities"] = capabilities
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_rollback"] = disable_rollback
            __props__.__dict__["enable_termination_protection"] = enable_termination_protection
            __props__.__dict__["notification_arns"] = notification_arns
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["stack_name"] = stack_name
            __props__.__dict__["stack_policy_body"] = stack_policy_body
            __props__.__dict__["stack_policy_url"] = stack_policy_url
            __props__.__dict__["stack_status_reason"] = stack_status_reason
            __props__.__dict__["tags"] = tags
            __props__.__dict__["template_body"] = template_body
            __props__.__dict__["template_url"] = template_url
            __props__.__dict__["timeout_in_minutes"] = timeout_in_minutes
            __props__.__dict__["change_set_id"] = None
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["last_update_time"] = None
            __props__.__dict__["outputs"] = None
            __props__.__dict__["parent_id"] = None
            __props__.__dict__["root_id"] = None
            __props__.__dict__["stack_id"] = None
            __props__.__dict__["stack_status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["stackName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Stack, __self__).__init__(
            'aws-native:cloudformation:Stack',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Stack':
        """
        Get an existing Stack resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = StackArgs.__new__(StackArgs)

        __props__.__dict__["capabilities"] = None
        __props__.__dict__["change_set_id"] = None
        __props__.__dict__["creation_time"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["disable_rollback"] = None
        __props__.__dict__["enable_termination_protection"] = None
        __props__.__dict__["last_update_time"] = None
        __props__.__dict__["notification_arns"] = None
        __props__.__dict__["outputs"] = None
        __props__.__dict__["parameters"] = None
        __props__.__dict__["parent_id"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["root_id"] = None
        __props__.__dict__["stack_id"] = None
        __props__.__dict__["stack_name"] = None
        __props__.__dict__["stack_policy_body"] = None
        __props__.__dict__["stack_policy_url"] = None
        __props__.__dict__["stack_status"] = None
        __props__.__dict__["stack_status_reason"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["template_body"] = None
        __props__.__dict__["template_url"] = None
        __props__.__dict__["timeout_in_minutes"] = None
        return Stack(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def capabilities(self) -> pulumi.Output[Optional[Sequence['StackCapabilitiesItem']]]:
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter(name="changeSetId")
    def change_set_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "change_set_id")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableRollback")
    def disable_rollback(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "disable_rollback")

    @property
    @pulumi.getter(name="enableTerminationProtection")
    def enable_termination_protection(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "enable_termination_protection")

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> pulumi.Output[str]:
        return pulumi.get(self, "last_update_time")

    @property
    @pulumi.getter(name="notificationArns")
    def notification_arns(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "notification_arns")

    @property
    @pulumi.getter
    def outputs(self) -> pulumi.Output[Sequence['outputs.StackOutput']]:
        return pulumi.get(self, "outputs")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "parent_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="rootId")
    def root_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "root_id")

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "stack_id")

    @property
    @pulumi.getter(name="stackName")
    def stack_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "stack_name")

    @property
    @pulumi.getter(name="stackPolicyBody")
    def stack_policy_body(self) -> pulumi.Output[Optional[Any]]:
        """
        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::CloudFormation::Stack` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "stack_policy_body")

    @property
    @pulumi.getter(name="stackPolicyUrl")
    def stack_policy_url(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "stack_policy_url")

    @property
    @pulumi.getter(name="stackStatus")
    def stack_status(self) -> pulumi.Output['StackStatus']:
        return pulumi.get(self, "stack_status")

    @property
    @pulumi.getter(name="stackStatusReason")
    def stack_status_reason(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "stack_status_reason")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="templateBody")
    def template_body(self) -> pulumi.Output[Optional[Any]]:
        """
        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::CloudFormation::Stack` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "template_body")

    @property
    @pulumi.getter(name="templateUrl")
    def template_url(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "template_url")

    @property
    @pulumi.getter(name="timeoutInMinutes")
    def timeout_in_minutes(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "timeout_in_minutes")

