# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['PrivacyBudgetTemplateArgs', 'PrivacyBudgetTemplate']

@pulumi.input_type
class PrivacyBudgetTemplateArgs:
    def __init__(__self__, *,
                 auto_refresh: pulumi.Input['PrivacyBudgetTemplateAutoRefresh'],
                 membership_identifier: pulumi.Input[str],
                 parameters: pulumi.Input['ParametersPropertiesArgs'],
                 privacy_budget_type: pulumi.Input['PrivacyBudgetTemplatePrivacyBudgetType'],
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a PrivacyBudgetTemplate resource.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An arbitrary set of tags (key-value pairs) for this cleanrooms privacy budget template.
        """
        pulumi.set(__self__, "auto_refresh", auto_refresh)
        pulumi.set(__self__, "membership_identifier", membership_identifier)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "privacy_budget_type", privacy_budget_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="autoRefresh")
    def auto_refresh(self) -> pulumi.Input['PrivacyBudgetTemplateAutoRefresh']:
        return pulumi.get(self, "auto_refresh")

    @auto_refresh.setter
    def auto_refresh(self, value: pulumi.Input['PrivacyBudgetTemplateAutoRefresh']):
        pulumi.set(self, "auto_refresh", value)

    @property
    @pulumi.getter(name="membershipIdentifier")
    def membership_identifier(self) -> pulumi.Input[str]:
        return pulumi.get(self, "membership_identifier")

    @membership_identifier.setter
    def membership_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "membership_identifier", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['ParametersPropertiesArgs']:
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['ParametersPropertiesArgs']):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="privacyBudgetType")
    def privacy_budget_type(self) -> pulumi.Input['PrivacyBudgetTemplatePrivacyBudgetType']:
        return pulumi.get(self, "privacy_budget_type")

    @privacy_budget_type.setter
    def privacy_budget_type(self, value: pulumi.Input['PrivacyBudgetTemplatePrivacyBudgetType']):
        pulumi.set(self, "privacy_budget_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An arbitrary set of tags (key-value pairs) for this cleanrooms privacy budget template.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class PrivacyBudgetTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_refresh: Optional[pulumi.Input['PrivacyBudgetTemplateAutoRefresh']] = None,
                 membership_identifier: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[pulumi.InputType['ParametersPropertiesArgs']]] = None,
                 privacy_budget_type: Optional[pulumi.Input['PrivacyBudgetTemplatePrivacyBudgetType']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        """
        Represents a privacy budget within a collaboration

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]] tags: An arbitrary set of tags (key-value pairs) for this cleanrooms privacy budget template.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrivacyBudgetTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a privacy budget within a collaboration

        :param str resource_name: The name of the resource.
        :param PrivacyBudgetTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrivacyBudgetTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_refresh: Optional[pulumi.Input['PrivacyBudgetTemplateAutoRefresh']] = None,
                 membership_identifier: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[pulumi.InputType['ParametersPropertiesArgs']]] = None,
                 privacy_budget_type: Optional[pulumi.Input['PrivacyBudgetTemplatePrivacyBudgetType']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrivacyBudgetTemplateArgs.__new__(PrivacyBudgetTemplateArgs)

            if auto_refresh is None and not opts.urn:
                raise TypeError("Missing required property 'auto_refresh'")
            __props__.__dict__["auto_refresh"] = auto_refresh
            if membership_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'membership_identifier'")
            __props__.__dict__["membership_identifier"] = membership_identifier
            if parameters is None and not opts.urn:
                raise TypeError("Missing required property 'parameters'")
            __props__.__dict__["parameters"] = parameters
            if privacy_budget_type is None and not opts.urn:
                raise TypeError("Missing required property 'privacy_budget_type'")
            __props__.__dict__["privacy_budget_type"] = privacy_budget_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["collaboration_arn"] = None
            __props__.__dict__["collaboration_identifier"] = None
            __props__.__dict__["membership_arn"] = None
            __props__.__dict__["privacy_budget_template_identifier"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["autoRefresh", "membershipIdentifier", "privacyBudgetType"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(PrivacyBudgetTemplate, __self__).__init__(
            'aws-native:cleanrooms:PrivacyBudgetTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'PrivacyBudgetTemplate':
        """
        Get an existing PrivacyBudgetTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PrivacyBudgetTemplateArgs.__new__(PrivacyBudgetTemplateArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["auto_refresh"] = None
        __props__.__dict__["collaboration_arn"] = None
        __props__.__dict__["collaboration_identifier"] = None
        __props__.__dict__["membership_arn"] = None
        __props__.__dict__["membership_identifier"] = None
        __props__.__dict__["parameters"] = None
        __props__.__dict__["privacy_budget_template_identifier"] = None
        __props__.__dict__["privacy_budget_type"] = None
        __props__.__dict__["tags"] = None
        return PrivacyBudgetTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoRefresh")
    def auto_refresh(self) -> pulumi.Output['PrivacyBudgetTemplateAutoRefresh']:
        return pulumi.get(self, "auto_refresh")

    @property
    @pulumi.getter(name="collaborationArn")
    def collaboration_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "collaboration_arn")

    @property
    @pulumi.getter(name="collaborationIdentifier")
    def collaboration_identifier(self) -> pulumi.Output[str]:
        return pulumi.get(self, "collaboration_identifier")

    @property
    @pulumi.getter(name="membershipArn")
    def membership_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "membership_arn")

    @property
    @pulumi.getter(name="membershipIdentifier")
    def membership_identifier(self) -> pulumi.Output[str]:
        return pulumi.get(self, "membership_identifier")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output['outputs.ParametersProperties']:
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="privacyBudgetTemplateIdentifier")
    def privacy_budget_template_identifier(self) -> pulumi.Output[str]:
        return pulumi.get(self, "privacy_budget_template_identifier")

    @property
    @pulumi.getter(name="privacyBudgetType")
    def privacy_budget_type(self) -> pulumi.Output['PrivacyBudgetTemplatePrivacyBudgetType']:
        return pulumi.get(self, "privacy_budget_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An arbitrary set of tags (key-value pairs) for this cleanrooms privacy budget template.
        """
        return pulumi.get(self, "tags")

