# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetMembershipResult',
    'AwaitableGetMembershipResult',
    'get_membership',
    'get_membership_output',
]

@pulumi.output_type
class GetMembershipResult:
    def __init__(__self__, arn=None, collaboration_arn=None, collaboration_creator_account_id=None, default_result_configuration=None, membership_identifier=None, payment_configuration=None, query_log_status=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if collaboration_arn and not isinstance(collaboration_arn, str):
            raise TypeError("Expected argument 'collaboration_arn' to be a str")
        pulumi.set(__self__, "collaboration_arn", collaboration_arn)
        if collaboration_creator_account_id and not isinstance(collaboration_creator_account_id, str):
            raise TypeError("Expected argument 'collaboration_creator_account_id' to be a str")
        pulumi.set(__self__, "collaboration_creator_account_id", collaboration_creator_account_id)
        if default_result_configuration and not isinstance(default_result_configuration, dict):
            raise TypeError("Expected argument 'default_result_configuration' to be a dict")
        pulumi.set(__self__, "default_result_configuration", default_result_configuration)
        if membership_identifier and not isinstance(membership_identifier, str):
            raise TypeError("Expected argument 'membership_identifier' to be a str")
        pulumi.set(__self__, "membership_identifier", membership_identifier)
        if payment_configuration and not isinstance(payment_configuration, dict):
            raise TypeError("Expected argument 'payment_configuration' to be a dict")
        pulumi.set(__self__, "payment_configuration", payment_configuration)
        if query_log_status and not isinstance(query_log_status, str):
            raise TypeError("Expected argument 'query_log_status' to be a str")
        pulumi.set(__self__, "query_log_status", query_log_status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="collaborationArn")
    def collaboration_arn(self) -> Optional[str]:
        return pulumi.get(self, "collaboration_arn")

    @property
    @pulumi.getter(name="collaborationCreatorAccountId")
    def collaboration_creator_account_id(self) -> Optional[str]:
        return pulumi.get(self, "collaboration_creator_account_id")

    @property
    @pulumi.getter(name="defaultResultConfiguration")
    def default_result_configuration(self) -> Optional['outputs.MembershipProtectedQueryResultConfiguration']:
        return pulumi.get(self, "default_result_configuration")

    @property
    @pulumi.getter(name="membershipIdentifier")
    def membership_identifier(self) -> Optional[str]:
        return pulumi.get(self, "membership_identifier")

    @property
    @pulumi.getter(name="paymentConfiguration")
    def payment_configuration(self) -> Optional['outputs.MembershipPaymentConfiguration']:
        return pulumi.get(self, "payment_configuration")

    @property
    @pulumi.getter(name="queryLogStatus")
    def query_log_status(self) -> Optional['MembershipQueryLogStatus']:
        return pulumi.get(self, "query_log_status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An arbitrary set of tags (key-value pairs) for this cleanrooms membership.
        """
        return pulumi.get(self, "tags")


class AwaitableGetMembershipResult(GetMembershipResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMembershipResult(
            arn=self.arn,
            collaboration_arn=self.collaboration_arn,
            collaboration_creator_account_id=self.collaboration_creator_account_id,
            default_result_configuration=self.default_result_configuration,
            membership_identifier=self.membership_identifier,
            payment_configuration=self.payment_configuration,
            query_log_status=self.query_log_status,
            tags=self.tags)


def get_membership(membership_identifier: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMembershipResult:
    """
    Represents an AWS account that is a part of a collaboration
    """
    __args__ = dict()
    __args__['membershipIdentifier'] = membership_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cleanrooms:getMembership', __args__, opts=opts, typ=GetMembershipResult).value

    return AwaitableGetMembershipResult(
        arn=pulumi.get(__ret__, 'arn'),
        collaboration_arn=pulumi.get(__ret__, 'collaboration_arn'),
        collaboration_creator_account_id=pulumi.get(__ret__, 'collaboration_creator_account_id'),
        default_result_configuration=pulumi.get(__ret__, 'default_result_configuration'),
        membership_identifier=pulumi.get(__ret__, 'membership_identifier'),
        payment_configuration=pulumi.get(__ret__, 'payment_configuration'),
        query_log_status=pulumi.get(__ret__, 'query_log_status'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_membership)
def get_membership_output(membership_identifier: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMembershipResult]:
    """
    Represents an AWS account that is a part of a collaboration
    """
    ...
