# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AgentActionGroup',
    'AgentActionGroupExecutor',
    'AgentAliasHistoryEvent',
    'AgentAliasRoutingConfigurationListItem',
    'AgentApiSchema0Properties',
    'AgentApiSchema1Properties',
    'AgentInferenceConfiguration',
    'AgentKnowledgeBase',
    'AgentPromptConfiguration',
    'AgentPromptOverrideConfiguration',
    'AgentS3Identifier',
    'DataSourceChunkingConfiguration',
    'DataSourceConfiguration',
    'DataSourceFixedSizeChunkingConfiguration',
    'DataSourceS3DataSourceConfiguration',
    'DataSourceServerSideEncryptionConfiguration',
    'DataSourceVectorIngestionConfiguration',
    'GuardrailContentFilterConfig',
    'GuardrailContentPolicyConfig',
    'GuardrailManagedWordsConfig',
    'GuardrailPiiEntityConfig',
    'GuardrailRegexConfig',
    'GuardrailSensitiveInformationPolicyConfig',
    'GuardrailTopicConfig',
    'GuardrailTopicPolicyConfig',
    'GuardrailWordConfig',
    'GuardrailWordPolicyConfig',
    'KnowledgeBaseConfiguration',
    'KnowledgeBaseOpenSearchServerlessConfiguration',
    'KnowledgeBaseOpenSearchServerlessFieldMapping',
    'KnowledgeBasePineconeConfiguration',
    'KnowledgeBasePineconeFieldMapping',
    'KnowledgeBaseRdsConfiguration',
    'KnowledgeBaseRdsFieldMapping',
    'KnowledgeBaseStorageConfiguration',
    'KnowledgeBaseVectorKnowledgeBaseConfiguration',
]

@pulumi.output_type
class AgentActionGroup(dict):
    """
    Contains the information of an Agent Action Group
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionGroupName":
            suggest = "action_group_name"
        elif key == "actionGroupExecutor":
            suggest = "action_group_executor"
        elif key == "actionGroupState":
            suggest = "action_group_state"
        elif key == "apiSchema":
            suggest = "api_schema"
        elif key == "parentActionGroupSignature":
            suggest = "parent_action_group_signature"
        elif key == "skipResourceInUseCheckOnDelete":
            suggest = "skip_resource_in_use_check_on_delete"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentActionGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentActionGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentActionGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_group_name: str,
                 action_group_executor: Optional['outputs.AgentActionGroupExecutor'] = None,
                 action_group_state: Optional['AgentActionGroupState'] = None,
                 api_schema: Optional[Any] = None,
                 description: Optional[str] = None,
                 parent_action_group_signature: Optional['AgentActionGroupSignature'] = None,
                 skip_resource_in_use_check_on_delete: Optional[bool] = None):
        """
        Contains the information of an Agent Action Group
        :param str action_group_name: Name of the action group
        :param str description: Description of action group
        :param bool skip_resource_in_use_check_on_delete: Specifies whether to allow deleting action group while it is in use.
        """
        pulumi.set(__self__, "action_group_name", action_group_name)
        if action_group_executor is not None:
            pulumi.set(__self__, "action_group_executor", action_group_executor)
        if action_group_state is not None:
            pulumi.set(__self__, "action_group_state", action_group_state)
        if api_schema is not None:
            pulumi.set(__self__, "api_schema", api_schema)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parent_action_group_signature is not None:
            pulumi.set(__self__, "parent_action_group_signature", parent_action_group_signature)
        if skip_resource_in_use_check_on_delete is not None:
            pulumi.set(__self__, "skip_resource_in_use_check_on_delete", skip_resource_in_use_check_on_delete)

    @property
    @pulumi.getter(name="actionGroupName")
    def action_group_name(self) -> str:
        """
        Name of the action group
        """
        return pulumi.get(self, "action_group_name")

    @property
    @pulumi.getter(name="actionGroupExecutor")
    def action_group_executor(self) -> Optional['outputs.AgentActionGroupExecutor']:
        return pulumi.get(self, "action_group_executor")

    @property
    @pulumi.getter(name="actionGroupState")
    def action_group_state(self) -> Optional['AgentActionGroupState']:
        return pulumi.get(self, "action_group_state")

    @property
    @pulumi.getter(name="apiSchema")
    def api_schema(self) -> Optional[Any]:
        return pulumi.get(self, "api_schema")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of action group
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="parentActionGroupSignature")
    def parent_action_group_signature(self) -> Optional['AgentActionGroupSignature']:
        return pulumi.get(self, "parent_action_group_signature")

    @property
    @pulumi.getter(name="skipResourceInUseCheckOnDelete")
    def skip_resource_in_use_check_on_delete(self) -> Optional[bool]:
        """
        Specifies whether to allow deleting action group while it is in use.
        """
        return pulumi.get(self, "skip_resource_in_use_check_on_delete")


@pulumi.output_type
class AgentActionGroupExecutor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambda":
            suggest = "lambda_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentActionGroupExecutor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentActionGroupExecutor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentActionGroupExecutor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_: str):
        """
        :param str lambda_: ARN of a Lambda.
        """
        pulumi.set(__self__, "lambda_", lambda_)

    @property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> str:
        """
        ARN of a Lambda.
        """
        return pulumi.get(self, "lambda_")


@pulumi.output_type
class AgentAliasHistoryEvent(dict):
    """
    History event for an alias for an Agent.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endDate":
            suggest = "end_date"
        elif key == "routingConfiguration":
            suggest = "routing_configuration"
        elif key == "startDate":
            suggest = "start_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentAliasHistoryEvent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentAliasHistoryEvent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentAliasHistoryEvent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_date: Optional[str] = None,
                 routing_configuration: Optional[Sequence['outputs.AgentAliasRoutingConfigurationListItem']] = None,
                 start_date: Optional[str] = None):
        """
        History event for an alias for an Agent.
        :param str end_date: Time Stamp.
        :param Sequence['AgentAliasRoutingConfigurationListItem'] routing_configuration: Routing configuration for an Agent alias.
        :param str start_date: Time Stamp.
        """
        if end_date is not None:
            pulumi.set(__self__, "end_date", end_date)
        if routing_configuration is not None:
            pulumi.set(__self__, "routing_configuration", routing_configuration)
        if start_date is not None:
            pulumi.set(__self__, "start_date", start_date)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> Optional[str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="routingConfiguration")
    def routing_configuration(self) -> Optional[Sequence['outputs.AgentAliasRoutingConfigurationListItem']]:
        """
        Routing configuration for an Agent alias.
        """
        return pulumi.get(self, "routing_configuration")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> Optional[str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "start_date")


@pulumi.output_type
class AgentAliasRoutingConfigurationListItem(dict):
    """
    Details about the routing configuration for an Agent alias.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentVersion":
            suggest = "agent_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentAliasRoutingConfigurationListItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentAliasRoutingConfigurationListItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentAliasRoutingConfigurationListItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_version: str):
        """
        Details about the routing configuration for an Agent alias.
        :param str agent_version: Agent Version.
        """
        pulumi.set(__self__, "agent_version", agent_version)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> str:
        """
        Agent Version.
        """
        return pulumi.get(self, "agent_version")


@pulumi.output_type
class AgentApiSchema0Properties(dict):
    """
    Contains information about the API Schema for the Action Group
    """
    def __init__(__self__, *,
                 s3: 'outputs.AgentS3Identifier'):
        """
        Contains information about the API Schema for the Action Group
        """
        pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter
    def s3(self) -> 'outputs.AgentS3Identifier':
        return pulumi.get(self, "s3")


@pulumi.output_type
class AgentApiSchema1Properties(dict):
    """
    Contains information about the API Schema for the Action Group
    """
    def __init__(__self__, *,
                 payload: str):
        """
        Contains information about the API Schema for the Action Group
        :param str payload: String OpenAPI Payload
        """
        pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter
    def payload(self) -> str:
        """
        String OpenAPI Payload
        """
        return pulumi.get(self, "payload")


@pulumi.output_type
class AgentInferenceConfiguration(dict):
    """
    Configuration for inference in prompt configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumLength":
            suggest = "maximum_length"
        elif key == "stopSequences":
            suggest = "stop_sequences"
        elif key == "topK":
            suggest = "top_k"
        elif key == "topP":
            suggest = "top_p"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentInferenceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentInferenceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentInferenceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_length: Optional[float] = None,
                 stop_sequences: Optional[Sequence[str]] = None,
                 temperature: Optional[float] = None,
                 top_k: Optional[float] = None,
                 top_p: Optional[float] = None):
        """
        Configuration for inference in prompt configuration
        :param float maximum_length: Maximum length of output
        :param Sequence[str] stop_sequences: List of stop sequences
        :param float temperature: Controls randomness, higher values increase diversity
        :param float top_k: Sample from the k most likely next tokens
        :param float top_p: Cumulative probability cutoff for token selection
        """
        if maximum_length is not None:
            pulumi.set(__self__, "maximum_length", maximum_length)
        if stop_sequences is not None:
            pulumi.set(__self__, "stop_sequences", stop_sequences)
        if temperature is not None:
            pulumi.set(__self__, "temperature", temperature)
        if top_k is not None:
            pulumi.set(__self__, "top_k", top_k)
        if top_p is not None:
            pulumi.set(__self__, "top_p", top_p)

    @property
    @pulumi.getter(name="maximumLength")
    def maximum_length(self) -> Optional[float]:
        """
        Maximum length of output
        """
        return pulumi.get(self, "maximum_length")

    @property
    @pulumi.getter(name="stopSequences")
    def stop_sequences(self) -> Optional[Sequence[str]]:
        """
        List of stop sequences
        """
        return pulumi.get(self, "stop_sequences")

    @property
    @pulumi.getter
    def temperature(self) -> Optional[float]:
        """
        Controls randomness, higher values increase diversity
        """
        return pulumi.get(self, "temperature")

    @property
    @pulumi.getter(name="topK")
    def top_k(self) -> Optional[float]:
        """
        Sample from the k most likely next tokens
        """
        return pulumi.get(self, "top_k")

    @property
    @pulumi.getter(name="topP")
    def top_p(self) -> Optional[float]:
        """
        Cumulative probability cutoff for token selection
        """
        return pulumi.get(self, "top_p")


@pulumi.output_type
class AgentKnowledgeBase(dict):
    """
    Agent Knowledge Base
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "knowledgeBaseId":
            suggest = "knowledge_base_id"
        elif key == "knowledgeBaseState":
            suggest = "knowledge_base_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentKnowledgeBase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentKnowledgeBase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentKnowledgeBase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 knowledge_base_id: str,
                 knowledge_base_state: Optional['AgentKnowledgeBaseState'] = None):
        """
        Agent Knowledge Base
        :param str description: Description of the Resource.
        :param str knowledge_base_id: Identifier for a resource.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "knowledge_base_id", knowledge_base_id)
        if knowledge_base_state is not None:
            pulumi.set(__self__, "knowledge_base_state", knowledge_base_state)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the Resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="knowledgeBaseId")
    def knowledge_base_id(self) -> str:
        """
        Identifier for a resource.
        """
        return pulumi.get(self, "knowledge_base_id")

    @property
    @pulumi.getter(name="knowledgeBaseState")
    def knowledge_base_state(self) -> Optional['AgentKnowledgeBaseState']:
        return pulumi.get(self, "knowledge_base_state")


@pulumi.output_type
class AgentPromptConfiguration(dict):
    """
    BasePromptConfiguration per Prompt Type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basePromptTemplate":
            suggest = "base_prompt_template"
        elif key == "inferenceConfiguration":
            suggest = "inference_configuration"
        elif key == "parserMode":
            suggest = "parser_mode"
        elif key == "promptCreationMode":
            suggest = "prompt_creation_mode"
        elif key == "promptState":
            suggest = "prompt_state"
        elif key == "promptType":
            suggest = "prompt_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentPromptConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentPromptConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentPromptConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_prompt_template: Optional[str] = None,
                 inference_configuration: Optional['outputs.AgentInferenceConfiguration'] = None,
                 parser_mode: Optional['AgentCreationMode'] = None,
                 prompt_creation_mode: Optional['AgentCreationMode'] = None,
                 prompt_state: Optional['AgentPromptState'] = None,
                 prompt_type: Optional['AgentPromptType'] = None):
        """
        BasePromptConfiguration per Prompt Type.
        :param str base_prompt_template: Base Prompt Template.
        """
        if base_prompt_template is not None:
            pulumi.set(__self__, "base_prompt_template", base_prompt_template)
        if inference_configuration is not None:
            pulumi.set(__self__, "inference_configuration", inference_configuration)
        if parser_mode is not None:
            pulumi.set(__self__, "parser_mode", parser_mode)
        if prompt_creation_mode is not None:
            pulumi.set(__self__, "prompt_creation_mode", prompt_creation_mode)
        if prompt_state is not None:
            pulumi.set(__self__, "prompt_state", prompt_state)
        if prompt_type is not None:
            pulumi.set(__self__, "prompt_type", prompt_type)

    @property
    @pulumi.getter(name="basePromptTemplate")
    def base_prompt_template(self) -> Optional[str]:
        """
        Base Prompt Template.
        """
        return pulumi.get(self, "base_prompt_template")

    @property
    @pulumi.getter(name="inferenceConfiguration")
    def inference_configuration(self) -> Optional['outputs.AgentInferenceConfiguration']:
        return pulumi.get(self, "inference_configuration")

    @property
    @pulumi.getter(name="parserMode")
    def parser_mode(self) -> Optional['AgentCreationMode']:
        return pulumi.get(self, "parser_mode")

    @property
    @pulumi.getter(name="promptCreationMode")
    def prompt_creation_mode(self) -> Optional['AgentCreationMode']:
        return pulumi.get(self, "prompt_creation_mode")

    @property
    @pulumi.getter(name="promptState")
    def prompt_state(self) -> Optional['AgentPromptState']:
        return pulumi.get(self, "prompt_state")

    @property
    @pulumi.getter(name="promptType")
    def prompt_type(self) -> Optional['AgentPromptType']:
        return pulumi.get(self, "prompt_type")


@pulumi.output_type
class AgentPromptOverrideConfiguration(dict):
    """
    Configuration for prompt override.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "promptConfigurations":
            suggest = "prompt_configurations"
        elif key == "overrideLambda":
            suggest = "override_lambda"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentPromptOverrideConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentPromptOverrideConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentPromptOverrideConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 prompt_configurations: Sequence['outputs.AgentPromptConfiguration'],
                 override_lambda: Optional[str] = None):
        """
        Configuration for prompt override.
        :param Sequence['AgentPromptConfiguration'] prompt_configurations: List of BasePromptConfiguration
        :param str override_lambda: ARN of a Lambda.
        """
        pulumi.set(__self__, "prompt_configurations", prompt_configurations)
        if override_lambda is not None:
            pulumi.set(__self__, "override_lambda", override_lambda)

    @property
    @pulumi.getter(name="promptConfigurations")
    def prompt_configurations(self) -> Sequence['outputs.AgentPromptConfiguration']:
        """
        List of BasePromptConfiguration
        """
        return pulumi.get(self, "prompt_configurations")

    @property
    @pulumi.getter(name="overrideLambda")
    def override_lambda(self) -> Optional[str]:
        """
        ARN of a Lambda.
        """
        return pulumi.get(self, "override_lambda")


@pulumi.output_type
class AgentS3Identifier(dict):
    """
    The identifier for the S3 resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3BucketName":
            suggest = "s3_bucket_name"
        elif key == "s3ObjectKey":
            suggest = "s3_object_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentS3Identifier. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentS3Identifier.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentS3Identifier.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket_name: Optional[str] = None,
                 s3_object_key: Optional[str] = None):
        """
        The identifier for the S3 resource.
        :param str s3_bucket_name: A bucket in S3.
        :param str s3_object_key: A object key in S3.
        """
        if s3_bucket_name is not None:
            pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_object_key is not None:
            pulumi.set(__self__, "s3_object_key", s3_object_key)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> Optional[str]:
        """
        A bucket in S3.
        """
        return pulumi.get(self, "s3_bucket_name")

    @property
    @pulumi.getter(name="s3ObjectKey")
    def s3_object_key(self) -> Optional[str]:
        """
        A object key in S3.
        """
        return pulumi.get(self, "s3_object_key")


@pulumi.output_type
class DataSourceChunkingConfiguration(dict):
    """
    Details about how to chunk the documents in the data source. A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chunkingStrategy":
            suggest = "chunking_strategy"
        elif key == "fixedSizeChunkingConfiguration":
            suggest = "fixed_size_chunking_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceChunkingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceChunkingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceChunkingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chunking_strategy: 'DataSourceChunkingStrategy',
                 fixed_size_chunking_configuration: Optional['outputs.DataSourceFixedSizeChunkingConfiguration'] = None):
        """
        Details about how to chunk the documents in the data source. A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
        """
        pulumi.set(__self__, "chunking_strategy", chunking_strategy)
        if fixed_size_chunking_configuration is not None:
            pulumi.set(__self__, "fixed_size_chunking_configuration", fixed_size_chunking_configuration)

    @property
    @pulumi.getter(name="chunkingStrategy")
    def chunking_strategy(self) -> 'DataSourceChunkingStrategy':
        return pulumi.get(self, "chunking_strategy")

    @property
    @pulumi.getter(name="fixedSizeChunkingConfiguration")
    def fixed_size_chunking_configuration(self) -> Optional['outputs.DataSourceFixedSizeChunkingConfiguration']:
        return pulumi.get(self, "fixed_size_chunking_configuration")


@pulumi.output_type
class DataSourceConfiguration(dict):
    """
    Specifies a raw data source location to ingest.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Configuration":
            suggest = "s3_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_configuration: 'outputs.DataSourceS3DataSourceConfiguration',
                 type: 'DataSourceType'):
        """
        Specifies a raw data source location to ingest.
        """
        pulumi.set(__self__, "s3_configuration", s3_configuration)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="s3Configuration")
    def s3_configuration(self) -> 'outputs.DataSourceS3DataSourceConfiguration':
        return pulumi.get(self, "s3_configuration")

    @property
    @pulumi.getter
    def type(self) -> 'DataSourceType':
        return pulumi.get(self, "type")


@pulumi.output_type
class DataSourceFixedSizeChunkingConfiguration(dict):
    """
    Configurations for when you choose fixed-size chunking. If you set the chunkingStrategy as NONE, exclude this field.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxTokens":
            suggest = "max_tokens"
        elif key == "overlapPercentage":
            suggest = "overlap_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceFixedSizeChunkingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceFixedSizeChunkingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceFixedSizeChunkingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_tokens: int,
                 overlap_percentage: int):
        """
        Configurations for when you choose fixed-size chunking. If you set the chunkingStrategy as NONE, exclude this field.
        :param int max_tokens: The maximum number of tokens to include in a chunk.
        :param int overlap_percentage: The percentage of overlap between adjacent chunks of a data source.
        """
        pulumi.set(__self__, "max_tokens", max_tokens)
        pulumi.set(__self__, "overlap_percentage", overlap_percentage)

    @property
    @pulumi.getter(name="maxTokens")
    def max_tokens(self) -> int:
        """
        The maximum number of tokens to include in a chunk.
        """
        return pulumi.get(self, "max_tokens")

    @property
    @pulumi.getter(name="overlapPercentage")
    def overlap_percentage(self) -> int:
        """
        The percentage of overlap between adjacent chunks of a data source.
        """
        return pulumi.get(self, "overlap_percentage")


@pulumi.output_type
class DataSourceS3DataSourceConfiguration(dict):
    """
    Contains information about the S3 configuration of the data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketArn":
            suggest = "bucket_arn"
        elif key == "bucketOwnerAccountId":
            suggest = "bucket_owner_account_id"
        elif key == "inclusionPrefixes":
            suggest = "inclusion_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceS3DataSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceS3DataSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceS3DataSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_arn: str,
                 bucket_owner_account_id: Optional[str] = None,
                 inclusion_prefixes: Optional[Sequence[str]] = None):
        """
        Contains information about the S3 configuration of the data source.
        :param str bucket_arn: The ARN of the bucket that contains the data source.
        :param str bucket_owner_account_id: The account ID for the owner of the S3 bucket.
        :param Sequence[str] inclusion_prefixes: A list of S3 prefixes that define the object containing the data sources.
        """
        pulumi.set(__self__, "bucket_arn", bucket_arn)
        if bucket_owner_account_id is not None:
            pulumi.set(__self__, "bucket_owner_account_id", bucket_owner_account_id)
        if inclusion_prefixes is not None:
            pulumi.set(__self__, "inclusion_prefixes", inclusion_prefixes)

    @property
    @pulumi.getter(name="bucketArn")
    def bucket_arn(self) -> str:
        """
        The ARN of the bucket that contains the data source.
        """
        return pulumi.get(self, "bucket_arn")

    @property
    @pulumi.getter(name="bucketOwnerAccountId")
    def bucket_owner_account_id(self) -> Optional[str]:
        """
        The account ID for the owner of the S3 bucket.
        """
        return pulumi.get(self, "bucket_owner_account_id")

    @property
    @pulumi.getter(name="inclusionPrefixes")
    def inclusion_prefixes(self) -> Optional[Sequence[str]]:
        """
        A list of S3 prefixes that define the object containing the data sources.
        """
        return pulumi.get(self, "inclusion_prefixes")


@pulumi.output_type
class DataSourceServerSideEncryptionConfiguration(dict):
    """
    Contains details about the server-side encryption for the data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyArn":
            suggest = "kms_key_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceServerSideEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceServerSideEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceServerSideEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_arn: Optional[str] = None):
        """
        Contains details about the server-side encryption for the data source.
        :param str kms_key_arn: The ARN of the AWS KMS key used to encrypt the resource.
        """
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[str]:
        """
        The ARN of the AWS KMS key used to encrypt the resource.
        """
        return pulumi.get(self, "kms_key_arn")


@pulumi.output_type
class DataSourceVectorIngestionConfiguration(dict):
    """
    Details about how to chunk the documents in the data source. A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chunkingConfiguration":
            suggest = "chunking_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceVectorIngestionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceVectorIngestionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceVectorIngestionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chunking_configuration: Optional['outputs.DataSourceChunkingConfiguration'] = None):
        """
        Details about how to chunk the documents in the data source. A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
        """
        if chunking_configuration is not None:
            pulumi.set(__self__, "chunking_configuration", chunking_configuration)

    @property
    @pulumi.getter(name="chunkingConfiguration")
    def chunking_configuration(self) -> Optional['outputs.DataSourceChunkingConfiguration']:
        return pulumi.get(self, "chunking_configuration")


@pulumi.output_type
class GuardrailContentFilterConfig(dict):
    """
    Content filter config in content policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputStrength":
            suggest = "input_strength"
        elif key == "outputStrength":
            suggest = "output_strength"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuardrailContentFilterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuardrailContentFilterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuardrailContentFilterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_strength: 'GuardrailFilterStrength',
                 output_strength: 'GuardrailFilterStrength',
                 type: 'GuardrailContentFilterType'):
        """
        Content filter config in content policy.
        """
        pulumi.set(__self__, "input_strength", input_strength)
        pulumi.set(__self__, "output_strength", output_strength)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="inputStrength")
    def input_strength(self) -> 'GuardrailFilterStrength':
        return pulumi.get(self, "input_strength")

    @property
    @pulumi.getter(name="outputStrength")
    def output_strength(self) -> 'GuardrailFilterStrength':
        return pulumi.get(self, "output_strength")

    @property
    @pulumi.getter
    def type(self) -> 'GuardrailContentFilterType':
        return pulumi.get(self, "type")


@pulumi.output_type
class GuardrailContentPolicyConfig(dict):
    """
    Content policy config for a guardrail.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filtersConfig":
            suggest = "filters_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuardrailContentPolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuardrailContentPolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuardrailContentPolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filters_config: Sequence['outputs.GuardrailContentFilterConfig']):
        """
        Content policy config for a guardrail.
        :param Sequence['GuardrailContentFilterConfig'] filters_config: List of content filter configs in content policy.
        """
        pulumi.set(__self__, "filters_config", filters_config)

    @property
    @pulumi.getter(name="filtersConfig")
    def filters_config(self) -> Sequence['outputs.GuardrailContentFilterConfig']:
        """
        List of content filter configs in content policy.
        """
        return pulumi.get(self, "filters_config")


@pulumi.output_type
class GuardrailManagedWordsConfig(dict):
    """
    A managed words config.
    """
    def __init__(__self__, *,
                 type: 'GuardrailManagedWordsType'):
        """
        A managed words config.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> 'GuardrailManagedWordsType':
        return pulumi.get(self, "type")


@pulumi.output_type
class GuardrailPiiEntityConfig(dict):
    """
    Pii entity configuration.
    """
    def __init__(__self__, *,
                 action: 'GuardrailSensitiveInformationAction',
                 type: 'GuardrailPiiEntityType'):
        """
        Pii entity configuration.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def action(self) -> 'GuardrailSensitiveInformationAction':
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def type(self) -> 'GuardrailPiiEntityType':
        return pulumi.get(self, "type")


@pulumi.output_type
class GuardrailRegexConfig(dict):
    """
    A regex configuration.
    """
    def __init__(__self__, *,
                 action: 'GuardrailSensitiveInformationAction',
                 name: str,
                 pattern: str,
                 description: Optional[str] = None):
        """
        A regex configuration.
        :param str name: The regex name.
        :param str pattern: The regex pattern.
        :param str description: The regex description.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pattern", pattern)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def action(self) -> 'GuardrailSensitiveInformationAction':
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The regex name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def pattern(self) -> str:
        """
        The regex pattern.
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The regex description.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class GuardrailSensitiveInformationPolicyConfig(dict):
    """
    Sensitive information policy config for a guardrail.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "piiEntitiesConfig":
            suggest = "pii_entities_config"
        elif key == "regexesConfig":
            suggest = "regexes_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuardrailSensitiveInformationPolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuardrailSensitiveInformationPolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuardrailSensitiveInformationPolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pii_entities_config: Optional[Sequence['outputs.GuardrailPiiEntityConfig']] = None,
                 regexes_config: Optional[Sequence['outputs.GuardrailRegexConfig']] = None):
        """
        Sensitive information policy config for a guardrail.
        :param Sequence['GuardrailPiiEntityConfig'] pii_entities_config: List of entities.
        :param Sequence['GuardrailRegexConfig'] regexes_config: List of regex.
        """
        if pii_entities_config is not None:
            pulumi.set(__self__, "pii_entities_config", pii_entities_config)
        if regexes_config is not None:
            pulumi.set(__self__, "regexes_config", regexes_config)

    @property
    @pulumi.getter(name="piiEntitiesConfig")
    def pii_entities_config(self) -> Optional[Sequence['outputs.GuardrailPiiEntityConfig']]:
        """
        List of entities.
        """
        return pulumi.get(self, "pii_entities_config")

    @property
    @pulumi.getter(name="regexesConfig")
    def regexes_config(self) -> Optional[Sequence['outputs.GuardrailRegexConfig']]:
        """
        List of regex.
        """
        return pulumi.get(self, "regexes_config")


@pulumi.output_type
class GuardrailTopicConfig(dict):
    """
    Topic config in topic policy.
    """
    def __init__(__self__, *,
                 definition: str,
                 name: str,
                 type: 'GuardrailTopicType',
                 examples: Optional[Sequence[str]] = None):
        """
        Topic config in topic policy.
        :param str definition: Definition of topic in topic policy
        :param str name: Name of topic in topic policy
        :param Sequence[str] examples: List of text examples
        """
        pulumi.set(__self__, "definition", definition)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if examples is not None:
            pulumi.set(__self__, "examples", examples)

    @property
    @pulumi.getter
    def definition(self) -> str:
        """
        Definition of topic in topic policy
        """
        return pulumi.get(self, "definition")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of topic in topic policy
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> 'GuardrailTopicType':
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def examples(self) -> Optional[Sequence[str]]:
        """
        List of text examples
        """
        return pulumi.get(self, "examples")


@pulumi.output_type
class GuardrailTopicPolicyConfig(dict):
    """
    Topic policy config for a guardrail.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topicsConfig":
            suggest = "topics_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuardrailTopicPolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuardrailTopicPolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuardrailTopicPolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 topics_config: Sequence['outputs.GuardrailTopicConfig']):
        """
        Topic policy config for a guardrail.
        :param Sequence['GuardrailTopicConfig'] topics_config: List of topic configs in topic policy.
        """
        pulumi.set(__self__, "topics_config", topics_config)

    @property
    @pulumi.getter(name="topicsConfig")
    def topics_config(self) -> Sequence['outputs.GuardrailTopicConfig']:
        """
        List of topic configs in topic policy.
        """
        return pulumi.get(self, "topics_config")


@pulumi.output_type
class GuardrailWordConfig(dict):
    """
    A custom word config.
    """
    def __init__(__self__, *,
                 text: str):
        """
        A custom word config.
        :param str text: The custom word text.
        """
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        The custom word text.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class GuardrailWordPolicyConfig(dict):
    """
    Word policy config for a guardrail.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "managedWordListsConfig":
            suggest = "managed_word_lists_config"
        elif key == "wordsConfig":
            suggest = "words_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GuardrailWordPolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GuardrailWordPolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GuardrailWordPolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 managed_word_lists_config: Optional[Sequence['outputs.GuardrailManagedWordsConfig']] = None,
                 words_config: Optional[Sequence['outputs.GuardrailWordConfig']] = None):
        """
        Word policy config for a guardrail.
        :param Sequence['GuardrailManagedWordsConfig'] managed_word_lists_config: A config for the list of managed words.
        :param Sequence['GuardrailWordConfig'] words_config: List of custom word configs.
        """
        if managed_word_lists_config is not None:
            pulumi.set(__self__, "managed_word_lists_config", managed_word_lists_config)
        if words_config is not None:
            pulumi.set(__self__, "words_config", words_config)

    @property
    @pulumi.getter(name="managedWordListsConfig")
    def managed_word_lists_config(self) -> Optional[Sequence['outputs.GuardrailManagedWordsConfig']]:
        """
        A config for the list of managed words.
        """
        return pulumi.get(self, "managed_word_lists_config")

    @property
    @pulumi.getter(name="wordsConfig")
    def words_config(self) -> Optional[Sequence['outputs.GuardrailWordConfig']]:
        """
        List of custom word configs.
        """
        return pulumi.get(self, "words_config")


@pulumi.output_type
class KnowledgeBaseConfiguration(dict):
    """
    Contains details about the embeddings model used for the knowledge base.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vectorKnowledgeBaseConfiguration":
            suggest = "vector_knowledge_base_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KnowledgeBaseConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KnowledgeBaseConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KnowledgeBaseConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: 'KnowledgeBaseType',
                 vector_knowledge_base_configuration: 'outputs.KnowledgeBaseVectorKnowledgeBaseConfiguration'):
        """
        Contains details about the embeddings model used for the knowledge base.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vector_knowledge_base_configuration", vector_knowledge_base_configuration)

    @property
    @pulumi.getter
    def type(self) -> 'KnowledgeBaseType':
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vectorKnowledgeBaseConfiguration")
    def vector_knowledge_base_configuration(self) -> 'outputs.KnowledgeBaseVectorKnowledgeBaseConfiguration':
        return pulumi.get(self, "vector_knowledge_base_configuration")


@pulumi.output_type
class KnowledgeBaseOpenSearchServerlessConfiguration(dict):
    """
    Contains the storage configuration of the knowledge base in Amazon OpenSearch Service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "collectionArn":
            suggest = "collection_arn"
        elif key == "fieldMapping":
            suggest = "field_mapping"
        elif key == "vectorIndexName":
            suggest = "vector_index_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KnowledgeBaseOpenSearchServerlessConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KnowledgeBaseOpenSearchServerlessConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KnowledgeBaseOpenSearchServerlessConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 collection_arn: str,
                 field_mapping: 'outputs.KnowledgeBaseOpenSearchServerlessFieldMapping',
                 vector_index_name: str):
        """
        Contains the storage configuration of the knowledge base in Amazon OpenSearch Service.
        :param str collection_arn: The ARN of the OpenSearch Service vector store.
        :param str vector_index_name: The name of the vector store.
        """
        pulumi.set(__self__, "collection_arn", collection_arn)
        pulumi.set(__self__, "field_mapping", field_mapping)
        pulumi.set(__self__, "vector_index_name", vector_index_name)

    @property
    @pulumi.getter(name="collectionArn")
    def collection_arn(self) -> str:
        """
        The ARN of the OpenSearch Service vector store.
        """
        return pulumi.get(self, "collection_arn")

    @property
    @pulumi.getter(name="fieldMapping")
    def field_mapping(self) -> 'outputs.KnowledgeBaseOpenSearchServerlessFieldMapping':
        return pulumi.get(self, "field_mapping")

    @property
    @pulumi.getter(name="vectorIndexName")
    def vector_index_name(self) -> str:
        """
        The name of the vector store.
        """
        return pulumi.get(self, "vector_index_name")


@pulumi.output_type
class KnowledgeBaseOpenSearchServerlessFieldMapping(dict):
    """
    A mapping of Bedrock Knowledge Base fields to OpenSearch Serverless field names
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metadataField":
            suggest = "metadata_field"
        elif key == "textField":
            suggest = "text_field"
        elif key == "vectorField":
            suggest = "vector_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KnowledgeBaseOpenSearchServerlessFieldMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KnowledgeBaseOpenSearchServerlessFieldMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KnowledgeBaseOpenSearchServerlessFieldMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metadata_field: str,
                 text_field: str,
                 vector_field: str):
        """
        A mapping of Bedrock Knowledge Base fields to OpenSearch Serverless field names
        :param str metadata_field: The name of the field in which Amazon Bedrock stores metadata about the vector store.
        :param str text_field: The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
        :param str vector_field: The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
        """
        pulumi.set(__self__, "metadata_field", metadata_field)
        pulumi.set(__self__, "text_field", text_field)
        pulumi.set(__self__, "vector_field", vector_field)

    @property
    @pulumi.getter(name="metadataField")
    def metadata_field(self) -> str:
        """
        The name of the field in which Amazon Bedrock stores metadata about the vector store.
        """
        return pulumi.get(self, "metadata_field")

    @property
    @pulumi.getter(name="textField")
    def text_field(self) -> str:
        """
        The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
        """
        return pulumi.get(self, "text_field")

    @property
    @pulumi.getter(name="vectorField")
    def vector_field(self) -> str:
        """
        The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
        """
        return pulumi.get(self, "vector_field")


@pulumi.output_type
class KnowledgeBasePineconeConfiguration(dict):
    """
    Contains the storage configuration of the knowledge base in Pinecone.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "credentialsSecretArn":
            suggest = "credentials_secret_arn"
        elif key == "fieldMapping":
            suggest = "field_mapping"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KnowledgeBasePineconeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KnowledgeBasePineconeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KnowledgeBasePineconeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: str,
                 credentials_secret_arn: str,
                 field_mapping: 'outputs.KnowledgeBasePineconeFieldMapping',
                 namespace: Optional[str] = None):
        """
        Contains the storage configuration of the knowledge base in Pinecone.
        :param str connection_string: The endpoint URL for your index management page.
        :param str credentials_secret_arn: The ARN of the secret that you created in AWS Secrets Manager that is linked to your Pinecone API key.
        :param str namespace: The namespace to be used to write new data to your database.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "credentials_secret_arn", credentials_secret_arn)
        pulumi.set(__self__, "field_mapping", field_mapping)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> str:
        """
        The endpoint URL for your index management page.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="credentialsSecretArn")
    def credentials_secret_arn(self) -> str:
        """
        The ARN of the secret that you created in AWS Secrets Manager that is linked to your Pinecone API key.
        """
        return pulumi.get(self, "credentials_secret_arn")

    @property
    @pulumi.getter(name="fieldMapping")
    def field_mapping(self) -> 'outputs.KnowledgeBasePineconeFieldMapping':
        return pulumi.get(self, "field_mapping")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The namespace to be used to write new data to your database.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class KnowledgeBasePineconeFieldMapping(dict):
    """
    Contains the names of the fields to which to map information about the vector store.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metadataField":
            suggest = "metadata_field"
        elif key == "textField":
            suggest = "text_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KnowledgeBasePineconeFieldMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KnowledgeBasePineconeFieldMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KnowledgeBasePineconeFieldMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metadata_field: str,
                 text_field: str):
        """
        Contains the names of the fields to which to map information about the vector store.
        :param str metadata_field: The name of the field in which Amazon Bedrock stores metadata about the vector store.
        :param str text_field: The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
        """
        pulumi.set(__self__, "metadata_field", metadata_field)
        pulumi.set(__self__, "text_field", text_field)

    @property
    @pulumi.getter(name="metadataField")
    def metadata_field(self) -> str:
        """
        The name of the field in which Amazon Bedrock stores metadata about the vector store.
        """
        return pulumi.get(self, "metadata_field")

    @property
    @pulumi.getter(name="textField")
    def text_field(self) -> str:
        """
        The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
        """
        return pulumi.get(self, "text_field")


@pulumi.output_type
class KnowledgeBaseRdsConfiguration(dict):
    """
    Contains details about the storage configuration of the knowledge base in Amazon RDS. For more information, see Create a vector index in Amazon RDS.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialsSecretArn":
            suggest = "credentials_secret_arn"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "fieldMapping":
            suggest = "field_mapping"
        elif key == "resourceArn":
            suggest = "resource_arn"
        elif key == "tableName":
            suggest = "table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KnowledgeBaseRdsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KnowledgeBaseRdsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KnowledgeBaseRdsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials_secret_arn: str,
                 database_name: str,
                 field_mapping: 'outputs.KnowledgeBaseRdsFieldMapping',
                 resource_arn: str,
                 table_name: str):
        """
        Contains details about the storage configuration of the knowledge base in Amazon RDS. For more information, see Create a vector index in Amazon RDS.
        :param str credentials_secret_arn: The ARN of the secret that you created in AWS Secrets Manager that is linked to your Amazon RDS database.
        :param str database_name: The name of your Amazon RDS database.
        :param str resource_arn: The ARN of the vector store.
        :param str table_name: The name of the table in the database.
        """
        pulumi.set(__self__, "credentials_secret_arn", credentials_secret_arn)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "field_mapping", field_mapping)
        pulumi.set(__self__, "resource_arn", resource_arn)
        pulumi.set(__self__, "table_name", table_name)

    @property
    @pulumi.getter(name="credentialsSecretArn")
    def credentials_secret_arn(self) -> str:
        """
        The ARN of the secret that you created in AWS Secrets Manager that is linked to your Amazon RDS database.
        """
        return pulumi.get(self, "credentials_secret_arn")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        The name of your Amazon RDS database.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="fieldMapping")
    def field_mapping(self) -> 'outputs.KnowledgeBaseRdsFieldMapping':
        return pulumi.get(self, "field_mapping")

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> str:
        """
        The ARN of the vector store.
        """
        return pulumi.get(self, "resource_arn")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        """
        The name of the table in the database.
        """
        return pulumi.get(self, "table_name")


@pulumi.output_type
class KnowledgeBaseRdsFieldMapping(dict):
    """
    Contains the names of the fields to which to map information about the vector store.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metadataField":
            suggest = "metadata_field"
        elif key == "primaryKeyField":
            suggest = "primary_key_field"
        elif key == "textField":
            suggest = "text_field"
        elif key == "vectorField":
            suggest = "vector_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KnowledgeBaseRdsFieldMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KnowledgeBaseRdsFieldMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KnowledgeBaseRdsFieldMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metadata_field: str,
                 primary_key_field: str,
                 text_field: str,
                 vector_field: str):
        """
        Contains the names of the fields to which to map information about the vector store.
        :param str metadata_field: The name of the field in which Amazon Bedrock stores metadata about the vector store.
        :param str primary_key_field: The name of the field in which Amazon Bedrock stores the ID for each entry.
        :param str text_field: The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
        :param str vector_field: The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
        """
        pulumi.set(__self__, "metadata_field", metadata_field)
        pulumi.set(__self__, "primary_key_field", primary_key_field)
        pulumi.set(__self__, "text_field", text_field)
        pulumi.set(__self__, "vector_field", vector_field)

    @property
    @pulumi.getter(name="metadataField")
    def metadata_field(self) -> str:
        """
        The name of the field in which Amazon Bedrock stores metadata about the vector store.
        """
        return pulumi.get(self, "metadata_field")

    @property
    @pulumi.getter(name="primaryKeyField")
    def primary_key_field(self) -> str:
        """
        The name of the field in which Amazon Bedrock stores the ID for each entry.
        """
        return pulumi.get(self, "primary_key_field")

    @property
    @pulumi.getter(name="textField")
    def text_field(self) -> str:
        """
        The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
        """
        return pulumi.get(self, "text_field")

    @property
    @pulumi.getter(name="vectorField")
    def vector_field(self) -> str:
        """
        The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
        """
        return pulumi.get(self, "vector_field")


@pulumi.output_type
class KnowledgeBaseStorageConfiguration(dict):
    """
    The vector store service in which the knowledge base is stored.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "opensearchServerlessConfiguration":
            suggest = "opensearch_serverless_configuration"
        elif key == "pineconeConfiguration":
            suggest = "pinecone_configuration"
        elif key == "rdsConfiguration":
            suggest = "rds_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KnowledgeBaseStorageConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KnowledgeBaseStorageConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KnowledgeBaseStorageConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: 'KnowledgeBaseStorageType',
                 opensearch_serverless_configuration: Optional['outputs.KnowledgeBaseOpenSearchServerlessConfiguration'] = None,
                 pinecone_configuration: Optional['outputs.KnowledgeBasePineconeConfiguration'] = None,
                 rds_configuration: Optional['outputs.KnowledgeBaseRdsConfiguration'] = None):
        """
        The vector store service in which the knowledge base is stored.
        """
        pulumi.set(__self__, "type", type)
        if opensearch_serverless_configuration is not None:
            pulumi.set(__self__, "opensearch_serverless_configuration", opensearch_serverless_configuration)
        if pinecone_configuration is not None:
            pulumi.set(__self__, "pinecone_configuration", pinecone_configuration)
        if rds_configuration is not None:
            pulumi.set(__self__, "rds_configuration", rds_configuration)

    @property
    @pulumi.getter
    def type(self) -> 'KnowledgeBaseStorageType':
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="opensearchServerlessConfiguration")
    def opensearch_serverless_configuration(self) -> Optional['outputs.KnowledgeBaseOpenSearchServerlessConfiguration']:
        return pulumi.get(self, "opensearch_serverless_configuration")

    @property
    @pulumi.getter(name="pineconeConfiguration")
    def pinecone_configuration(self) -> Optional['outputs.KnowledgeBasePineconeConfiguration']:
        return pulumi.get(self, "pinecone_configuration")

    @property
    @pulumi.getter(name="rdsConfiguration")
    def rds_configuration(self) -> Optional['outputs.KnowledgeBaseRdsConfiguration']:
        return pulumi.get(self, "rds_configuration")


@pulumi.output_type
class KnowledgeBaseVectorKnowledgeBaseConfiguration(dict):
    """
    Contains details about the model used to create vector embeddings for the knowledge base.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "embeddingModelArn":
            suggest = "embedding_model_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KnowledgeBaseVectorKnowledgeBaseConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KnowledgeBaseVectorKnowledgeBaseConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KnowledgeBaseVectorKnowledgeBaseConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 embedding_model_arn: str):
        """
        Contains details about the model used to create vector embeddings for the knowledge base.
        :param str embedding_model_arn: The ARN of the model used to create vector embeddings for the knowledge base.
        """
        pulumi.set(__self__, "embedding_model_arn", embedding_model_arn)

    @property
    @pulumi.getter(name="embeddingModelArn")
    def embedding_model_arn(self) -> str:
        """
        The ARN of the model used to create vector embeddings for the knowledge base.
        """
        return pulumi.get(self, "embedding_model_arn")


