# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['DataSourceArgs', 'DataSource']

@pulumi.input_type
class DataSourceArgs:
    def __init__(__self__, *,
                 data_source_configuration: pulumi.Input['DataSourceConfigurationArgs'],
                 knowledge_base_id: pulumi.Input[str],
                 data_deletion_policy: Optional[pulumi.Input['DataSourceDataDeletionPolicy']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 server_side_encryption_configuration: Optional[pulumi.Input['DataSourceServerSideEncryptionConfigurationArgs']] = None,
                 vector_ingestion_configuration: Optional[pulumi.Input['DataSourceVectorIngestionConfigurationArgs']] = None):
        """
        The set of arguments for constructing a DataSource resource.
        :param pulumi.Input[str] knowledge_base_id: The unique identifier of the knowledge base to which to add the data source.
        :param pulumi.Input[str] description: Description of the Resource.
        :param pulumi.Input[str] name: The name of the data source.
        """
        pulumi.set(__self__, "data_source_configuration", data_source_configuration)
        pulumi.set(__self__, "knowledge_base_id", knowledge_base_id)
        if data_deletion_policy is not None:
            pulumi.set(__self__, "data_deletion_policy", data_deletion_policy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if server_side_encryption_configuration is not None:
            pulumi.set(__self__, "server_side_encryption_configuration", server_side_encryption_configuration)
        if vector_ingestion_configuration is not None:
            pulumi.set(__self__, "vector_ingestion_configuration", vector_ingestion_configuration)

    @property
    @pulumi.getter(name="dataSourceConfiguration")
    def data_source_configuration(self) -> pulumi.Input['DataSourceConfigurationArgs']:
        return pulumi.get(self, "data_source_configuration")

    @data_source_configuration.setter
    def data_source_configuration(self, value: pulumi.Input['DataSourceConfigurationArgs']):
        pulumi.set(self, "data_source_configuration", value)

    @property
    @pulumi.getter(name="knowledgeBaseId")
    def knowledge_base_id(self) -> pulumi.Input[str]:
        """
        The unique identifier of the knowledge base to which to add the data source.
        """
        return pulumi.get(self, "knowledge_base_id")

    @knowledge_base_id.setter
    def knowledge_base_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "knowledge_base_id", value)

    @property
    @pulumi.getter(name="dataDeletionPolicy")
    def data_deletion_policy(self) -> Optional[pulumi.Input['DataSourceDataDeletionPolicy']]:
        return pulumi.get(self, "data_deletion_policy")

    @data_deletion_policy.setter
    def data_deletion_policy(self, value: Optional[pulumi.Input['DataSourceDataDeletionPolicy']]):
        pulumi.set(self, "data_deletion_policy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the Resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the data source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serverSideEncryptionConfiguration")
    def server_side_encryption_configuration(self) -> Optional[pulumi.Input['DataSourceServerSideEncryptionConfigurationArgs']]:
        return pulumi.get(self, "server_side_encryption_configuration")

    @server_side_encryption_configuration.setter
    def server_side_encryption_configuration(self, value: Optional[pulumi.Input['DataSourceServerSideEncryptionConfigurationArgs']]):
        pulumi.set(self, "server_side_encryption_configuration", value)

    @property
    @pulumi.getter(name="vectorIngestionConfiguration")
    def vector_ingestion_configuration(self) -> Optional[pulumi.Input['DataSourceVectorIngestionConfigurationArgs']]:
        return pulumi.get(self, "vector_ingestion_configuration")

    @vector_ingestion_configuration.setter
    def vector_ingestion_configuration(self, value: Optional[pulumi.Input['DataSourceVectorIngestionConfigurationArgs']]):
        pulumi.set(self, "vector_ingestion_configuration", value)


class DataSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_deletion_policy: Optional[pulumi.Input['DataSourceDataDeletionPolicy']] = None,
                 data_source_configuration: Optional[pulumi.Input[pulumi.InputType['DataSourceConfigurationArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 knowledge_base_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 server_side_encryption_configuration: Optional[pulumi.Input[pulumi.InputType['DataSourceServerSideEncryptionConfigurationArgs']]] = None,
                 vector_ingestion_configuration: Optional[pulumi.Input[pulumi.InputType['DataSourceVectorIngestionConfigurationArgs']]] = None,
                 __props__=None):
        """
        Definition of AWS::Bedrock::DataSource Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the Resource.
        :param pulumi.Input[str] knowledge_base_id: The unique identifier of the knowledge base to which to add the data source.
        :param pulumi.Input[str] name: The name of the data source.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Bedrock::DataSource Resource Type

        :param str resource_name: The name of the resource.
        :param DataSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_deletion_policy: Optional[pulumi.Input['DataSourceDataDeletionPolicy']] = None,
                 data_source_configuration: Optional[pulumi.Input[pulumi.InputType['DataSourceConfigurationArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 knowledge_base_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 server_side_encryption_configuration: Optional[pulumi.Input[pulumi.InputType['DataSourceServerSideEncryptionConfigurationArgs']]] = None,
                 vector_ingestion_configuration: Optional[pulumi.Input[pulumi.InputType['DataSourceVectorIngestionConfigurationArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataSourceArgs.__new__(DataSourceArgs)

            __props__.__dict__["data_deletion_policy"] = data_deletion_policy
            if data_source_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'data_source_configuration'")
            __props__.__dict__["data_source_configuration"] = data_source_configuration
            __props__.__dict__["description"] = description
            if knowledge_base_id is None and not opts.urn:
                raise TypeError("Missing required property 'knowledge_base_id'")
            __props__.__dict__["knowledge_base_id"] = knowledge_base_id
            __props__.__dict__["name"] = name
            __props__.__dict__["server_side_encryption_configuration"] = server_side_encryption_configuration
            __props__.__dict__["vector_ingestion_configuration"] = vector_ingestion_configuration
            __props__.__dict__["created_at"] = None
            __props__.__dict__["data_source_id"] = None
            __props__.__dict__["data_source_status"] = None
            __props__.__dict__["failure_reasons"] = None
            __props__.__dict__["updated_at"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["knowledgeBaseId", "vectorIngestionConfiguration"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DataSource, __self__).__init__(
            'aws-native:bedrock:DataSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DataSource':
        """
        Get an existing DataSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DataSourceArgs.__new__(DataSourceArgs)

        __props__.__dict__["created_at"] = None
        __props__.__dict__["data_deletion_policy"] = None
        __props__.__dict__["data_source_configuration"] = None
        __props__.__dict__["data_source_id"] = None
        __props__.__dict__["data_source_status"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["failure_reasons"] = None
        __props__.__dict__["knowledge_base_id"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["server_side_encryption_configuration"] = None
        __props__.__dict__["updated_at"] = None
        __props__.__dict__["vector_ingestion_configuration"] = None
        return DataSource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The time at which the data source was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="dataDeletionPolicy")
    def data_deletion_policy(self) -> pulumi.Output[Optional['DataSourceDataDeletionPolicy']]:
        return pulumi.get(self, "data_deletion_policy")

    @property
    @pulumi.getter(name="dataSourceConfiguration")
    def data_source_configuration(self) -> pulumi.Output['outputs.DataSourceConfiguration']:
        return pulumi.get(self, "data_source_configuration")

    @property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> pulumi.Output[str]:
        """
        Identifier for a resource.
        """
        return pulumi.get(self, "data_source_id")

    @property
    @pulumi.getter(name="dataSourceStatus")
    def data_source_status(self) -> pulumi.Output['DataSourceStatus']:
        return pulumi.get(self, "data_source_status")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the Resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="failureReasons")
    def failure_reasons(self) -> pulumi.Output[Sequence[str]]:
        """
        The details of the failure reasons related to the data source.
        """
        return pulumi.get(self, "failure_reasons")

    @property
    @pulumi.getter(name="knowledgeBaseId")
    def knowledge_base_id(self) -> pulumi.Output[str]:
        """
        The unique identifier of the knowledge base to which to add the data source.
        """
        return pulumi.get(self, "knowledge_base_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the data source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serverSideEncryptionConfiguration")
    def server_side_encryption_configuration(self) -> pulumi.Output[Optional['outputs.DataSourceServerSideEncryptionConfiguration']]:
        return pulumi.get(self, "server_side_encryption_configuration")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The time at which the knowledge base was last updated.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="vectorIngestionConfiguration")
    def vector_ingestion_configuration(self) -> pulumi.Output[Optional['outputs.DataSourceVectorIngestionConfiguration']]:
        return pulumi.get(self, "vector_ingestion_configuration")

