# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['AgentAliasArgs', 'AgentAlias']

@pulumi.input_type
class AgentAliasArgs:
    def __init__(__self__, *,
                 agent_id: pulumi.Input[str],
                 agent_alias_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 routing_configuration: Optional[pulumi.Input[Sequence[pulumi.Input['AgentAliasRoutingConfigurationListItemArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AgentAlias resource.
        :param pulumi.Input[str] agent_id: Identifier for a resource.
        :param pulumi.Input[str] agent_alias_name: Name for a resource.
        :param pulumi.Input[str] description: Description of the Resource.
        :param pulumi.Input[Sequence[pulumi.Input['AgentAliasRoutingConfigurationListItemArgs']]] routing_configuration: Routing configuration for an Agent alias.
        """
        pulumi.set(__self__, "agent_id", agent_id)
        if agent_alias_name is not None:
            pulumi.set(__self__, "agent_alias_name", agent_alias_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if routing_configuration is not None:
            pulumi.set(__self__, "routing_configuration", routing_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Input[str]:
        """
        Identifier for a resource.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "agent_id", value)

    @property
    @pulumi.getter(name="agentAliasName")
    def agent_alias_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for a resource.
        """
        return pulumi.get(self, "agent_alias_name")

    @agent_alias_name.setter
    def agent_alias_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_alias_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the Resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="routingConfiguration")
    def routing_configuration(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AgentAliasRoutingConfigurationListItemArgs']]]]:
        """
        Routing configuration for an Agent alias.
        """
        return pulumi.get(self, "routing_configuration")

    @routing_configuration.setter
    def routing_configuration(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AgentAliasRoutingConfigurationListItemArgs']]]]):
        pulumi.set(self, "routing_configuration", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class AgentAlias(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_alias_name: Optional[pulumi.Input[str]] = None,
                 agent_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 routing_configuration: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AgentAliasRoutingConfigurationListItemArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Definition of AWS::Bedrock::AgentAlias Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] agent_alias_name: Name for a resource.
        :param pulumi.Input[str] agent_id: Identifier for a resource.
        :param pulumi.Input[str] description: Description of the Resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AgentAliasRoutingConfigurationListItemArgs']]]] routing_configuration: Routing configuration for an Agent alias.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AgentAliasArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Bedrock::AgentAlias Resource Type

        :param str resource_name: The name of the resource.
        :param AgentAliasArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentAliasArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_alias_name: Optional[pulumi.Input[str]] = None,
                 agent_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 routing_configuration: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AgentAliasRoutingConfigurationListItemArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentAliasArgs.__new__(AgentAliasArgs)

            __props__.__dict__["agent_alias_name"] = agent_alias_name
            if agent_id is None and not opts.urn:
                raise TypeError("Missing required property 'agent_id'")
            __props__.__dict__["agent_id"] = agent_id
            __props__.__dict__["description"] = description
            __props__.__dict__["routing_configuration"] = routing_configuration
            __props__.__dict__["tags"] = tags
            __props__.__dict__["agent_alias_arn"] = None
            __props__.__dict__["agent_alias_history_events"] = None
            __props__.__dict__["agent_alias_id"] = None
            __props__.__dict__["agent_alias_status"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["agentId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(AgentAlias, __self__).__init__(
            'aws-native:bedrock:AgentAlias',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AgentAlias':
        """
        Get an existing AgentAlias resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AgentAliasArgs.__new__(AgentAliasArgs)

        __props__.__dict__["agent_alias_arn"] = None
        __props__.__dict__["agent_alias_history_events"] = None
        __props__.__dict__["agent_alias_id"] = None
        __props__.__dict__["agent_alias_name"] = None
        __props__.__dict__["agent_alias_status"] = None
        __props__.__dict__["agent_id"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["routing_configuration"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["updated_at"] = None
        return AgentAlias(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentAliasArn")
    def agent_alias_arn(self) -> pulumi.Output[str]:
        """
        Arn representation of the Agent Alias.
        """
        return pulumi.get(self, "agent_alias_arn")

    @property
    @pulumi.getter(name="agentAliasHistoryEvents")
    def agent_alias_history_events(self) -> pulumi.Output[Sequence['outputs.AgentAliasHistoryEvent']]:
        """
        The list of history events for an alias for an Agent.
        """
        return pulumi.get(self, "agent_alias_history_events")

    @property
    @pulumi.getter(name="agentAliasId")
    def agent_alias_id(self) -> pulumi.Output[str]:
        """
        Id for an Agent Alias generated at the server side.
        """
        return pulumi.get(self, "agent_alias_id")

    @property
    @pulumi.getter(name="agentAliasName")
    def agent_alias_name(self) -> pulumi.Output[str]:
        """
        Name for a resource.
        """
        return pulumi.get(self, "agent_alias_name")

    @property
    @pulumi.getter(name="agentAliasStatus")
    def agent_alias_status(self) -> pulumi.Output['AgentAliasStatus']:
        return pulumi.get(self, "agent_alias_status")

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Output[str]:
        """
        Identifier for a resource.
        """
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the Resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="routingConfiguration")
    def routing_configuration(self) -> pulumi.Output[Optional[Sequence['outputs.AgentAliasRoutingConfigurationListItem']]]:
        """
        Routing configuration for an Agent alias.
        """
        return pulumi.get(self, "routing_configuration")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        Time Stamp.
        """
        return pulumi.get(self, "updated_at")

