# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AgentActionGroupExecutorArgs',
    'AgentActionGroupArgs',
    'AgentAliasRoutingConfigurationListItemArgs',
    'AgentApiSchema0PropertiesArgs',
    'AgentApiSchema1PropertiesArgs',
    'AgentInferenceConfigurationArgs',
    'AgentKnowledgeBaseArgs',
    'AgentPromptConfigurationArgs',
    'AgentPromptOverrideConfigurationArgs',
    'AgentS3IdentifierArgs',
    'DataSourceChunkingConfigurationArgs',
    'DataSourceConfigurationArgs',
    'DataSourceFixedSizeChunkingConfigurationArgs',
    'DataSourceS3DataSourceConfigurationArgs',
    'DataSourceServerSideEncryptionConfigurationArgs',
    'DataSourceVectorIngestionConfigurationArgs',
    'GuardrailContentFilterConfigArgs',
    'GuardrailContentPolicyConfigArgs',
    'GuardrailManagedWordsConfigArgs',
    'GuardrailPiiEntityConfigArgs',
    'GuardrailRegexConfigArgs',
    'GuardrailSensitiveInformationPolicyConfigArgs',
    'GuardrailTopicConfigArgs',
    'GuardrailTopicPolicyConfigArgs',
    'GuardrailWordConfigArgs',
    'GuardrailWordPolicyConfigArgs',
    'KnowledgeBaseConfigurationArgs',
    'KnowledgeBaseOpenSearchServerlessConfigurationArgs',
    'KnowledgeBaseOpenSearchServerlessFieldMappingArgs',
    'KnowledgeBasePineconeConfigurationArgs',
    'KnowledgeBasePineconeFieldMappingArgs',
    'KnowledgeBaseRdsConfigurationArgs',
    'KnowledgeBaseRdsFieldMappingArgs',
    'KnowledgeBaseStorageConfigurationArgs',
    'KnowledgeBaseVectorKnowledgeBaseConfigurationArgs',
]

@pulumi.input_type
class AgentActionGroupExecutorArgs:
    def __init__(__self__, *,
                 lambda_: pulumi.Input[str]):
        """
        :param pulumi.Input[str] lambda_: ARN of a Lambda.
        """
        pulumi.set(__self__, "lambda_", lambda_)

    @property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> pulumi.Input[str]:
        """
        ARN of a Lambda.
        """
        return pulumi.get(self, "lambda_")

    @lambda_.setter
    def lambda_(self, value: pulumi.Input[str]):
        pulumi.set(self, "lambda_", value)


@pulumi.input_type
class AgentActionGroupArgs:
    def __init__(__self__, *,
                 action_group_name: pulumi.Input[str],
                 action_group_executor: Optional[pulumi.Input['AgentActionGroupExecutorArgs']] = None,
                 action_group_state: Optional[pulumi.Input['AgentActionGroupState']] = None,
                 api_schema: Optional[pulumi.Input[Union['AgentApiSchema0PropertiesArgs', 'AgentApiSchema1PropertiesArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 parent_action_group_signature: Optional[pulumi.Input['AgentActionGroupSignature']] = None,
                 skip_resource_in_use_check_on_delete: Optional[pulumi.Input[bool]] = None):
        """
        Contains the information of an Agent Action Group
        :param pulumi.Input[str] action_group_name: Name of the action group
        :param pulumi.Input[str] description: Description of action group
        :param pulumi.Input[bool] skip_resource_in_use_check_on_delete: Specifies whether to allow deleting action group while it is in use.
        """
        pulumi.set(__self__, "action_group_name", action_group_name)
        if action_group_executor is not None:
            pulumi.set(__self__, "action_group_executor", action_group_executor)
        if action_group_state is not None:
            pulumi.set(__self__, "action_group_state", action_group_state)
        if api_schema is not None:
            pulumi.set(__self__, "api_schema", api_schema)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if parent_action_group_signature is not None:
            pulumi.set(__self__, "parent_action_group_signature", parent_action_group_signature)
        if skip_resource_in_use_check_on_delete is not None:
            pulumi.set(__self__, "skip_resource_in_use_check_on_delete", skip_resource_in_use_check_on_delete)

    @property
    @pulumi.getter(name="actionGroupName")
    def action_group_name(self) -> pulumi.Input[str]:
        """
        Name of the action group
        """
        return pulumi.get(self, "action_group_name")

    @action_group_name.setter
    def action_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "action_group_name", value)

    @property
    @pulumi.getter(name="actionGroupExecutor")
    def action_group_executor(self) -> Optional[pulumi.Input['AgentActionGroupExecutorArgs']]:
        return pulumi.get(self, "action_group_executor")

    @action_group_executor.setter
    def action_group_executor(self, value: Optional[pulumi.Input['AgentActionGroupExecutorArgs']]):
        pulumi.set(self, "action_group_executor", value)

    @property
    @pulumi.getter(name="actionGroupState")
    def action_group_state(self) -> Optional[pulumi.Input['AgentActionGroupState']]:
        return pulumi.get(self, "action_group_state")

    @action_group_state.setter
    def action_group_state(self, value: Optional[pulumi.Input['AgentActionGroupState']]):
        pulumi.set(self, "action_group_state", value)

    @property
    @pulumi.getter(name="apiSchema")
    def api_schema(self) -> Optional[pulumi.Input[Union['AgentApiSchema0PropertiesArgs', 'AgentApiSchema1PropertiesArgs']]]:
        return pulumi.get(self, "api_schema")

    @api_schema.setter
    def api_schema(self, value: Optional[pulumi.Input[Union['AgentApiSchema0PropertiesArgs', 'AgentApiSchema1PropertiesArgs']]]):
        pulumi.set(self, "api_schema", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of action group
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="parentActionGroupSignature")
    def parent_action_group_signature(self) -> Optional[pulumi.Input['AgentActionGroupSignature']]:
        return pulumi.get(self, "parent_action_group_signature")

    @parent_action_group_signature.setter
    def parent_action_group_signature(self, value: Optional[pulumi.Input['AgentActionGroupSignature']]):
        pulumi.set(self, "parent_action_group_signature", value)

    @property
    @pulumi.getter(name="skipResourceInUseCheckOnDelete")
    def skip_resource_in_use_check_on_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to allow deleting action group while it is in use.
        """
        return pulumi.get(self, "skip_resource_in_use_check_on_delete")

    @skip_resource_in_use_check_on_delete.setter
    def skip_resource_in_use_check_on_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_resource_in_use_check_on_delete", value)


@pulumi.input_type
class AgentAliasRoutingConfigurationListItemArgs:
    def __init__(__self__, *,
                 agent_version: pulumi.Input[str]):
        """
        Details about the routing configuration for an Agent alias.
        :param pulumi.Input[str] agent_version: Agent Version.
        """
        pulumi.set(__self__, "agent_version", agent_version)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> pulumi.Input[str]:
        """
        Agent Version.
        """
        return pulumi.get(self, "agent_version")

    @agent_version.setter
    def agent_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "agent_version", value)


@pulumi.input_type
class AgentApiSchema0PropertiesArgs:
    def __init__(__self__, *,
                 s3: pulumi.Input['AgentS3IdentifierArgs']):
        """
        Contains information about the API Schema for the Action Group
        """
        pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter
    def s3(self) -> pulumi.Input['AgentS3IdentifierArgs']:
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: pulumi.Input['AgentS3IdentifierArgs']):
        pulumi.set(self, "s3", value)


@pulumi.input_type
class AgentApiSchema1PropertiesArgs:
    def __init__(__self__, *,
                 payload: pulumi.Input[str]):
        """
        Contains information about the API Schema for the Action Group
        :param pulumi.Input[str] payload: String OpenAPI Payload
        """
        pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter
    def payload(self) -> pulumi.Input[str]:
        """
        String OpenAPI Payload
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: pulumi.Input[str]):
        pulumi.set(self, "payload", value)


@pulumi.input_type
class AgentInferenceConfigurationArgs:
    def __init__(__self__, *,
                 maximum_length: Optional[pulumi.Input[float]] = None,
                 stop_sequences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 temperature: Optional[pulumi.Input[float]] = None,
                 top_k: Optional[pulumi.Input[float]] = None,
                 top_p: Optional[pulumi.Input[float]] = None):
        """
        Configuration for inference in prompt configuration
        :param pulumi.Input[float] maximum_length: Maximum length of output
        :param pulumi.Input[Sequence[pulumi.Input[str]]] stop_sequences: List of stop sequences
        :param pulumi.Input[float] temperature: Controls randomness, higher values increase diversity
        :param pulumi.Input[float] top_k: Sample from the k most likely next tokens
        :param pulumi.Input[float] top_p: Cumulative probability cutoff for token selection
        """
        if maximum_length is not None:
            pulumi.set(__self__, "maximum_length", maximum_length)
        if stop_sequences is not None:
            pulumi.set(__self__, "stop_sequences", stop_sequences)
        if temperature is not None:
            pulumi.set(__self__, "temperature", temperature)
        if top_k is not None:
            pulumi.set(__self__, "top_k", top_k)
        if top_p is not None:
            pulumi.set(__self__, "top_p", top_p)

    @property
    @pulumi.getter(name="maximumLength")
    def maximum_length(self) -> Optional[pulumi.Input[float]]:
        """
        Maximum length of output
        """
        return pulumi.get(self, "maximum_length")

    @maximum_length.setter
    def maximum_length(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "maximum_length", value)

    @property
    @pulumi.getter(name="stopSequences")
    def stop_sequences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of stop sequences
        """
        return pulumi.get(self, "stop_sequences")

    @stop_sequences.setter
    def stop_sequences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "stop_sequences", value)

    @property
    @pulumi.getter
    def temperature(self) -> Optional[pulumi.Input[float]]:
        """
        Controls randomness, higher values increase diversity
        """
        return pulumi.get(self, "temperature")

    @temperature.setter
    def temperature(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "temperature", value)

    @property
    @pulumi.getter(name="topK")
    def top_k(self) -> Optional[pulumi.Input[float]]:
        """
        Sample from the k most likely next tokens
        """
        return pulumi.get(self, "top_k")

    @top_k.setter
    def top_k(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "top_k", value)

    @property
    @pulumi.getter(name="topP")
    def top_p(self) -> Optional[pulumi.Input[float]]:
        """
        Cumulative probability cutoff for token selection
        """
        return pulumi.get(self, "top_p")

    @top_p.setter
    def top_p(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "top_p", value)


@pulumi.input_type
class AgentKnowledgeBaseArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 knowledge_base_id: pulumi.Input[str],
                 knowledge_base_state: Optional[pulumi.Input['AgentKnowledgeBaseState']] = None):
        """
        Agent Knowledge Base
        :param pulumi.Input[str] description: Description of the Resource.
        :param pulumi.Input[str] knowledge_base_id: Identifier for a resource.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "knowledge_base_id", knowledge_base_id)
        if knowledge_base_state is not None:
            pulumi.set(__self__, "knowledge_base_state", knowledge_base_state)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        Description of the Resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="knowledgeBaseId")
    def knowledge_base_id(self) -> pulumi.Input[str]:
        """
        Identifier for a resource.
        """
        return pulumi.get(self, "knowledge_base_id")

    @knowledge_base_id.setter
    def knowledge_base_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "knowledge_base_id", value)

    @property
    @pulumi.getter(name="knowledgeBaseState")
    def knowledge_base_state(self) -> Optional[pulumi.Input['AgentKnowledgeBaseState']]:
        return pulumi.get(self, "knowledge_base_state")

    @knowledge_base_state.setter
    def knowledge_base_state(self, value: Optional[pulumi.Input['AgentKnowledgeBaseState']]):
        pulumi.set(self, "knowledge_base_state", value)


@pulumi.input_type
class AgentPromptConfigurationArgs:
    def __init__(__self__, *,
                 base_prompt_template: Optional[pulumi.Input[str]] = None,
                 inference_configuration: Optional[pulumi.Input['AgentInferenceConfigurationArgs']] = None,
                 parser_mode: Optional[pulumi.Input['AgentCreationMode']] = None,
                 prompt_creation_mode: Optional[pulumi.Input['AgentCreationMode']] = None,
                 prompt_state: Optional[pulumi.Input['AgentPromptState']] = None,
                 prompt_type: Optional[pulumi.Input['AgentPromptType']] = None):
        """
        BasePromptConfiguration per Prompt Type.
        :param pulumi.Input[str] base_prompt_template: Base Prompt Template.
        """
        if base_prompt_template is not None:
            pulumi.set(__self__, "base_prompt_template", base_prompt_template)
        if inference_configuration is not None:
            pulumi.set(__self__, "inference_configuration", inference_configuration)
        if parser_mode is not None:
            pulumi.set(__self__, "parser_mode", parser_mode)
        if prompt_creation_mode is not None:
            pulumi.set(__self__, "prompt_creation_mode", prompt_creation_mode)
        if prompt_state is not None:
            pulumi.set(__self__, "prompt_state", prompt_state)
        if prompt_type is not None:
            pulumi.set(__self__, "prompt_type", prompt_type)

    @property
    @pulumi.getter(name="basePromptTemplate")
    def base_prompt_template(self) -> Optional[pulumi.Input[str]]:
        """
        Base Prompt Template.
        """
        return pulumi.get(self, "base_prompt_template")

    @base_prompt_template.setter
    def base_prompt_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_prompt_template", value)

    @property
    @pulumi.getter(name="inferenceConfiguration")
    def inference_configuration(self) -> Optional[pulumi.Input['AgentInferenceConfigurationArgs']]:
        return pulumi.get(self, "inference_configuration")

    @inference_configuration.setter
    def inference_configuration(self, value: Optional[pulumi.Input['AgentInferenceConfigurationArgs']]):
        pulumi.set(self, "inference_configuration", value)

    @property
    @pulumi.getter(name="parserMode")
    def parser_mode(self) -> Optional[pulumi.Input['AgentCreationMode']]:
        return pulumi.get(self, "parser_mode")

    @parser_mode.setter
    def parser_mode(self, value: Optional[pulumi.Input['AgentCreationMode']]):
        pulumi.set(self, "parser_mode", value)

    @property
    @pulumi.getter(name="promptCreationMode")
    def prompt_creation_mode(self) -> Optional[pulumi.Input['AgentCreationMode']]:
        return pulumi.get(self, "prompt_creation_mode")

    @prompt_creation_mode.setter
    def prompt_creation_mode(self, value: Optional[pulumi.Input['AgentCreationMode']]):
        pulumi.set(self, "prompt_creation_mode", value)

    @property
    @pulumi.getter(name="promptState")
    def prompt_state(self) -> Optional[pulumi.Input['AgentPromptState']]:
        return pulumi.get(self, "prompt_state")

    @prompt_state.setter
    def prompt_state(self, value: Optional[pulumi.Input['AgentPromptState']]):
        pulumi.set(self, "prompt_state", value)

    @property
    @pulumi.getter(name="promptType")
    def prompt_type(self) -> Optional[pulumi.Input['AgentPromptType']]:
        return pulumi.get(self, "prompt_type")

    @prompt_type.setter
    def prompt_type(self, value: Optional[pulumi.Input['AgentPromptType']]):
        pulumi.set(self, "prompt_type", value)


@pulumi.input_type
class AgentPromptOverrideConfigurationArgs:
    def __init__(__self__, *,
                 prompt_configurations: pulumi.Input[Sequence[pulumi.Input['AgentPromptConfigurationArgs']]],
                 override_lambda: Optional[pulumi.Input[str]] = None):
        """
        Configuration for prompt override.
        :param pulumi.Input[Sequence[pulumi.Input['AgentPromptConfigurationArgs']]] prompt_configurations: List of BasePromptConfiguration
        :param pulumi.Input[str] override_lambda: ARN of a Lambda.
        """
        pulumi.set(__self__, "prompt_configurations", prompt_configurations)
        if override_lambda is not None:
            pulumi.set(__self__, "override_lambda", override_lambda)

    @property
    @pulumi.getter(name="promptConfigurations")
    def prompt_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['AgentPromptConfigurationArgs']]]:
        """
        List of BasePromptConfiguration
        """
        return pulumi.get(self, "prompt_configurations")

    @prompt_configurations.setter
    def prompt_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['AgentPromptConfigurationArgs']]]):
        pulumi.set(self, "prompt_configurations", value)

    @property
    @pulumi.getter(name="overrideLambda")
    def override_lambda(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of a Lambda.
        """
        return pulumi.get(self, "override_lambda")

    @override_lambda.setter
    def override_lambda(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "override_lambda", value)


@pulumi.input_type
class AgentS3IdentifierArgs:
    def __init__(__self__, *,
                 s3_bucket_name: Optional[pulumi.Input[str]] = None,
                 s3_object_key: Optional[pulumi.Input[str]] = None):
        """
        The identifier for the S3 resource.
        :param pulumi.Input[str] s3_bucket_name: A bucket in S3.
        :param pulumi.Input[str] s3_object_key: A object key in S3.
        """
        if s3_bucket_name is not None:
            pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_object_key is not None:
            pulumi.set(__self__, "s3_object_key", s3_object_key)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        A bucket in S3.
        """
        return pulumi.get(self, "s3_bucket_name")

    @s3_bucket_name.setter
    def s3_bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_bucket_name", value)

    @property
    @pulumi.getter(name="s3ObjectKey")
    def s3_object_key(self) -> Optional[pulumi.Input[str]]:
        """
        A object key in S3.
        """
        return pulumi.get(self, "s3_object_key")

    @s3_object_key.setter
    def s3_object_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_object_key", value)


@pulumi.input_type
class DataSourceChunkingConfigurationArgs:
    def __init__(__self__, *,
                 chunking_strategy: pulumi.Input['DataSourceChunkingStrategy'],
                 fixed_size_chunking_configuration: Optional[pulumi.Input['DataSourceFixedSizeChunkingConfigurationArgs']] = None):
        """
        Details about how to chunk the documents in the data source. A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
        """
        pulumi.set(__self__, "chunking_strategy", chunking_strategy)
        if fixed_size_chunking_configuration is not None:
            pulumi.set(__self__, "fixed_size_chunking_configuration", fixed_size_chunking_configuration)

    @property
    @pulumi.getter(name="chunkingStrategy")
    def chunking_strategy(self) -> pulumi.Input['DataSourceChunkingStrategy']:
        return pulumi.get(self, "chunking_strategy")

    @chunking_strategy.setter
    def chunking_strategy(self, value: pulumi.Input['DataSourceChunkingStrategy']):
        pulumi.set(self, "chunking_strategy", value)

    @property
    @pulumi.getter(name="fixedSizeChunkingConfiguration")
    def fixed_size_chunking_configuration(self) -> Optional[pulumi.Input['DataSourceFixedSizeChunkingConfigurationArgs']]:
        return pulumi.get(self, "fixed_size_chunking_configuration")

    @fixed_size_chunking_configuration.setter
    def fixed_size_chunking_configuration(self, value: Optional[pulumi.Input['DataSourceFixedSizeChunkingConfigurationArgs']]):
        pulumi.set(self, "fixed_size_chunking_configuration", value)


@pulumi.input_type
class DataSourceConfigurationArgs:
    def __init__(__self__, *,
                 s3_configuration: pulumi.Input['DataSourceS3DataSourceConfigurationArgs'],
                 type: pulumi.Input['DataSourceType']):
        """
        Specifies a raw data source location to ingest.
        """
        pulumi.set(__self__, "s3_configuration", s3_configuration)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="s3Configuration")
    def s3_configuration(self) -> pulumi.Input['DataSourceS3DataSourceConfigurationArgs']:
        return pulumi.get(self, "s3_configuration")

    @s3_configuration.setter
    def s3_configuration(self, value: pulumi.Input['DataSourceS3DataSourceConfigurationArgs']):
        pulumi.set(self, "s3_configuration", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['DataSourceType']:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['DataSourceType']):
        pulumi.set(self, "type", value)


@pulumi.input_type
class DataSourceFixedSizeChunkingConfigurationArgs:
    def __init__(__self__, *,
                 max_tokens: pulumi.Input[int],
                 overlap_percentage: pulumi.Input[int]):
        """
        Configurations for when you choose fixed-size chunking. If you set the chunkingStrategy as NONE, exclude this field.
        :param pulumi.Input[int] max_tokens: The maximum number of tokens to include in a chunk.
        :param pulumi.Input[int] overlap_percentage: The percentage of overlap between adjacent chunks of a data source.
        """
        pulumi.set(__self__, "max_tokens", max_tokens)
        pulumi.set(__self__, "overlap_percentage", overlap_percentage)

    @property
    @pulumi.getter(name="maxTokens")
    def max_tokens(self) -> pulumi.Input[int]:
        """
        The maximum number of tokens to include in a chunk.
        """
        return pulumi.get(self, "max_tokens")

    @max_tokens.setter
    def max_tokens(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_tokens", value)

    @property
    @pulumi.getter(name="overlapPercentage")
    def overlap_percentage(self) -> pulumi.Input[int]:
        """
        The percentage of overlap between adjacent chunks of a data source.
        """
        return pulumi.get(self, "overlap_percentage")

    @overlap_percentage.setter
    def overlap_percentage(self, value: pulumi.Input[int]):
        pulumi.set(self, "overlap_percentage", value)


@pulumi.input_type
class DataSourceS3DataSourceConfigurationArgs:
    def __init__(__self__, *,
                 bucket_arn: pulumi.Input[str],
                 bucket_owner_account_id: Optional[pulumi.Input[str]] = None,
                 inclusion_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Contains information about the S3 configuration of the data source.
        :param pulumi.Input[str] bucket_arn: The ARN of the bucket that contains the data source.
        :param pulumi.Input[str] bucket_owner_account_id: The account ID for the owner of the S3 bucket.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] inclusion_prefixes: A list of S3 prefixes that define the object containing the data sources.
        """
        pulumi.set(__self__, "bucket_arn", bucket_arn)
        if bucket_owner_account_id is not None:
            pulumi.set(__self__, "bucket_owner_account_id", bucket_owner_account_id)
        if inclusion_prefixes is not None:
            pulumi.set(__self__, "inclusion_prefixes", inclusion_prefixes)

    @property
    @pulumi.getter(name="bucketArn")
    def bucket_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the bucket that contains the data source.
        """
        return pulumi.get(self, "bucket_arn")

    @bucket_arn.setter
    def bucket_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_arn", value)

    @property
    @pulumi.getter(name="bucketOwnerAccountId")
    def bucket_owner_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account ID for the owner of the S3 bucket.
        """
        return pulumi.get(self, "bucket_owner_account_id")

    @bucket_owner_account_id.setter
    def bucket_owner_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_owner_account_id", value)

    @property
    @pulumi.getter(name="inclusionPrefixes")
    def inclusion_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of S3 prefixes that define the object containing the data sources.
        """
        return pulumi.get(self, "inclusion_prefixes")

    @inclusion_prefixes.setter
    def inclusion_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "inclusion_prefixes", value)


@pulumi.input_type
class DataSourceServerSideEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 kms_key_arn: Optional[pulumi.Input[str]] = None):
        """
        Contains details about the server-side encryption for the data source.
        :param pulumi.Input[str] kms_key_arn: The ARN of the AWS KMS key used to encrypt the resource.
        """
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the AWS KMS key used to encrypt the resource.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)


@pulumi.input_type
class DataSourceVectorIngestionConfigurationArgs:
    def __init__(__self__, *,
                 chunking_configuration: Optional[pulumi.Input['DataSourceChunkingConfigurationArgs']] = None):
        """
        Details about how to chunk the documents in the data source. A chunk refers to an excerpt from a data source that is returned when the knowledge base that it belongs to is queried.
        """
        if chunking_configuration is not None:
            pulumi.set(__self__, "chunking_configuration", chunking_configuration)

    @property
    @pulumi.getter(name="chunkingConfiguration")
    def chunking_configuration(self) -> Optional[pulumi.Input['DataSourceChunkingConfigurationArgs']]:
        return pulumi.get(self, "chunking_configuration")

    @chunking_configuration.setter
    def chunking_configuration(self, value: Optional[pulumi.Input['DataSourceChunkingConfigurationArgs']]):
        pulumi.set(self, "chunking_configuration", value)


@pulumi.input_type
class GuardrailContentFilterConfigArgs:
    def __init__(__self__, *,
                 input_strength: pulumi.Input['GuardrailFilterStrength'],
                 output_strength: pulumi.Input['GuardrailFilterStrength'],
                 type: pulumi.Input['GuardrailContentFilterType']):
        """
        Content filter config in content policy.
        """
        pulumi.set(__self__, "input_strength", input_strength)
        pulumi.set(__self__, "output_strength", output_strength)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="inputStrength")
    def input_strength(self) -> pulumi.Input['GuardrailFilterStrength']:
        return pulumi.get(self, "input_strength")

    @input_strength.setter
    def input_strength(self, value: pulumi.Input['GuardrailFilterStrength']):
        pulumi.set(self, "input_strength", value)

    @property
    @pulumi.getter(name="outputStrength")
    def output_strength(self) -> pulumi.Input['GuardrailFilterStrength']:
        return pulumi.get(self, "output_strength")

    @output_strength.setter
    def output_strength(self, value: pulumi.Input['GuardrailFilterStrength']):
        pulumi.set(self, "output_strength", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['GuardrailContentFilterType']:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['GuardrailContentFilterType']):
        pulumi.set(self, "type", value)


@pulumi.input_type
class GuardrailContentPolicyConfigArgs:
    def __init__(__self__, *,
                 filters_config: pulumi.Input[Sequence[pulumi.Input['GuardrailContentFilterConfigArgs']]]):
        """
        Content policy config for a guardrail.
        :param pulumi.Input[Sequence[pulumi.Input['GuardrailContentFilterConfigArgs']]] filters_config: List of content filter configs in content policy.
        """
        pulumi.set(__self__, "filters_config", filters_config)

    @property
    @pulumi.getter(name="filtersConfig")
    def filters_config(self) -> pulumi.Input[Sequence[pulumi.Input['GuardrailContentFilterConfigArgs']]]:
        """
        List of content filter configs in content policy.
        """
        return pulumi.get(self, "filters_config")

    @filters_config.setter
    def filters_config(self, value: pulumi.Input[Sequence[pulumi.Input['GuardrailContentFilterConfigArgs']]]):
        pulumi.set(self, "filters_config", value)


@pulumi.input_type
class GuardrailManagedWordsConfigArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['GuardrailManagedWordsType']):
        """
        A managed words config.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['GuardrailManagedWordsType']:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['GuardrailManagedWordsType']):
        pulumi.set(self, "type", value)


@pulumi.input_type
class GuardrailPiiEntityConfigArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['GuardrailSensitiveInformationAction'],
                 type: pulumi.Input['GuardrailPiiEntityType']):
        """
        Pii entity configuration.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input['GuardrailSensitiveInformationAction']:
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['GuardrailSensitiveInformationAction']):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['GuardrailPiiEntityType']:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['GuardrailPiiEntityType']):
        pulumi.set(self, "type", value)


@pulumi.input_type
class GuardrailRegexConfigArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['GuardrailSensitiveInformationAction'],
                 name: pulumi.Input[str],
                 pattern: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        A regex configuration.
        :param pulumi.Input[str] name: The regex name.
        :param pulumi.Input[str] pattern: The regex pattern.
        :param pulumi.Input[str] description: The regex description.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pattern", pattern)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input['GuardrailSensitiveInformationAction']:
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['GuardrailSensitiveInformationAction']):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The regex name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def pattern(self) -> pulumi.Input[str]:
        """
        The regex pattern.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: pulumi.Input[str]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The regex description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class GuardrailSensitiveInformationPolicyConfigArgs:
    def __init__(__self__, *,
                 pii_entities_config: Optional[pulumi.Input[Sequence[pulumi.Input['GuardrailPiiEntityConfigArgs']]]] = None,
                 regexes_config: Optional[pulumi.Input[Sequence[pulumi.Input['GuardrailRegexConfigArgs']]]] = None):
        """
        Sensitive information policy config for a guardrail.
        :param pulumi.Input[Sequence[pulumi.Input['GuardrailPiiEntityConfigArgs']]] pii_entities_config: List of entities.
        :param pulumi.Input[Sequence[pulumi.Input['GuardrailRegexConfigArgs']]] regexes_config: List of regex.
        """
        if pii_entities_config is not None:
            pulumi.set(__self__, "pii_entities_config", pii_entities_config)
        if regexes_config is not None:
            pulumi.set(__self__, "regexes_config", regexes_config)

    @property
    @pulumi.getter(name="piiEntitiesConfig")
    def pii_entities_config(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GuardrailPiiEntityConfigArgs']]]]:
        """
        List of entities.
        """
        return pulumi.get(self, "pii_entities_config")

    @pii_entities_config.setter
    def pii_entities_config(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GuardrailPiiEntityConfigArgs']]]]):
        pulumi.set(self, "pii_entities_config", value)

    @property
    @pulumi.getter(name="regexesConfig")
    def regexes_config(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GuardrailRegexConfigArgs']]]]:
        """
        List of regex.
        """
        return pulumi.get(self, "regexes_config")

    @regexes_config.setter
    def regexes_config(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GuardrailRegexConfigArgs']]]]):
        pulumi.set(self, "regexes_config", value)


@pulumi.input_type
class GuardrailTopicConfigArgs:
    def __init__(__self__, *,
                 definition: pulumi.Input[str],
                 name: pulumi.Input[str],
                 type: pulumi.Input['GuardrailTopicType'],
                 examples: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Topic config in topic policy.
        :param pulumi.Input[str] definition: Definition of topic in topic policy
        :param pulumi.Input[str] name: Name of topic in topic policy
        :param pulumi.Input[Sequence[pulumi.Input[str]]] examples: List of text examples
        """
        pulumi.set(__self__, "definition", definition)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if examples is not None:
            pulumi.set(__self__, "examples", examples)

    @property
    @pulumi.getter
    def definition(self) -> pulumi.Input[str]:
        """
        Definition of topic in topic policy
        """
        return pulumi.get(self, "definition")

    @definition.setter
    def definition(self, value: pulumi.Input[str]):
        pulumi.set(self, "definition", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of topic in topic policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['GuardrailTopicType']:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['GuardrailTopicType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def examples(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of text examples
        """
        return pulumi.get(self, "examples")

    @examples.setter
    def examples(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "examples", value)


@pulumi.input_type
class GuardrailTopicPolicyConfigArgs:
    def __init__(__self__, *,
                 topics_config: pulumi.Input[Sequence[pulumi.Input['GuardrailTopicConfigArgs']]]):
        """
        Topic policy config for a guardrail.
        :param pulumi.Input[Sequence[pulumi.Input['GuardrailTopicConfigArgs']]] topics_config: List of topic configs in topic policy.
        """
        pulumi.set(__self__, "topics_config", topics_config)

    @property
    @pulumi.getter(name="topicsConfig")
    def topics_config(self) -> pulumi.Input[Sequence[pulumi.Input['GuardrailTopicConfigArgs']]]:
        """
        List of topic configs in topic policy.
        """
        return pulumi.get(self, "topics_config")

    @topics_config.setter
    def topics_config(self, value: pulumi.Input[Sequence[pulumi.Input['GuardrailTopicConfigArgs']]]):
        pulumi.set(self, "topics_config", value)


@pulumi.input_type
class GuardrailWordConfigArgs:
    def __init__(__self__, *,
                 text: pulumi.Input[str]):
        """
        A custom word config.
        :param pulumi.Input[str] text: The custom word text.
        """
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> pulumi.Input[str]:
        """
        The custom word text.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: pulumi.Input[str]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class GuardrailWordPolicyConfigArgs:
    def __init__(__self__, *,
                 managed_word_lists_config: Optional[pulumi.Input[Sequence[pulumi.Input['GuardrailManagedWordsConfigArgs']]]] = None,
                 words_config: Optional[pulumi.Input[Sequence[pulumi.Input['GuardrailWordConfigArgs']]]] = None):
        """
        Word policy config for a guardrail.
        :param pulumi.Input[Sequence[pulumi.Input['GuardrailManagedWordsConfigArgs']]] managed_word_lists_config: A config for the list of managed words.
        :param pulumi.Input[Sequence[pulumi.Input['GuardrailWordConfigArgs']]] words_config: List of custom word configs.
        """
        if managed_word_lists_config is not None:
            pulumi.set(__self__, "managed_word_lists_config", managed_word_lists_config)
        if words_config is not None:
            pulumi.set(__self__, "words_config", words_config)

    @property
    @pulumi.getter(name="managedWordListsConfig")
    def managed_word_lists_config(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GuardrailManagedWordsConfigArgs']]]]:
        """
        A config for the list of managed words.
        """
        return pulumi.get(self, "managed_word_lists_config")

    @managed_word_lists_config.setter
    def managed_word_lists_config(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GuardrailManagedWordsConfigArgs']]]]):
        pulumi.set(self, "managed_word_lists_config", value)

    @property
    @pulumi.getter(name="wordsConfig")
    def words_config(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GuardrailWordConfigArgs']]]]:
        """
        List of custom word configs.
        """
        return pulumi.get(self, "words_config")

    @words_config.setter
    def words_config(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GuardrailWordConfigArgs']]]]):
        pulumi.set(self, "words_config", value)


@pulumi.input_type
class KnowledgeBaseConfigurationArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['KnowledgeBaseType'],
                 vector_knowledge_base_configuration: pulumi.Input['KnowledgeBaseVectorKnowledgeBaseConfigurationArgs']):
        """
        Contains details about the embeddings model used for the knowledge base.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vector_knowledge_base_configuration", vector_knowledge_base_configuration)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['KnowledgeBaseType']:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['KnowledgeBaseType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vectorKnowledgeBaseConfiguration")
    def vector_knowledge_base_configuration(self) -> pulumi.Input['KnowledgeBaseVectorKnowledgeBaseConfigurationArgs']:
        return pulumi.get(self, "vector_knowledge_base_configuration")

    @vector_knowledge_base_configuration.setter
    def vector_knowledge_base_configuration(self, value: pulumi.Input['KnowledgeBaseVectorKnowledgeBaseConfigurationArgs']):
        pulumi.set(self, "vector_knowledge_base_configuration", value)


@pulumi.input_type
class KnowledgeBaseOpenSearchServerlessConfigurationArgs:
    def __init__(__self__, *,
                 collection_arn: pulumi.Input[str],
                 field_mapping: pulumi.Input['KnowledgeBaseOpenSearchServerlessFieldMappingArgs'],
                 vector_index_name: pulumi.Input[str]):
        """
        Contains the storage configuration of the knowledge base in Amazon OpenSearch Service.
        :param pulumi.Input[str] collection_arn: The ARN of the OpenSearch Service vector store.
        :param pulumi.Input[str] vector_index_name: The name of the vector store.
        """
        pulumi.set(__self__, "collection_arn", collection_arn)
        pulumi.set(__self__, "field_mapping", field_mapping)
        pulumi.set(__self__, "vector_index_name", vector_index_name)

    @property
    @pulumi.getter(name="collectionArn")
    def collection_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the OpenSearch Service vector store.
        """
        return pulumi.get(self, "collection_arn")

    @collection_arn.setter
    def collection_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "collection_arn", value)

    @property
    @pulumi.getter(name="fieldMapping")
    def field_mapping(self) -> pulumi.Input['KnowledgeBaseOpenSearchServerlessFieldMappingArgs']:
        return pulumi.get(self, "field_mapping")

    @field_mapping.setter
    def field_mapping(self, value: pulumi.Input['KnowledgeBaseOpenSearchServerlessFieldMappingArgs']):
        pulumi.set(self, "field_mapping", value)

    @property
    @pulumi.getter(name="vectorIndexName")
    def vector_index_name(self) -> pulumi.Input[str]:
        """
        The name of the vector store.
        """
        return pulumi.get(self, "vector_index_name")

    @vector_index_name.setter
    def vector_index_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "vector_index_name", value)


@pulumi.input_type
class KnowledgeBaseOpenSearchServerlessFieldMappingArgs:
    def __init__(__self__, *,
                 metadata_field: pulumi.Input[str],
                 text_field: pulumi.Input[str],
                 vector_field: pulumi.Input[str]):
        """
        A mapping of Bedrock Knowledge Base fields to OpenSearch Serverless field names
        :param pulumi.Input[str] metadata_field: The name of the field in which Amazon Bedrock stores metadata about the vector store.
        :param pulumi.Input[str] text_field: The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
        :param pulumi.Input[str] vector_field: The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
        """
        pulumi.set(__self__, "metadata_field", metadata_field)
        pulumi.set(__self__, "text_field", text_field)
        pulumi.set(__self__, "vector_field", vector_field)

    @property
    @pulumi.getter(name="metadataField")
    def metadata_field(self) -> pulumi.Input[str]:
        """
        The name of the field in which Amazon Bedrock stores metadata about the vector store.
        """
        return pulumi.get(self, "metadata_field")

    @metadata_field.setter
    def metadata_field(self, value: pulumi.Input[str]):
        pulumi.set(self, "metadata_field", value)

    @property
    @pulumi.getter(name="textField")
    def text_field(self) -> pulumi.Input[str]:
        """
        The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
        """
        return pulumi.get(self, "text_field")

    @text_field.setter
    def text_field(self, value: pulumi.Input[str]):
        pulumi.set(self, "text_field", value)

    @property
    @pulumi.getter(name="vectorField")
    def vector_field(self) -> pulumi.Input[str]:
        """
        The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
        """
        return pulumi.get(self, "vector_field")

    @vector_field.setter
    def vector_field(self, value: pulumi.Input[str]):
        pulumi.set(self, "vector_field", value)


@pulumi.input_type
class KnowledgeBasePineconeConfigurationArgs:
    def __init__(__self__, *,
                 connection_string: pulumi.Input[str],
                 credentials_secret_arn: pulumi.Input[str],
                 field_mapping: pulumi.Input['KnowledgeBasePineconeFieldMappingArgs'],
                 namespace: Optional[pulumi.Input[str]] = None):
        """
        Contains the storage configuration of the knowledge base in Pinecone.
        :param pulumi.Input[str] connection_string: The endpoint URL for your index management page.
        :param pulumi.Input[str] credentials_secret_arn: The ARN of the secret that you created in AWS Secrets Manager that is linked to your Pinecone API key.
        :param pulumi.Input[str] namespace: The namespace to be used to write new data to your database.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "credentials_secret_arn", credentials_secret_arn)
        pulumi.set(__self__, "field_mapping", field_mapping)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Input[str]:
        """
        The endpoint URL for your index management page.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="credentialsSecretArn")
    def credentials_secret_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the secret that you created in AWS Secrets Manager that is linked to your Pinecone API key.
        """
        return pulumi.get(self, "credentials_secret_arn")

    @credentials_secret_arn.setter
    def credentials_secret_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "credentials_secret_arn", value)

    @property
    @pulumi.getter(name="fieldMapping")
    def field_mapping(self) -> pulumi.Input['KnowledgeBasePineconeFieldMappingArgs']:
        return pulumi.get(self, "field_mapping")

    @field_mapping.setter
    def field_mapping(self, value: pulumi.Input['KnowledgeBasePineconeFieldMappingArgs']):
        pulumi.set(self, "field_mapping", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to be used to write new data to your database.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class KnowledgeBasePineconeFieldMappingArgs:
    def __init__(__self__, *,
                 metadata_field: pulumi.Input[str],
                 text_field: pulumi.Input[str]):
        """
        Contains the names of the fields to which to map information about the vector store.
        :param pulumi.Input[str] metadata_field: The name of the field in which Amazon Bedrock stores metadata about the vector store.
        :param pulumi.Input[str] text_field: The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
        """
        pulumi.set(__self__, "metadata_field", metadata_field)
        pulumi.set(__self__, "text_field", text_field)

    @property
    @pulumi.getter(name="metadataField")
    def metadata_field(self) -> pulumi.Input[str]:
        """
        The name of the field in which Amazon Bedrock stores metadata about the vector store.
        """
        return pulumi.get(self, "metadata_field")

    @metadata_field.setter
    def metadata_field(self, value: pulumi.Input[str]):
        pulumi.set(self, "metadata_field", value)

    @property
    @pulumi.getter(name="textField")
    def text_field(self) -> pulumi.Input[str]:
        """
        The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
        """
        return pulumi.get(self, "text_field")

    @text_field.setter
    def text_field(self, value: pulumi.Input[str]):
        pulumi.set(self, "text_field", value)


@pulumi.input_type
class KnowledgeBaseRdsConfigurationArgs:
    def __init__(__self__, *,
                 credentials_secret_arn: pulumi.Input[str],
                 database_name: pulumi.Input[str],
                 field_mapping: pulumi.Input['KnowledgeBaseRdsFieldMappingArgs'],
                 resource_arn: pulumi.Input[str],
                 table_name: pulumi.Input[str]):
        """
        Contains details about the storage configuration of the knowledge base in Amazon RDS. For more information, see Create a vector index in Amazon RDS.
        :param pulumi.Input[str] credentials_secret_arn: The ARN of the secret that you created in AWS Secrets Manager that is linked to your Amazon RDS database.
        :param pulumi.Input[str] database_name: The name of your Amazon RDS database.
        :param pulumi.Input[str] resource_arn: The ARN of the vector store.
        :param pulumi.Input[str] table_name: The name of the table in the database.
        """
        pulumi.set(__self__, "credentials_secret_arn", credentials_secret_arn)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "field_mapping", field_mapping)
        pulumi.set(__self__, "resource_arn", resource_arn)
        pulumi.set(__self__, "table_name", table_name)

    @property
    @pulumi.getter(name="credentialsSecretArn")
    def credentials_secret_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the secret that you created in AWS Secrets Manager that is linked to your Amazon RDS database.
        """
        return pulumi.get(self, "credentials_secret_arn")

    @credentials_secret_arn.setter
    def credentials_secret_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "credentials_secret_arn", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        The name of your Amazon RDS database.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="fieldMapping")
    def field_mapping(self) -> pulumi.Input['KnowledgeBaseRdsFieldMappingArgs']:
        return pulumi.get(self, "field_mapping")

    @field_mapping.setter
    def field_mapping(self, value: pulumi.Input['KnowledgeBaseRdsFieldMappingArgs']):
        pulumi.set(self, "field_mapping", value)

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the vector store.
        """
        return pulumi.get(self, "resource_arn")

    @resource_arn.setter
    def resource_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_arn", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[str]:
        """
        The name of the table in the database.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_name", value)


@pulumi.input_type
class KnowledgeBaseRdsFieldMappingArgs:
    def __init__(__self__, *,
                 metadata_field: pulumi.Input[str],
                 primary_key_field: pulumi.Input[str],
                 text_field: pulumi.Input[str],
                 vector_field: pulumi.Input[str]):
        """
        Contains the names of the fields to which to map information about the vector store.
        :param pulumi.Input[str] metadata_field: The name of the field in which Amazon Bedrock stores metadata about the vector store.
        :param pulumi.Input[str] primary_key_field: The name of the field in which Amazon Bedrock stores the ID for each entry.
        :param pulumi.Input[str] text_field: The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
        :param pulumi.Input[str] vector_field: The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
        """
        pulumi.set(__self__, "metadata_field", metadata_field)
        pulumi.set(__self__, "primary_key_field", primary_key_field)
        pulumi.set(__self__, "text_field", text_field)
        pulumi.set(__self__, "vector_field", vector_field)

    @property
    @pulumi.getter(name="metadataField")
    def metadata_field(self) -> pulumi.Input[str]:
        """
        The name of the field in which Amazon Bedrock stores metadata about the vector store.
        """
        return pulumi.get(self, "metadata_field")

    @metadata_field.setter
    def metadata_field(self, value: pulumi.Input[str]):
        pulumi.set(self, "metadata_field", value)

    @property
    @pulumi.getter(name="primaryKeyField")
    def primary_key_field(self) -> pulumi.Input[str]:
        """
        The name of the field in which Amazon Bedrock stores the ID for each entry.
        """
        return pulumi.get(self, "primary_key_field")

    @primary_key_field.setter
    def primary_key_field(self, value: pulumi.Input[str]):
        pulumi.set(self, "primary_key_field", value)

    @property
    @pulumi.getter(name="textField")
    def text_field(self) -> pulumi.Input[str]:
        """
        The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to the chunking strategy you choose.
        """
        return pulumi.get(self, "text_field")

    @text_field.setter
    def text_field(self, value: pulumi.Input[str]):
        pulumi.set(self, "text_field", value)

    @property
    @pulumi.getter(name="vectorField")
    def vector_field(self) -> pulumi.Input[str]:
        """
        The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
        """
        return pulumi.get(self, "vector_field")

    @vector_field.setter
    def vector_field(self, value: pulumi.Input[str]):
        pulumi.set(self, "vector_field", value)


@pulumi.input_type
class KnowledgeBaseStorageConfigurationArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['KnowledgeBaseStorageType'],
                 opensearch_serverless_configuration: Optional[pulumi.Input['KnowledgeBaseOpenSearchServerlessConfigurationArgs']] = None,
                 pinecone_configuration: Optional[pulumi.Input['KnowledgeBasePineconeConfigurationArgs']] = None,
                 rds_configuration: Optional[pulumi.Input['KnowledgeBaseRdsConfigurationArgs']] = None):
        """
        The vector store service in which the knowledge base is stored.
        """
        pulumi.set(__self__, "type", type)
        if opensearch_serverless_configuration is not None:
            pulumi.set(__self__, "opensearch_serverless_configuration", opensearch_serverless_configuration)
        if pinecone_configuration is not None:
            pulumi.set(__self__, "pinecone_configuration", pinecone_configuration)
        if rds_configuration is not None:
            pulumi.set(__self__, "rds_configuration", rds_configuration)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['KnowledgeBaseStorageType']:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['KnowledgeBaseStorageType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="opensearchServerlessConfiguration")
    def opensearch_serverless_configuration(self) -> Optional[pulumi.Input['KnowledgeBaseOpenSearchServerlessConfigurationArgs']]:
        return pulumi.get(self, "opensearch_serverless_configuration")

    @opensearch_serverless_configuration.setter
    def opensearch_serverless_configuration(self, value: Optional[pulumi.Input['KnowledgeBaseOpenSearchServerlessConfigurationArgs']]):
        pulumi.set(self, "opensearch_serverless_configuration", value)

    @property
    @pulumi.getter(name="pineconeConfiguration")
    def pinecone_configuration(self) -> Optional[pulumi.Input['KnowledgeBasePineconeConfigurationArgs']]:
        return pulumi.get(self, "pinecone_configuration")

    @pinecone_configuration.setter
    def pinecone_configuration(self, value: Optional[pulumi.Input['KnowledgeBasePineconeConfigurationArgs']]):
        pulumi.set(self, "pinecone_configuration", value)

    @property
    @pulumi.getter(name="rdsConfiguration")
    def rds_configuration(self) -> Optional[pulumi.Input['KnowledgeBaseRdsConfigurationArgs']]:
        return pulumi.get(self, "rds_configuration")

    @rds_configuration.setter
    def rds_configuration(self, value: Optional[pulumi.Input['KnowledgeBaseRdsConfigurationArgs']]):
        pulumi.set(self, "rds_configuration", value)


@pulumi.input_type
class KnowledgeBaseVectorKnowledgeBaseConfigurationArgs:
    def __init__(__self__, *,
                 embedding_model_arn: pulumi.Input[str]):
        """
        Contains details about the model used to create vector embeddings for the knowledge base.
        :param pulumi.Input[str] embedding_model_arn: The ARN of the model used to create vector embeddings for the knowledge base.
        """
        pulumi.set(__self__, "embedding_model_arn", embedding_model_arn)

    @property
    @pulumi.getter(name="embeddingModelArn")
    def embedding_model_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the model used to create vector embeddings for the knowledge base.
        """
        return pulumi.get(self, "embedding_model_arn")

    @embedding_model_arn.setter
    def embedding_model_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "embedding_model_arn", value)


