# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RestoreTestingSelectionArgs', 'RestoreTestingSelection']

@pulumi.input_type
class RestoreTestingSelectionArgs:
    def __init__(__self__, *,
                 iam_role_arn: pulumi.Input[str],
                 protected_resource_type: pulumi.Input[str],
                 restore_testing_plan_name: pulumi.Input[str],
                 protected_resource_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 protected_resource_conditions: Optional[pulumi.Input['RestoreTestingSelectionProtectedResourceConditionsArgs']] = None,
                 restore_metadata_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 restore_testing_selection_name: Optional[pulumi.Input[str]] = None,
                 validation_window_hours: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a RestoreTestingSelection resource.
        """
        pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        pulumi.set(__self__, "protected_resource_type", protected_resource_type)
        pulumi.set(__self__, "restore_testing_plan_name", restore_testing_plan_name)
        if protected_resource_arns is not None:
            pulumi.set(__self__, "protected_resource_arns", protected_resource_arns)
        if protected_resource_conditions is not None:
            pulumi.set(__self__, "protected_resource_conditions", protected_resource_conditions)
        if restore_metadata_overrides is not None:
            pulumi.set(__self__, "restore_metadata_overrides", restore_metadata_overrides)
        if restore_testing_selection_name is not None:
            pulumi.set(__self__, "restore_testing_selection_name", restore_testing_selection_name)
        if validation_window_hours is not None:
            pulumi.set(__self__, "validation_window_hours", validation_window_hours)

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "iam_role_arn")

    @iam_role_arn.setter
    def iam_role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "iam_role_arn", value)

    @property
    @pulumi.getter(name="protectedResourceType")
    def protected_resource_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "protected_resource_type")

    @protected_resource_type.setter
    def protected_resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_resource_type", value)

    @property
    @pulumi.getter(name="restoreTestingPlanName")
    def restore_testing_plan_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "restore_testing_plan_name")

    @restore_testing_plan_name.setter
    def restore_testing_plan_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "restore_testing_plan_name", value)

    @property
    @pulumi.getter(name="protectedResourceArns")
    def protected_resource_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "protected_resource_arns")

    @protected_resource_arns.setter
    def protected_resource_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "protected_resource_arns", value)

    @property
    @pulumi.getter(name="protectedResourceConditions")
    def protected_resource_conditions(self) -> Optional[pulumi.Input['RestoreTestingSelectionProtectedResourceConditionsArgs']]:
        return pulumi.get(self, "protected_resource_conditions")

    @protected_resource_conditions.setter
    def protected_resource_conditions(self, value: Optional[pulumi.Input['RestoreTestingSelectionProtectedResourceConditionsArgs']]):
        pulumi.set(self, "protected_resource_conditions", value)

    @property
    @pulumi.getter(name="restoreMetadataOverrides")
    def restore_metadata_overrides(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "restore_metadata_overrides")

    @restore_metadata_overrides.setter
    def restore_metadata_overrides(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "restore_metadata_overrides", value)

    @property
    @pulumi.getter(name="restoreTestingSelectionName")
    def restore_testing_selection_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "restore_testing_selection_name")

    @restore_testing_selection_name.setter
    def restore_testing_selection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restore_testing_selection_name", value)

    @property
    @pulumi.getter(name="validationWindowHours")
    def validation_window_hours(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "validation_window_hours")

    @validation_window_hours.setter
    def validation_window_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "validation_window_hours", value)


class RestoreTestingSelection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 iam_role_arn: Optional[pulumi.Input[str]] = None,
                 protected_resource_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 protected_resource_conditions: Optional[pulumi.Input[pulumi.InputType['RestoreTestingSelectionProtectedResourceConditionsArgs']]] = None,
                 protected_resource_type: Optional[pulumi.Input[str]] = None,
                 restore_metadata_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 restore_testing_plan_name: Optional[pulumi.Input[str]] = None,
                 restore_testing_selection_name: Optional[pulumi.Input[str]] = None,
                 validation_window_hours: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Backup::RestoreTestingSelection

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RestoreTestingSelectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Backup::RestoreTestingSelection

        :param str resource_name: The name of the resource.
        :param RestoreTestingSelectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RestoreTestingSelectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 iam_role_arn: Optional[pulumi.Input[str]] = None,
                 protected_resource_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 protected_resource_conditions: Optional[pulumi.Input[pulumi.InputType['RestoreTestingSelectionProtectedResourceConditionsArgs']]] = None,
                 protected_resource_type: Optional[pulumi.Input[str]] = None,
                 restore_metadata_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 restore_testing_plan_name: Optional[pulumi.Input[str]] = None,
                 restore_testing_selection_name: Optional[pulumi.Input[str]] = None,
                 validation_window_hours: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RestoreTestingSelectionArgs.__new__(RestoreTestingSelectionArgs)

            if iam_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'iam_role_arn'")
            __props__.__dict__["iam_role_arn"] = iam_role_arn
            __props__.__dict__["protected_resource_arns"] = protected_resource_arns
            __props__.__dict__["protected_resource_conditions"] = protected_resource_conditions
            if protected_resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'protected_resource_type'")
            __props__.__dict__["protected_resource_type"] = protected_resource_type
            __props__.__dict__["restore_metadata_overrides"] = restore_metadata_overrides
            if restore_testing_plan_name is None and not opts.urn:
                raise TypeError("Missing required property 'restore_testing_plan_name'")
            __props__.__dict__["restore_testing_plan_name"] = restore_testing_plan_name
            __props__.__dict__["restore_testing_selection_name"] = restore_testing_selection_name
            __props__.__dict__["validation_window_hours"] = validation_window_hours
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["protectedResourceType", "restoreTestingPlanName", "restoreTestingSelectionName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(RestoreTestingSelection, __self__).__init__(
            'aws-native:backup:RestoreTestingSelection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'RestoreTestingSelection':
        """
        Get an existing RestoreTestingSelection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RestoreTestingSelectionArgs.__new__(RestoreTestingSelectionArgs)

        __props__.__dict__["iam_role_arn"] = None
        __props__.__dict__["protected_resource_arns"] = None
        __props__.__dict__["protected_resource_conditions"] = None
        __props__.__dict__["protected_resource_type"] = None
        __props__.__dict__["restore_metadata_overrides"] = None
        __props__.__dict__["restore_testing_plan_name"] = None
        __props__.__dict__["restore_testing_selection_name"] = None
        __props__.__dict__["validation_window_hours"] = None
        return RestoreTestingSelection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "iam_role_arn")

    @property
    @pulumi.getter(name="protectedResourceArns")
    def protected_resource_arns(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "protected_resource_arns")

    @property
    @pulumi.getter(name="protectedResourceConditions")
    def protected_resource_conditions(self) -> pulumi.Output[Optional['outputs.RestoreTestingSelectionProtectedResourceConditions']]:
        return pulumi.get(self, "protected_resource_conditions")

    @property
    @pulumi.getter(name="protectedResourceType")
    def protected_resource_type(self) -> pulumi.Output[str]:
        return pulumi.get(self, "protected_resource_type")

    @property
    @pulumi.getter(name="restoreMetadataOverrides")
    def restore_metadata_overrides(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "restore_metadata_overrides")

    @property
    @pulumi.getter(name="restoreTestingPlanName")
    def restore_testing_plan_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "restore_testing_plan_name")

    @property
    @pulumi.getter(name="restoreTestingSelectionName")
    def restore_testing_selection_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "restore_testing_selection_name")

    @property
    @pulumi.getter(name="validationWindowHours")
    def validation_window_hours(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "validation_window_hours")

