# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['TransformerArgs', 'Transformer']

@pulumi.input_type
class TransformerArgs:
    def __init__(__self__, *,
                 edi_type: pulumi.Input['TransformerEdiTypePropertiesArgs'],
                 file_format: pulumi.Input['TransformerFileFormat'],
                 mapping_template: pulumi.Input[str],
                 status: pulumi.Input['TransformerStatus'],
                 name: Optional[pulumi.Input[str]] = None,
                 sample_document: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Transformer resource.
        """
        pulumi.set(__self__, "edi_type", edi_type)
        pulumi.set(__self__, "file_format", file_format)
        pulumi.set(__self__, "mapping_template", mapping_template)
        pulumi.set(__self__, "status", status)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sample_document is not None:
            pulumi.set(__self__, "sample_document", sample_document)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="ediType")
    def edi_type(self) -> pulumi.Input['TransformerEdiTypePropertiesArgs']:
        return pulumi.get(self, "edi_type")

    @edi_type.setter
    def edi_type(self, value: pulumi.Input['TransformerEdiTypePropertiesArgs']):
        pulumi.set(self, "edi_type", value)

    @property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> pulumi.Input['TransformerFileFormat']:
        return pulumi.get(self, "file_format")

    @file_format.setter
    def file_format(self, value: pulumi.Input['TransformerFileFormat']):
        pulumi.set(self, "file_format", value)

    @property
    @pulumi.getter(name="mappingTemplate")
    def mapping_template(self) -> pulumi.Input[str]:
        return pulumi.get(self, "mapping_template")

    @mapping_template.setter
    def mapping_template(self, value: pulumi.Input[str]):
        pulumi.set(self, "mapping_template", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input['TransformerStatus']:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input['TransformerStatus']):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sampleDocument")
    def sample_document(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "sample_document")

    @sample_document.setter
    def sample_document(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sample_document", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class Transformer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 edi_type: Optional[pulumi.Input[pulumi.InputType['TransformerEdiTypePropertiesArgs']]] = None,
                 file_format: Optional[pulumi.Input['TransformerFileFormat']] = None,
                 mapping_template: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sample_document: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input['TransformerStatus']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::B2BI::Transformer Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransformerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::B2BI::Transformer Resource Type

        :param str resource_name: The name of the resource.
        :param TransformerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransformerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 edi_type: Optional[pulumi.Input[pulumi.InputType['TransformerEdiTypePropertiesArgs']]] = None,
                 file_format: Optional[pulumi.Input['TransformerFileFormat']] = None,
                 mapping_template: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sample_document: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input['TransformerStatus']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['_root_inputs.TagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransformerArgs.__new__(TransformerArgs)

            if edi_type is None and not opts.urn:
                raise TypeError("Missing required property 'edi_type'")
            __props__.__dict__["edi_type"] = edi_type
            if file_format is None and not opts.urn:
                raise TypeError("Missing required property 'file_format'")
            __props__.__dict__["file_format"] = file_format
            if mapping_template is None and not opts.urn:
                raise TypeError("Missing required property 'mapping_template'")
            __props__.__dict__["mapping_template"] = mapping_template
            __props__.__dict__["name"] = name
            __props__.__dict__["sample_document"] = sample_document
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["created_at"] = None
            __props__.__dict__["modified_at"] = None
            __props__.__dict__["transformer_arn"] = None
            __props__.__dict__["transformer_id"] = None
        super(Transformer, __self__).__init__(
            'aws-native:b2bi:Transformer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Transformer':
        """
        Get an existing Transformer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TransformerArgs.__new__(TransformerArgs)

        __props__.__dict__["created_at"] = None
        __props__.__dict__["edi_type"] = None
        __props__.__dict__["file_format"] = None
        __props__.__dict__["mapping_template"] = None
        __props__.__dict__["modified_at"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["sample_document"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["transformer_arn"] = None
        __props__.__dict__["transformer_id"] = None
        return Transformer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="ediType")
    def edi_type(self) -> pulumi.Output['outputs.TransformerEdiTypeProperties']:
        return pulumi.get(self, "edi_type")

    @property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> pulumi.Output['TransformerFileFormat']:
        return pulumi.get(self, "file_format")

    @property
    @pulumi.getter(name="mappingTemplate")
    def mapping_template(self) -> pulumi.Output[str]:
        return pulumi.get(self, "mapping_template")

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "modified_at")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sampleDocument")
    def sample_document(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "sample_document")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['TransformerStatus']:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="transformerArn")
    def transformer_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "transformer_arn")

    @property
    @pulumi.getter(name="transformerId")
    def transformer_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "transformer_id")

