# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ResolverArgs', 'Resolver']

@pulumi.input_type
class ResolverArgs:
    def __init__(__self__, *,
                 api_id: pulumi.Input[str],
                 field_name: pulumi.Input[str],
                 type_name: pulumi.Input[str],
                 caching_config: Optional[pulumi.Input['ResolverCachingConfigArgs']] = None,
                 code: Optional[pulumi.Input[str]] = None,
                 code_s3_location: Optional[pulumi.Input[str]] = None,
                 data_source_name: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 max_batch_size: Optional[pulumi.Input[int]] = None,
                 metrics_config: Optional[pulumi.Input['ResolverMetricsConfig']] = None,
                 pipeline_config: Optional[pulumi.Input['ResolverPipelineConfigArgs']] = None,
                 request_mapping_template: Optional[pulumi.Input[str]] = None,
                 request_mapping_template_s3_location: Optional[pulumi.Input[str]] = None,
                 response_mapping_template: Optional[pulumi.Input[str]] = None,
                 response_mapping_template_s3_location: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input['ResolverAppSyncRuntimeArgs']] = None,
                 sync_config: Optional[pulumi.Input['ResolverSyncConfigArgs']] = None):
        """
        The set of arguments for constructing a Resolver resource.
        :param pulumi.Input[str] api_id: The APSYlong GraphQL API to which you want to attach this resolver.
        :param pulumi.Input[str] field_name: The GraphQL field on a type that invokes the resolver.
        :param pulumi.Input[str] type_name: The GraphQL type that invokes this resolver.
        :param pulumi.Input['ResolverCachingConfigArgs'] caching_config: The caching configuration for the resolver.
        :param pulumi.Input[str] code: The ``resolver`` code that contains the request and response functions. When code is used, the ``runtime`` is required. The runtime value must be ``APPSYNC_JS``.
        :param pulumi.Input[str] code_s3_location: The Amazon S3 endpoint.
        :param pulumi.Input[str] data_source_name: The resolver data source name.
        :param pulumi.Input[str] kind: The resolver type.
                 +   *UNIT*: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.
                 +   *PIPELINE*: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of ``Function`` objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.
        :param pulumi.Input[int] max_batch_size: The maximum number of resolver request inputs that will be sent to a single LAMlong function in a ``BatchInvoke`` operation.
        :param pulumi.Input['ResolverMetricsConfig'] metrics_config: Enables or disables enhanced resolver metrics for specified resolvers. Note that ``MetricsConfig`` won't be used unless the ``resolverLevelMetricsBehavior`` value is set to ``PER_RESOLVER_METRICS``. If the ``resolverLevelMetricsBehavior`` is set to ``FULL_REQUEST_RESOLVER_METRICS`` instead, ``MetricsConfig`` will be ignored. However, you can still set its value.
        :param pulumi.Input['ResolverPipelineConfigArgs'] pipeline_config: Functions linked with the pipeline resolver.
        :param pulumi.Input[str] request_mapping_template: The request mapping template.
                Request mapping templates are optional when using a Lambda data source. For all other data sources, a request mapping template is required.
        :param pulumi.Input[str] request_mapping_template_s3_location: The location of a request mapping template in an S3 bucket. Use this if you want to provision with a template file in S3 rather than embedding it in your CFNshort template.
        :param pulumi.Input[str] response_mapping_template: The response mapping template.
        :param pulumi.Input[str] response_mapping_template_s3_location: The location of a response mapping template in an S3 bucket. Use this if you want to provision with a template file in S3 rather than embedding it in your CFNshort template.
        :param pulumi.Input['ResolverAppSyncRuntimeArgs'] runtime: Describes a runtime used by an APSYlong resolver or APSYlong function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
        :param pulumi.Input['ResolverSyncConfigArgs'] sync_config: The ``SyncConfig`` for a resolver attached to a versioned data source.
        """
        pulumi.set(__self__, "api_id", api_id)
        pulumi.set(__self__, "field_name", field_name)
        pulumi.set(__self__, "type_name", type_name)
        if caching_config is not None:
            pulumi.set(__self__, "caching_config", caching_config)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if code_s3_location is not None:
            pulumi.set(__self__, "code_s3_location", code_s3_location)
        if data_source_name is not None:
            pulumi.set(__self__, "data_source_name", data_source_name)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if max_batch_size is not None:
            pulumi.set(__self__, "max_batch_size", max_batch_size)
        if metrics_config is not None:
            pulumi.set(__self__, "metrics_config", metrics_config)
        if pipeline_config is not None:
            pulumi.set(__self__, "pipeline_config", pipeline_config)
        if request_mapping_template is not None:
            pulumi.set(__self__, "request_mapping_template", request_mapping_template)
        if request_mapping_template_s3_location is not None:
            pulumi.set(__self__, "request_mapping_template_s3_location", request_mapping_template_s3_location)
        if response_mapping_template is not None:
            pulumi.set(__self__, "response_mapping_template", response_mapping_template)
        if response_mapping_template_s3_location is not None:
            pulumi.set(__self__, "response_mapping_template_s3_location", response_mapping_template_s3_location)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if sync_config is not None:
            pulumi.set(__self__, "sync_config", sync_config)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Input[str]:
        """
        The APSYlong GraphQL API to which you want to attach this resolver.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_id", value)

    @property
    @pulumi.getter(name="fieldName")
    def field_name(self) -> pulumi.Input[str]:
        """
        The GraphQL field on a type that invokes the resolver.
        """
        return pulumi.get(self, "field_name")

    @field_name.setter
    def field_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "field_name", value)

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> pulumi.Input[str]:
        """
        The GraphQL type that invokes this resolver.
        """
        return pulumi.get(self, "type_name")

    @type_name.setter
    def type_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "type_name", value)

    @property
    @pulumi.getter(name="cachingConfig")
    def caching_config(self) -> Optional[pulumi.Input['ResolverCachingConfigArgs']]:
        """
        The caching configuration for the resolver.
        """
        return pulumi.get(self, "caching_config")

    @caching_config.setter
    def caching_config(self, value: Optional[pulumi.Input['ResolverCachingConfigArgs']]):
        pulumi.set(self, "caching_config", value)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[str]]:
        """
        The ``resolver`` code that contains the request and response functions. When code is used, the ``runtime`` is required. The runtime value must be ``APPSYNC_JS``.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="codeS3Location")
    def code_s3_location(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon S3 endpoint.
        """
        return pulumi.get(self, "code_s3_location")

    @code_s3_location.setter
    def code_s3_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code_s3_location", value)

    @property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> Optional[pulumi.Input[str]]:
        """
        The resolver data source name.
        """
        return pulumi.get(self, "data_source_name")

    @data_source_name.setter
    def data_source_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_source_name", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        The resolver type.
          +   *UNIT*: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.
          +   *PIPELINE*: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of ``Function`` objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="maxBatchSize")
    def max_batch_size(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of resolver request inputs that will be sent to a single LAMlong function in a ``BatchInvoke`` operation.
        """
        return pulumi.get(self, "max_batch_size")

    @max_batch_size.setter
    def max_batch_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_batch_size", value)

    @property
    @pulumi.getter(name="metricsConfig")
    def metrics_config(self) -> Optional[pulumi.Input['ResolverMetricsConfig']]:
        """
        Enables or disables enhanced resolver metrics for specified resolvers. Note that ``MetricsConfig`` won't be used unless the ``resolverLevelMetricsBehavior`` value is set to ``PER_RESOLVER_METRICS``. If the ``resolverLevelMetricsBehavior`` is set to ``FULL_REQUEST_RESOLVER_METRICS`` instead, ``MetricsConfig`` will be ignored. However, you can still set its value.
        """
        return pulumi.get(self, "metrics_config")

    @metrics_config.setter
    def metrics_config(self, value: Optional[pulumi.Input['ResolverMetricsConfig']]):
        pulumi.set(self, "metrics_config", value)

    @property
    @pulumi.getter(name="pipelineConfig")
    def pipeline_config(self) -> Optional[pulumi.Input['ResolverPipelineConfigArgs']]:
        """
        Functions linked with the pipeline resolver.
        """
        return pulumi.get(self, "pipeline_config")

    @pipeline_config.setter
    def pipeline_config(self, value: Optional[pulumi.Input['ResolverPipelineConfigArgs']]):
        pulumi.set(self, "pipeline_config", value)

    @property
    @pulumi.getter(name="requestMappingTemplate")
    def request_mapping_template(self) -> Optional[pulumi.Input[str]]:
        """
        The request mapping template.
         Request mapping templates are optional when using a Lambda data source. For all other data sources, a request mapping template is required.
        """
        return pulumi.get(self, "request_mapping_template")

    @request_mapping_template.setter
    def request_mapping_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_mapping_template", value)

    @property
    @pulumi.getter(name="requestMappingTemplateS3Location")
    def request_mapping_template_s3_location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of a request mapping template in an S3 bucket. Use this if you want to provision with a template file in S3 rather than embedding it in your CFNshort template.
        """
        return pulumi.get(self, "request_mapping_template_s3_location")

    @request_mapping_template_s3_location.setter
    def request_mapping_template_s3_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_mapping_template_s3_location", value)

    @property
    @pulumi.getter(name="responseMappingTemplate")
    def response_mapping_template(self) -> Optional[pulumi.Input[str]]:
        """
        The response mapping template.
        """
        return pulumi.get(self, "response_mapping_template")

    @response_mapping_template.setter
    def response_mapping_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_mapping_template", value)

    @property
    @pulumi.getter(name="responseMappingTemplateS3Location")
    def response_mapping_template_s3_location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of a response mapping template in an S3 bucket. Use this if you want to provision with a template file in S3 rather than embedding it in your CFNshort template.
        """
        return pulumi.get(self, "response_mapping_template_s3_location")

    @response_mapping_template_s3_location.setter
    def response_mapping_template_s3_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_mapping_template_s3_location", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input['ResolverAppSyncRuntimeArgs']]:
        """
        Describes a runtime used by an APSYlong resolver or APSYlong function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input['ResolverAppSyncRuntimeArgs']]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="syncConfig")
    def sync_config(self) -> Optional[pulumi.Input['ResolverSyncConfigArgs']]:
        """
        The ``SyncConfig`` for a resolver attached to a versioned data source.
        """
        return pulumi.get(self, "sync_config")

    @sync_config.setter
    def sync_config(self, value: Optional[pulumi.Input['ResolverSyncConfigArgs']]):
        pulumi.set(self, "sync_config", value)


class Resolver(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_id: Optional[pulumi.Input[str]] = None,
                 caching_config: Optional[pulumi.Input[pulumi.InputType['ResolverCachingConfigArgs']]] = None,
                 code: Optional[pulumi.Input[str]] = None,
                 code_s3_location: Optional[pulumi.Input[str]] = None,
                 data_source_name: Optional[pulumi.Input[str]] = None,
                 field_name: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 max_batch_size: Optional[pulumi.Input[int]] = None,
                 metrics_config: Optional[pulumi.Input['ResolverMetricsConfig']] = None,
                 pipeline_config: Optional[pulumi.Input[pulumi.InputType['ResolverPipelineConfigArgs']]] = None,
                 request_mapping_template: Optional[pulumi.Input[str]] = None,
                 request_mapping_template_s3_location: Optional[pulumi.Input[str]] = None,
                 response_mapping_template: Optional[pulumi.Input[str]] = None,
                 response_mapping_template_s3_location: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[pulumi.InputType['ResolverAppSyncRuntimeArgs']]] = None,
                 sync_config: Optional[pulumi.Input[pulumi.InputType['ResolverSyncConfigArgs']]] = None,
                 type_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The ``AWS::AppSync::Resolver`` resource defines the logical GraphQL resolver that you attach to fields in a schema. Request and response templates for resolvers are written in Apache Velocity Template Language (VTL) format. For more information about resolvers, see [Resolver Mapping Template Reference](https://docs.aws.amazon.com/appsync/latest/devguide/resolver-mapping-template-reference.html).
          When you submit an update, CFNLong updates resources based on differences between what you submit and the stack's current template. To cause this resource to be updated you must change a property value for this resource in the CFNshort template. Changing the S3 file content without changing a property value will not result in an update operation.
         See [Update Behaviors of Stack Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html) in the *User Guide*.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        graph_ql_api_id = config.require("graphQlApiId")
        data_source_name = config.require("dataSourceName")
        field_name = config.require("fieldName")
        type_name = config.require("typeName")
        request_mapping_template_s3_location_input = config.require("requestMappingTemplateS3LocationInput")
        response_mapping_template_s3_location_input = config.require("responseMappingTemplateS3LocationInput")
        resolver = aws_native.appsync.Resolver("resolver",
            api_id=graph_ql_api_id,
            type_name=type_name,
            field_name=field_name,
            data_source_name=data_source_name,
            request_mapping_template_s3_location=request_mapping_template_s3_location_input,
            response_mapping_template_s3_location=response_mapping_template_s3_location_input)

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_id: The APSYlong GraphQL API to which you want to attach this resolver.
        :param pulumi.Input[pulumi.InputType['ResolverCachingConfigArgs']] caching_config: The caching configuration for the resolver.
        :param pulumi.Input[str] code: The ``resolver`` code that contains the request and response functions. When code is used, the ``runtime`` is required. The runtime value must be ``APPSYNC_JS``.
        :param pulumi.Input[str] code_s3_location: The Amazon S3 endpoint.
        :param pulumi.Input[str] data_source_name: The resolver data source name.
        :param pulumi.Input[str] field_name: The GraphQL field on a type that invokes the resolver.
        :param pulumi.Input[str] kind: The resolver type.
                 +   *UNIT*: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.
                 +   *PIPELINE*: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of ``Function`` objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.
        :param pulumi.Input[int] max_batch_size: The maximum number of resolver request inputs that will be sent to a single LAMlong function in a ``BatchInvoke`` operation.
        :param pulumi.Input['ResolverMetricsConfig'] metrics_config: Enables or disables enhanced resolver metrics for specified resolvers. Note that ``MetricsConfig`` won't be used unless the ``resolverLevelMetricsBehavior`` value is set to ``PER_RESOLVER_METRICS``. If the ``resolverLevelMetricsBehavior`` is set to ``FULL_REQUEST_RESOLVER_METRICS`` instead, ``MetricsConfig`` will be ignored. However, you can still set its value.
        :param pulumi.Input[pulumi.InputType['ResolverPipelineConfigArgs']] pipeline_config: Functions linked with the pipeline resolver.
        :param pulumi.Input[str] request_mapping_template: The request mapping template.
                Request mapping templates are optional when using a Lambda data source. For all other data sources, a request mapping template is required.
        :param pulumi.Input[str] request_mapping_template_s3_location: The location of a request mapping template in an S3 bucket. Use this if you want to provision with a template file in S3 rather than embedding it in your CFNshort template.
        :param pulumi.Input[str] response_mapping_template: The response mapping template.
        :param pulumi.Input[str] response_mapping_template_s3_location: The location of a response mapping template in an S3 bucket. Use this if you want to provision with a template file in S3 rather than embedding it in your CFNshort template.
        :param pulumi.Input[pulumi.InputType['ResolverAppSyncRuntimeArgs']] runtime: Describes a runtime used by an APSYlong resolver or APSYlong function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
        :param pulumi.Input[pulumi.InputType['ResolverSyncConfigArgs']] sync_config: The ``SyncConfig`` for a resolver attached to a versioned data source.
        :param pulumi.Input[str] type_name: The GraphQL type that invokes this resolver.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResolverArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The ``AWS::AppSync::Resolver`` resource defines the logical GraphQL resolver that you attach to fields in a schema. Request and response templates for resolvers are written in Apache Velocity Template Language (VTL) format. For more information about resolvers, see [Resolver Mapping Template Reference](https://docs.aws.amazon.com/appsync/latest/devguide/resolver-mapping-template-reference.html).
          When you submit an update, CFNLong updates resources based on differences between what you submit and the stack's current template. To cause this resource to be updated you must change a property value for this resource in the CFNshort template. Changing the S3 file content without changing a property value will not result in an update operation.
         See [Update Behaviors of Stack Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html) in the *User Guide*.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        graph_ql_api_id = config.require("graphQlApiId")
        data_source_name = config.require("dataSourceName")
        field_name = config.require("fieldName")
        type_name = config.require("typeName")
        request_mapping_template_s3_location_input = config.require("requestMappingTemplateS3LocationInput")
        response_mapping_template_s3_location_input = config.require("responseMappingTemplateS3LocationInput")
        resolver = aws_native.appsync.Resolver("resolver",
            api_id=graph_ql_api_id,
            type_name=type_name,
            field_name=field_name,
            data_source_name=data_source_name,
            request_mapping_template_s3_location=request_mapping_template_s3_location_input,
            response_mapping_template_s3_location=response_mapping_template_s3_location_input)

        ```

        :param str resource_name: The name of the resource.
        :param ResolverArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResolverArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_id: Optional[pulumi.Input[str]] = None,
                 caching_config: Optional[pulumi.Input[pulumi.InputType['ResolverCachingConfigArgs']]] = None,
                 code: Optional[pulumi.Input[str]] = None,
                 code_s3_location: Optional[pulumi.Input[str]] = None,
                 data_source_name: Optional[pulumi.Input[str]] = None,
                 field_name: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 max_batch_size: Optional[pulumi.Input[int]] = None,
                 metrics_config: Optional[pulumi.Input['ResolverMetricsConfig']] = None,
                 pipeline_config: Optional[pulumi.Input[pulumi.InputType['ResolverPipelineConfigArgs']]] = None,
                 request_mapping_template: Optional[pulumi.Input[str]] = None,
                 request_mapping_template_s3_location: Optional[pulumi.Input[str]] = None,
                 response_mapping_template: Optional[pulumi.Input[str]] = None,
                 response_mapping_template_s3_location: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[pulumi.InputType['ResolverAppSyncRuntimeArgs']]] = None,
                 sync_config: Optional[pulumi.Input[pulumi.InputType['ResolverSyncConfigArgs']]] = None,
                 type_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResolverArgs.__new__(ResolverArgs)

            if api_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_id'")
            __props__.__dict__["api_id"] = api_id
            __props__.__dict__["caching_config"] = caching_config
            __props__.__dict__["code"] = code
            __props__.__dict__["code_s3_location"] = code_s3_location
            __props__.__dict__["data_source_name"] = data_source_name
            if field_name is None and not opts.urn:
                raise TypeError("Missing required property 'field_name'")
            __props__.__dict__["field_name"] = field_name
            __props__.__dict__["kind"] = kind
            __props__.__dict__["max_batch_size"] = max_batch_size
            __props__.__dict__["metrics_config"] = metrics_config
            __props__.__dict__["pipeline_config"] = pipeline_config
            __props__.__dict__["request_mapping_template"] = request_mapping_template
            __props__.__dict__["request_mapping_template_s3_location"] = request_mapping_template_s3_location
            __props__.__dict__["response_mapping_template"] = response_mapping_template
            __props__.__dict__["response_mapping_template_s3_location"] = response_mapping_template_s3_location
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["sync_config"] = sync_config
            if type_name is None and not opts.urn:
                raise TypeError("Missing required property 'type_name'")
            __props__.__dict__["type_name"] = type_name
            __props__.__dict__["resolver_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["apiId", "fieldName", "typeName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Resolver, __self__).__init__(
            'aws-native:appsync:Resolver',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Resolver':
        """
        Get an existing Resolver resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ResolverArgs.__new__(ResolverArgs)

        __props__.__dict__["api_id"] = None
        __props__.__dict__["caching_config"] = None
        __props__.__dict__["code"] = None
        __props__.__dict__["code_s3_location"] = None
        __props__.__dict__["data_source_name"] = None
        __props__.__dict__["field_name"] = None
        __props__.__dict__["kind"] = None
        __props__.__dict__["max_batch_size"] = None
        __props__.__dict__["metrics_config"] = None
        __props__.__dict__["pipeline_config"] = None
        __props__.__dict__["request_mapping_template"] = None
        __props__.__dict__["request_mapping_template_s3_location"] = None
        __props__.__dict__["resolver_arn"] = None
        __props__.__dict__["response_mapping_template"] = None
        __props__.__dict__["response_mapping_template_s3_location"] = None
        __props__.__dict__["runtime"] = None
        __props__.__dict__["sync_config"] = None
        __props__.__dict__["type_name"] = None
        return Resolver(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Output[str]:
        """
        The APSYlong GraphQL API to which you want to attach this resolver.
        """
        return pulumi.get(self, "api_id")

    @property
    @pulumi.getter(name="cachingConfig")
    def caching_config(self) -> pulumi.Output[Optional['outputs.ResolverCachingConfig']]:
        """
        The caching configuration for the resolver.
        """
        return pulumi.get(self, "caching_config")

    @property
    @pulumi.getter
    def code(self) -> pulumi.Output[Optional[str]]:
        """
        The ``resolver`` code that contains the request and response functions. When code is used, the ``runtime`` is required. The runtime value must be ``APPSYNC_JS``.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="codeS3Location")
    def code_s3_location(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon S3 endpoint.
        """
        return pulumi.get(self, "code_s3_location")

    @property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> pulumi.Output[Optional[str]]:
        """
        The resolver data source name.
        """
        return pulumi.get(self, "data_source_name")

    @property
    @pulumi.getter(name="fieldName")
    def field_name(self) -> pulumi.Output[str]:
        """
        The GraphQL field on a type that invokes the resolver.
        """
        return pulumi.get(self, "field_name")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[Optional[str]]:
        """
        The resolver type.
          +   *UNIT*: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.
          +   *PIPELINE*: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of ``Function`` objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="maxBatchSize")
    def max_batch_size(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of resolver request inputs that will be sent to a single LAMlong function in a ``BatchInvoke`` operation.
        """
        return pulumi.get(self, "max_batch_size")

    @property
    @pulumi.getter(name="metricsConfig")
    def metrics_config(self) -> pulumi.Output[Optional['ResolverMetricsConfig']]:
        """
        Enables or disables enhanced resolver metrics for specified resolvers. Note that ``MetricsConfig`` won't be used unless the ``resolverLevelMetricsBehavior`` value is set to ``PER_RESOLVER_METRICS``. If the ``resolverLevelMetricsBehavior`` is set to ``FULL_REQUEST_RESOLVER_METRICS`` instead, ``MetricsConfig`` will be ignored. However, you can still set its value.
        """
        return pulumi.get(self, "metrics_config")

    @property
    @pulumi.getter(name="pipelineConfig")
    def pipeline_config(self) -> pulumi.Output[Optional['outputs.ResolverPipelineConfig']]:
        """
        Functions linked with the pipeline resolver.
        """
        return pulumi.get(self, "pipeline_config")

    @property
    @pulumi.getter(name="requestMappingTemplate")
    def request_mapping_template(self) -> pulumi.Output[Optional[str]]:
        """
        The request mapping template.
         Request mapping templates are optional when using a Lambda data source. For all other data sources, a request mapping template is required.
        """
        return pulumi.get(self, "request_mapping_template")

    @property
    @pulumi.getter(name="requestMappingTemplateS3Location")
    def request_mapping_template_s3_location(self) -> pulumi.Output[Optional[str]]:
        """
        The location of a request mapping template in an S3 bucket. Use this if you want to provision with a template file in S3 rather than embedding it in your CFNshort template.
        """
        return pulumi.get(self, "request_mapping_template_s3_location")

    @property
    @pulumi.getter(name="resolverArn")
    def resolver_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "resolver_arn")

    @property
    @pulumi.getter(name="responseMappingTemplate")
    def response_mapping_template(self) -> pulumi.Output[Optional[str]]:
        """
        The response mapping template.
        """
        return pulumi.get(self, "response_mapping_template")

    @property
    @pulumi.getter(name="responseMappingTemplateS3Location")
    def response_mapping_template_s3_location(self) -> pulumi.Output[Optional[str]]:
        """
        The location of a response mapping template in an S3 bucket. Use this if you want to provision with a template file in S3 rather than embedding it in your CFNshort template.
        """
        return pulumi.get(self, "response_mapping_template_s3_location")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[Optional['outputs.ResolverAppSyncRuntime']]:
        """
        Describes a runtime used by an APSYlong resolver or APSYlong function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="syncConfig")
    def sync_config(self) -> pulumi.Output[Optional['outputs.ResolverSyncConfig']]:
        """
        The ``SyncConfig`` for a resolver attached to a versioned data source.
        """
        return pulumi.get(self, "sync_config")

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> pulumi.Output[str]:
        """
        The GraphQL type that invokes this resolver.
        """
        return pulumi.get(self, "type_name")

