# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ScalableTargetAction',
    'ScalableTargetScheduledAction',
    'ScalableTargetSuspendedState',
    'ScalingPolicyCustomizedMetricSpecification',
    'ScalingPolicyMetricDimension',
    'ScalingPolicyPredefinedMetricSpecification',
    'ScalingPolicyStepAdjustment',
    'ScalingPolicyStepScalingPolicyConfiguration',
    'ScalingPolicyTargetTrackingMetric',
    'ScalingPolicyTargetTrackingMetricDataQuery',
    'ScalingPolicyTargetTrackingMetricDimension',
    'ScalingPolicyTargetTrackingMetricStat',
    'ScalingPolicyTargetTrackingScalingPolicyConfiguration',
]

@pulumi.output_type
class ScalableTargetAction(dict):
    """
    ``ScalableTargetAction`` specifies the minimum and maximum capacity for the ``ScalableTargetAction`` property of the [AWS::ApplicationAutoScaling::ScalableTarget ScheduledAction](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html) property type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minCapacity":
            suggest = "min_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalableTargetAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalableTargetAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalableTargetAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_capacity: Optional[int] = None,
                 min_capacity: Optional[int] = None):
        """
        ``ScalableTargetAction`` specifies the minimum and maximum capacity for the ``ScalableTargetAction`` property of the [AWS::ApplicationAutoScaling::ScalableTarget ScheduledAction](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html) property type.
        :param int max_capacity: The maximum capacity.
        :param int min_capacity: The minimum capacity.
        """
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[int]:
        """
        The maximum capacity.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[int]:
        """
        The minimum capacity.
        """
        return pulumi.get(self, "min_capacity")


@pulumi.output_type
class ScalableTargetScheduledAction(dict):
    """
    ``ScheduledAction`` is a property of the [AWS::ApplicationAutoScaling::ScalableTarget](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html) resource that specifies a scheduled action for a scalable target. 
     For more information, see [Scheduled scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html) in the *Application Auto Scaling User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scheduledActionName":
            suggest = "scheduled_action_name"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "scalableTargetAction":
            suggest = "scalable_target_action"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalableTargetScheduledAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalableTargetScheduledAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalableTargetScheduledAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule: str,
                 scheduled_action_name: str,
                 end_time: Optional[str] = None,
                 scalable_target_action: Optional['outputs.ScalableTargetAction'] = None,
                 start_time: Optional[str] = None,
                 timezone: Optional[str] = None):
        """
        ``ScheduledAction`` is a property of the [AWS::ApplicationAutoScaling::ScalableTarget](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html) resource that specifies a scheduled action for a scalable target. 
         For more information, see [Scheduled scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html) in the *Application Auto Scaling User Guide*.
        :param str schedule: The schedule for this action. The following formats are supported:
                 +  At expressions - "``at(yyyy-mm-ddThh:mm:ss)``"
                 +  Rate expressions - "``rate(value unit)``"
                 +  Cron expressions - "``cron(fields)``"
                 
                At expressions are useful for one-time schedules. Cron expressions are useful for scheduled actions that run periodically at a specified date and time, and rate expressions are useful for scheduled actions that run at a regular interval.
                At and cron expressions use Universal Coordinated Time (UTC) by default.
                The cron format consists of six fields separated by white spaces: [Minutes] [Hours] [Day_of_Month] [Month] [Day_of_Week] [Year].
                For rate expressions, *value* is a positive integer and *unit* is ``minute`` | ``minutes`` | ``hour`` | ``hours`` | ``day`` | ``days``.
        :param str scheduled_action_name: The name of the scheduled action. This name must be unique among all other scheduled actions on the specified scalable target.
        :param str end_time: The date and time that the action is scheduled to end, in UTC.
        :param 'ScalableTargetAction' scalable_target_action: The new minimum and maximum capacity. You can set both values or just one. At the scheduled time, if the current capacity is below the minimum capacity, Application Auto Scaling scales out to the minimum capacity. If the current capacity is above the maximum capacity, Application Auto Scaling scales in to the maximum capacity.
        :param str start_time: The date and time that the action is scheduled to begin, in UTC.
        :param str timezone: The time zone used when referring to the date and time of a scheduled action, when the scheduled action uses an at or cron expression.
        """
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "scheduled_action_name", scheduled_action_name)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if scalable_target_action is not None:
            pulumi.set(__self__, "scalable_target_action", scalable_target_action)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter
    def schedule(self) -> str:
        """
        The schedule for this action. The following formats are supported:
          +  At expressions - "``at(yyyy-mm-ddThh:mm:ss)``"
          +  Rate expressions - "``rate(value unit)``"
          +  Cron expressions - "``cron(fields)``"
          
         At expressions are useful for one-time schedules. Cron expressions are useful for scheduled actions that run periodically at a specified date and time, and rate expressions are useful for scheduled actions that run at a regular interval.
         At and cron expressions use Universal Coordinated Time (UTC) by default.
         The cron format consists of six fields separated by white spaces: [Minutes] [Hours] [Day_of_Month] [Month] [Day_of_Week] [Year].
         For rate expressions, *value* is a positive integer and *unit* is ``minute`` | ``minutes`` | ``hour`` | ``hours`` | ``day`` | ``days``.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="scheduledActionName")
    def scheduled_action_name(self) -> str:
        """
        The name of the scheduled action. This name must be unique among all other scheduled actions on the specified scalable target.
        """
        return pulumi.get(self, "scheduled_action_name")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        The date and time that the action is scheduled to end, in UTC.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="scalableTargetAction")
    def scalable_target_action(self) -> Optional['outputs.ScalableTargetAction']:
        """
        The new minimum and maximum capacity. You can set both values or just one. At the scheduled time, if the current capacity is below the minimum capacity, Application Auto Scaling scales out to the minimum capacity. If the current capacity is above the maximum capacity, Application Auto Scaling scales in to the maximum capacity.
        """
        return pulumi.get(self, "scalable_target_action")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        The date and time that the action is scheduled to begin, in UTC.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def timezone(self) -> Optional[str]:
        """
        The time zone used when referring to the date and time of a scheduled action, when the scheduled action uses an at or cron expression.
        """
        return pulumi.get(self, "timezone")


@pulumi.output_type
class ScalableTargetSuspendedState(dict):
    """
    ``SuspendedState`` is a property of the [AWS::ApplicationAutoScaling::ScalableTarget](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html) resource that specifies whether the scaling activities for a scalable target are in a suspended state.
     For more information, see [Suspending and resuming scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-suspend-resume-scaling.html) in the *Application Auto Scaling User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dynamicScalingInSuspended":
            suggest = "dynamic_scaling_in_suspended"
        elif key == "dynamicScalingOutSuspended":
            suggest = "dynamic_scaling_out_suspended"
        elif key == "scheduledScalingSuspended":
            suggest = "scheduled_scaling_suspended"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalableTargetSuspendedState. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalableTargetSuspendedState.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalableTargetSuspendedState.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dynamic_scaling_in_suspended: Optional[bool] = None,
                 dynamic_scaling_out_suspended: Optional[bool] = None,
                 scheduled_scaling_suspended: Optional[bool] = None):
        """
        ``SuspendedState`` is a property of the [AWS::ApplicationAutoScaling::ScalableTarget](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html) resource that specifies whether the scaling activities for a scalable target are in a suspended state.
         For more information, see [Suspending and resuming scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-suspend-resume-scaling.html) in the *Application Auto Scaling User Guide*.
        :param bool dynamic_scaling_in_suspended: Whether scale in by a target tracking scaling policy or a step scaling policy is suspended. Set the value to ``true`` if you don't want Application Auto Scaling to remove capacity when a scaling policy is triggered. The default is ``false``.
        :param bool dynamic_scaling_out_suspended: Whether scale out by a target tracking scaling policy or a step scaling policy is suspended. Set the value to ``true`` if you don't want Application Auto Scaling to add capacity when a scaling policy is triggered. The default is ``false``.
        :param bool scheduled_scaling_suspended: Whether scheduled scaling is suspended. Set the value to ``true`` if you don't want Application Auto Scaling to add or remove capacity by initiating scheduled actions. The default is ``false``.
        """
        if dynamic_scaling_in_suspended is not None:
            pulumi.set(__self__, "dynamic_scaling_in_suspended", dynamic_scaling_in_suspended)
        if dynamic_scaling_out_suspended is not None:
            pulumi.set(__self__, "dynamic_scaling_out_suspended", dynamic_scaling_out_suspended)
        if scheduled_scaling_suspended is not None:
            pulumi.set(__self__, "scheduled_scaling_suspended", scheduled_scaling_suspended)

    @property
    @pulumi.getter(name="dynamicScalingInSuspended")
    def dynamic_scaling_in_suspended(self) -> Optional[bool]:
        """
        Whether scale in by a target tracking scaling policy or a step scaling policy is suspended. Set the value to ``true`` if you don't want Application Auto Scaling to remove capacity when a scaling policy is triggered. The default is ``false``.
        """
        return pulumi.get(self, "dynamic_scaling_in_suspended")

    @property
    @pulumi.getter(name="dynamicScalingOutSuspended")
    def dynamic_scaling_out_suspended(self) -> Optional[bool]:
        """
        Whether scale out by a target tracking scaling policy or a step scaling policy is suspended. Set the value to ``true`` if you don't want Application Auto Scaling to add capacity when a scaling policy is triggered. The default is ``false``.
        """
        return pulumi.get(self, "dynamic_scaling_out_suspended")

    @property
    @pulumi.getter(name="scheduledScalingSuspended")
    def scheduled_scaling_suspended(self) -> Optional[bool]:
        """
        Whether scheduled scaling is suspended. Set the value to ``true`` if you don't want Application Auto Scaling to add or remove capacity by initiating scheduled actions. The default is ``false``.
        """
        return pulumi.get(self, "scheduled_scaling_suspended")


@pulumi.output_type
class ScalingPolicyCustomizedMetricSpecification(dict):
    """
    Represents a CloudWatch metric of your choosing for a target tracking scaling policy to use with Application Auto Scaling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyCustomizedMetricSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyCustomizedMetricSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyCustomizedMetricSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimensions: Optional[Sequence['outputs.ScalingPolicyMetricDimension']] = None,
                 metric_name: Optional[str] = None,
                 metrics: Optional[Sequence['outputs.ScalingPolicyTargetTrackingMetricDataQuery']] = None,
                 namespace: Optional[str] = None,
                 statistic: Optional[str] = None,
                 unit: Optional[str] = None):
        """
        Represents a CloudWatch metric of your choosing for a target tracking scaling policy to use with Application Auto Scaling.
        :param Sequence['ScalingPolicyMetricDimension'] dimensions: The dimensions of the metric.
        :param str metric_name: The name of the metric. To get the exact metric name, namespace, and dimensions, inspect the Metric object that is returned by a call to ListMetrics.
        :param Sequence['ScalingPolicyTargetTrackingMetricDataQuery'] metrics: The metrics to include in the target tracking scaling policy, as a metric data query. This can include both raw metric and metric math expressions.
        :param str namespace: The namespace of the metric.
        :param str statistic: The statistic of the metric.
        :param str unit: The unit of the metric. For a complete list of the units that CloudWatch supports, see the MetricDatum data type in the Amazon CloudWatch API Reference.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.ScalingPolicyMetricDimension']]:
        """
        The dimensions of the metric.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[str]:
        """
        The name of the metric. To get the exact metric name, namespace, and dimensions, inspect the Metric object that is returned by a call to ListMetrics.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.ScalingPolicyTargetTrackingMetricDataQuery']]:
        """
        The metrics to include in the target tracking scaling policy, as a metric data query. This can include both raw metric and metric math expressions.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The namespace of the metric.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def statistic(self) -> Optional[str]:
        """
        The statistic of the metric.
        """
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter
    def unit(self) -> Optional[str]:
        """
        The unit of the metric. For a complete list of the units that CloudWatch supports, see the MetricDatum data type in the Amazon CloudWatch API Reference.
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class ScalingPolicyMetricDimension(dict):
    """
    Describes the dimension names and values associated with a metric.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        Describes the dimension names and values associated with a metric.
        :param str name: The name of the dimension.
        :param str value: The value of the dimension.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the dimension.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the dimension.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ScalingPolicyPredefinedMetricSpecification(dict):
    """
    Represents a predefined metric for a target tracking scaling policy to use with Application Auto Scaling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "predefinedMetricType":
            suggest = "predefined_metric_type"
        elif key == "resourceLabel":
            suggest = "resource_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyPredefinedMetricSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyPredefinedMetricSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyPredefinedMetricSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 predefined_metric_type: str,
                 resource_label: Optional[str] = None):
        """
        Represents a predefined metric for a target tracking scaling policy to use with Application Auto Scaling.
        :param str predefined_metric_type: The metric type. The ALBRequestCountPerTarget metric type applies only to Spot Fleets and ECS services.
        :param str resource_label: Identifies the resource associated with the metric type. You can't specify a resource label unless the metric type is ALBRequestCountPerTarget and there is a target group attached to the Spot Fleet or ECS service.
        """
        pulumi.set(__self__, "predefined_metric_type", predefined_metric_type)
        if resource_label is not None:
            pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedMetricType")
    def predefined_metric_type(self) -> str:
        """
        The metric type. The ALBRequestCountPerTarget metric type applies only to Spot Fleets and ECS services.
        """
        return pulumi.get(self, "predefined_metric_type")

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> Optional[str]:
        """
        Identifies the resource associated with the metric type. You can't specify a resource label unless the metric type is ALBRequestCountPerTarget and there is a target group attached to the Spot Fleet or ECS service.
        """
        return pulumi.get(self, "resource_label")


@pulumi.output_type
class ScalingPolicyStepAdjustment(dict):
    """
    Represents a step adjustment for a StepScalingPolicyConfiguration. Describes an adjustment based on the difference between the value of the aggregated CloudWatch metric and the breach threshold that you've defined for the alarm.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scalingAdjustment":
            suggest = "scaling_adjustment"
        elif key == "metricIntervalLowerBound":
            suggest = "metric_interval_lower_bound"
        elif key == "metricIntervalUpperBound":
            suggest = "metric_interval_upper_bound"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyStepAdjustment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyStepAdjustment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyStepAdjustment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scaling_adjustment: int,
                 metric_interval_lower_bound: Optional[float] = None,
                 metric_interval_upper_bound: Optional[float] = None):
        """
        Represents a step adjustment for a StepScalingPolicyConfiguration. Describes an adjustment based on the difference between the value of the aggregated CloudWatch metric and the breach threshold that you've defined for the alarm.
        :param int scaling_adjustment: The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value.
        :param float metric_interval_lower_bound: The lower bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.
        :param float metric_interval_upper_bound: The upper bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.
        """
        pulumi.set(__self__, "scaling_adjustment", scaling_adjustment)
        if metric_interval_lower_bound is not None:
            pulumi.set(__self__, "metric_interval_lower_bound", metric_interval_lower_bound)
        if metric_interval_upper_bound is not None:
            pulumi.set(__self__, "metric_interval_upper_bound", metric_interval_upper_bound)

    @property
    @pulumi.getter(name="scalingAdjustment")
    def scaling_adjustment(self) -> int:
        """
        The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value.
        """
        return pulumi.get(self, "scaling_adjustment")

    @property
    @pulumi.getter(name="metricIntervalLowerBound")
    def metric_interval_lower_bound(self) -> Optional[float]:
        """
        The lower bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.
        """
        return pulumi.get(self, "metric_interval_lower_bound")

    @property
    @pulumi.getter(name="metricIntervalUpperBound")
    def metric_interval_upper_bound(self) -> Optional[float]:
        """
        The upper bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.
        """
        return pulumi.get(self, "metric_interval_upper_bound")


@pulumi.output_type
class ScalingPolicyStepScalingPolicyConfiguration(dict):
    """
    A step scaling policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adjustmentType":
            suggest = "adjustment_type"
        elif key == "metricAggregationType":
            suggest = "metric_aggregation_type"
        elif key == "minAdjustmentMagnitude":
            suggest = "min_adjustment_magnitude"
        elif key == "stepAdjustments":
            suggest = "step_adjustments"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyStepScalingPolicyConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyStepScalingPolicyConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyStepScalingPolicyConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 adjustment_type: Optional[str] = None,
                 cooldown: Optional[int] = None,
                 metric_aggregation_type: Optional[str] = None,
                 min_adjustment_magnitude: Optional[int] = None,
                 step_adjustments: Optional[Sequence['outputs.ScalingPolicyStepAdjustment']] = None):
        """
        A step scaling policy.
        :param str adjustment_type: Specifies how the ScalingAdjustment value in a StepAdjustment is interpreted.
        :param int cooldown: The amount of time, in seconds, to wait for a previous scaling activity to take effect.
        :param str metric_aggregation_type: The aggregation type for the CloudWatch metrics. Valid values are Minimum, Maximum, and Average. If the aggregation type is null, the value is treated as Average
        :param int min_adjustment_magnitude: The minimum value to scale by when the adjustment type is PercentChangeInCapacity.
        :param Sequence['ScalingPolicyStepAdjustment'] step_adjustments: A set of adjustments that enable you to scale based on the size of the alarm breach.
        """
        if adjustment_type is not None:
            pulumi.set(__self__, "adjustment_type", adjustment_type)
        if cooldown is not None:
            pulumi.set(__self__, "cooldown", cooldown)
        if metric_aggregation_type is not None:
            pulumi.set(__self__, "metric_aggregation_type", metric_aggregation_type)
        if min_adjustment_magnitude is not None:
            pulumi.set(__self__, "min_adjustment_magnitude", min_adjustment_magnitude)
        if step_adjustments is not None:
            pulumi.set(__self__, "step_adjustments", step_adjustments)

    @property
    @pulumi.getter(name="adjustmentType")
    def adjustment_type(self) -> Optional[str]:
        """
        Specifies how the ScalingAdjustment value in a StepAdjustment is interpreted.
        """
        return pulumi.get(self, "adjustment_type")

    @property
    @pulumi.getter
    def cooldown(self) -> Optional[int]:
        """
        The amount of time, in seconds, to wait for a previous scaling activity to take effect.
        """
        return pulumi.get(self, "cooldown")

    @property
    @pulumi.getter(name="metricAggregationType")
    def metric_aggregation_type(self) -> Optional[str]:
        """
        The aggregation type for the CloudWatch metrics. Valid values are Minimum, Maximum, and Average. If the aggregation type is null, the value is treated as Average
        """
        return pulumi.get(self, "metric_aggregation_type")

    @property
    @pulumi.getter(name="minAdjustmentMagnitude")
    def min_adjustment_magnitude(self) -> Optional[int]:
        """
        The minimum value to scale by when the adjustment type is PercentChangeInCapacity.
        """
        return pulumi.get(self, "min_adjustment_magnitude")

    @property
    @pulumi.getter(name="stepAdjustments")
    def step_adjustments(self) -> Optional[Sequence['outputs.ScalingPolicyStepAdjustment']]:
        """
        A set of adjustments that enable you to scale based on the size of the alarm breach.
        """
        return pulumi.get(self, "step_adjustments")


@pulumi.output_type
class ScalingPolicyTargetTrackingMetric(dict):
    """
    Represents a specific metric.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyTargetTrackingMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyTargetTrackingMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyTargetTrackingMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimensions: Optional[Sequence['outputs.ScalingPolicyTargetTrackingMetricDimension']] = None,
                 metric_name: Optional[str] = None,
                 namespace: Optional[str] = None):
        """
        Represents a specific metric.
        :param Sequence['ScalingPolicyTargetTrackingMetricDimension'] dimensions: The dimensions for the metric.
        :param str metric_name: The name of the metric.
        :param str namespace: The namespace of the metric.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.ScalingPolicyTargetTrackingMetricDimension']]:
        """
        The dimensions for the metric.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[str]:
        """
        The name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The namespace of the metric.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class ScalingPolicyTargetTrackingMetricDataQuery(dict):
    """
    The metric data to return. Also defines whether this call is returning data for one metric only, or whether it is performing a math expression on the values of returned metric statistics to create a new time series. A time series is a series of data points, each of which is associated with a timestamp.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricStat":
            suggest = "metric_stat"
        elif key == "returnData":
            suggest = "return_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyTargetTrackingMetricDataQuery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyTargetTrackingMetricDataQuery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyTargetTrackingMetricDataQuery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expression: Optional[str] = None,
                 id: Optional[str] = None,
                 label: Optional[str] = None,
                 metric_stat: Optional['outputs.ScalingPolicyTargetTrackingMetricStat'] = None,
                 return_data: Optional[bool] = None):
        """
        The metric data to return. Also defines whether this call is returning data for one metric only, or whether it is performing a math expression on the values of returned metric statistics to create a new time series. A time series is a series of data points, each of which is associated with a timestamp.
        :param str expression: The math expression to perform on the returned data, if this object is performing a math expression.
        :param str id: A short name that identifies the object's results in the response.
        :param str label: A human-readable label for this metric or expression. This is especially useful if this is a math expression, so that you know what the value represents.
        :param 'ScalingPolicyTargetTrackingMetricStat' metric_stat: Information about the metric data to return.
        :param bool return_data: Indicates whether to return the timestamps and raw data values of this metric.
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if metric_stat is not None:
            pulumi.set(__self__, "metric_stat", metric_stat)
        if return_data is not None:
            pulumi.set(__self__, "return_data", return_data)

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        """
        The math expression to perform on the returned data, if this object is performing a math expression.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        A short name that identifies the object's results in the response.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        A human-readable label for this metric or expression. This is especially useful if this is a math expression, so that you know what the value represents.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="metricStat")
    def metric_stat(self) -> Optional['outputs.ScalingPolicyTargetTrackingMetricStat']:
        """
        Information about the metric data to return.
        """
        return pulumi.get(self, "metric_stat")

    @property
    @pulumi.getter(name="returnData")
    def return_data(self) -> Optional[bool]:
        """
        Indicates whether to return the timestamps and raw data values of this metric.
        """
        return pulumi.get(self, "return_data")


@pulumi.output_type
class ScalingPolicyTargetTrackingMetricDimension(dict):
    """
    Describes the dimension of a metric.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Describes the dimension of a metric.
        :param str name: The name of the dimension.
        :param str value: The value of the dimension.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the dimension.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the dimension.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ScalingPolicyTargetTrackingMetricStat(dict):
    """
    This structure defines the CloudWatch metric to return, along with the statistic, period, and unit.
    """
    def __init__(__self__, *,
                 metric: Optional['outputs.ScalingPolicyTargetTrackingMetric'] = None,
                 stat: Optional[str] = None,
                 unit: Optional[str] = None):
        """
        This structure defines the CloudWatch metric to return, along with the statistic, period, and unit.
        :param 'ScalingPolicyTargetTrackingMetric' metric: The CloudWatch metric to return, including the metric name, namespace, and dimensions. 
        :param str stat: The statistic to return. It can include any CloudWatch statistic or extended statistic.
        :param str unit: The unit to use for the returned data points.
        """
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if stat is not None:
            pulumi.set(__self__, "stat", stat)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def metric(self) -> Optional['outputs.ScalingPolicyTargetTrackingMetric']:
        """
        The CloudWatch metric to return, including the metric name, namespace, and dimensions. 
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter
    def stat(self) -> Optional[str]:
        """
        The statistic to return. It can include any CloudWatch statistic or extended statistic.
        """
        return pulumi.get(self, "stat")

    @property
    @pulumi.getter
    def unit(self) -> Optional[str]:
        """
        The unit to use for the returned data points.
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class ScalingPolicyTargetTrackingScalingPolicyConfiguration(dict):
    """
    A target tracking scaling policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetValue":
            suggest = "target_value"
        elif key == "customizedMetricSpecification":
            suggest = "customized_metric_specification"
        elif key == "disableScaleIn":
            suggest = "disable_scale_in"
        elif key == "predefinedMetricSpecification":
            suggest = "predefined_metric_specification"
        elif key == "scaleInCooldown":
            suggest = "scale_in_cooldown"
        elif key == "scaleOutCooldown":
            suggest = "scale_out_cooldown"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyTargetTrackingScalingPolicyConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyTargetTrackingScalingPolicyConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyTargetTrackingScalingPolicyConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_value: float,
                 customized_metric_specification: Optional['outputs.ScalingPolicyCustomizedMetricSpecification'] = None,
                 disable_scale_in: Optional[bool] = None,
                 predefined_metric_specification: Optional['outputs.ScalingPolicyPredefinedMetricSpecification'] = None,
                 scale_in_cooldown: Optional[int] = None,
                 scale_out_cooldown: Optional[int] = None):
        """
        A target tracking scaling policy.
        :param float target_value: The target value for the metric. Although this property accepts numbers of type Double, it won't accept values that are either too small or too large. Values must be in the range of -2^360 to 2^360. The value must be a valid number based on the choice of metric. For example, if the metric is CPU utilization, then the target value is a percent value that represents how much of the CPU can be used before scaling out.
        :param 'ScalingPolicyCustomizedMetricSpecification' customized_metric_specification: A customized metric. You can specify either a predefined metric or a customized metric.
        :param bool disable_scale_in: Indicates whether scale in by the target tracking scaling policy is disabled. If the value is true, scale in is disabled and the target tracking scaling policy won't remove capacity from the scalable target. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable target. The default value is false.
        :param 'ScalingPolicyPredefinedMetricSpecification' predefined_metric_specification: A predefined metric. You can specify either a predefined metric or a customized metric.
        :param int scale_in_cooldown: The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start.
        :param int scale_out_cooldown: The amount of time, in seconds, to wait for a previous scale-out activity to take effect.
        """
        pulumi.set(__self__, "target_value", target_value)
        if customized_metric_specification is not None:
            pulumi.set(__self__, "customized_metric_specification", customized_metric_specification)
        if disable_scale_in is not None:
            pulumi.set(__self__, "disable_scale_in", disable_scale_in)
        if predefined_metric_specification is not None:
            pulumi.set(__self__, "predefined_metric_specification", predefined_metric_specification)
        if scale_in_cooldown is not None:
            pulumi.set(__self__, "scale_in_cooldown", scale_in_cooldown)
        if scale_out_cooldown is not None:
            pulumi.set(__self__, "scale_out_cooldown", scale_out_cooldown)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> float:
        """
        The target value for the metric. Although this property accepts numbers of type Double, it won't accept values that are either too small or too large. Values must be in the range of -2^360 to 2^360. The value must be a valid number based on the choice of metric. For example, if the metric is CPU utilization, then the target value is a percent value that represents how much of the CPU can be used before scaling out.
        """
        return pulumi.get(self, "target_value")

    @property
    @pulumi.getter(name="customizedMetricSpecification")
    def customized_metric_specification(self) -> Optional['outputs.ScalingPolicyCustomizedMetricSpecification']:
        """
        A customized metric. You can specify either a predefined metric or a customized metric.
        """
        return pulumi.get(self, "customized_metric_specification")

    @property
    @pulumi.getter(name="disableScaleIn")
    def disable_scale_in(self) -> Optional[bool]:
        """
        Indicates whether scale in by the target tracking scaling policy is disabled. If the value is true, scale in is disabled and the target tracking scaling policy won't remove capacity from the scalable target. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable target. The default value is false.
        """
        return pulumi.get(self, "disable_scale_in")

    @property
    @pulumi.getter(name="predefinedMetricSpecification")
    def predefined_metric_specification(self) -> Optional['outputs.ScalingPolicyPredefinedMetricSpecification']:
        """
        A predefined metric. You can specify either a predefined metric or a customized metric.
        """
        return pulumi.get(self, "predefined_metric_specification")

    @property
    @pulumi.getter(name="scaleInCooldown")
    def scale_in_cooldown(self) -> Optional[int]:
        """
        The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start.
        """
        return pulumi.get(self, "scale_in_cooldown")

    @property
    @pulumi.getter(name="scaleOutCooldown")
    def scale_out_cooldown(self) -> Optional[int]:
        """
        The amount of time, in seconds, to wait for a previous scale-out activity to take effect.
        """
        return pulumi.get(self, "scale_out_cooldown")


