# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ScalableTargetActionArgs',
    'ScalableTargetScheduledActionArgs',
    'ScalableTargetSuspendedStateArgs',
    'ScalingPolicyCustomizedMetricSpecificationArgs',
    'ScalingPolicyMetricDimensionArgs',
    'ScalingPolicyPredefinedMetricSpecificationArgs',
    'ScalingPolicyStepAdjustmentArgs',
    'ScalingPolicyStepScalingPolicyConfigurationArgs',
    'ScalingPolicyTargetTrackingMetricDataQueryArgs',
    'ScalingPolicyTargetTrackingMetricDimensionArgs',
    'ScalingPolicyTargetTrackingMetricStatArgs',
    'ScalingPolicyTargetTrackingMetricArgs',
    'ScalingPolicyTargetTrackingScalingPolicyConfigurationArgs',
]

@pulumi.input_type
class ScalableTargetActionArgs:
    def __init__(__self__, *,
                 max_capacity: Optional[pulumi.Input[int]] = None,
                 min_capacity: Optional[pulumi.Input[int]] = None):
        """
        ``ScalableTargetAction`` specifies the minimum and maximum capacity for the ``ScalableTargetAction`` property of the [AWS::ApplicationAutoScaling::ScalableTarget ScheduledAction](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html) property type.
        :param pulumi.Input[int] max_capacity: The maximum capacity.
        :param pulumi.Input[int] min_capacity: The minimum capacity.
        """
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum capacity.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum capacity.
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_capacity", value)


@pulumi.input_type
class ScalableTargetScheduledActionArgs:
    def __init__(__self__, *,
                 schedule: pulumi.Input[str],
                 scheduled_action_name: pulumi.Input[str],
                 end_time: Optional[pulumi.Input[str]] = None,
                 scalable_target_action: Optional[pulumi.Input['ScalableTargetActionArgs']] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None):
        """
        ``ScheduledAction`` is a property of the [AWS::ApplicationAutoScaling::ScalableTarget](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html) resource that specifies a scheduled action for a scalable target. 
         For more information, see [Scheduled scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html) in the *Application Auto Scaling User Guide*.
        :param pulumi.Input[str] schedule: The schedule for this action. The following formats are supported:
                 +  At expressions - "``at(yyyy-mm-ddThh:mm:ss)``"
                 +  Rate expressions - "``rate(value unit)``"
                 +  Cron expressions - "``cron(fields)``"
                 
                At expressions are useful for one-time schedules. Cron expressions are useful for scheduled actions that run periodically at a specified date and time, and rate expressions are useful for scheduled actions that run at a regular interval.
                At and cron expressions use Universal Coordinated Time (UTC) by default.
                The cron format consists of six fields separated by white spaces: [Minutes] [Hours] [Day_of_Month] [Month] [Day_of_Week] [Year].
                For rate expressions, *value* is a positive integer and *unit* is ``minute`` | ``minutes`` | ``hour`` | ``hours`` | ``day`` | ``days``.
        :param pulumi.Input[str] scheduled_action_name: The name of the scheduled action. This name must be unique among all other scheduled actions on the specified scalable target.
        :param pulumi.Input[str] end_time: The date and time that the action is scheduled to end, in UTC.
        :param pulumi.Input['ScalableTargetActionArgs'] scalable_target_action: The new minimum and maximum capacity. You can set both values or just one. At the scheduled time, if the current capacity is below the minimum capacity, Application Auto Scaling scales out to the minimum capacity. If the current capacity is above the maximum capacity, Application Auto Scaling scales in to the maximum capacity.
        :param pulumi.Input[str] start_time: The date and time that the action is scheduled to begin, in UTC.
        :param pulumi.Input[str] timezone: The time zone used when referring to the date and time of a scheduled action, when the scheduled action uses an at or cron expression.
        """
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "scheduled_action_name", scheduled_action_name)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if scalable_target_action is not None:
            pulumi.set(__self__, "scalable_target_action", scalable_target_action)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Input[str]:
        """
        The schedule for this action. The following formats are supported:
          +  At expressions - "``at(yyyy-mm-ddThh:mm:ss)``"
          +  Rate expressions - "``rate(value unit)``"
          +  Cron expressions - "``cron(fields)``"
          
         At expressions are useful for one-time schedules. Cron expressions are useful for scheduled actions that run periodically at a specified date and time, and rate expressions are useful for scheduled actions that run at a regular interval.
         At and cron expressions use Universal Coordinated Time (UTC) by default.
         The cron format consists of six fields separated by white spaces: [Minutes] [Hours] [Day_of_Month] [Month] [Day_of_Week] [Year].
         For rate expressions, *value* is a positive integer and *unit* is ``minute`` | ``minutes`` | ``hour`` | ``hours`` | ``day`` | ``days``.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: pulumi.Input[str]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="scheduledActionName")
    def scheduled_action_name(self) -> pulumi.Input[str]:
        """
        The name of the scheduled action. This name must be unique among all other scheduled actions on the specified scalable target.
        """
        return pulumi.get(self, "scheduled_action_name")

    @scheduled_action_name.setter
    def scheduled_action_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "scheduled_action_name", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time that the action is scheduled to end, in UTC.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="scalableTargetAction")
    def scalable_target_action(self) -> Optional[pulumi.Input['ScalableTargetActionArgs']]:
        """
        The new minimum and maximum capacity. You can set both values or just one. At the scheduled time, if the current capacity is below the minimum capacity, Application Auto Scaling scales out to the minimum capacity. If the current capacity is above the maximum capacity, Application Auto Scaling scales in to the maximum capacity.
        """
        return pulumi.get(self, "scalable_target_action")

    @scalable_target_action.setter
    def scalable_target_action(self, value: Optional[pulumi.Input['ScalableTargetActionArgs']]):
        pulumi.set(self, "scalable_target_action", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time that the action is scheduled to begin, in UTC.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone used when referring to the date and time of a scheduled action, when the scheduled action uses an at or cron expression.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)


@pulumi.input_type
class ScalableTargetSuspendedStateArgs:
    def __init__(__self__, *,
                 dynamic_scaling_in_suspended: Optional[pulumi.Input[bool]] = None,
                 dynamic_scaling_out_suspended: Optional[pulumi.Input[bool]] = None,
                 scheduled_scaling_suspended: Optional[pulumi.Input[bool]] = None):
        """
        ``SuspendedState`` is a property of the [AWS::ApplicationAutoScaling::ScalableTarget](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html) resource that specifies whether the scaling activities for a scalable target are in a suspended state.
         For more information, see [Suspending and resuming scaling](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-suspend-resume-scaling.html) in the *Application Auto Scaling User Guide*.
        :param pulumi.Input[bool] dynamic_scaling_in_suspended: Whether scale in by a target tracking scaling policy or a step scaling policy is suspended. Set the value to ``true`` if you don't want Application Auto Scaling to remove capacity when a scaling policy is triggered. The default is ``false``.
        :param pulumi.Input[bool] dynamic_scaling_out_suspended: Whether scale out by a target tracking scaling policy or a step scaling policy is suspended. Set the value to ``true`` if you don't want Application Auto Scaling to add capacity when a scaling policy is triggered. The default is ``false``.
        :param pulumi.Input[bool] scheduled_scaling_suspended: Whether scheduled scaling is suspended. Set the value to ``true`` if you don't want Application Auto Scaling to add or remove capacity by initiating scheduled actions. The default is ``false``.
        """
        if dynamic_scaling_in_suspended is not None:
            pulumi.set(__self__, "dynamic_scaling_in_suspended", dynamic_scaling_in_suspended)
        if dynamic_scaling_out_suspended is not None:
            pulumi.set(__self__, "dynamic_scaling_out_suspended", dynamic_scaling_out_suspended)
        if scheduled_scaling_suspended is not None:
            pulumi.set(__self__, "scheduled_scaling_suspended", scheduled_scaling_suspended)

    @property
    @pulumi.getter(name="dynamicScalingInSuspended")
    def dynamic_scaling_in_suspended(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether scale in by a target tracking scaling policy or a step scaling policy is suspended. Set the value to ``true`` if you don't want Application Auto Scaling to remove capacity when a scaling policy is triggered. The default is ``false``.
        """
        return pulumi.get(self, "dynamic_scaling_in_suspended")

    @dynamic_scaling_in_suspended.setter
    def dynamic_scaling_in_suspended(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dynamic_scaling_in_suspended", value)

    @property
    @pulumi.getter(name="dynamicScalingOutSuspended")
    def dynamic_scaling_out_suspended(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether scale out by a target tracking scaling policy or a step scaling policy is suspended. Set the value to ``true`` if you don't want Application Auto Scaling to add capacity when a scaling policy is triggered. The default is ``false``.
        """
        return pulumi.get(self, "dynamic_scaling_out_suspended")

    @dynamic_scaling_out_suspended.setter
    def dynamic_scaling_out_suspended(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dynamic_scaling_out_suspended", value)

    @property
    @pulumi.getter(name="scheduledScalingSuspended")
    def scheduled_scaling_suspended(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether scheduled scaling is suspended. Set the value to ``true`` if you don't want Application Auto Scaling to add or remove capacity by initiating scheduled actions. The default is ``false``.
        """
        return pulumi.get(self, "scheduled_scaling_suspended")

    @scheduled_scaling_suspended.setter
    def scheduled_scaling_suspended(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "scheduled_scaling_suspended", value)


@pulumi.input_type
class ScalingPolicyCustomizedMetricSpecificationArgs:
    def __init__(__self__, *,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDimensionArgs']]]] = None,
                 metric_name: Optional[pulumi.Input[str]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyTargetTrackingMetricDataQueryArgs']]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 statistic: Optional[pulumi.Input[str]] = None,
                 unit: Optional[pulumi.Input[str]] = None):
        """
        Represents a CloudWatch metric of your choosing for a target tracking scaling policy to use with Application Auto Scaling.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDimensionArgs']]] dimensions: The dimensions of the metric.
        :param pulumi.Input[str] metric_name: The name of the metric. To get the exact metric name, namespace, and dimensions, inspect the Metric object that is returned by a call to ListMetrics.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingPolicyTargetTrackingMetricDataQueryArgs']]] metrics: The metrics to include in the target tracking scaling policy, as a metric data query. This can include both raw metric and metric math expressions.
        :param pulumi.Input[str] namespace: The namespace of the metric.
        :param pulumi.Input[str] statistic: The statistic of the metric.
        :param pulumi.Input[str] unit: The unit of the metric. For a complete list of the units that CloudWatch supports, see the MetricDatum data type in the Amazon CloudWatch API Reference.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDimensionArgs']]]]:
        """
        The dimensions of the metric.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyMetricDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the metric. To get the exact metric name, namespace, and dimensions, inspect the Metric object that is returned by a call to ListMetrics.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyTargetTrackingMetricDataQueryArgs']]]]:
        """
        The metrics to include in the target tracking scaling policy, as a metric data query. This can include both raw metric and metric math expressions.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyTargetTrackingMetricDataQueryArgs']]]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace of the metric.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def statistic(self) -> Optional[pulumi.Input[str]]:
        """
        The statistic of the metric.
        """
        return pulumi.get(self, "statistic")

    @statistic.setter
    def statistic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "statistic", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[str]]:
        """
        The unit of the metric. For a complete list of the units that CloudWatch supports, see the MetricDatum data type in the Amazon CloudWatch API Reference.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit", value)


@pulumi.input_type
class ScalingPolicyMetricDimensionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Describes the dimension names and values associated with a metric.
        :param pulumi.Input[str] name: The name of the dimension.
        :param pulumi.Input[str] value: The value of the dimension.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the dimension.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the dimension.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ScalingPolicyPredefinedMetricSpecificationArgs:
    def __init__(__self__, *,
                 predefined_metric_type: pulumi.Input[str],
                 resource_label: Optional[pulumi.Input[str]] = None):
        """
        Represents a predefined metric for a target tracking scaling policy to use with Application Auto Scaling.
        :param pulumi.Input[str] predefined_metric_type: The metric type. The ALBRequestCountPerTarget metric type applies only to Spot Fleets and ECS services.
        :param pulumi.Input[str] resource_label: Identifies the resource associated with the metric type. You can't specify a resource label unless the metric type is ALBRequestCountPerTarget and there is a target group attached to the Spot Fleet or ECS service.
        """
        pulumi.set(__self__, "predefined_metric_type", predefined_metric_type)
        if resource_label is not None:
            pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedMetricType")
    def predefined_metric_type(self) -> pulumi.Input[str]:
        """
        The metric type. The ALBRequestCountPerTarget metric type applies only to Spot Fleets and ECS services.
        """
        return pulumi.get(self, "predefined_metric_type")

    @predefined_metric_type.setter
    def predefined_metric_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "predefined_metric_type", value)

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the resource associated with the metric type. You can't specify a resource label unless the metric type is ALBRequestCountPerTarget and there is a target group attached to the Spot Fleet or ECS service.
        """
        return pulumi.get(self, "resource_label")

    @resource_label.setter
    def resource_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_label", value)


@pulumi.input_type
class ScalingPolicyStepAdjustmentArgs:
    def __init__(__self__, *,
                 scaling_adjustment: pulumi.Input[int],
                 metric_interval_lower_bound: Optional[pulumi.Input[float]] = None,
                 metric_interval_upper_bound: Optional[pulumi.Input[float]] = None):
        """
        Represents a step adjustment for a StepScalingPolicyConfiguration. Describes an adjustment based on the difference between the value of the aggregated CloudWatch metric and the breach threshold that you've defined for the alarm.
        :param pulumi.Input[int] scaling_adjustment: The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value.
        :param pulumi.Input[float] metric_interval_lower_bound: The lower bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.
        :param pulumi.Input[float] metric_interval_upper_bound: The upper bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.
        """
        pulumi.set(__self__, "scaling_adjustment", scaling_adjustment)
        if metric_interval_lower_bound is not None:
            pulumi.set(__self__, "metric_interval_lower_bound", metric_interval_lower_bound)
        if metric_interval_upper_bound is not None:
            pulumi.set(__self__, "metric_interval_upper_bound", metric_interval_upper_bound)

    @property
    @pulumi.getter(name="scalingAdjustment")
    def scaling_adjustment(self) -> pulumi.Input[int]:
        """
        The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value.
        """
        return pulumi.get(self, "scaling_adjustment")

    @scaling_adjustment.setter
    def scaling_adjustment(self, value: pulumi.Input[int]):
        pulumi.set(self, "scaling_adjustment", value)

    @property
    @pulumi.getter(name="metricIntervalLowerBound")
    def metric_interval_lower_bound(self) -> Optional[pulumi.Input[float]]:
        """
        The lower bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.
        """
        return pulumi.get(self, "metric_interval_lower_bound")

    @metric_interval_lower_bound.setter
    def metric_interval_lower_bound(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "metric_interval_lower_bound", value)

    @property
    @pulumi.getter(name="metricIntervalUpperBound")
    def metric_interval_upper_bound(self) -> Optional[pulumi.Input[float]]:
        """
        The upper bound for the difference between the alarm threshold and the CloudWatch metric. If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.
        """
        return pulumi.get(self, "metric_interval_upper_bound")

    @metric_interval_upper_bound.setter
    def metric_interval_upper_bound(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "metric_interval_upper_bound", value)


@pulumi.input_type
class ScalingPolicyStepScalingPolicyConfigurationArgs:
    def __init__(__self__, *,
                 adjustment_type: Optional[pulumi.Input[str]] = None,
                 cooldown: Optional[pulumi.Input[int]] = None,
                 metric_aggregation_type: Optional[pulumi.Input[str]] = None,
                 min_adjustment_magnitude: Optional[pulumi.Input[int]] = None,
                 step_adjustments: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyStepAdjustmentArgs']]]] = None):
        """
        A step scaling policy.
        :param pulumi.Input[str] adjustment_type: Specifies how the ScalingAdjustment value in a StepAdjustment is interpreted.
        :param pulumi.Input[int] cooldown: The amount of time, in seconds, to wait for a previous scaling activity to take effect.
        :param pulumi.Input[str] metric_aggregation_type: The aggregation type for the CloudWatch metrics. Valid values are Minimum, Maximum, and Average. If the aggregation type is null, the value is treated as Average
        :param pulumi.Input[int] min_adjustment_magnitude: The minimum value to scale by when the adjustment type is PercentChangeInCapacity.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingPolicyStepAdjustmentArgs']]] step_adjustments: A set of adjustments that enable you to scale based on the size of the alarm breach.
        """
        if adjustment_type is not None:
            pulumi.set(__self__, "adjustment_type", adjustment_type)
        if cooldown is not None:
            pulumi.set(__self__, "cooldown", cooldown)
        if metric_aggregation_type is not None:
            pulumi.set(__self__, "metric_aggregation_type", metric_aggregation_type)
        if min_adjustment_magnitude is not None:
            pulumi.set(__self__, "min_adjustment_magnitude", min_adjustment_magnitude)
        if step_adjustments is not None:
            pulumi.set(__self__, "step_adjustments", step_adjustments)

    @property
    @pulumi.getter(name="adjustmentType")
    def adjustment_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies how the ScalingAdjustment value in a StepAdjustment is interpreted.
        """
        return pulumi.get(self, "adjustment_type")

    @adjustment_type.setter
    def adjustment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "adjustment_type", value)

    @property
    @pulumi.getter
    def cooldown(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time, in seconds, to wait for a previous scaling activity to take effect.
        """
        return pulumi.get(self, "cooldown")

    @cooldown.setter
    def cooldown(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cooldown", value)

    @property
    @pulumi.getter(name="metricAggregationType")
    def metric_aggregation_type(self) -> Optional[pulumi.Input[str]]:
        """
        The aggregation type for the CloudWatch metrics. Valid values are Minimum, Maximum, and Average. If the aggregation type is null, the value is treated as Average
        """
        return pulumi.get(self, "metric_aggregation_type")

    @metric_aggregation_type.setter
    def metric_aggregation_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_aggregation_type", value)

    @property
    @pulumi.getter(name="minAdjustmentMagnitude")
    def min_adjustment_magnitude(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum value to scale by when the adjustment type is PercentChangeInCapacity.
        """
        return pulumi.get(self, "min_adjustment_magnitude")

    @min_adjustment_magnitude.setter
    def min_adjustment_magnitude(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_adjustment_magnitude", value)

    @property
    @pulumi.getter(name="stepAdjustments")
    def step_adjustments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyStepAdjustmentArgs']]]]:
        """
        A set of adjustments that enable you to scale based on the size of the alarm breach.
        """
        return pulumi.get(self, "step_adjustments")

    @step_adjustments.setter
    def step_adjustments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyStepAdjustmentArgs']]]]):
        pulumi.set(self, "step_adjustments", value)


@pulumi.input_type
class ScalingPolicyTargetTrackingMetricDataQueryArgs:
    def __init__(__self__, *,
                 expression: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 metric_stat: Optional[pulumi.Input['ScalingPolicyTargetTrackingMetricStatArgs']] = None,
                 return_data: Optional[pulumi.Input[bool]] = None):
        """
        The metric data to return. Also defines whether this call is returning data for one metric only, or whether it is performing a math expression on the values of returned metric statistics to create a new time series. A time series is a series of data points, each of which is associated with a timestamp.
        :param pulumi.Input[str] expression: The math expression to perform on the returned data, if this object is performing a math expression.
        :param pulumi.Input[str] id: A short name that identifies the object's results in the response.
        :param pulumi.Input[str] label: A human-readable label for this metric or expression. This is especially useful if this is a math expression, so that you know what the value represents.
        :param pulumi.Input['ScalingPolicyTargetTrackingMetricStatArgs'] metric_stat: Information about the metric data to return.
        :param pulumi.Input[bool] return_data: Indicates whether to return the timestamps and raw data values of this metric.
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if metric_stat is not None:
            pulumi.set(__self__, "metric_stat", metric_stat)
        if return_data is not None:
            pulumi.set(__self__, "return_data", return_data)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        The math expression to perform on the returned data, if this object is performing a math expression.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        A short name that identifies the object's results in the response.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable label for this metric or expression. This is especially useful if this is a math expression, so that you know what the value represents.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="metricStat")
    def metric_stat(self) -> Optional[pulumi.Input['ScalingPolicyTargetTrackingMetricStatArgs']]:
        """
        Information about the metric data to return.
        """
        return pulumi.get(self, "metric_stat")

    @metric_stat.setter
    def metric_stat(self, value: Optional[pulumi.Input['ScalingPolicyTargetTrackingMetricStatArgs']]):
        pulumi.set(self, "metric_stat", value)

    @property
    @pulumi.getter(name="returnData")
    def return_data(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to return the timestamps and raw data values of this metric.
        """
        return pulumi.get(self, "return_data")

    @return_data.setter
    def return_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "return_data", value)


@pulumi.input_type
class ScalingPolicyTargetTrackingMetricDimensionArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Describes the dimension of a metric.
        :param pulumi.Input[str] name: The name of the dimension.
        :param pulumi.Input[str] value: The value of the dimension.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the dimension.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the dimension.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ScalingPolicyTargetTrackingMetricStatArgs:
    def __init__(__self__, *,
                 metric: Optional[pulumi.Input['ScalingPolicyTargetTrackingMetricArgs']] = None,
                 stat: Optional[pulumi.Input[str]] = None,
                 unit: Optional[pulumi.Input[str]] = None):
        """
        This structure defines the CloudWatch metric to return, along with the statistic, period, and unit.
        :param pulumi.Input['ScalingPolicyTargetTrackingMetricArgs'] metric: The CloudWatch metric to return, including the metric name, namespace, and dimensions. 
        :param pulumi.Input[str] stat: The statistic to return. It can include any CloudWatch statistic or extended statistic.
        :param pulumi.Input[str] unit: The unit to use for the returned data points.
        """
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if stat is not None:
            pulumi.set(__self__, "stat", stat)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input['ScalingPolicyTargetTrackingMetricArgs']]:
        """
        The CloudWatch metric to return, including the metric name, namespace, and dimensions. 
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input['ScalingPolicyTargetTrackingMetricArgs']]):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter
    def stat(self) -> Optional[pulumi.Input[str]]:
        """
        The statistic to return. It can include any CloudWatch statistic or extended statistic.
        """
        return pulumi.get(self, "stat")

    @stat.setter
    def stat(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stat", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[str]]:
        """
        The unit to use for the returned data points.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit", value)


@pulumi.input_type
class ScalingPolicyTargetTrackingMetricArgs:
    def __init__(__self__, *,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyTargetTrackingMetricDimensionArgs']]]] = None,
                 metric_name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None):
        """
        Represents a specific metric.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingPolicyTargetTrackingMetricDimensionArgs']]] dimensions: The dimensions for the metric.
        :param pulumi.Input[str] metric_name: The name of the metric.
        :param pulumi.Input[str] namespace: The namespace of the metric.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyTargetTrackingMetricDimensionArgs']]]]:
        """
        The dimensions for the metric.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingPolicyTargetTrackingMetricDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace of the metric.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class ScalingPolicyTargetTrackingScalingPolicyConfigurationArgs:
    def __init__(__self__, *,
                 target_value: pulumi.Input[float],
                 customized_metric_specification: Optional[pulumi.Input['ScalingPolicyCustomizedMetricSpecificationArgs']] = None,
                 disable_scale_in: Optional[pulumi.Input[bool]] = None,
                 predefined_metric_specification: Optional[pulumi.Input['ScalingPolicyPredefinedMetricSpecificationArgs']] = None,
                 scale_in_cooldown: Optional[pulumi.Input[int]] = None,
                 scale_out_cooldown: Optional[pulumi.Input[int]] = None):
        """
        A target tracking scaling policy.
        :param pulumi.Input[float] target_value: The target value for the metric. Although this property accepts numbers of type Double, it won't accept values that are either too small or too large. Values must be in the range of -2^360 to 2^360. The value must be a valid number based on the choice of metric. For example, if the metric is CPU utilization, then the target value is a percent value that represents how much of the CPU can be used before scaling out.
        :param pulumi.Input['ScalingPolicyCustomizedMetricSpecificationArgs'] customized_metric_specification: A customized metric. You can specify either a predefined metric or a customized metric.
        :param pulumi.Input[bool] disable_scale_in: Indicates whether scale in by the target tracking scaling policy is disabled. If the value is true, scale in is disabled and the target tracking scaling policy won't remove capacity from the scalable target. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable target. The default value is false.
        :param pulumi.Input['ScalingPolicyPredefinedMetricSpecificationArgs'] predefined_metric_specification: A predefined metric. You can specify either a predefined metric or a customized metric.
        :param pulumi.Input[int] scale_in_cooldown: The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start.
        :param pulumi.Input[int] scale_out_cooldown: The amount of time, in seconds, to wait for a previous scale-out activity to take effect.
        """
        pulumi.set(__self__, "target_value", target_value)
        if customized_metric_specification is not None:
            pulumi.set(__self__, "customized_metric_specification", customized_metric_specification)
        if disable_scale_in is not None:
            pulumi.set(__self__, "disable_scale_in", disable_scale_in)
        if predefined_metric_specification is not None:
            pulumi.set(__self__, "predefined_metric_specification", predefined_metric_specification)
        if scale_in_cooldown is not None:
            pulumi.set(__self__, "scale_in_cooldown", scale_in_cooldown)
        if scale_out_cooldown is not None:
            pulumi.set(__self__, "scale_out_cooldown", scale_out_cooldown)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> pulumi.Input[float]:
        """
        The target value for the metric. Although this property accepts numbers of type Double, it won't accept values that are either too small or too large. Values must be in the range of -2^360 to 2^360. The value must be a valid number based on the choice of metric. For example, if the metric is CPU utilization, then the target value is a percent value that represents how much of the CPU can be used before scaling out.
        """
        return pulumi.get(self, "target_value")

    @target_value.setter
    def target_value(self, value: pulumi.Input[float]):
        pulumi.set(self, "target_value", value)

    @property
    @pulumi.getter(name="customizedMetricSpecification")
    def customized_metric_specification(self) -> Optional[pulumi.Input['ScalingPolicyCustomizedMetricSpecificationArgs']]:
        """
        A customized metric. You can specify either a predefined metric or a customized metric.
        """
        return pulumi.get(self, "customized_metric_specification")

    @customized_metric_specification.setter
    def customized_metric_specification(self, value: Optional[pulumi.Input['ScalingPolicyCustomizedMetricSpecificationArgs']]):
        pulumi.set(self, "customized_metric_specification", value)

    @property
    @pulumi.getter(name="disableScaleIn")
    def disable_scale_in(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether scale in by the target tracking scaling policy is disabled. If the value is true, scale in is disabled and the target tracking scaling policy won't remove capacity from the scalable target. Otherwise, scale in is enabled and the target tracking scaling policy can remove capacity from the scalable target. The default value is false.
        """
        return pulumi.get(self, "disable_scale_in")

    @disable_scale_in.setter
    def disable_scale_in(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_scale_in", value)

    @property
    @pulumi.getter(name="predefinedMetricSpecification")
    def predefined_metric_specification(self) -> Optional[pulumi.Input['ScalingPolicyPredefinedMetricSpecificationArgs']]:
        """
        A predefined metric. You can specify either a predefined metric or a customized metric.
        """
        return pulumi.get(self, "predefined_metric_specification")

    @predefined_metric_specification.setter
    def predefined_metric_specification(self, value: Optional[pulumi.Input['ScalingPolicyPredefinedMetricSpecificationArgs']]):
        pulumi.set(self, "predefined_metric_specification", value)

    @property
    @pulumi.getter(name="scaleInCooldown")
    def scale_in_cooldown(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start.
        """
        return pulumi.get(self, "scale_in_cooldown")

    @scale_in_cooldown.setter
    def scale_in_cooldown(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scale_in_cooldown", value)

    @property
    @pulumi.getter(name="scaleOutCooldown")
    def scale_out_cooldown(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time, in seconds, to wait for a previous scale-out activity to take effect.
        """
        return pulumi.get(self, "scale_out_cooldown")

    @scale_out_cooldown.setter
    def scale_out_cooldown(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scale_out_cooldown", value)


