# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ConfigurationProfileValidators',
    'EnvironmentMonitor',
    'ExtensionAction',
    'ExtensionParameter',
]

@pulumi.output_type
class ConfigurationProfileValidators(dict):
    """
    A list of methods for validating the configuration.
    """
    def __init__(__self__, *,
                 content: Optional[str] = None,
                 type: Optional[str] = None):
        """
        A list of methods for validating the configuration.
        :param str content: Either the JSON Schema content or the Amazon Resource Name (ARN) of an Lambda function.
        :param str type: AWS AppConfig supports validators of type JSON_SCHEMA and LAMBDA.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def content(self) -> Optional[str]:
        """
        Either the JSON Schema content or the Amazon Resource Name (ARN) of an Lambda function.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        AWS AppConfig supports validators of type JSON_SCHEMA and LAMBDA.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EnvironmentMonitor(dict):
    """
    Amazon CloudWatch alarm to monitor during the deployment process.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alarmArn":
            suggest = "alarm_arn"
        elif key == "alarmRoleArn":
            suggest = "alarm_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentMonitor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentMonitor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentMonitor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarm_arn: str,
                 alarm_role_arn: Optional[str] = None):
        """
        Amazon CloudWatch alarm to monitor during the deployment process.
        :param str alarm_arn: Amazon Resource Name (ARN) of the Amazon CloudWatch alarm.
        :param str alarm_role_arn: ARN of an AWS Identity and Access Management (IAM) role for AWS AppConfig to monitor AlarmArn.
        """
        pulumi.set(__self__, "alarm_arn", alarm_arn)
        if alarm_role_arn is not None:
            pulumi.set(__self__, "alarm_role_arn", alarm_role_arn)

    @property
    @pulumi.getter(name="alarmArn")
    def alarm_arn(self) -> str:
        """
        Amazon Resource Name (ARN) of the Amazon CloudWatch alarm.
        """
        return pulumi.get(self, "alarm_arn")

    @property
    @pulumi.getter(name="alarmRoleArn")
    def alarm_role_arn(self) -> Optional[str]:
        """
        ARN of an AWS Identity and Access Management (IAM) role for AWS AppConfig to monitor AlarmArn.
        """
        return pulumi.get(self, "alarm_role_arn")


@pulumi.output_type
class ExtensionAction(dict):
    """
    An action for an extension to take at a specific action point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtensionAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtensionAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtensionAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 uri: str,
                 description: Optional[str] = None,
                 role_arn: Optional[str] = None):
        """
        An action for an extension to take at a specific action point.
        :param str name: The name of the extension action.
        :param str uri: The URI of the extension action.
        :param str description: The description of the extension Action.
        :param str role_arn: The ARN of the role for invoking the extension action.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "uri", uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the extension action.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The URI of the extension action.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the extension Action.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        The ARN of the role for invoking the extension action.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class ExtensionParameter(dict):
    """
    A parameter for the extension to send to a specific action.
    """
    def __init__(__self__, *,
                 required: bool,
                 description: Optional[str] = None,
                 dynamic: Optional[bool] = None):
        """
        A parameter for the extension to send to a specific action.
        :param str description: The description of the extension Parameter.
        """
        pulumi.set(__self__, "required", required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dynamic is not None:
            pulumi.set(__self__, "dynamic", dynamic)

    @property
    @pulumi.getter
    def required(self) -> bool:
        return pulumi.get(self, "required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the extension Parameter.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dynamic(self) -> Optional[bool]:
        return pulumi.get(self, "dynamic")


