# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDomainNameResult',
    'AwaitableGetDomainNameResult',
    'get_domain_name',
    'get_domain_name_output',
]

@pulumi.output_type
class GetDomainNameResult:
    def __init__(__self__, domain_name_configurations=None, mutual_tls_authentication=None, regional_domain_name=None, regional_hosted_zone_id=None, tags=None):
        if domain_name_configurations and not isinstance(domain_name_configurations, list):
            raise TypeError("Expected argument 'domain_name_configurations' to be a list")
        pulumi.set(__self__, "domain_name_configurations", domain_name_configurations)
        if mutual_tls_authentication and not isinstance(mutual_tls_authentication, dict):
            raise TypeError("Expected argument 'mutual_tls_authentication' to be a dict")
        pulumi.set(__self__, "mutual_tls_authentication", mutual_tls_authentication)
        if regional_domain_name and not isinstance(regional_domain_name, str):
            raise TypeError("Expected argument 'regional_domain_name' to be a str")
        pulumi.set(__self__, "regional_domain_name", regional_domain_name)
        if regional_hosted_zone_id and not isinstance(regional_hosted_zone_id, str):
            raise TypeError("Expected argument 'regional_hosted_zone_id' to be a str")
        pulumi.set(__self__, "regional_hosted_zone_id", regional_hosted_zone_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="domainNameConfigurations")
    def domain_name_configurations(self) -> Optional[Sequence['outputs.DomainNameConfiguration']]:
        """
        The domain name configurations.
        """
        return pulumi.get(self, "domain_name_configurations")

    @property
    @pulumi.getter(name="mutualTlsAuthentication")
    def mutual_tls_authentication(self) -> Optional['outputs.DomainNameMutualTlsAuthentication']:
        """
        The mutual TLS authentication configuration for a custom domain name.
        """
        return pulumi.get(self, "mutual_tls_authentication")

    @property
    @pulumi.getter(name="regionalDomainName")
    def regional_domain_name(self) -> Optional[str]:
        return pulumi.get(self, "regional_domain_name")

    @property
    @pulumi.getter(name="regionalHostedZoneId")
    def regional_hosted_zone_id(self) -> Optional[str]:
        return pulumi.get(self, "regional_hosted_zone_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        The collection of tags associated with a domain name.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDomainNameResult(GetDomainNameResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainNameResult(
            domain_name_configurations=self.domain_name_configurations,
            mutual_tls_authentication=self.mutual_tls_authentication,
            regional_domain_name=self.regional_domain_name,
            regional_hosted_zone_id=self.regional_hosted_zone_id,
            tags=self.tags)


def get_domain_name(domain_name: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainNameResult:
    """
    The ``AWS::ApiGatewayV2::DomainName`` resource specifies a custom domain name for your API in Amazon API Gateway (API Gateway).
     You can use a custom domain name to provide a URL that's more intuitive and easier to recall. For more information about using custom domain names, see [Set up Custom Domain Name for an API in API Gateway](https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html) in the *API Gateway Developer Guide*.


    :param str domain_name: The custom domain name for your API in Amazon API Gateway. Uppercase letters are not supported.
    """
    __args__ = dict()
    __args__['domainName'] = domain_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:apigatewayv2:getDomainName', __args__, opts=opts, typ=GetDomainNameResult).value

    return AwaitableGetDomainNameResult(
        domain_name_configurations=pulumi.get(__ret__, 'domain_name_configurations'),
        mutual_tls_authentication=pulumi.get(__ret__, 'mutual_tls_authentication'),
        regional_domain_name=pulumi.get(__ret__, 'regional_domain_name'),
        regional_hosted_zone_id=pulumi.get(__ret__, 'regional_hosted_zone_id'),
        tags=pulumi.get(__ret__, 'tags'))


@_utilities.lift_output_func(get_domain_name)
def get_domain_name_output(domain_name: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDomainNameResult]:
    """
    The ``AWS::ApiGatewayV2::DomainName`` resource specifies a custom domain name for your API in Amazon API Gateway (API Gateway).
     You can use a custom domain name to provide a URL that's more intuitive and easier to recall. For more information about using custom domain names, see [Set up Custom Domain Name for an API in API Gateway](https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html) in the *API Gateway Developer Guide*.


    :param str domain_name: The custom domain name for your API in Amazon API Gateway. Uppercase letters are not supported.
    """
    ...
