# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetApiMappingResult',
    'AwaitableGetApiMappingResult',
    'get_api_mapping',
    'get_api_mapping_output',
]

@pulumi.output_type
class GetApiMappingResult:
    def __init__(__self__, api_id=None, api_mapping_id=None, api_mapping_key=None, stage=None):
        if api_id and not isinstance(api_id, str):
            raise TypeError("Expected argument 'api_id' to be a str")
        pulumi.set(__self__, "api_id", api_id)
        if api_mapping_id and not isinstance(api_mapping_id, str):
            raise TypeError("Expected argument 'api_mapping_id' to be a str")
        pulumi.set(__self__, "api_mapping_id", api_mapping_id)
        if api_mapping_key and not isinstance(api_mapping_key, str):
            raise TypeError("Expected argument 'api_mapping_key' to be a str")
        pulumi.set(__self__, "api_mapping_key", api_mapping_key)
        if stage and not isinstance(stage, str):
            raise TypeError("Expected argument 'stage' to be a str")
        pulumi.set(__self__, "stage", stage)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> Optional[str]:
        """
        The identifier of the API.
        """
        return pulumi.get(self, "api_id")

    @property
    @pulumi.getter(name="apiMappingId")
    def api_mapping_id(self) -> Optional[str]:
        return pulumi.get(self, "api_mapping_id")

    @property
    @pulumi.getter(name="apiMappingKey")
    def api_mapping_key(self) -> Optional[str]:
        """
        The API mapping key.
        """
        return pulumi.get(self, "api_mapping_key")

    @property
    @pulumi.getter
    def stage(self) -> Optional[str]:
        """
        The API stage.
        """
        return pulumi.get(self, "stage")


class AwaitableGetApiMappingResult(GetApiMappingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiMappingResult(
            api_id=self.api_id,
            api_mapping_id=self.api_mapping_id,
            api_mapping_key=self.api_mapping_key,
            stage=self.stage)


def get_api_mapping(api_mapping_id: Optional[str] = None,
                    domain_name: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiMappingResult:
    """
    The ``AWS::ApiGatewayV2::ApiMapping`` resource contains an API mapping. An API mapping relates a path of your custom domain name to a stage of your API. A custom domain name can have multiple API mappings, but the paths can't overlap. A custom domain can map only to APIs of the same protocol type. For more information, see [CreateApiMapping](https://docs.aws.amazon.com/apigatewayv2/latest/api-reference/domainnames-domainname-apimappings.html#CreateApiMapping) in the *Amazon API Gateway V2 API Reference*.


    :param str domain_name: The domain name.
    """
    __args__ = dict()
    __args__['apiMappingId'] = api_mapping_id
    __args__['domainName'] = domain_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:apigatewayv2:getApiMapping', __args__, opts=opts, typ=GetApiMappingResult).value

    return AwaitableGetApiMappingResult(
        api_id=pulumi.get(__ret__, 'api_id'),
        api_mapping_id=pulumi.get(__ret__, 'api_mapping_id'),
        api_mapping_key=pulumi.get(__ret__, 'api_mapping_key'),
        stage=pulumi.get(__ret__, 'stage'))


@_utilities.lift_output_func(get_api_mapping)
def get_api_mapping_output(api_mapping_id: Optional[pulumi.Input[str]] = None,
                           domain_name: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetApiMappingResult]:
    """
    The ``AWS::ApiGatewayV2::ApiMapping`` resource contains an API mapping. An API mapping relates a path of your custom domain name to a stage of your API. A custom domain name can have multiple API mappings, but the paths can't overlap. A custom domain can map only to APIs of the same protocol type. For more information, see [CreateApiMapping](https://docs.aws.amazon.com/apigatewayv2/latest/api-reference/domainnames-domainname-apimappings.html#CreateApiMapping) in the *Amazon API Gateway V2 API Reference*.


    :param str domain_name: The domain name.
    """
    ...
