# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ApiBodyS3LocationArgs',
    'ApiCorsArgs',
    'AuthorizerJwtConfigurationArgs',
    'DomainNameConfigurationArgs',
    'DomainNameMutualTlsAuthenticationArgs',
    'RouteParameterConstraintsArgs',
    'RouteResponseParameterConstraintsArgs',
]

@pulumi.input_type
class ApiBodyS3LocationArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The ``BodyS3Location`` property specifies an S3 location from which to import an OpenAPI definition. Supported only for HTTP APIs.
        :param pulumi.Input[str] bucket: The S3 bucket that contains the OpenAPI definition to import. Required if you specify a ``BodyS3Location`` for an API.
        :param pulumi.Input[str] etag: The Etag of the S3 object.
        :param pulumi.Input[str] key: The key of the S3 object. Required if you specify a ``BodyS3Location`` for an API.
        :param pulumi.Input[str] version: The version of the S3 object.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The S3 bucket that contains the OpenAPI definition to import. Required if you specify a ``BodyS3Location`` for an API.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        The Etag of the S3 object.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The key of the S3 object. Required if you specify a ``BodyS3Location`` for an API.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the S3 object.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class ApiCorsArgs:
    def __init__(__self__, *,
                 allow_credentials: Optional[pulumi.Input[bool]] = None,
                 allow_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allow_methods: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allow_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 expose_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_age: Optional[pulumi.Input[int]] = None):
        """
        The ``Cors`` property specifies a CORS configuration for an API. Supported only for HTTP APIs. See [Configuring CORS](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html) for more information.
        :param pulumi.Input[bool] allow_credentials: Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_headers: Represents a collection of allowed headers. Supported only for HTTP APIs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_methods: Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_origins: Represents a collection of allowed origins. Supported only for HTTP APIs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] expose_headers: Represents a collection of exposed headers. Supported only for HTTP APIs.
        :param pulumi.Input[int] max_age: The number of seconds that the browser should cache preflight request results. Supported only for HTTP APIs.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "allow_credentials")

    @allow_credentials.setter
    def allow_credentials(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_credentials", value)

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Represents a collection of allowed headers. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "allow_headers")

    @allow_headers.setter
    def allow_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allow_headers", value)

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "allow_methods")

    @allow_methods.setter
    def allow_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allow_methods", value)

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Represents a collection of allowed origins. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "allow_origins")

    @allow_origins.setter
    def allow_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allow_origins", value)

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Represents a collection of exposed headers. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "expose_headers")

    @expose_headers.setter
    def expose_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "expose_headers", value)

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds that the browser should cache preflight request results. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "max_age")

    @max_age.setter
    def max_age(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_age", value)


@pulumi.input_type
class AuthorizerJwtConfigurationArgs:
    def __init__(__self__, *,
                 audience: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 issuer: Optional[pulumi.Input[str]] = None):
        """
        The ``JWTConfiguration`` property specifies the configuration of a JWT authorizer. Required for the ``JWT`` authorizer type. Supported only for HTTP APIs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] audience: A list of the intended recipients of the JWT. A valid JWT must provide an ``aud`` that matches at least one entry in this list. See [RFC 7519](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc7519#section-4.1.3). Required for the ``JWT`` authorizer type. Supported only for HTTP APIs.
        :param pulumi.Input[str] issuer: The base domain of the identity provider that issues JSON Web Tokens. For example, an Amazon Cognito user pool has the following format: ``https://cognito-idp.{region}.amazonaws.com/{userPoolId}``. Required for the ``JWT`` authorizer type. Supported only for HTTP APIs.
        """
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)

    @property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the intended recipients of the JWT. A valid JWT must provide an ``aud`` that matches at least one entry in this list. See [RFC 7519](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc7519#section-4.1.3). Required for the ``JWT`` authorizer type. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "audience", value)

    @property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[str]]:
        """
        The base domain of the identity provider that issues JSON Web Tokens. For example, an Amazon Cognito user pool has the following format: ``https://cognito-idp.{region}.amazonaws.com/{userPoolId}``. Required for the ``JWT`` authorizer type. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer", value)


@pulumi.input_type
class DomainNameConfigurationArgs:
    def __init__(__self__, *,
                 certificate_arn: Optional[pulumi.Input[str]] = None,
                 certificate_name: Optional[pulumi.Input[str]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 ownership_verification_certificate_arn: Optional[pulumi.Input[str]] = None,
                 security_policy: Optional[pulumi.Input[str]] = None):
        """
        The ``DomainNameConfiguration`` property type specifies the configuration for an API's domain name.
         ``DomainNameConfiguration`` is a property of the [AWS::ApiGatewayV2::DomainName](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html) resource.
        :param pulumi.Input[str] certificate_arn: An AWS-managed certificate that will be used by the edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.
        :param pulumi.Input[str] certificate_name: The user-friendly name of the certificate that will be used by the edge-optimized endpoint for this domain name.
        :param pulumi.Input[str] endpoint_type: The endpoint type.
        :param pulumi.Input[str] ownership_verification_certificate_arn: The Amazon resource name (ARN) for the public certificate issued by ACMlong. This ARN is used to validate custom domain ownership. It's required only if you configure mutual TLS and use either an ACM-imported or a private CA certificate ARN as the regionalCertificateArn.
        :param pulumi.Input[str] security_policy: The Transport Layer Security (TLS) version of the security policy for this domain name. The valid values are ``TLS_1_0`` and ``TLS_1_2``.
        """
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if ownership_verification_certificate_arn is not None:
            pulumi.set(__self__, "ownership_verification_certificate_arn", ownership_verification_certificate_arn)
        if security_policy is not None:
            pulumi.set(__self__, "security_policy", security_policy)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[pulumi.Input[str]]:
        """
        An AWS-managed certificate that will be used by the edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.
        """
        return pulumi.get(self, "certificate_arn")

    @certificate_arn.setter
    def certificate_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_arn", value)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-friendly name of the certificate that will be used by the edge-optimized endpoint for this domain name.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_name", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint type.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="ownershipVerificationCertificateArn")
    def ownership_verification_certificate_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon resource name (ARN) for the public certificate issued by ACMlong. This ARN is used to validate custom domain ownership. It's required only if you configure mutual TLS and use either an ACM-imported or a private CA certificate ARN as the regionalCertificateArn.
        """
        return pulumi.get(self, "ownership_verification_certificate_arn")

    @ownership_verification_certificate_arn.setter
    def ownership_verification_certificate_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ownership_verification_certificate_arn", value)

    @property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The Transport Layer Security (TLS) version of the security policy for this domain name. The valid values are ``TLS_1_0`` and ``TLS_1_2``.
        """
        return pulumi.get(self, "security_policy")

    @security_policy.setter
    def security_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_policy", value)


@pulumi.input_type
class DomainNameMutualTlsAuthenticationArgs:
    def __init__(__self__, *,
                 truststore_uri: Optional[pulumi.Input[str]] = None,
                 truststore_version: Optional[pulumi.Input[str]] = None):
        """
        If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.
        :param pulumi.Input[str] truststore_uri: An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, ``s3://bucket-name/key-name``. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.
        :param pulumi.Input[str] truststore_version: The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket.
        """
        if truststore_uri is not None:
            pulumi.set(__self__, "truststore_uri", truststore_uri)
        if truststore_version is not None:
            pulumi.set(__self__, "truststore_version", truststore_version)

    @property
    @pulumi.getter(name="truststoreUri")
    def truststore_uri(self) -> Optional[pulumi.Input[str]]:
        """
        An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, ``s3://bucket-name/key-name``. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.
        """
        return pulumi.get(self, "truststore_uri")

    @truststore_uri.setter
    def truststore_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "truststore_uri", value)

    @property
    @pulumi.getter(name="truststoreVersion")
    def truststore_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket.
        """
        return pulumi.get(self, "truststore_version")

    @truststore_version.setter
    def truststore_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "truststore_version", value)


@pulumi.input_type
class RouteParameterConstraintsArgs:
    def __init__(__self__, *,
                 required: pulumi.Input[bool]):
        pulumi.set(__self__, "required", required)

    @property
    @pulumi.getter
    def required(self) -> pulumi.Input[bool]:
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: pulumi.Input[bool]):
        pulumi.set(self, "required", value)


@pulumi.input_type
class RouteResponseParameterConstraintsArgs:
    def __init__(__self__, *,
                 required: pulumi.Input[bool]):
        """
        Specifies whether the parameter is required.
        :param pulumi.Input[bool] required: Specifies whether the parameter is required.
        """
        pulumi.set(__self__, "required", required)

    @property
    @pulumi.getter
    def required(self) -> pulumi.Input[bool]:
        """
        Specifies whether the parameter is required.
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: pulumi.Input[bool]):
        pulumi.set(self, "required", value)


