# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['MethodArgs', 'Method']

@pulumi.input_type
class MethodArgs:
    def __init__(__self__, *,
                 http_method: pulumi.Input[str],
                 resource_id: pulumi.Input[str],
                 rest_api_id: pulumi.Input[str],
                 api_key_required: Optional[pulumi.Input[bool]] = None,
                 authorization_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 authorization_type: Optional[pulumi.Input['MethodAuthorizationType']] = None,
                 authorizer_id: Optional[pulumi.Input[str]] = None,
                 integration: Optional[pulumi.Input['MethodIntegrationArgs']] = None,
                 method_responses: Optional[pulumi.Input[Sequence[pulumi.Input['MethodResponseArgs']]]] = None,
                 operation_name: Optional[pulumi.Input[str]] = None,
                 request_models: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 request_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union[bool, str]]]]] = None,
                 request_validator_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Method resource.
        :param pulumi.Input[str] http_method: The method's HTTP verb.
        :param pulumi.Input[str] resource_id: The Resource identifier for the MethodResponse resource.
        :param pulumi.Input[str] rest_api_id: The string identifier of the associated RestApi.
        :param pulumi.Input[bool] api_key_required: A boolean flag specifying whether a valid ApiKey is required to invoke this method.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] authorization_scopes: A list of authorization scopes configured on the method. The scopes are used with a ``COGNITO_USER_POOLS`` authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
        :param pulumi.Input['MethodAuthorizationType'] authorization_type: The method's authorization type. This parameter is required. For valid values, see [Method](https://docs.aws.amazon.com/apigateway/latest/api/API_Method.html) in the *API Gateway API Reference*.
                 If you specify the ``AuthorizerId`` property, specify ``CUSTOM`` or ``COGNITO_USER_POOLS`` for this property.
        :param pulumi.Input[str] authorizer_id: The identifier of an authorizer to use on this method. The method's authorization type must be ``CUSTOM`` or ``COGNITO_USER_POOLS``.
        :param pulumi.Input['MethodIntegrationArgs'] integration: Represents an ``HTTP``, ``HTTP_PROXY``, ``AWS``, ``AWS_PROXY``, or Mock integration.
        :param pulumi.Input[Sequence[pulumi.Input['MethodResponseArgs']]] method_responses: Gets a method response associated with a given HTTP status code.
        :param pulumi.Input[str] operation_name: A human-friendly operation identifier for the method. For example, you can assign the ``operationName`` of ``ListPets`` for the ``GET /pets`` method in the ``PetStore`` example.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] request_models: A key-value map specifying data schemas, represented by Model resources, (as the mapped value) of the request payloads of given content types (as the mapping key).
        :param pulumi.Input[Mapping[str, pulumi.Input[Union[bool, str]]]] request_parameters: A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of ``method.request.{location}.{name}``, where ``location`` is ``querystring``, ``path``, or ``header`` and ``name`` is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (``true``) or optional (``false``). The method request parameter names defined here are available in Integration to be mapped to integration request parameters or templates.
        :param pulumi.Input[str] request_validator_id: The identifier of a RequestValidator for request validation.
        """
        pulumi.set(__self__, "http_method", http_method)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "rest_api_id", rest_api_id)
        if api_key_required is not None:
            pulumi.set(__self__, "api_key_required", api_key_required)
        if authorization_scopes is not None:
            pulumi.set(__self__, "authorization_scopes", authorization_scopes)
        if authorization_type is not None:
            pulumi.set(__self__, "authorization_type", authorization_type)
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if integration is not None:
            pulumi.set(__self__, "integration", integration)
        if method_responses is not None:
            pulumi.set(__self__, "method_responses", method_responses)
        if operation_name is not None:
            pulumi.set(__self__, "operation_name", operation_name)
        if request_models is not None:
            pulumi.set(__self__, "request_models", request_models)
        if request_parameters is not None:
            pulumi.set(__self__, "request_parameters", request_parameters)
        if request_validator_id is not None:
            pulumi.set(__self__, "request_validator_id", request_validator_id)

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> pulumi.Input[str]:
        """
        The method's HTTP verb.
        """
        return pulumi.get(self, "http_method")

    @http_method.setter
    def http_method(self, value: pulumi.Input[str]):
        pulumi.set(self, "http_method", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        The Resource identifier for the MethodResponse resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> pulumi.Input[str]:
        """
        The string identifier of the associated RestApi.
        """
        return pulumi.get(self, "rest_api_id")

    @rest_api_id.setter
    def rest_api_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "rest_api_id", value)

    @property
    @pulumi.getter(name="apiKeyRequired")
    def api_key_required(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean flag specifying whether a valid ApiKey is required to invoke this method.
        """
        return pulumi.get(self, "api_key_required")

    @api_key_required.setter
    def api_key_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "api_key_required", value)

    @property
    @pulumi.getter(name="authorizationScopes")
    def authorization_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of authorization scopes configured on the method. The scopes are used with a ``COGNITO_USER_POOLS`` authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
        """
        return pulumi.get(self, "authorization_scopes")

    @authorization_scopes.setter
    def authorization_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "authorization_scopes", value)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> Optional[pulumi.Input['MethodAuthorizationType']]:
        """
        The method's authorization type. This parameter is required. For valid values, see [Method](https://docs.aws.amazon.com/apigateway/latest/api/API_Method.html) in the *API Gateway API Reference*.
          If you specify the ``AuthorizerId`` property, specify ``CUSTOM`` or ``COGNITO_USER_POOLS`` for this property.
        """
        return pulumi.get(self, "authorization_type")

    @authorization_type.setter
    def authorization_type(self, value: Optional[pulumi.Input['MethodAuthorizationType']]):
        pulumi.set(self, "authorization_type", value)

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of an authorizer to use on this method. The method's authorization type must be ``CUSTOM`` or ``COGNITO_USER_POOLS``.
        """
        return pulumi.get(self, "authorizer_id")

    @authorizer_id.setter
    def authorizer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorizer_id", value)

    @property
    @pulumi.getter
    def integration(self) -> Optional[pulumi.Input['MethodIntegrationArgs']]:
        """
        Represents an ``HTTP``, ``HTTP_PROXY``, ``AWS``, ``AWS_PROXY``, or Mock integration.
        """
        return pulumi.get(self, "integration")

    @integration.setter
    def integration(self, value: Optional[pulumi.Input['MethodIntegrationArgs']]):
        pulumi.set(self, "integration", value)

    @property
    @pulumi.getter(name="methodResponses")
    def method_responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MethodResponseArgs']]]]:
        """
        Gets a method response associated with a given HTTP status code.
        """
        return pulumi.get(self, "method_responses")

    @method_responses.setter
    def method_responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MethodResponseArgs']]]]):
        pulumi.set(self, "method_responses", value)

    @property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> Optional[pulumi.Input[str]]:
        """
        A human-friendly operation identifier for the method. For example, you can assign the ``operationName`` of ``ListPets`` for the ``GET /pets`` method in the ``PetStore`` example.
        """
        return pulumi.get(self, "operation_name")

    @operation_name.setter
    def operation_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation_name", value)

    @property
    @pulumi.getter(name="requestModels")
    def request_models(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A key-value map specifying data schemas, represented by Model resources, (as the mapped value) of the request payloads of given content types (as the mapping key).
        """
        return pulumi.get(self, "request_models")

    @request_models.setter
    def request_models(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "request_models", value)

    @property
    @pulumi.getter(name="requestParameters")
    def request_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Union[bool, str]]]]]:
        """
        A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of ``method.request.{location}.{name}``, where ``location`` is ``querystring``, ``path``, or ``header`` and ``name`` is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (``true``) or optional (``false``). The method request parameter names defined here are available in Integration to be mapped to integration request parameters or templates.
        """
        return pulumi.get(self, "request_parameters")

    @request_parameters.setter
    def request_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union[bool, str]]]]]):
        pulumi.set(self, "request_parameters", value)

    @property
    @pulumi.getter(name="requestValidatorId")
    def request_validator_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of a RequestValidator for request validation.
        """
        return pulumi.get(self, "request_validator_id")

    @request_validator_id.setter
    def request_validator_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_validator_id", value)


class Method(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key_required: Optional[pulumi.Input[bool]] = None,
                 authorization_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 authorization_type: Optional[pulumi.Input['MethodAuthorizationType']] = None,
                 authorizer_id: Optional[pulumi.Input[str]] = None,
                 http_method: Optional[pulumi.Input[str]] = None,
                 integration: Optional[pulumi.Input[pulumi.InputType['MethodIntegrationArgs']]] = None,
                 method_responses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MethodResponseArgs']]]]] = None,
                 operation_name: Optional[pulumi.Input[str]] = None,
                 request_models: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 request_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union[bool, str]]]]] = None,
                 request_validator_id: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 rest_api_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The ``AWS::ApiGateway::Method`` resource creates API Gateway methods that define the parameters and body that clients must send in their requests.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] api_key_required: A boolean flag specifying whether a valid ApiKey is required to invoke this method.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] authorization_scopes: A list of authorization scopes configured on the method. The scopes are used with a ``COGNITO_USER_POOLS`` authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
        :param pulumi.Input['MethodAuthorizationType'] authorization_type: The method's authorization type. This parameter is required. For valid values, see [Method](https://docs.aws.amazon.com/apigateway/latest/api/API_Method.html) in the *API Gateway API Reference*.
                 If you specify the ``AuthorizerId`` property, specify ``CUSTOM`` or ``COGNITO_USER_POOLS`` for this property.
        :param pulumi.Input[str] authorizer_id: The identifier of an authorizer to use on this method. The method's authorization type must be ``CUSTOM`` or ``COGNITO_USER_POOLS``.
        :param pulumi.Input[str] http_method: The method's HTTP verb.
        :param pulumi.Input[pulumi.InputType['MethodIntegrationArgs']] integration: Represents an ``HTTP``, ``HTTP_PROXY``, ``AWS``, ``AWS_PROXY``, or Mock integration.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MethodResponseArgs']]]] method_responses: Gets a method response associated with a given HTTP status code.
        :param pulumi.Input[str] operation_name: A human-friendly operation identifier for the method. For example, you can assign the ``operationName`` of ``ListPets`` for the ``GET /pets`` method in the ``PetStore`` example.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] request_models: A key-value map specifying data schemas, represented by Model resources, (as the mapped value) of the request payloads of given content types (as the mapping key).
        :param pulumi.Input[Mapping[str, pulumi.Input[Union[bool, str]]]] request_parameters: A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of ``method.request.{location}.{name}``, where ``location`` is ``querystring``, ``path``, or ``header`` and ``name`` is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (``true``) or optional (``false``). The method request parameter names defined here are available in Integration to be mapped to integration request parameters or templates.
        :param pulumi.Input[str] request_validator_id: The identifier of a RequestValidator for request validation.
        :param pulumi.Input[str] resource_id: The Resource identifier for the MethodResponse resource.
        :param pulumi.Input[str] rest_api_id: The string identifier of the associated RestApi.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MethodArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The ``AWS::ApiGateway::Method`` resource creates API Gateway methods that define the parameters and body that clients must send in their requests.

        :param str resource_name: The name of the resource.
        :param MethodArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MethodArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key_required: Optional[pulumi.Input[bool]] = None,
                 authorization_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 authorization_type: Optional[pulumi.Input['MethodAuthorizationType']] = None,
                 authorizer_id: Optional[pulumi.Input[str]] = None,
                 http_method: Optional[pulumi.Input[str]] = None,
                 integration: Optional[pulumi.Input[pulumi.InputType['MethodIntegrationArgs']]] = None,
                 method_responses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MethodResponseArgs']]]]] = None,
                 operation_name: Optional[pulumi.Input[str]] = None,
                 request_models: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 request_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union[bool, str]]]]] = None,
                 request_validator_id: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 rest_api_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MethodArgs.__new__(MethodArgs)

            __props__.__dict__["api_key_required"] = api_key_required
            __props__.__dict__["authorization_scopes"] = authorization_scopes
            __props__.__dict__["authorization_type"] = authorization_type
            __props__.__dict__["authorizer_id"] = authorizer_id
            if http_method is None and not opts.urn:
                raise TypeError("Missing required property 'http_method'")
            __props__.__dict__["http_method"] = http_method
            __props__.__dict__["integration"] = integration
            __props__.__dict__["method_responses"] = method_responses
            __props__.__dict__["operation_name"] = operation_name
            __props__.__dict__["request_models"] = request_models
            __props__.__dict__["request_parameters"] = request_parameters
            __props__.__dict__["request_validator_id"] = request_validator_id
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            if rest_api_id is None and not opts.urn:
                raise TypeError("Missing required property 'rest_api_id'")
            __props__.__dict__["rest_api_id"] = rest_api_id
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["httpMethod", "resourceId", "restApiId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Method, __self__).__init__(
            'aws-native:apigateway:Method',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Method':
        """
        Get an existing Method resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = MethodArgs.__new__(MethodArgs)

        __props__.__dict__["api_key_required"] = None
        __props__.__dict__["authorization_scopes"] = None
        __props__.__dict__["authorization_type"] = None
        __props__.__dict__["authorizer_id"] = None
        __props__.__dict__["http_method"] = None
        __props__.__dict__["integration"] = None
        __props__.__dict__["method_responses"] = None
        __props__.__dict__["operation_name"] = None
        __props__.__dict__["request_models"] = None
        __props__.__dict__["request_parameters"] = None
        __props__.__dict__["request_validator_id"] = None
        __props__.__dict__["resource_id"] = None
        __props__.__dict__["rest_api_id"] = None
        return Method(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiKeyRequired")
    def api_key_required(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean flag specifying whether a valid ApiKey is required to invoke this method.
        """
        return pulumi.get(self, "api_key_required")

    @property
    @pulumi.getter(name="authorizationScopes")
    def authorization_scopes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of authorization scopes configured on the method. The scopes are used with a ``COGNITO_USER_POOLS`` authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
        """
        return pulumi.get(self, "authorization_scopes")

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> pulumi.Output[Optional['MethodAuthorizationType']]:
        """
        The method's authorization type. This parameter is required. For valid values, see [Method](https://docs.aws.amazon.com/apigateway/latest/api/API_Method.html) in the *API Gateway API Reference*.
          If you specify the ``AuthorizerId`` property, specify ``CUSTOM`` or ``COGNITO_USER_POOLS`` for this property.
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> pulumi.Output[Optional[str]]:
        """
        The identifier of an authorizer to use on this method. The method's authorization type must be ``CUSTOM`` or ``COGNITO_USER_POOLS``.
        """
        return pulumi.get(self, "authorizer_id")

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> pulumi.Output[str]:
        """
        The method's HTTP verb.
        """
        return pulumi.get(self, "http_method")

    @property
    @pulumi.getter
    def integration(self) -> pulumi.Output[Optional['outputs.MethodIntegration']]:
        """
        Represents an ``HTTP``, ``HTTP_PROXY``, ``AWS``, ``AWS_PROXY``, or Mock integration.
        """
        return pulumi.get(self, "integration")

    @property
    @pulumi.getter(name="methodResponses")
    def method_responses(self) -> pulumi.Output[Optional[Sequence['outputs.MethodResponse']]]:
        """
        Gets a method response associated with a given HTTP status code.
        """
        return pulumi.get(self, "method_responses")

    @property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> pulumi.Output[Optional[str]]:
        """
        A human-friendly operation identifier for the method. For example, you can assign the ``operationName`` of ``ListPets`` for the ``GET /pets`` method in the ``PetStore`` example.
        """
        return pulumi.get(self, "operation_name")

    @property
    @pulumi.getter(name="requestModels")
    def request_models(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A key-value map specifying data schemas, represented by Model resources, (as the mapped value) of the request payloads of given content types (as the mapping key).
        """
        return pulumi.get(self, "request_models")

    @property
    @pulumi.getter(name="requestParameters")
    def request_parameters(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of ``method.request.{location}.{name}``, where ``location`` is ``querystring``, ``path``, or ``header`` and ``name`` is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (``true``) or optional (``false``). The method request parameter names defined here are available in Integration to be mapped to integration request parameters or templates.
        """
        return pulumi.get(self, "request_parameters")

    @property
    @pulumi.getter(name="requestValidatorId")
    def request_validator_id(self) -> pulumi.Output[Optional[str]]:
        """
        The identifier of a RequestValidator for request validation.
        """
        return pulumi.get(self, "request_validator_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[str]:
        """
        The Resource identifier for the MethodResponse resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> pulumi.Output[str]:
        """
        The string identifier of the associated RestApi.
        """
        return pulumi.get(self, "rest_api_id")

