# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DocumentationVersionArgs', 'DocumentationVersion']

@pulumi.input_type
class DocumentationVersionArgs:
    def __init__(__self__, *,
                 documentation_version: pulumi.Input[str],
                 rest_api_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DocumentationVersion resource.
        :param pulumi.Input[str] documentation_version: The version identifier of the to-be-updated documentation version.
        :param pulumi.Input[str] rest_api_id: The string identifier of the associated RestApi.
        :param pulumi.Input[str] description: A description about the new documentation snapshot.
        """
        pulumi.set(__self__, "documentation_version", documentation_version)
        pulumi.set(__self__, "rest_api_id", rest_api_id)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="documentationVersion")
    def documentation_version(self) -> pulumi.Input[str]:
        """
        The version identifier of the to-be-updated documentation version.
        """
        return pulumi.get(self, "documentation_version")

    @documentation_version.setter
    def documentation_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "documentation_version", value)

    @property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> pulumi.Input[str]:
        """
        The string identifier of the associated RestApi.
        """
        return pulumi.get(self, "rest_api_id")

    @rest_api_id.setter
    def rest_api_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "rest_api_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description about the new documentation snapshot.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


class DocumentationVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 documentation_version: Optional[pulumi.Input[str]] = None,
                 rest_api_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The ``AWS::ApiGateway::DocumentationVersion`` resource creates a snapshot of the documentation for an API. For more information, see [Representation of API Documentation in API Gateway](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api-content-representation.html) in the *API Gateway Developer Guide*.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description about the new documentation snapshot.
        :param pulumi.Input[str] documentation_version: The version identifier of the to-be-updated documentation version.
        :param pulumi.Input[str] rest_api_id: The string identifier of the associated RestApi.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DocumentationVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The ``AWS::ApiGateway::DocumentationVersion`` resource creates a snapshot of the documentation for an API. For more information, see [Representation of API Documentation in API Gateway](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api-content-representation.html) in the *API Gateway Developer Guide*.

        :param str resource_name: The name of the resource.
        :param DocumentationVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DocumentationVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 documentation_version: Optional[pulumi.Input[str]] = None,
                 rest_api_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DocumentationVersionArgs.__new__(DocumentationVersionArgs)

            __props__.__dict__["description"] = description
            if documentation_version is None and not opts.urn:
                raise TypeError("Missing required property 'documentation_version'")
            __props__.__dict__["documentation_version"] = documentation_version
            if rest_api_id is None and not opts.urn:
                raise TypeError("Missing required property 'rest_api_id'")
            __props__.__dict__["rest_api_id"] = rest_api_id
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["documentationVersion", "restApiId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DocumentationVersion, __self__).__init__(
            'aws-native:apigateway:DocumentationVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DocumentationVersion':
        """
        Get an existing DocumentationVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DocumentationVersionArgs.__new__(DocumentationVersionArgs)

        __props__.__dict__["description"] = None
        __props__.__dict__["documentation_version"] = None
        __props__.__dict__["rest_api_id"] = None
        return DocumentationVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description about the new documentation snapshot.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="documentationVersion")
    def documentation_version(self) -> pulumi.Output[str]:
        """
        The version identifier of the to-be-updated documentation version.
        """
        return pulumi.get(self, "documentation_version")

    @property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> pulumi.Output[str]:
        """
        The string identifier of the associated RestApi.
        """
        return pulumi.get(self, "rest_api_id")

