# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'CertificateApiPassthrough',
    'CertificateAuthorityAccessDescription',
    'CertificateAuthorityAccessMethod',
    'CertificateAuthorityCrlConfiguration',
    'CertificateAuthorityCrlDistributionPointExtensionConfiguration',
    'CertificateAuthorityCsrExtensions',
    'CertificateAuthorityCustomAttribute',
    'CertificateAuthorityEdiPartyName',
    'CertificateAuthorityGeneralName',
    'CertificateAuthorityKeyUsage',
    'CertificateAuthorityOcspConfiguration',
    'CertificateAuthorityOtherName',
    'CertificateAuthorityRevocationConfiguration',
    'CertificateAuthoritySubject',
    'CertificateCustomAttribute',
    'CertificateCustomExtension',
    'CertificateEdiPartyName',
    'CertificateExtendedKeyUsage',
    'CertificateExtensions',
    'CertificateGeneralName',
    'CertificateKeyUsage',
    'CertificateOtherName',
    'CertificatePolicyInformation',
    'CertificatePolicyQualifierInfo',
    'CertificateQualifier',
    'CertificateSubject',
    'CertificateValidity',
]

@pulumi.output_type
class CertificateApiPassthrough(dict):
    """
    Contains X.509 certificate information to be placed in an issued certificate. An ``APIPassthrough`` or ``APICSRPassthrough`` template variant must be selected, or else this parameter is ignored. 
     If conflicting or duplicate certificate information is supplied from other sources, AWS Private CA applies [order of operation rules](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html#template-order-of-operations) to determine what information is used.
    """
    def __init__(__self__, *,
                 extensions: Optional['outputs.CertificateExtensions'] = None,
                 subject: Optional['outputs.CertificateSubject'] = None):
        """
        Contains X.509 certificate information to be placed in an issued certificate. An ``APIPassthrough`` or ``APICSRPassthrough`` template variant must be selected, or else this parameter is ignored. 
         If conflicting or duplicate certificate information is supplied from other sources, AWS Private CA applies [order of operation rules](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html#template-order-of-operations) to determine what information is used.
        :param 'CertificateExtensions' extensions: Specifies X.509 extension information for a certificate.
        :param 'CertificateSubject' subject: Contains information about the certificate subject. The Subject field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The Subject must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate.
        """
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)

    @property
    @pulumi.getter
    def extensions(self) -> Optional['outputs.CertificateExtensions']:
        """
        Specifies X.509 extension information for a certificate.
        """
        return pulumi.get(self, "extensions")

    @property
    @pulumi.getter
    def subject(self) -> Optional['outputs.CertificateSubject']:
        """
        Contains information about the certificate subject. The Subject field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The Subject must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate.
        """
        return pulumi.get(self, "subject")


@pulumi.output_type
class CertificateAuthorityAccessDescription(dict):
    """
    Structure that contains X.509 AccessDescription information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessLocation":
            suggest = "access_location"
        elif key == "accessMethod":
            suggest = "access_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityAccessDescription. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityAccessDescription.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityAccessDescription.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_location: 'outputs.CertificateAuthorityGeneralName',
                 access_method: 'outputs.CertificateAuthorityAccessMethod'):
        """
        Structure that contains X.509 AccessDescription information.
        """
        pulumi.set(__self__, "access_location", access_location)
        pulumi.set(__self__, "access_method", access_method)

    @property
    @pulumi.getter(name="accessLocation")
    def access_location(self) -> 'outputs.CertificateAuthorityGeneralName':
        return pulumi.get(self, "access_location")

    @property
    @pulumi.getter(name="accessMethod")
    def access_method(self) -> 'outputs.CertificateAuthorityAccessMethod':
        return pulumi.get(self, "access_method")


@pulumi.output_type
class CertificateAuthorityAccessMethod(dict):
    """
    Structure that contains X.509 AccessMethod information. Assign one and ONLY one field.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessMethodType":
            suggest = "access_method_type"
        elif key == "customObjectIdentifier":
            suggest = "custom_object_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityAccessMethod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityAccessMethod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityAccessMethod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_method_type: Optional[str] = None,
                 custom_object_identifier: Optional[str] = None):
        """
        Structure that contains X.509 AccessMethod information. Assign one and ONLY one field.
        """
        if access_method_type is not None:
            pulumi.set(__self__, "access_method_type", access_method_type)
        if custom_object_identifier is not None:
            pulumi.set(__self__, "custom_object_identifier", custom_object_identifier)

    @property
    @pulumi.getter(name="accessMethodType")
    def access_method_type(self) -> Optional[str]:
        return pulumi.get(self, "access_method_type")

    @property
    @pulumi.getter(name="customObjectIdentifier")
    def custom_object_identifier(self) -> Optional[str]:
        return pulumi.get(self, "custom_object_identifier")


@pulumi.output_type
class CertificateAuthorityCrlConfiguration(dict):
    """
    Your certificate authority can create and maintain a certificate revocation list (CRL). A CRL contains information about certificates that have been revoked.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crlDistributionPointExtensionConfiguration":
            suggest = "crl_distribution_point_extension_configuration"
        elif key == "customCname":
            suggest = "custom_cname"
        elif key == "expirationInDays":
            suggest = "expiration_in_days"
        elif key == "s3BucketName":
            suggest = "s3_bucket_name"
        elif key == "s3ObjectAcl":
            suggest = "s3_object_acl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityCrlConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityCrlConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityCrlConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 crl_distribution_point_extension_configuration: Optional['outputs.CertificateAuthorityCrlDistributionPointExtensionConfiguration'] = None,
                 custom_cname: Optional[str] = None,
                 enabled: Optional[bool] = None,
                 expiration_in_days: Optional[int] = None,
                 s3_bucket_name: Optional[str] = None,
                 s3_object_acl: Optional[str] = None):
        """
        Your certificate authority can create and maintain a certificate revocation list (CRL). A CRL contains information about certificates that have been revoked.
        """
        if crl_distribution_point_extension_configuration is not None:
            pulumi.set(__self__, "crl_distribution_point_extension_configuration", crl_distribution_point_extension_configuration)
        if custom_cname is not None:
            pulumi.set(__self__, "custom_cname", custom_cname)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if expiration_in_days is not None:
            pulumi.set(__self__, "expiration_in_days", expiration_in_days)
        if s3_bucket_name is not None:
            pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_object_acl is not None:
            pulumi.set(__self__, "s3_object_acl", s3_object_acl)

    @property
    @pulumi.getter(name="crlDistributionPointExtensionConfiguration")
    def crl_distribution_point_extension_configuration(self) -> Optional['outputs.CertificateAuthorityCrlDistributionPointExtensionConfiguration']:
        return pulumi.get(self, "crl_distribution_point_extension_configuration")

    @property
    @pulumi.getter(name="customCname")
    def custom_cname(self) -> Optional[str]:
        return pulumi.get(self, "custom_cname")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="expirationInDays")
    def expiration_in_days(self) -> Optional[int]:
        return pulumi.get(self, "expiration_in_days")

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> Optional[str]:
        return pulumi.get(self, "s3_bucket_name")

    @property
    @pulumi.getter(name="s3ObjectAcl")
    def s3_object_acl(self) -> Optional[str]:
        return pulumi.get(self, "s3_object_acl")


@pulumi.output_type
class CertificateAuthorityCrlDistributionPointExtensionConfiguration(dict):
    """
    Configures the default behavior of the CRL Distribution Point extension for certificates issued by your certificate authority
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "omitExtension":
            suggest = "omit_extension"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityCrlDistributionPointExtensionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityCrlDistributionPointExtensionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityCrlDistributionPointExtensionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 omit_extension: bool):
        """
        Configures the default behavior of the CRL Distribution Point extension for certificates issued by your certificate authority
        """
        pulumi.set(__self__, "omit_extension", omit_extension)

    @property
    @pulumi.getter(name="omitExtension")
    def omit_extension(self) -> bool:
        return pulumi.get(self, "omit_extension")


@pulumi.output_type
class CertificateAuthorityCsrExtensions(dict):
    """
    Structure that contains CSR pass though extensions information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyUsage":
            suggest = "key_usage"
        elif key == "subjectInformationAccess":
            suggest = "subject_information_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityCsrExtensions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityCsrExtensions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityCsrExtensions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_usage: Optional['outputs.CertificateAuthorityKeyUsage'] = None,
                 subject_information_access: Optional[Sequence['outputs.CertificateAuthorityAccessDescription']] = None):
        """
        Structure that contains CSR pass though extensions information.
        """
        if key_usage is not None:
            pulumi.set(__self__, "key_usage", key_usage)
        if subject_information_access is not None:
            pulumi.set(__self__, "subject_information_access", subject_information_access)

    @property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> Optional['outputs.CertificateAuthorityKeyUsage']:
        return pulumi.get(self, "key_usage")

    @property
    @pulumi.getter(name="subjectInformationAccess")
    def subject_information_access(self) -> Optional[Sequence['outputs.CertificateAuthorityAccessDescription']]:
        return pulumi.get(self, "subject_information_access")


@pulumi.output_type
class CertificateAuthorityCustomAttribute(dict):
    """
    Structure that contains X.500 attribute type and value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdentifier":
            suggest = "object_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityCustomAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityCustomAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityCustomAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_identifier: str,
                 value: str):
        """
        Structure that contains X.500 attribute type and value.
        """
        pulumi.set(__self__, "object_identifier", object_identifier)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="objectIdentifier")
    def object_identifier(self) -> str:
        return pulumi.get(self, "object_identifier")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class CertificateAuthorityEdiPartyName(dict):
    """
    Structure that contains X.509 EdiPartyName information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nameAssigner":
            suggest = "name_assigner"
        elif key == "partyName":
            suggest = "party_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityEdiPartyName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityEdiPartyName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityEdiPartyName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name_assigner: str,
                 party_name: str):
        """
        Structure that contains X.509 EdiPartyName information.
        """
        pulumi.set(__self__, "name_assigner", name_assigner)
        pulumi.set(__self__, "party_name", party_name)

    @property
    @pulumi.getter(name="nameAssigner")
    def name_assigner(self) -> str:
        return pulumi.get(self, "name_assigner")

    @property
    @pulumi.getter(name="partyName")
    def party_name(self) -> str:
        return pulumi.get(self, "party_name")


@pulumi.output_type
class CertificateAuthorityGeneralName(dict):
    """
    Structure that contains X.509 GeneralName information. Assign one and ONLY one field.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "directoryName":
            suggest = "directory_name"
        elif key == "dnsName":
            suggest = "dns_name"
        elif key == "ediPartyName":
            suggest = "edi_party_name"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "otherName":
            suggest = "other_name"
        elif key == "registeredId":
            suggest = "registered_id"
        elif key == "rfc822Name":
            suggest = "rfc822_name"
        elif key == "uniformResourceIdentifier":
            suggest = "uniform_resource_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityGeneralName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityGeneralName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityGeneralName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 directory_name: Optional['outputs.CertificateAuthoritySubject'] = None,
                 dns_name: Optional[str] = None,
                 edi_party_name: Optional['outputs.CertificateAuthorityEdiPartyName'] = None,
                 ip_address: Optional[str] = None,
                 other_name: Optional['outputs.CertificateAuthorityOtherName'] = None,
                 registered_id: Optional[str] = None,
                 rfc822_name: Optional[str] = None,
                 uniform_resource_identifier: Optional[str] = None):
        """
        Structure that contains X.509 GeneralName information. Assign one and ONLY one field.
        """
        if directory_name is not None:
            pulumi.set(__self__, "directory_name", directory_name)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if edi_party_name is not None:
            pulumi.set(__self__, "edi_party_name", edi_party_name)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if other_name is not None:
            pulumi.set(__self__, "other_name", other_name)
        if registered_id is not None:
            pulumi.set(__self__, "registered_id", registered_id)
        if rfc822_name is not None:
            pulumi.set(__self__, "rfc822_name", rfc822_name)
        if uniform_resource_identifier is not None:
            pulumi.set(__self__, "uniform_resource_identifier", uniform_resource_identifier)

    @property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> Optional['outputs.CertificateAuthoritySubject']:
        return pulumi.get(self, "directory_name")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[str]:
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ediPartyName")
    def edi_party_name(self) -> Optional['outputs.CertificateAuthorityEdiPartyName']:
        return pulumi.get(self, "edi_party_name")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="otherName")
    def other_name(self) -> Optional['outputs.CertificateAuthorityOtherName']:
        return pulumi.get(self, "other_name")

    @property
    @pulumi.getter(name="registeredId")
    def registered_id(self) -> Optional[str]:
        return pulumi.get(self, "registered_id")

    @property
    @pulumi.getter(name="rfc822Name")
    def rfc822_name(self) -> Optional[str]:
        return pulumi.get(self, "rfc822_name")

    @property
    @pulumi.getter(name="uniformResourceIdentifier")
    def uniform_resource_identifier(self) -> Optional[str]:
        return pulumi.get(self, "uniform_resource_identifier")


@pulumi.output_type
class CertificateAuthorityKeyUsage(dict):
    """
    Structure that contains X.509 KeyUsage information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crlSign":
            suggest = "crl_sign"
        elif key == "dataEncipherment":
            suggest = "data_encipherment"
        elif key == "decipherOnly":
            suggest = "decipher_only"
        elif key == "digitalSignature":
            suggest = "digital_signature"
        elif key == "encipherOnly":
            suggest = "encipher_only"
        elif key == "keyAgreement":
            suggest = "key_agreement"
        elif key == "keyCertSign":
            suggest = "key_cert_sign"
        elif key == "keyEncipherment":
            suggest = "key_encipherment"
        elif key == "nonRepudiation":
            suggest = "non_repudiation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 crl_sign: Optional[bool] = None,
                 data_encipherment: Optional[bool] = None,
                 decipher_only: Optional[bool] = None,
                 digital_signature: Optional[bool] = None,
                 encipher_only: Optional[bool] = None,
                 key_agreement: Optional[bool] = None,
                 key_cert_sign: Optional[bool] = None,
                 key_encipherment: Optional[bool] = None,
                 non_repudiation: Optional[bool] = None):
        """
        Structure that contains X.509 KeyUsage information.
        """
        if crl_sign is not None:
            pulumi.set(__self__, "crl_sign", crl_sign)
        if data_encipherment is not None:
            pulumi.set(__self__, "data_encipherment", data_encipherment)
        if decipher_only is not None:
            pulumi.set(__self__, "decipher_only", decipher_only)
        if digital_signature is not None:
            pulumi.set(__self__, "digital_signature", digital_signature)
        if encipher_only is not None:
            pulumi.set(__self__, "encipher_only", encipher_only)
        if key_agreement is not None:
            pulumi.set(__self__, "key_agreement", key_agreement)
        if key_cert_sign is not None:
            pulumi.set(__self__, "key_cert_sign", key_cert_sign)
        if key_encipherment is not None:
            pulumi.set(__self__, "key_encipherment", key_encipherment)
        if non_repudiation is not None:
            pulumi.set(__self__, "non_repudiation", non_repudiation)

    @property
    @pulumi.getter(name="crlSign")
    def crl_sign(self) -> Optional[bool]:
        return pulumi.get(self, "crl_sign")

    @property
    @pulumi.getter(name="dataEncipherment")
    def data_encipherment(self) -> Optional[bool]:
        return pulumi.get(self, "data_encipherment")

    @property
    @pulumi.getter(name="decipherOnly")
    def decipher_only(self) -> Optional[bool]:
        return pulumi.get(self, "decipher_only")

    @property
    @pulumi.getter(name="digitalSignature")
    def digital_signature(self) -> Optional[bool]:
        return pulumi.get(self, "digital_signature")

    @property
    @pulumi.getter(name="encipherOnly")
    def encipher_only(self) -> Optional[bool]:
        return pulumi.get(self, "encipher_only")

    @property
    @pulumi.getter(name="keyAgreement")
    def key_agreement(self) -> Optional[bool]:
        return pulumi.get(self, "key_agreement")

    @property
    @pulumi.getter(name="keyCertSign")
    def key_cert_sign(self) -> Optional[bool]:
        return pulumi.get(self, "key_cert_sign")

    @property
    @pulumi.getter(name="keyEncipherment")
    def key_encipherment(self) -> Optional[bool]:
        return pulumi.get(self, "key_encipherment")

    @property
    @pulumi.getter(name="nonRepudiation")
    def non_repudiation(self) -> Optional[bool]:
        return pulumi.get(self, "non_repudiation")


@pulumi.output_type
class CertificateAuthorityOcspConfiguration(dict):
    """
    Helps to configure online certificate status protocol (OCSP) responder for your certificate authority
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ocspCustomCname":
            suggest = "ocsp_custom_cname"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityOcspConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityOcspConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityOcspConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 ocsp_custom_cname: Optional[str] = None):
        """
        Helps to configure online certificate status protocol (OCSP) responder for your certificate authority
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ocsp_custom_cname is not None:
            pulumi.set(__self__, "ocsp_custom_cname", ocsp_custom_cname)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="ocspCustomCname")
    def ocsp_custom_cname(self) -> Optional[str]:
        return pulumi.get(self, "ocsp_custom_cname")


@pulumi.output_type
class CertificateAuthorityOtherName(dict):
    """
    Structure that contains X.509 OtherName information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "typeId":
            suggest = "type_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityOtherName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityOtherName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityOtherName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type_id: str,
                 value: str):
        """
        Structure that contains X.509 OtherName information.
        """
        pulumi.set(__self__, "type_id", type_id)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="typeId")
    def type_id(self) -> str:
        return pulumi.get(self, "type_id")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class CertificateAuthorityRevocationConfiguration(dict):
    """
    Certificate Authority revocation information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crlConfiguration":
            suggest = "crl_configuration"
        elif key == "ocspConfiguration":
            suggest = "ocsp_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityRevocationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityRevocationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityRevocationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 crl_configuration: Optional['outputs.CertificateAuthorityCrlConfiguration'] = None,
                 ocsp_configuration: Optional['outputs.CertificateAuthorityOcspConfiguration'] = None):
        """
        Certificate Authority revocation information.
        """
        if crl_configuration is not None:
            pulumi.set(__self__, "crl_configuration", crl_configuration)
        if ocsp_configuration is not None:
            pulumi.set(__self__, "ocsp_configuration", ocsp_configuration)

    @property
    @pulumi.getter(name="crlConfiguration")
    def crl_configuration(self) -> Optional['outputs.CertificateAuthorityCrlConfiguration']:
        return pulumi.get(self, "crl_configuration")

    @property
    @pulumi.getter(name="ocspConfiguration")
    def ocsp_configuration(self) -> Optional['outputs.CertificateAuthorityOcspConfiguration']:
        return pulumi.get(self, "ocsp_configuration")


@pulumi.output_type
class CertificateAuthoritySubject(dict):
    """
    Structure that contains X.500 distinguished name information for your CA.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "customAttributes":
            suggest = "custom_attributes"
        elif key == "distinguishedNameQualifier":
            suggest = "distinguished_name_qualifier"
        elif key == "generationQualifier":
            suggest = "generation_qualifier"
        elif key == "givenName":
            suggest = "given_name"
        elif key == "organizationalUnit":
            suggest = "organizational_unit"
        elif key == "serialNumber":
            suggest = "serial_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthoritySubject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthoritySubject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthoritySubject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_name: Optional[str] = None,
                 country: Optional[str] = None,
                 custom_attributes: Optional[Sequence['outputs.CertificateAuthorityCustomAttribute']] = None,
                 distinguished_name_qualifier: Optional[str] = None,
                 generation_qualifier: Optional[str] = None,
                 given_name: Optional[str] = None,
                 initials: Optional[str] = None,
                 locality: Optional[str] = None,
                 organization: Optional[str] = None,
                 organizational_unit: Optional[str] = None,
                 pseudonym: Optional[str] = None,
                 serial_number: Optional[str] = None,
                 state: Optional[str] = None,
                 surname: Optional[str] = None,
                 title: Optional[str] = None):
        """
        Structure that contains X.500 distinguished name information for your CA.
        """
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if distinguished_name_qualifier is not None:
            pulumi.set(__self__, "distinguished_name_qualifier", distinguished_name_qualifier)
        if generation_qualifier is not None:
            pulumi.set(__self__, "generation_qualifier", generation_qualifier)
        if given_name is not None:
            pulumi.set(__self__, "given_name", given_name)
        if initials is not None:
            pulumi.set(__self__, "initials", initials)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if pseudonym is not None:
            pulumi.set(__self__, "pseudonym", pseudonym)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if surname is not None:
            pulumi.set(__self__, "surname", surname)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[str]:
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter
    def country(self) -> Optional[str]:
        return pulumi.get(self, "country")

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[Sequence['outputs.CertificateAuthorityCustomAttribute']]:
        return pulumi.get(self, "custom_attributes")

    @property
    @pulumi.getter(name="distinguishedNameQualifier")
    def distinguished_name_qualifier(self) -> Optional[str]:
        return pulumi.get(self, "distinguished_name_qualifier")

    @property
    @pulumi.getter(name="generationQualifier")
    def generation_qualifier(self) -> Optional[str]:
        return pulumi.get(self, "generation_qualifier")

    @property
    @pulumi.getter(name="givenName")
    def given_name(self) -> Optional[str]:
        return pulumi.get(self, "given_name")

    @property
    @pulumi.getter
    def initials(self) -> Optional[str]:
        return pulumi.get(self, "initials")

    @property
    @pulumi.getter
    def locality(self) -> Optional[str]:
        return pulumi.get(self, "locality")

    @property
    @pulumi.getter
    def organization(self) -> Optional[str]:
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[str]:
        return pulumi.get(self, "organizational_unit")

    @property
    @pulumi.getter
    def pseudonym(self) -> Optional[str]:
        return pulumi.get(self, "pseudonym")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[str]:
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def surname(self) -> Optional[str]:
        return pulumi.get(self, "surname")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        return pulumi.get(self, "title")


@pulumi.output_type
class CertificateCustomAttribute(dict):
    """
    Defines the X.500 relative distinguished name (RDN).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdentifier":
            suggest = "object_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCustomAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCustomAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCustomAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_identifier: str,
                 value: str):
        """
        Defines the X.500 relative distinguished name (RDN).
        :param str object_identifier: Specifies the object identifier (OID) of the attribute type of the relative distinguished name (RDN).
        :param str value: Specifies the attribute value of relative distinguished name (RDN).
        """
        pulumi.set(__self__, "object_identifier", object_identifier)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="objectIdentifier")
    def object_identifier(self) -> str:
        """
        Specifies the object identifier (OID) of the attribute type of the relative distinguished name (RDN).
        """
        return pulumi.get(self, "object_identifier")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Specifies the attribute value of relative distinguished name (RDN).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CertificateCustomExtension(dict):
    """
    Specifies the X.509 extension information for a certificate.
     Extensions present in ``CustomExtensions`` follow the ``ApiPassthrough`` [template rules](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html#template-order-of-operations).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdentifier":
            suggest = "object_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCustomExtension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCustomExtension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCustomExtension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_identifier: str,
                 value: str,
                 critical: Optional[bool] = None):
        """
        Specifies the X.509 extension information for a certificate.
         Extensions present in ``CustomExtensions`` follow the ``ApiPassthrough`` [template rules](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html#template-order-of-operations).
        :param str object_identifier: Specifies the object identifier (OID) of the X.509 extension. For more information, see the [Global OID reference database.](https://docs.aws.amazon.com/https://oidref.com/2.5.29)
        :param str value: Specifies the base64-encoded value of the X.509 extension.
        :param bool critical: Specifies the critical flag of the X.509 extension.
        """
        pulumi.set(__self__, "object_identifier", object_identifier)
        pulumi.set(__self__, "value", value)
        if critical is not None:
            pulumi.set(__self__, "critical", critical)

    @property
    @pulumi.getter(name="objectIdentifier")
    def object_identifier(self) -> str:
        """
        Specifies the object identifier (OID) of the X.509 extension. For more information, see the [Global OID reference database.](https://docs.aws.amazon.com/https://oidref.com/2.5.29)
        """
        return pulumi.get(self, "object_identifier")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Specifies the base64-encoded value of the X.509 extension.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def critical(self) -> Optional[bool]:
        """
        Specifies the critical flag of the X.509 extension.
        """
        return pulumi.get(self, "critical")


@pulumi.output_type
class CertificateEdiPartyName(dict):
    """
    Describes an Electronic Data Interchange (EDI) entity as described in as defined in [Subject Alternative Name](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280) in RFC 5280.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nameAssigner":
            suggest = "name_assigner"
        elif key == "partyName":
            suggest = "party_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateEdiPartyName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateEdiPartyName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateEdiPartyName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name_assigner: str,
                 party_name: str):
        """
        Describes an Electronic Data Interchange (EDI) entity as described in as defined in [Subject Alternative Name](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280) in RFC 5280.
        :param str name_assigner: Specifies the name assigner.
        :param str party_name: Specifies the party name.
        """
        pulumi.set(__self__, "name_assigner", name_assigner)
        pulumi.set(__self__, "party_name", party_name)

    @property
    @pulumi.getter(name="nameAssigner")
    def name_assigner(self) -> str:
        """
        Specifies the name assigner.
        """
        return pulumi.get(self, "name_assigner")

    @property
    @pulumi.getter(name="partyName")
    def party_name(self) -> str:
        """
        Specifies the party name.
        """
        return pulumi.get(self, "party_name")


@pulumi.output_type
class CertificateExtendedKeyUsage(dict):
    """
    Specifies additional purposes for which the certified public key may be used other than basic purposes indicated in the ``KeyUsage`` extension.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extendedKeyUsageObjectIdentifier":
            suggest = "extended_key_usage_object_identifier"
        elif key == "extendedKeyUsageType":
            suggest = "extended_key_usage_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateExtendedKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateExtendedKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateExtendedKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extended_key_usage_object_identifier: Optional[str] = None,
                 extended_key_usage_type: Optional[str] = None):
        """
        Specifies additional purposes for which the certified public key may be used other than basic purposes indicated in the ``KeyUsage`` extension.
        :param str extended_key_usage_object_identifier: Specifies a custom ``ExtendedKeyUsage`` with an object identifier (OID).
        :param str extended_key_usage_type: Specifies a standard ``ExtendedKeyUsage`` as defined as in [RFC 5280](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.1.12).
        """
        if extended_key_usage_object_identifier is not None:
            pulumi.set(__self__, "extended_key_usage_object_identifier", extended_key_usage_object_identifier)
        if extended_key_usage_type is not None:
            pulumi.set(__self__, "extended_key_usage_type", extended_key_usage_type)

    @property
    @pulumi.getter(name="extendedKeyUsageObjectIdentifier")
    def extended_key_usage_object_identifier(self) -> Optional[str]:
        """
        Specifies a custom ``ExtendedKeyUsage`` with an object identifier (OID).
        """
        return pulumi.get(self, "extended_key_usage_object_identifier")

    @property
    @pulumi.getter(name="extendedKeyUsageType")
    def extended_key_usage_type(self) -> Optional[str]:
        """
        Specifies a standard ``ExtendedKeyUsage`` as defined as in [RFC 5280](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.1.12).
        """
        return pulumi.get(self, "extended_key_usage_type")


@pulumi.output_type
class CertificateExtensions(dict):
    """
    Contains X.509 extension information for a certificate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificatePolicies":
            suggest = "certificate_policies"
        elif key == "customExtensions":
            suggest = "custom_extensions"
        elif key == "extendedKeyUsage":
            suggest = "extended_key_usage"
        elif key == "keyUsage":
            suggest = "key_usage"
        elif key == "subjectAlternativeNames":
            suggest = "subject_alternative_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateExtensions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateExtensions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateExtensions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_policies: Optional[Sequence['outputs.CertificatePolicyInformation']] = None,
                 custom_extensions: Optional[Sequence['outputs.CertificateCustomExtension']] = None,
                 extended_key_usage: Optional[Sequence['outputs.CertificateExtendedKeyUsage']] = None,
                 key_usage: Optional['outputs.CertificateKeyUsage'] = None,
                 subject_alternative_names: Optional[Sequence['outputs.CertificateGeneralName']] = None):
        """
        Contains X.509 extension information for a certificate.
        :param Sequence['CertificatePolicyInformation'] certificate_policies: Contains a sequence of one or more policy information terms, each of which consists of an object identifier (OID) and optional qualifiers. For more information, see NIST's definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier).
                In an end-entity certificate, these terms indicate the policy under which the certificate was issued and the purposes for which it may be used. In a CA certificate, these terms limit the set of policies for certification paths that include this certificate.
        :param Sequence['CertificateCustomExtension'] custom_extensions: Contains a sequence of one or more X.509 extensions, each of which consists of an object identifier (OID), a base64-encoded value, and the critical flag. For more information, see the [Global OID reference database.](https://docs.aws.amazon.com/https://oidref.com/2.5.29)
        :param Sequence['CertificateExtendedKeyUsage'] extended_key_usage: Specifies additional purposes for which the certified public key may be used other than basic purposes indicated in the ``KeyUsage`` extension.
        :param 'CertificateKeyUsage' key_usage: Defines one or more purposes for which the key contained in the certificate can be used. Default value for each option is false.
        :param Sequence['CertificateGeneralName'] subject_alternative_names: The subject alternative name extension allows identities to be bound to the subject of the certificate. These identities may be included in addition to or in place of the identity in the subject field of the certificate.
        """
        if certificate_policies is not None:
            pulumi.set(__self__, "certificate_policies", certificate_policies)
        if custom_extensions is not None:
            pulumi.set(__self__, "custom_extensions", custom_extensions)
        if extended_key_usage is not None:
            pulumi.set(__self__, "extended_key_usage", extended_key_usage)
        if key_usage is not None:
            pulumi.set(__self__, "key_usage", key_usage)
        if subject_alternative_names is not None:
            pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)

    @property
    @pulumi.getter(name="certificatePolicies")
    def certificate_policies(self) -> Optional[Sequence['outputs.CertificatePolicyInformation']]:
        """
        Contains a sequence of one or more policy information terms, each of which consists of an object identifier (OID) and optional qualifiers. For more information, see NIST's definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier).
         In an end-entity certificate, these terms indicate the policy under which the certificate was issued and the purposes for which it may be used. In a CA certificate, these terms limit the set of policies for certification paths that include this certificate.
        """
        return pulumi.get(self, "certificate_policies")

    @property
    @pulumi.getter(name="customExtensions")
    def custom_extensions(self) -> Optional[Sequence['outputs.CertificateCustomExtension']]:
        """
        Contains a sequence of one or more X.509 extensions, each of which consists of an object identifier (OID), a base64-encoded value, and the critical flag. For more information, see the [Global OID reference database.](https://docs.aws.amazon.com/https://oidref.com/2.5.29)
        """
        return pulumi.get(self, "custom_extensions")

    @property
    @pulumi.getter(name="extendedKeyUsage")
    def extended_key_usage(self) -> Optional[Sequence['outputs.CertificateExtendedKeyUsage']]:
        """
        Specifies additional purposes for which the certified public key may be used other than basic purposes indicated in the ``KeyUsage`` extension.
        """
        return pulumi.get(self, "extended_key_usage")

    @property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> Optional['outputs.CertificateKeyUsage']:
        """
        Defines one or more purposes for which the key contained in the certificate can be used. Default value for each option is false.
        """
        return pulumi.get(self, "key_usage")

    @property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Optional[Sequence['outputs.CertificateGeneralName']]:
        """
        The subject alternative name extension allows identities to be bound to the subject of the certificate. These identities may be included in addition to or in place of the identity in the subject field of the certificate.
        """
        return pulumi.get(self, "subject_alternative_names")


@pulumi.output_type
class CertificateGeneralName(dict):
    """
    Describes an ASN.1 X.400 ``GeneralName`` as defined in [RFC 5280](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280). Only one of the following naming options should be provided. Providing more than one option results in an ``InvalidArgsException`` error.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "directoryName":
            suggest = "directory_name"
        elif key == "dnsName":
            suggest = "dns_name"
        elif key == "ediPartyName":
            suggest = "edi_party_name"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "otherName":
            suggest = "other_name"
        elif key == "registeredId":
            suggest = "registered_id"
        elif key == "rfc822Name":
            suggest = "rfc822_name"
        elif key == "uniformResourceIdentifier":
            suggest = "uniform_resource_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateGeneralName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateGeneralName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateGeneralName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 directory_name: Optional['outputs.CertificateSubject'] = None,
                 dns_name: Optional[str] = None,
                 edi_party_name: Optional['outputs.CertificateEdiPartyName'] = None,
                 ip_address: Optional[str] = None,
                 other_name: Optional['outputs.CertificateOtherName'] = None,
                 registered_id: Optional[str] = None,
                 rfc822_name: Optional[str] = None,
                 uniform_resource_identifier: Optional[str] = None):
        """
        Describes an ASN.1 X.400 ``GeneralName`` as defined in [RFC 5280](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280). Only one of the following naming options should be provided. Providing more than one option results in an ``InvalidArgsException`` error.
        :param 'CertificateSubject' directory_name: Contains information about the certificate subject. The certificate can be one issued by your private certificate authority (CA) or it can be your private CA certificate. The Subject field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The Subject must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate. The DN must be unique for each entity, but your private CA can issue more than one certificate with the same DN to the same entity.
        :param str dns_name: Represents ``GeneralName`` as a DNS name.
        :param 'CertificateEdiPartyName' edi_party_name: Represents ``GeneralName`` as an ``EdiPartyName`` object.
        :param str ip_address: Represents ``GeneralName`` as an IPv4 or IPv6 address.
        :param 'CertificateOtherName' other_name: Represents ``GeneralName`` using an ``OtherName`` object.
        :param str registered_id: Represents ``GeneralName`` as an object identifier (OID).
        :param str rfc822_name: Represents ``GeneralName`` as an [RFC 822](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc822) email address.
        :param str uniform_resource_identifier: Represents ``GeneralName`` as a URI.
        """
        if directory_name is not None:
            pulumi.set(__self__, "directory_name", directory_name)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if edi_party_name is not None:
            pulumi.set(__self__, "edi_party_name", edi_party_name)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if other_name is not None:
            pulumi.set(__self__, "other_name", other_name)
        if registered_id is not None:
            pulumi.set(__self__, "registered_id", registered_id)
        if rfc822_name is not None:
            pulumi.set(__self__, "rfc822_name", rfc822_name)
        if uniform_resource_identifier is not None:
            pulumi.set(__self__, "uniform_resource_identifier", uniform_resource_identifier)

    @property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> Optional['outputs.CertificateSubject']:
        """
        Contains information about the certificate subject. The certificate can be one issued by your private certificate authority (CA) or it can be your private CA certificate. The Subject field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The Subject must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate. The DN must be unique for each entity, but your private CA can issue more than one certificate with the same DN to the same entity.
        """
        return pulumi.get(self, "directory_name")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[str]:
        """
        Represents ``GeneralName`` as a DNS name.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ediPartyName")
    def edi_party_name(self) -> Optional['outputs.CertificateEdiPartyName']:
        """
        Represents ``GeneralName`` as an ``EdiPartyName`` object.
        """
        return pulumi.get(self, "edi_party_name")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        Represents ``GeneralName`` as an IPv4 or IPv6 address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="otherName")
    def other_name(self) -> Optional['outputs.CertificateOtherName']:
        """
        Represents ``GeneralName`` using an ``OtherName`` object.
        """
        return pulumi.get(self, "other_name")

    @property
    @pulumi.getter(name="registeredId")
    def registered_id(self) -> Optional[str]:
        """
        Represents ``GeneralName`` as an object identifier (OID).
        """
        return pulumi.get(self, "registered_id")

    @property
    @pulumi.getter(name="rfc822Name")
    def rfc822_name(self) -> Optional[str]:
        """
        Represents ``GeneralName`` as an [RFC 822](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc822) email address.
        """
        return pulumi.get(self, "rfc822_name")

    @property
    @pulumi.getter(name="uniformResourceIdentifier")
    def uniform_resource_identifier(self) -> Optional[str]:
        """
        Represents ``GeneralName`` as a URI.
        """
        return pulumi.get(self, "uniform_resource_identifier")


@pulumi.output_type
class CertificateKeyUsage(dict):
    """
    Defines one or more purposes for which the key contained in the certificate can be used. Default value for each option is false.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crlSign":
            suggest = "crl_sign"
        elif key == "dataEncipherment":
            suggest = "data_encipherment"
        elif key == "decipherOnly":
            suggest = "decipher_only"
        elif key == "digitalSignature":
            suggest = "digital_signature"
        elif key == "encipherOnly":
            suggest = "encipher_only"
        elif key == "keyAgreement":
            suggest = "key_agreement"
        elif key == "keyCertSign":
            suggest = "key_cert_sign"
        elif key == "keyEncipherment":
            suggest = "key_encipherment"
        elif key == "nonRepudiation":
            suggest = "non_repudiation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 crl_sign: Optional[bool] = None,
                 data_encipherment: Optional[bool] = None,
                 decipher_only: Optional[bool] = None,
                 digital_signature: Optional[bool] = None,
                 encipher_only: Optional[bool] = None,
                 key_agreement: Optional[bool] = None,
                 key_cert_sign: Optional[bool] = None,
                 key_encipherment: Optional[bool] = None,
                 non_repudiation: Optional[bool] = None):
        """
        Defines one or more purposes for which the key contained in the certificate can be used. Default value for each option is false.
        :param bool crl_sign: Key can be used to sign CRLs.
        :param bool data_encipherment: Key can be used to decipher data.
        :param bool decipher_only: Key can be used only to decipher data.
        :param bool digital_signature: Key can be used for digital signing.
        :param bool encipher_only: Key can be used only to encipher data.
        :param bool key_agreement: Key can be used in a key-agreement protocol.
        :param bool key_cert_sign: Key can be used to sign certificates.
        :param bool key_encipherment: Key can be used to encipher data.
        :param bool non_repudiation: Key can be used for non-repudiation.
        """
        if crl_sign is not None:
            pulumi.set(__self__, "crl_sign", crl_sign)
        if data_encipherment is not None:
            pulumi.set(__self__, "data_encipherment", data_encipherment)
        if decipher_only is not None:
            pulumi.set(__self__, "decipher_only", decipher_only)
        if digital_signature is not None:
            pulumi.set(__self__, "digital_signature", digital_signature)
        if encipher_only is not None:
            pulumi.set(__self__, "encipher_only", encipher_only)
        if key_agreement is not None:
            pulumi.set(__self__, "key_agreement", key_agreement)
        if key_cert_sign is not None:
            pulumi.set(__self__, "key_cert_sign", key_cert_sign)
        if key_encipherment is not None:
            pulumi.set(__self__, "key_encipherment", key_encipherment)
        if non_repudiation is not None:
            pulumi.set(__self__, "non_repudiation", non_repudiation)

    @property
    @pulumi.getter(name="crlSign")
    def crl_sign(self) -> Optional[bool]:
        """
        Key can be used to sign CRLs.
        """
        return pulumi.get(self, "crl_sign")

    @property
    @pulumi.getter(name="dataEncipherment")
    def data_encipherment(self) -> Optional[bool]:
        """
        Key can be used to decipher data.
        """
        return pulumi.get(self, "data_encipherment")

    @property
    @pulumi.getter(name="decipherOnly")
    def decipher_only(self) -> Optional[bool]:
        """
        Key can be used only to decipher data.
        """
        return pulumi.get(self, "decipher_only")

    @property
    @pulumi.getter(name="digitalSignature")
    def digital_signature(self) -> Optional[bool]:
        """
        Key can be used for digital signing.
        """
        return pulumi.get(self, "digital_signature")

    @property
    @pulumi.getter(name="encipherOnly")
    def encipher_only(self) -> Optional[bool]:
        """
        Key can be used only to encipher data.
        """
        return pulumi.get(self, "encipher_only")

    @property
    @pulumi.getter(name="keyAgreement")
    def key_agreement(self) -> Optional[bool]:
        """
        Key can be used in a key-agreement protocol.
        """
        return pulumi.get(self, "key_agreement")

    @property
    @pulumi.getter(name="keyCertSign")
    def key_cert_sign(self) -> Optional[bool]:
        """
        Key can be used to sign certificates.
        """
        return pulumi.get(self, "key_cert_sign")

    @property
    @pulumi.getter(name="keyEncipherment")
    def key_encipherment(self) -> Optional[bool]:
        """
        Key can be used to encipher data.
        """
        return pulumi.get(self, "key_encipherment")

    @property
    @pulumi.getter(name="nonRepudiation")
    def non_repudiation(self) -> Optional[bool]:
        """
        Key can be used for non-repudiation.
        """
        return pulumi.get(self, "non_repudiation")


@pulumi.output_type
class CertificateOtherName(dict):
    """
    Defines a custom ASN.1 X.400 ``GeneralName`` using an object identifier (OID) and value. The OID must satisfy the regular expression shown below. For more information, see NIST's definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "typeId":
            suggest = "type_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateOtherName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateOtherName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateOtherName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type_id: str,
                 value: str):
        """
        Defines a custom ASN.1 X.400 ``GeneralName`` using an object identifier (OID) and value. The OID must satisfy the regular expression shown below. For more information, see NIST's definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier).
        :param str type_id: Specifies an OID.
        :param str value: Specifies an OID value.
        """
        pulumi.set(__self__, "type_id", type_id)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="typeId")
    def type_id(self) -> str:
        """
        Specifies an OID.
        """
        return pulumi.get(self, "type_id")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Specifies an OID value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CertificatePolicyInformation(dict):
    """
    Defines the X.509 ``CertificatePolicies`` extension.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certPolicyId":
            suggest = "cert_policy_id"
        elif key == "policyQualifiers":
            suggest = "policy_qualifiers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificatePolicyInformation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificatePolicyInformation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificatePolicyInformation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_policy_id: str,
                 policy_qualifiers: Optional[Sequence['outputs.CertificatePolicyQualifierInfo']] = None):
        """
        Defines the X.509 ``CertificatePolicies`` extension.
        :param str cert_policy_id: Specifies the object identifier (OID) of the certificate policy under which the certificate was issued. For more information, see NIST's definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier).
        :param Sequence['CertificatePolicyQualifierInfo'] policy_qualifiers: Modifies the given ``CertPolicyId`` with a qualifier. AWS Private CA supports the certification practice statement (CPS) qualifier.
        """
        pulumi.set(__self__, "cert_policy_id", cert_policy_id)
        if policy_qualifiers is not None:
            pulumi.set(__self__, "policy_qualifiers", policy_qualifiers)

    @property
    @pulumi.getter(name="certPolicyId")
    def cert_policy_id(self) -> str:
        """
        Specifies the object identifier (OID) of the certificate policy under which the certificate was issued. For more information, see NIST's definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier).
        """
        return pulumi.get(self, "cert_policy_id")

    @property
    @pulumi.getter(name="policyQualifiers")
    def policy_qualifiers(self) -> Optional[Sequence['outputs.CertificatePolicyQualifierInfo']]:
        """
        Modifies the given ``CertPolicyId`` with a qualifier. AWS Private CA supports the certification practice statement (CPS) qualifier.
        """
        return pulumi.get(self, "policy_qualifiers")


@pulumi.output_type
class CertificatePolicyQualifierInfo(dict):
    """
    Modifies the ``CertPolicyId`` of a ``PolicyInformation`` object with a qualifier. AWS Private CA supports the certification practice statement (CPS) qualifier.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyQualifierId":
            suggest = "policy_qualifier_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificatePolicyQualifierInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificatePolicyQualifierInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificatePolicyQualifierInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_qualifier_id: str,
                 qualifier: 'outputs.CertificateQualifier'):
        """
        Modifies the ``CertPolicyId`` of a ``PolicyInformation`` object with a qualifier. AWS Private CA supports the certification practice statement (CPS) qualifier.
        :param str policy_qualifier_id: Identifies the qualifier modifying a ``CertPolicyId``.
        :param 'CertificateQualifier' qualifier: Defines the qualifier type. AWS Private CA supports the use of a URI for a CPS qualifier in this field.
        """
        pulumi.set(__self__, "policy_qualifier_id", policy_qualifier_id)
        pulumi.set(__self__, "qualifier", qualifier)

    @property
    @pulumi.getter(name="policyQualifierId")
    def policy_qualifier_id(self) -> str:
        """
        Identifies the qualifier modifying a ``CertPolicyId``.
        """
        return pulumi.get(self, "policy_qualifier_id")

    @property
    @pulumi.getter
    def qualifier(self) -> 'outputs.CertificateQualifier':
        """
        Defines the qualifier type. AWS Private CA supports the use of a URI for a CPS qualifier in this field.
        """
        return pulumi.get(self, "qualifier")


@pulumi.output_type
class CertificateQualifier(dict):
    """
    Defines a ``PolicyInformation`` qualifier. AWS Private CA supports the [certification practice statement (CPS) qualifier](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.1.4) defined in RFC 5280.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpsUri":
            suggest = "cps_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateQualifier. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateQualifier.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateQualifier.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cps_uri: str):
        """
        Defines a ``PolicyInformation`` qualifier. AWS Private CA supports the [certification practice statement (CPS) qualifier](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.1.4) defined in RFC 5280.
        :param str cps_uri: Contains a pointer to a certification practice statement (CPS) published by the CA.
        """
        pulumi.set(__self__, "cps_uri", cps_uri)

    @property
    @pulumi.getter(name="cpsUri")
    def cps_uri(self) -> str:
        """
        Contains a pointer to a certification practice statement (CPS) published by the CA.
        """
        return pulumi.get(self, "cps_uri")


@pulumi.output_type
class CertificateSubject(dict):
    """
    Contains information about the certificate subject. The ``Subject`` field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The ``Subject``must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "customAttributes":
            suggest = "custom_attributes"
        elif key == "distinguishedNameQualifier":
            suggest = "distinguished_name_qualifier"
        elif key == "generationQualifier":
            suggest = "generation_qualifier"
        elif key == "givenName":
            suggest = "given_name"
        elif key == "organizationalUnit":
            suggest = "organizational_unit"
        elif key == "serialNumber":
            suggest = "serial_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateSubject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateSubject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateSubject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_name: Optional[str] = None,
                 country: Optional[str] = None,
                 custom_attributes: Optional[Sequence['outputs.CertificateCustomAttribute']] = None,
                 distinguished_name_qualifier: Optional[str] = None,
                 generation_qualifier: Optional[str] = None,
                 given_name: Optional[str] = None,
                 initials: Optional[str] = None,
                 locality: Optional[str] = None,
                 organization: Optional[str] = None,
                 organizational_unit: Optional[str] = None,
                 pseudonym: Optional[str] = None,
                 serial_number: Optional[str] = None,
                 state: Optional[str] = None,
                 surname: Optional[str] = None,
                 title: Optional[str] = None):
        """
        Contains information about the certificate subject. The ``Subject`` field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The ``Subject``must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate.
        :param str common_name: For CA and end-entity certificates in a private PKI, the common name (CN) can be any string within the length limit.
                Note: In publicly trusted certificates, the common name must be a fully qualified domain name (FQDN) associated with the certificate subject.
        :param str country: Two-digit code that specifies the country in which the certificate subject located.
        :param Sequence['CertificateCustomAttribute'] custom_attributes: Contains a sequence of one or more X.500 relative distinguished names (RDNs), each of which consists of an object identifier (OID) and a value. For more information, see NIST’s definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier).
                 Custom attributes cannot be used in combination with standard attributes.
        :param str distinguished_name_qualifier: Disambiguating information for the certificate subject.
        :param str generation_qualifier: Typically a qualifier appended to the name of an individual. Examples include Jr. for junior, Sr. for senior, and III for third.
        :param str given_name: First name.
        :param str initials: Concatenation that typically contains the first letter of the *GivenName*, the first letter of the middle name if one exists, and the first letter of the *Surname*.
        :param str locality: The locality (such as a city or town) in which the certificate subject is located.
        :param str organization: Legal name of the organization with which the certificate subject is affiliated.
        :param str organizational_unit: A subdivision or unit of the organization (such as sales or finance) with which the certificate subject is affiliated.
        :param str pseudonym: Typically a shortened version of a longer *GivenName*. For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth, Liz, or Eliza.
        :param str serial_number: The certificate serial number.
        :param str state: State in which the subject of the certificate is located.
        :param str surname: Family name. In the US and the UK, for example, the surname of an individual is ordered last. In Asian cultures the surname is typically ordered first.
        :param str title: A title such as Mr. or Ms., which is pre-pended to the name to refer formally to the certificate subject.
        """
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if distinguished_name_qualifier is not None:
            pulumi.set(__self__, "distinguished_name_qualifier", distinguished_name_qualifier)
        if generation_qualifier is not None:
            pulumi.set(__self__, "generation_qualifier", generation_qualifier)
        if given_name is not None:
            pulumi.set(__self__, "given_name", given_name)
        if initials is not None:
            pulumi.set(__self__, "initials", initials)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if pseudonym is not None:
            pulumi.set(__self__, "pseudonym", pseudonym)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if surname is not None:
            pulumi.set(__self__, "surname", surname)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[str]:
        """
        For CA and end-entity certificates in a private PKI, the common name (CN) can be any string within the length limit.
         Note: In publicly trusted certificates, the common name must be a fully qualified domain name (FQDN) associated with the certificate subject.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter
    def country(self) -> Optional[str]:
        """
        Two-digit code that specifies the country in which the certificate subject located.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[Sequence['outputs.CertificateCustomAttribute']]:
        """
        Contains a sequence of one or more X.500 relative distinguished names (RDNs), each of which consists of an object identifier (OID) and a value. For more information, see NIST’s definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier).
          Custom attributes cannot be used in combination with standard attributes.
        """
        return pulumi.get(self, "custom_attributes")

    @property
    @pulumi.getter(name="distinguishedNameQualifier")
    def distinguished_name_qualifier(self) -> Optional[str]:
        """
        Disambiguating information for the certificate subject.
        """
        return pulumi.get(self, "distinguished_name_qualifier")

    @property
    @pulumi.getter(name="generationQualifier")
    def generation_qualifier(self) -> Optional[str]:
        """
        Typically a qualifier appended to the name of an individual. Examples include Jr. for junior, Sr. for senior, and III for third.
        """
        return pulumi.get(self, "generation_qualifier")

    @property
    @pulumi.getter(name="givenName")
    def given_name(self) -> Optional[str]:
        """
        First name.
        """
        return pulumi.get(self, "given_name")

    @property
    @pulumi.getter
    def initials(self) -> Optional[str]:
        """
        Concatenation that typically contains the first letter of the *GivenName*, the first letter of the middle name if one exists, and the first letter of the *Surname*.
        """
        return pulumi.get(self, "initials")

    @property
    @pulumi.getter
    def locality(self) -> Optional[str]:
        """
        The locality (such as a city or town) in which the certificate subject is located.
        """
        return pulumi.get(self, "locality")

    @property
    @pulumi.getter
    def organization(self) -> Optional[str]:
        """
        Legal name of the organization with which the certificate subject is affiliated.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[str]:
        """
        A subdivision or unit of the organization (such as sales or finance) with which the certificate subject is affiliated.
        """
        return pulumi.get(self, "organizational_unit")

    @property
    @pulumi.getter
    def pseudonym(self) -> Optional[str]:
        """
        Typically a shortened version of a longer *GivenName*. For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth, Liz, or Eliza.
        """
        return pulumi.get(self, "pseudonym")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[str]:
        """
        The certificate serial number.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        State in which the subject of the certificate is located.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def surname(self) -> Optional[str]:
        """
        Family name. In the US and the UK, for example, the surname of an individual is ordered last. In Asian cultures the surname is typically ordered first.
        """
        return pulumi.get(self, "surname")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        """
        A title such as Mr. or Ms., which is pre-pended to the name to refer formally to the certificate subject.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class CertificateValidity(dict):
    """
    Length of time for which the certificate issued by your private certificate authority (CA), or by the private CA itself, is valid in days, months, or years. You can issue a certificate by calling the ``IssueCertificate`` operation.
    """
    def __init__(__self__, *,
                 type: str,
                 value: float):
        """
        Length of time for which the certificate issued by your private certificate authority (CA), or by the private CA itself, is valid in days, months, or years. You can issue a certificate by calling the ``IssueCertificate`` operation.
        :param str type: Specifies whether the ``Value`` parameter represents days, months, or years.
        :param float value: A long integer interpreted according to the value of ``Type``, below.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies whether the ``Value`` parameter represents days, months, or years.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        A long integer interpreted according to the value of ``Type``, below.
        """
        return pulumi.get(self, "value")


