# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetCertificateAuthorityResult',
    'AwaitableGetCertificateAuthorityResult',
    'get_certificate_authority',
    'get_certificate_authority_output',
]

@pulumi.output_type
class GetCertificateAuthorityResult:
    def __init__(__self__, arn=None, certificate_signing_request=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if certificate_signing_request and not isinstance(certificate_signing_request, str):
            raise TypeError("Expected argument 'certificate_signing_request' to be a str")
        pulumi.set(__self__, "certificate_signing_request", certificate_signing_request)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the certificate authority.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="certificateSigningRequest")
    def certificate_signing_request(self) -> Optional[str]:
        """
        The base64 PEM-encoded certificate signing request (CSR) for your certificate authority certificate.
        """
        return pulumi.get(self, "certificate_signing_request")


class AwaitableGetCertificateAuthorityResult(GetCertificateAuthorityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateAuthorityResult(
            arn=self.arn,
            certificate_signing_request=self.certificate_signing_request)


def get_certificate_authority(arn: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateAuthorityResult:
    """
    Private certificate authority.


    :param str arn: The Amazon Resource Name (ARN) of the certificate authority.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:acmpca:getCertificateAuthority', __args__, opts=opts, typ=GetCertificateAuthorityResult).value

    return AwaitableGetCertificateAuthorityResult(
        arn=pulumi.get(__ret__, 'arn'),
        certificate_signing_request=pulumi.get(__ret__, 'certificate_signing_request'))


@_utilities.lift_output_func(get_certificate_authority)
def get_certificate_authority_output(arn: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCertificateAuthorityResult]:
    """
    Private certificate authority.


    :param str arn: The Amazon Resource Name (ARN) of the certificate authority.
    """
    ...
