# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AnalyzerArchiveRule',
    'AnalyzerConfigurationProperties',
    'AnalyzerFilter',
    'AnalyzerUnusedAccessConfiguration',
]

@pulumi.output_type
class AnalyzerArchiveRule(dict):
    """
    An Access Analyzer archive rule. Archive rules automatically archive new findings that meet the criteria you define when you create the rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleName":
            suggest = "rule_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyzerArchiveRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyzerArchiveRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyzerArchiveRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter: Sequence['outputs.AnalyzerFilter'],
                 rule_name: str):
        """
        An Access Analyzer archive rule. Archive rules automatically archive new findings that meet the criteria you define when you create the rule.
        :param str rule_name: The archive rule name
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "rule_name", rule_name)

    @property
    @pulumi.getter
    def filter(self) -> Sequence['outputs.AnalyzerFilter']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> str:
        """
        The archive rule name
        """
        return pulumi.get(self, "rule_name")


@pulumi.output_type
class AnalyzerConfigurationProperties(dict):
    """
    The configuration for the analyzer
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unusedAccessConfiguration":
            suggest = "unused_access_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyzerConfigurationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyzerConfigurationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyzerConfigurationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 unused_access_configuration: Optional['outputs.AnalyzerUnusedAccessConfiguration'] = None):
        """
        The configuration for the analyzer
        """
        if unused_access_configuration is not None:
            pulumi.set(__self__, "unused_access_configuration", unused_access_configuration)

    @property
    @pulumi.getter(name="unusedAccessConfiguration")
    def unused_access_configuration(self) -> Optional['outputs.AnalyzerUnusedAccessConfiguration']:
        return pulumi.get(self, "unused_access_configuration")


@pulumi.output_type
class AnalyzerFilter(dict):
    def __init__(__self__, *,
                 property: str,
                 contains: Optional[Sequence[str]] = None,
                 eq: Optional[Sequence[str]] = None,
                 exists: Optional[bool] = None,
                 neq: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "property", property)
        if contains is not None:
            pulumi.set(__self__, "contains", contains)
        if eq is not None:
            pulumi.set(__self__, "eq", eq)
        if exists is not None:
            pulumi.set(__self__, "exists", exists)
        if neq is not None:
            pulumi.set(__self__, "neq", neq)

    @property
    @pulumi.getter
    def contains(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "contains")

    @property
    @pulumi.getter
    def eq(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "eq")

    @property
    @pulumi.getter
    def exists(self) -> Optional[bool]:
        return pulumi.get(self, "exists")

    @property
    @pulumi.getter
    def neq(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "neq")

    @property
    @pulumi.getter
    def property(self) -> str:
        return pulumi.get(self, "property")


@pulumi.output_type
class AnalyzerUnusedAccessConfiguration(dict):
    """
    The Configuration for Unused Access Analyzer
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unusedAccessAge":
            suggest = "unused_access_age"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyzerUnusedAccessConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyzerUnusedAccessConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyzerUnusedAccessConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 unused_access_age: Optional[int] = None):
        """
        The Configuration for Unused Access Analyzer
        :param int unused_access_age: The specified access age in days for which to generate findings for unused access. For example, if you specify 90 days, the analyzer will generate findings for IAM entities within the accounts of the selected organization for any access that hasn't been used in 90 or more days since the analyzer's last scan. You can choose a value between 1 and 180 days.
        """
        if unused_access_age is not None:
            pulumi.set(__self__, "unused_access_age", unused_access_age)

    @property
    @pulumi.getter(name="unusedAccessAge")
    def unused_access_age(self) -> Optional[int]:
        """
        The specified access age in days for which to generate findings for unused access. For example, if you specify 90 days, the analyzer will generate findings for IAM entities within the accounts of the selected organization for any access that hasn't been used in 90 or more days since the analyzer's last scan. You can choose a value between 1 and 180 days.
        """
        return pulumi.get(self, "unused_access_age")


